/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.ExportResolution;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class JSProperty {
    public static final int ACCESSOR = 8;
    public static final int PROXY = 16;
    public static final int CONST = 32;
    public static final int MODULE_NAMESPACE_EXPORT = 64;
    private static final int DATA_SPECIAL = 80;

    private JSProperty() {
    }

    @CompilerDirectives.TruffleBoundary
    public static String toString(Property property) {
        return "\"" + property.getKey() + "\"" + JSProperty.getAttributeString(property) + ":" + property.getLocation();
    }

    private static String getAttributeString(Property property) {
        String negative = JSProperty.getAttributeString(property, false);
        return negative.isEmpty() ? "" : "-" + negative;
    }

    protected static String getAttributeString(Property property, boolean positive) {
        return (JSProperty.isEnumerable(property) == positive ? "e" : "") + (JSProperty.isConfigurable(property) == positive ? "c" : "") + (JSProperty.isData(property) && JSProperty.isWritable(property) == positive ? "w" : "");
    }

    public static Object getValue(Property property, DynamicObject store, Object thisObj, Node encapsulatingNode) {
        Object value = property.get(store, false);
        if (JSProperty.isAccessor(property)) {
            return JSProperty.getValueAccessor(thisObj, value, encapsulatingNode);
        }
        if (JSProperty.isProxy(property)) {
            return ((PropertyProxy)value).get(store);
        }
        assert (JSProperty.isData(property) && !JSProperty.isDataSpecial(property)) : property;
        return value;
    }

    private static Object getValueAccessor(Object thisObj, Object value, Node encapsulatingNode) {
        DynamicObject getter = ((Accessor)value).getGetter();
        if (getter != Undefined.instance) {
            return JSRuntime.call(getter, thisObj, JSArguments.EMPTY_ARGUMENTS_ARRAY, encapsulatingNode);
        }
        return Undefined.instance;
    }

    public static boolean setValue(Property property, DynamicObject store, Object thisObj, Object value, boolean isStrict, Node encapsulatingNode) {
        if (JSProperty.isAccessor(property)) {
            return JSProperty.setValueAccessor(property, store, thisObj, value, isStrict, encapsulatingNode);
        }
        if (JSProperty.isWritable(property)) {
            if (JSProperty.isProxy(property)) {
                return JSProperty.setValueProxy(property, store, thisObj, value, isStrict);
            }
            assert (JSProperty.isData(property) && !JSProperty.isDataSpecial(property)) : property;
            assert (!(value instanceof Accessor || value instanceof PropertyProxy || value instanceof ExportResolution));
            boolean success = DynamicObjectLibrary.getUncached().putIfPresent(store, property.getKey(), value);
            assert (success);
            return true;
        }
        if (isStrict) {
            throw Errors.createTypeErrorNotWritableProperty(property.getKey(), thisObj);
        }
        return false;
    }

    private static boolean setValueAccessor(Property property, DynamicObject store, Object thisObj, Object value, boolean isStrict, Node encapsulatingNode) {
        DynamicObject setter = ((Accessor)JSDynamicObject.getOrNull(store, property.getKey())).getSetter();
        if (setter != Undefined.instance) {
            JSRuntime.call(setter, thisObj, new Object[]{value}, encapsulatingNode);
            return true;
        }
        if (isStrict) {
            throw Errors.createTypeErrorCannotSetAccessorProperty(property.getKey(), store);
        }
        return false;
    }

    private static boolean setValueProxy(Property property, DynamicObject store, Object thisObj, Object value, boolean isStrict) {
        boolean ret = ((PropertyProxy)JSDynamicObject.getOrNull(store, property.getKey())).set(store, value);
        if (!ret && isStrict) {
            throw Errors.createTypeErrorNotWritableProperty(property.getKey(), thisObj);
        }
        return ret;
    }

    public static boolean isConfigurable(Property property) {
        return JSProperty.isConfigurable(property.getFlags());
    }

    public static boolean isEnumerable(Property property) {
        return JSProperty.isEnumerable(property.getFlags());
    }

    public static boolean isWritable(Property property) {
        return JSProperty.isWritable(property.getFlags());
    }

    public static boolean isProxy(Property property) {
        return JSProperty.isProxy(property.getFlags());
    }

    public static boolean isAccessor(Property property) {
        return JSProperty.isAccessor(property.getFlags());
    }

    public static boolean isData(Property property) {
        return JSProperty.isData(property.getFlags());
    }

    public static boolean isConst(Property property) {
        return JSProperty.isConst(property.getFlags());
    }

    public static boolean isModuleNamespaceExport(Property property) {
        return JSProperty.isModuleNamespaceExport(property.getFlags());
    }

    public static boolean isDataSpecial(Property property) {
        return JSProperty.isDataSpecial(property.getFlags());
    }

    public static boolean isConfigurable(int flags) {
        return (flags & 2) == 0;
    }

    public static boolean isEnumerable(int flags) {
        return (flags & 1) == 0;
    }

    public static boolean isWritable(int flags) {
        return (flags & 4) == 0;
    }

    public static boolean isProxy(int flags) {
        return (flags & 0x10) != 0;
    }

    public static boolean isAccessor(int flags) {
        return (flags & 8) != 0;
    }

    public static boolean isData(int flags) {
        return (flags & 8) == 0;
    }

    public static boolean isConst(int flags) {
        return (flags & 0x20) != 0;
    }

    public static boolean isModuleNamespaceExport(int flags) {
        return (flags & 0x40) != 0;
    }

    public static boolean isDataSpecial(int flags) {
        return (flags & 0x50) != 0;
    }

    public static PropertyProxy getConstantProxy(Property proxyProperty) {
        assert (JSProperty.isProxy(proxyProperty));
        return proxyProperty.getLocation().isConstant() ? (PropertyProxy)proxyProperty.get(null, false) : null;
    }
}

