/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.painter;

import com.paterva.maltego.ui.graph.view2d.painter.EntityPainter;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterComparator;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openide.util.Lookup;

class DefaultEntityPainterRegistry
extends EntityPainterRegistry {
    private Map<String, EntityPainter> _painters;

    DefaultEntityPainterRegistry() {
    }

    @Override
    public Collection<EntityPainter> getEntityPainters() {
        return Collections.unmodifiableCollection(this.getSortedEntityPainterMap().values());
    }

    @Override
    public Collection<String> getEntityPainterNames() {
        return Collections.unmodifiableCollection(this.getSortedEntityPainterMap().keySet());
    }

    @Override
    public EntityPainter getDefaultPainter() {
        return this.getEntityPainters().iterator().next();
    }

    @Override
    public EntityPainter getEntityPainter(String name) {
        return this.getSortedEntityPainterMap().get(name);
    }

    private synchronized Map<String, EntityPainter> getSortedEntityPainterMap() {
        if (this._painters == null) {
            this._painters = new LinkedHashMap<String, EntityPainter>();
            Lookup lookup = Lookup.getDefault();
            ArrayList painters = new ArrayList(lookup.lookupAll(EntityPainter.class));
            Collections.sort(painters, new EntityPainterComparator());
            for (EntityPainter painter : painters) {
                this._painters.put(painter.getName(), painter);
            }
        }
        return this._painters;
    }
}

