/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RotatedLabel
extends JPanel {
    private Direction _direction = Direction.HORIZONTAL;
    private JLabel _delegate;

    public RotatedLabel(String text) {
        this.getDelegate().setText(text);
    }

    @Override
    public Color getForeground() {
        return this.getDelegate().getForeground();
    }

    @Override
    public void setForeground(Color fg) {
        this.getDelegate().setForeground(fg);
    }

    @Override
    public Font getFont() {
        return this.getDelegate().getFont();
    }

    @Override
    public void setFont(Font font) {
        this.getDelegate().setFont(font);
    }

    public Direction getDirection() {
        return this._direction;
    }

    public void setDirection(Direction direction) {
        this._direction = direction;
    }

    private JLabel getDelegate() {
        if (this._delegate == null) {
            this._delegate = new JLabel();
        }
        return this._delegate;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getDimension(this.getDelegate().getMinimumSize());
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getDimension(this.getDelegate().getMaximumSize());
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getDimension(this.getDelegate().getPreferredSize());
    }

    @Override
    public Dimension getSize() {
        return this.getDimension(this.getDelegate().getPreferredSize());
    }

    @Override
    public int getWidth() {
        return this.getSize().width;
    }

    @Override
    public int getHeight() {
        return this.getSize().height;
    }

    private Dimension getDimension(Dimension d) {
        if (this.isRotated()) {
            d = new Dimension(d.height, d.width);
        }
        return d;
    }

    private boolean isRotated() {
        return Direction.HORIZONTAL != this.getDirection();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D gr = (Graphics2D)g;
        gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        switch (this.getDirection()) {
            case VERTICAL_UP: {
                gr.translate(0.0, this.getSize().getHeight());
                gr.transform(AffineTransform.getQuadrantRotateInstance(-1));
                break;
            }
            case VERTICAL_DOWN: {
                gr.transform(AffineTransform.getQuadrantRotateInstance(1));
                gr.translate(0.0, -this.getSize().getWidth());
                break;
            }
        }
        JLabel label = this.getDelegate();
        label.setSize(label.getPreferredSize());
        label.paint(g);
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL_UP,
        VERTICAL_DOWN;

    }
}

