/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph;

import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.ChatRoomCookie;
import com.paterva.maltego.chatapi.conn.ConnectionException;
import com.paterva.maltego.chatapi.conn.ConnectionInfo;
import com.paterva.maltego.chatapi.conn.ConnectionInitiationCallback;
import com.paterva.maltego.chatapi.conn.ConnectionStatus;
import com.paterva.maltego.chatapi.conn.ConnectionStatusEvent;
import com.paterva.maltego.chatapi.conn.ConnectionStatusListener;
import com.paterva.maltego.chatapi.msg.ChatMessagePropagator;
import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.Participant;
import com.paterva.maltego.collab.Payload;
import com.paterva.maltego.collab.PayloadCollection;
import com.paterva.maltego.collab.graph.AddDeleteConflictResolver;
import com.paterva.maltego.collab.graph.CollaborationChatRoom;
import com.paterva.maltego.collab.graph.GraphProvider;
import com.paterva.maltego.collab.graph.GraphSnapshot;
import com.paterva.maltego.collab.graph.LogCallback;
import com.paterva.maltego.collab.graph.StartGraphMessage;
import com.paterva.maltego.collab.graph.TransactionConflictDetector;
import com.paterva.maltego.collab.graph.TransactionConflictResolver;
import com.paterva.maltego.collab.graph.serialization.CollaborationSerializationException;
import com.paterva.maltego.collab.graph.serialization.CollectionSettingsSerializer;
import com.paterva.maltego.collab.graph.serialization.CollectionSettingsStub;
import com.paterva.maltego.collab.graph.serialization.EntitySpecSerializer;
import com.paterva.maltego.collab.graph.serialization.GraphTransactionSerializer;
import com.paterva.maltego.collab.graph.serialization.LayoutModeSerializer;
import com.paterva.maltego.collab.graph.serialization.LayoutModeSettings;
import com.paterva.maltego.collab.graph.serialization.LinkSpecSerializer;
import com.paterva.maltego.collab.graph.state.ConnectionController;
import com.paterva.maltego.collab.session.CollaborationSessionInfo;
import com.paterva.maltego.collab.session.PayloadHelper;
import com.paterva.maltego.collab.ui.ChatFilterSettings;
import com.paterva.maltego.collab.ui.GraphMessageType;
import com.paterva.maltego.collab.ui.MessageColors;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.EntityUpdate;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.LinkUpdate;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.GraphLogListener;
import com.paterva.maltego.graph.GraphLogger;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.views.collect.CollectionSettings;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.imgfactory.icons.IconResourceRegistry;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.imgfactoryapi.VirtualIcon;
import com.paterva.maltego.serializers.GraphSerializationException;
import com.paterva.maltego.serializers.compact.IconCollection;
import com.paterva.maltego.serializers.compact.IconsSerializer;
import com.paterva.maltego.sound.SoundPlayer;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.ui.graph.GraphCopyHelper;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewRegistry;
import com.paterva.maltego.ui.graph.ModifiedHelper;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.data.GraphDataUtils;
import com.paterva.maltego.ui.graph.merge.InteractiveGraphMerger;
import com.paterva.maltego.ui.graph.transacting.GraphTransactor;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorListener;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorRegistry;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.ui.graph.transactions.GraphTransactions;
import com.paterva.maltego.ui.graph.transactions.TransactionBatchFactory;
import com.paterva.maltego.ui.graph.view2d.NodeEditHook;
import com.paterva.maltego.ui.graph.view2d.ViewGraphName;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutChangePropagator;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutHelper;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutSettings;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutSettingsWrapper;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.output.MessageChunk;
import com.paterva.maltego.util.output.MessageLinkAdapter;
import com.paterva.maltego.util.output.MessageLinkListener;
import com.paterva.maltego.util.output.OutputMessage;
import com.paterva.maltego.util.ui.WindowUtil;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public class GraphChatRoom
extends CollaborationChatRoom
implements GraphTransactorListener {
    private static final Logger LOG = Logger.getLogger(GraphChatRoom.class.getName());
    private GraphDataObject _graphDataObject;
    private GraphTransactor _transactor;
    private boolean _doingTransaction = false;
    private boolean _doingLayout = false;
    private boolean _doingCollectionSettings = false;
    private PropertyChangeListener _layoutChangeListener;
    private PropertyChangeListener _collectionSettingsListener;
    private GraphLogListener _logListener;
    private final Set<String> _entitySpecs = new HashSet<String>();
    private final Set<String> _linkSpecs = new HashSet<String>();
    private TransactionConflictResolver _conflictResolver;
    private Queue<PayloadCollection> _payloadQueue;
    private transient boolean _uiActive = false;
    private final Object _initializationLock = new Object();
    private String _lastAppliedTransactionID;
    private final Object _transactionIDLock = new Object();

    public GraphChatRoom() {
        this(new ConnectionController());
    }

    private GraphChatRoom(ConnectionController controller) {
        super(controller);
        this._payloadQueue = new LinkedList<PayloadCollection>();
    }

    @Override
    public void connect(ConnectionInfo info, ConnectionInitiationCallback cb) throws ConnectionException {
        this._conflictResolver = this.createConflictResolver((CollaborationSessionInfo)info);
        super.connect(info, cb);
    }

    @Override
    public void reconnect(ConnectionInitiationCallback cb) throws ConnectionException {
        super.reconnect(cb);
    }

    private TransactionConflictResolver createConflictResolver(CollaborationSessionInfo info) {
        TransactionConflictDetector detector = info.isUseConflictResolver() ? new TransactionConflictDetector.Default() : new TransactionConflictDetector.None();
        return new TransactionConflictResolver.Default(detector, new LogCallbackHandler());
    }

    private Optional<TransactionConflictResolver> conflictResolver() {
        return Optional.ofNullable(this._conflictResolver);
    }

    public GraphID getGraphID() {
        return this._transactor == null ? null : this._transactor.getGraphID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializationComplete() {
        Object object = this._initializationLock;
        synchronized (object) {
            this._uiActive = true;
            this.applyPayloadQueue();
            this._initializationLock.notifyAll();
        }
    }

    private void applyPayloadQueue() {
        while (!this._payloadQueue.isEmpty()) {
            this.processRxPayload(this._payloadQueue.remove());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleRxPayload(PayloadCollection payloads) {
        super.handleRxPayload(payloads);
        Object object = this._initializationLock;
        synchronized (object) {
            if (this._uiActive) {
                this.processRxPayload(payloads);
            } else {
                this._payloadQueue.add(payloads);
            }
        }
    }

    private void processRxPayload(PayloadCollection payloads) {
        try {
            this.handleRxCollectionSettings(payloads.ofType("collect"));
            this.handleRxIcons(payloads.ofType("icons"));
            this.handleRxEntities(payloads.ofType("especs"));
            this.handleRxLinks(payloads.ofType("lspecs"));
            this.handleRxTransactions(payloads.ofType("xaction"));
            this.handleRxLayout(payloads.ofType("layouts"));
        }
        catch (CollaborationException ex) {
            this.handleRxError("Error parsing payload", ex);
        }
    }

    private void handleRxCollectionSettings(Collection<Payload> payloads) throws CollaborationException {
        if (!payloads.isEmpty()) {
            LinkedHashMap<Payload, CollectionSettingsStub> deserializedPayloads = new LinkedHashMap<Payload, CollectionSettingsStub>();
            CollectionSettingsSerializer serializer = new CollectionSettingsSerializer();
            for (Payload payload : payloads) {
                if (StringUtils.isBlank((CharSequence)payload.getBody())) continue;
                CollectionSettingsStub settings = serializer.read(payload.getBody());
                deserializedPayloads.put(payload, settings);
            }
            if (!deserializedPayloads.isEmpty()) {
                this.applyCollectionSettings(deserializedPayloads);
            }
        }
    }

    private void handleRxLayout(Collection<Payload> payloads) throws CollaborationException {
        if (!payloads.isEmpty()) {
            LinkedHashMap<Payload, Collection<LayoutModeSettings>> deserializedPayloads = new LinkedHashMap<Payload, Collection<LayoutModeSettings>>();
            LayoutModeSerializer serializer = new LayoutModeSerializer();
            for (Payload payload : payloads) {
                String parsedPayload = PayloadHelper.parsePayload(payload.getType(), payload.getBody(), false);
                Collection<LayoutModeSettings> data = serializer.read(parsedPayload);
                deserializedPayloads.put(payload, data);
            }
            this.applyLayoutChange(deserializedPayloads);
        }
    }

    private void handleRxEntities(Collection<Payload> payloads) throws CollaborationException {
        if (!payloads.isEmpty()) {
            LinkedHashMap<Payload, Collection<MaltegoEntitySpec>> deserializedPayloads = new LinkedHashMap<Payload, Collection<MaltegoEntitySpec>>();
            EntitySpecSerializer serializer = new EntitySpecSerializer();
            for (Payload payload : payloads) {
                String parsedPayload = PayloadHelper.parsePayload(payload.getType(), payload.getBody(), false);
                Collection<MaltegoEntitySpec> specs = serializer.read(parsedPayload);
                deserializedPayloads.put(payload, specs);
            }
            this.applyEntitySpecs(deserializedPayloads);
        }
    }

    private void handleRxLinks(Collection<Payload> payloads) throws CollaborationException {
        if (!payloads.isEmpty()) {
            LinkedHashMap<Payload, Collection<MaltegoLinkSpec>> deserializedPayloads = new LinkedHashMap<Payload, Collection<MaltegoLinkSpec>>();
            LinkSpecSerializer serializer = new LinkSpecSerializer();
            for (Payload payload : payloads) {
                String parsedPayload = PayloadHelper.parsePayload(payload.getType(), payload.getBody(), false);
                Collection<MaltegoLinkSpec> specs = serializer.read(parsedPayload);
                deserializedPayloads.put(payload, specs);
            }
            this.applyLinkSpecs(deserializedPayloads);
        }
    }

    private void handleRxTransactions(Collection<Payload> payloads) throws CollaborationException {
        if (!payloads.isEmpty()) {
            LinkedHashMap<Payload, GraphTransactionBatch> deserializedPayloads = new LinkedHashMap<Payload, GraphTransactionBatch>();
            GraphTransactionSerializer serializer = new GraphTransactionSerializer();
            for (Payload payload : payloads) {
                String body = payload.getBody();
                LOG.log(Level.FINE, "Received from {0}:\n{1}", new Object[]{payload.getFrom(), body});
                GraphTransactionBatch batch = serializer.readBatch(body, this.getGraphID());
                deserializedPayloads.put(payload, batch);
            }
            this.applyTransactions(deserializedPayloads);
        }
    }

    private void handleRxIcons(Collection<Payload> payloads) throws CollaborationException {
        try {
            if (!payloads.isEmpty()) {
                LinkedHashMap<Payload, IconCollection> deserializedPayloads = new LinkedHashMap<Payload, IconCollection>();
                IconsSerializer serializer = new IconsSerializer();
                for (Payload payload : payloads) {
                    IconCollection icons = serializer.read(payload.getBody());
                    deserializedPayloads.put(payload, icons);
                }
                this.applyIcons(deserializedPayloads);
            }
        }
        catch (GraphSerializationException ex) {
            throw new CollaborationSerializationException((NormalException)ex);
        }
    }

    private void applyTransactions(Map<Payload, GraphTransactionBatch> payloads) {
        GraphChatRoom.runInEDTLater(() -> {
            try {
                WindowUtil.showWaitCursor();
                boolean updated = false;
                Object object = this._transactionIDLock;
                synchronized (object) {
                    for (Map.Entry entry : payloads.entrySet()) {
                        GraphMessageType mType;
                        GraphTransactionBatch batch = (GraphTransactionBatch)entry.getValue();
                        if (batch == null) continue;
                        Payload payload = (Payload)entry.getKey();
                        Participant from = payload.getFrom();
                        Date timestamp = payload.getTimestamp();
                        GraphMessageType graphMessageType = mType = from.isMe() ? GraphMessageType.OWN_GRAPH_CHANGE : GraphMessageType.OTHER_GRAPH_CHANGE;
                        if (ChatFilterSettings.isShow(mType) && batch.isSignificant()) {
                            String msgText = this.getAlias(from) + ": " + batch.getDescription().getStringOne();
                            ChatMessagePropagator.logMessage((ChatRoom)this, (LogMessageLevel)LogMessageLevel.Info, (OutputMessage)new OutputMessage(msgText), (Color)MessageColors.getColor(mType), (Date)timestamp);
                        }
                        this._doingTransaction = true;
                        ArrayList<GraphTransactionBatch> updateModifiedList = new ArrayList<GraphTransactionBatch>();
                        TransactionConflictResolver resolver = this.conflictResolver().orElse(null);
                        GraphTransactionBatch[] resolved = new GraphTransactionBatch[]{batch};
                        if (resolver != null) {
                            resolved = resolver.incoming(batch, from.getName(), from.isMe(), timestamp, updateModifiedList);
                        }
                        for (GraphTransactionBatch batch1 : resolved) {
                            GraphTransactionBatch resolvedBatch = AddDeleteConflictResolver.resolve(this.getGraphID(), batch1);
                            if (resolvedBatch.isEmpty()) continue;
                            this._transactor.doTransactions(resolvedBatch);
                            if (!resolvedBatch.isSignificant()) continue;
                            updated = true;
                        }
                        this._lastAppliedTransactionID = payload.getID();
                        this._doingTransaction = false;
                        if (updateModifiedList.isEmpty()) continue;
                        this.updateModified(updateModifiedList);
                    }
                }
                if (updated) {
                    SoundPlayer.instance().play("SharedGraphChanged");
                }
            }
            finally {
                WindowUtil.hideWaitCursor();
            }
        });
    }

    private void updateModified(List<GraphTransactionBatch> updateModifiedList) {
        HashSet<EntityUpdate> entityUpdates = new HashSet<EntityUpdate>();
        HashSet<LinkUpdate> linkUpdates = new HashSet<LinkUpdate>();
        String alias = this.getClientUser().getAlias();
        GraphID graphID = this.getGraphID();
        for (GraphTransactionBatch batch : updateModifiedList) {
            for (GraphTransaction transaction : batch.getTransactions()) {
                for (EntityID entityID : transaction.getEntityIDs()) {
                    MaltegoEntity graphEntity = GraphStoreHelper.getEntity((GraphID)graphID, (EntityID)entityID);
                    if (graphEntity == null) continue;
                    entityUpdates.add(ModifiedHelper.createUpdate((String)alias, (MaltegoEntity)graphEntity));
                }
                for (LinkID linkID : transaction.getLinkIDs()) {
                    MaltegoLink graphLink = GraphStoreHelper.getLink((GraphID)graphID, (LinkID)linkID);
                    if (graphLink == null) continue;
                    linkUpdates.add(ModifiedHelper.createUpdate((String)alias, (MaltegoLink)graphLink));
                }
            }
        }
        if (!entityUpdates.isEmpty() || !linkUpdates.isEmpty()) {
            GraphTransactionBatch batch;
            SimilarStrings description = new SimilarStrings("Update last modified properties after conflict");
            batch = new GraphTransactionBatch(description, true, new GraphTransaction[0]);
            batch.add(GraphTransactions.updateEntitiesAndLinks(entityUpdates, linkUpdates));
            this._transactor.doTransactions(batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyEntitySpecs(Map<Payload, Collection<MaltegoEntitySpec>> payloads) {
        EntityRegistry registry = EntityRegistry.forGraphID((GraphID)this.getGraphID());
        Set<String> set = this._entitySpecs;
        synchronized (set) {
            Object object = this._transactionIDLock;
            synchronized (object) {
                for (Map.Entry<Payload, Collection<MaltegoEntitySpec>> entry : payloads.entrySet()) {
                    Payload payload = entry.getKey();
                    Collection<MaltegoEntitySpec> specs = entry.getValue();
                    Participant from = payload.getFrom();
                    for (MaltegoEntitySpec spec : specs) {
                        GraphMessageType mType;
                        EntityRegistry defaultRegistry;
                        boolean isMe = from.isMe();
                        if (!isMe) {
                            this._entitySpecs.add(spec.getTypeName());
                            registry.put((TypeSpec)spec);
                        }
                        String msg = String.format("%s added the %s entity type to the graph", this.getAlias(from), spec.getDisplayName());
                        OutputMessage chatMsg = new OutputMessage(msg);
                        MessageLinkListener addSpecListener = null;
                        if (!isMe && (addSpecListener = this.createAddEntitySpecChatListener(defaultRegistry = EntityRegistry.getDefault(), spec)) != null) {
                            chatMsg.addChunk(new MessageChunk(" ("));
                            chatMsg.addChunk(new MessageChunk("Import entity type", addSpecListener));
                            chatMsg.addChunk(new MessageChunk(")"));
                        }
                        GraphMessageType graphMessageType = mType = isMe ? GraphMessageType.OWN_NOTIFICATION : GraphMessageType.OTHER_NOTIFICATION;
                        if (ChatFilterSettings.isShow(mType) || addSpecListener != null) {
                            ChatMessagePropagator.logMessage((ChatRoom)this, (LogMessageLevel)LogMessageLevel.Info, (OutputMessage)chatMsg, (Color)MessageColors.getColor(mType), (Date)payload.getTimestamp());
                        }
                        this._lastAppliedTransactionID = payload.getID();
                    }
                }
            }
        }
    }

    private MessageLinkListener createAddEntitySpecChatListener(final EntityRegistry defaultRegistry, final MaltegoEntitySpec spec) {
        MessageLinkAdapter addSpecListener = null;
        if (!defaultRegistry.contains(spec.getTypeName())) {
            addSpecListener = new MessageLinkAdapter(){

                public void linkAction() {
                    if (defaultRegistry.contains(spec.getTypeName())) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Entity type already imported."));
                    } else {
                        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)"Do you want to import this entity type so that you can use it in other graphs as well?", "New Entity Type", 0);
                        if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
                            defaultRegistry.put((TypeSpec)spec);
                            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)"Entity type imported successfully");
                            msg.setTitle("Import successful");
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                        }
                    }
                }
            };
        }
        return addSpecListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyLinkSpecs(Map<Payload, Collection<MaltegoLinkSpec>> payloads) {
        LinkRegistry registry = LinkRegistry.forGraphID((GraphID)this.getGraphID());
        Set<String> set = this._linkSpecs;
        synchronized (set) {
            Object object = this._transactionIDLock;
            synchronized (object) {
                for (Map.Entry<Payload, Collection<MaltegoLinkSpec>> entry : payloads.entrySet()) {
                    Payload payload = entry.getKey();
                    Collection<MaltegoLinkSpec> specs = entry.getValue();
                    Participant from = payload.getFrom();
                    for (MaltegoLinkSpec spec : specs) {
                        GraphMessageType mType;
                        boolean isMe = from.isMe();
                        if (!isMe) {
                            this._linkSpecs.add(spec.getTypeName());
                            registry.put((TypeSpec)spec);
                        }
                        OutputMessage msg = new OutputMessage(String.format("%s added the %s link type to the graph", this.getAlias(from), spec.getDisplayName()));
                        GraphMessageType graphMessageType = mType = isMe ? GraphMessageType.OWN_NOTIFICATION : GraphMessageType.OTHER_NOTIFICATION;
                        if (ChatFilterSettings.isShow(mType)) {
                            ChatMessagePropagator.logMessage((ChatRoom)this, (LogMessageLevel)LogMessageLevel.Info, (OutputMessage)msg, (Color)MessageColors.getColor(mType), (Date)payload.getTimestamp());
                        }
                        this._lastAppliedTransactionID = payload.getID();
                    }
                }
            }
        }
    }

    private void applyCollectionSettings(Map<Payload, CollectionSettingsStub> payloads) {
        GraphChatRoom.runInEDTLater(() -> {
            this._doingCollectionSettings = true;
            Object object = this._transactionIDLock;
            synchronized (object) {
                for (Map.Entry entry : payloads.entrySet()) {
                    Payload payload = (Payload)entry.getKey();
                    CollectionSettingsStub stub = (CollectionSettingsStub)entry.getValue();
                    Participant participant = payload.getFrom();
                    boolean me = participant.isMe();
                    if (!me) {
                        GraphID graphID = this.getGraphID();
                        CollectionSettings settings = CollectionSettings.getDefault();
                        settings.setLayoutNew(false);
                        if (stub.getEnabled() != null) {
                            settings.setEnabled(graphID, stub.getEnabled().booleanValue());
                        }
                        if (stub.getMinEntities() != null) {
                            settings.setMinRequiredEntitiesPerNode(graphID, stub.getMinEntities().intValue());
                        }
                        if (stub.getRatio() != null) {
                            settings.setRuleRatio(stub.getRatio().doubleValue());
                        }
                        settings.setLayoutNew(true);
                    }
                    this._lastAppliedTransactionID = payload.getID();
                    String alias = this.getAlias(participant);
                    String msg = String.format("%s changed the collection settings", alias);
                    OutputMessage chatMsg = new OutputMessage(msg);
                    GraphMessageType mType = me ? GraphMessageType.OWN_NOTIFICATION : GraphMessageType.OTHER_NOTIFICATION;
                    ChatMessagePropagator.logMessage((ChatRoom)this, (LogMessageLevel)LogMessageLevel.Info, (OutputMessage)chatMsg, (Color)MessageColors.getColor(mType), (Date)payload.getTimestamp());
                }
            }
            this._doingCollectionSettings = false;
        });
    }

    private void applyLayoutChange(Map<Payload, Collection<LayoutModeSettings>> payloads) {
        GraphChatRoom.runInEDTLater(() -> {
            this._doingLayout = true;
            Object object = this._transactionIDLock;
            synchronized (object) {
                for (Map.Entry entry : payloads.entrySet()) {
                    Payload payload = (Payload)entry.getKey();
                    Collection settings = (Collection)entry.getValue();
                    Participant participant = payload.getFrom();
                    boolean me = participant.isMe();
                    for (LayoutModeSettings layoutModeSettings : settings) {
                        String viewName = layoutModeSettings.getViewName();
                        LayoutSettings layoutSettings = layoutModeSettings.getSettings();
                        if (!me) {
                            LayoutHelper.setLayout((GraphID)this.getGraphID(), (String)viewName, (LayoutSettings)layoutSettings, (boolean)true);
                        }
                        this._lastAppliedTransactionID = payload.getID();
                        String alias = this.getAlias(participant);
                        String layoutMode = layoutSettings.getMode().getName();
                        String allOrNew = String.format("Layout %s", layoutSettings.isLayoutAll() ? "All" : "New");
                        String msg = String.format("%s changed the layout mode to %s (%s) (%s)", alias, layoutMode, allOrNew, viewName);
                        OutputMessage chatMsg = new OutputMessage(msg);
                        GraphMessageType mType = me ? GraphMessageType.OWN_NOTIFICATION : GraphMessageType.OTHER_NOTIFICATION;
                        ChatMessagePropagator.logMessage((ChatRoom)this, (LogMessageLevel)LogMessageLevel.Info, (OutputMessage)chatMsg, (Color)MessageColors.getColor(mType), (Date)payload.getTimestamp());
                    }
                }
            }
            this._doingLayout = false;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyIcons(Map<Payload, IconCollection> payloads) {
        Object object = this._transactionIDLock;
        synchronized (object) {
            for (Map.Entry<Payload, IconCollection> entry : payloads.entrySet()) {
                Payload payload = entry.getKey();
                IconCollection icons = entry.getValue();
                for (Map.Entry categoryEntry : icons.entrySet()) {
                    String category = (String)categoryEntry.getKey();
                    for (Map.Entry nameEntry : ((Map)categoryEntry.getValue()).entrySet()) {
                        String name = (String)nameEntry.getKey();
                        IconCollection.Icon icon = (IconCollection.Icon)nameEntry.getValue();
                        Set aliases = icon.getAliases();
                        Map images = icon.getImages();
                        this.generateMissingImages(images);
                        this.applyIcon(payload.getFrom(), category, name, images, aliases, payload.getTimestamp());
                        this._lastAppliedTransactionID = payload.getID();
                    }
                }
            }
        }
    }

    private void applyIcon(Participant from, String category, String name, Map<IconSize, Image> images, Set<String> aliases, Date timestamp) {
        try {
            GraphMessageType mType;
            IconRegistry defaultRegistry;
            IconRegistry registry;
            boolean isMe = from.isMe();
            if (!isMe && !(registry = IconRegistry.forGraphID((GraphID)this._graphDataObject.getGraphID())).existsCaseInsensitive(category, name)) {
                RegistryIcon icon = registry.addFromImages(category, name, images);
                registry.setAliases(icon, aliases);
            }
            String msg = String.format("%s added a %s icon to the graph", this.getAlias(from), name);
            OutputMessage chatMsg = new OutputMessage(msg);
            MessageLinkListener addIconListener = null;
            if (!isMe && (addIconListener = this.createAddIconChatListener(defaultRegistry = IconRegistry.getDefault(), category, name, images)) != null) {
                chatMsg.addChunk(new MessageChunk(" ("));
                chatMsg.addChunk(new MessageChunk("Import icon", addIconListener));
                chatMsg.addChunk(new MessageChunk(")"));
            }
            GraphMessageType graphMessageType = mType = from.isMe() ? GraphMessageType.OWN_NOTIFICATION : GraphMessageType.OTHER_NOTIFICATION;
            if (ChatFilterSettings.isShow(mType) || addIconListener != null) {
                ChatMessagePropagator.logMessage((ChatRoom)this, (LogMessageLevel)LogMessageLevel.Info, (OutputMessage)chatMsg, (Color)MessageColors.getColor(mType), (Date)timestamp);
            }
        }
        catch (IOException ex) {
            NormalException.showStackTrace((Throwable)ex);
        }
    }

    private void generateMissingImages(Map<IconSize, Image> images) {
        IconSize biggest = null;
        for (IconSize iconSize : images.keySet()) {
            if (biggest != null && biggest.getSize() >= iconSize.getSize()) continue;
            biggest = iconSize;
        }
        for (IconSize iconSize : IconSize.values()) {
            if (images.containsKey(iconSize)) continue;
            BufferedImage biggestImg = ImageUtils.createBufferedImage((Image)images.get(biggest));
            int size = iconSize.getSize();
            BufferedImage resized = ImageUtils.smartSize((BufferedImage)biggestImg, (double)size, (double)size);
            images.put(iconSize, resized);
        }
    }

    private MessageLinkListener createAddIconChatListener(final IconRegistry defaultRegistry, final String category, final String name, final Map<IconSize, Image> images) {
        MessageLinkAdapter addIconListener = null;
        if (!defaultRegistry.existsCaseInsensitive(category, name)) {
            addIconListener = new MessageLinkAdapter(){

                public void linkAction() {
                    if (defaultRegistry.existsCaseInsensitive(category, name)) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Icon already imported."));
                    } else {
                        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)"Do you want to import this icon so that you can use it for other entity types?", "New Icon", 0);
                        if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
                            try {
                                defaultRegistry.addFromImages(category, name, images);
                                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)"Icon imported successfully");
                                msg.setTitle("Import successful");
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                            }
                            catch (IOException ex) {
                                NormalException.showStackTrace((Throwable)ex);
                            }
                        }
                    }
                }
            };
        }
        return addIconListener;
    }

    private void addListeners() {
        this._layoutChangeListener = new LayoutChangeListener();
        LayoutChangePropagator lcp = LayoutChangePropagator.getInstance();
        lcp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._layoutChangeListener, (Object)lcp));
        this._logListener = new GraphLoggerListener();
        GraphLogger graphLogger = GraphLogger.getDefault();
        graphLogger.addGraphLogListener((GraphLogListener)WeakListeners.create(GraphLogListener.class, (EventListener)this._logListener, (Object)graphLogger));
        this._collectionSettingsListener = new CollectionSettingsListener();
        CollectionSettings collectionSettings = CollectionSettings.getDefault();
        collectionSettings.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._collectionSettingsListener, (Object)collectionSettings));
    }

    public void setGraphDataObject(GraphDataObject gdo) {
        GraphID graphID;
        this._graphDataObject = gdo;
        GraphTransactor transactor = null;
        if (this._graphDataObject != null && (graphID = gdo.getOrLoadGraph()) != null) {
            transactor = GraphTransactorRegistry.getDefault().get(graphID);
            this.getConnectionController().setGraphProvider(new GraphProviderImpl());
            this.updateTabColor(this.getConnectionStatus());
        }
        this.setGraphTransactor(transactor);
    }

    public GraphDataObject getGraphDataObject() {
        return this._graphDataObject;
    }

    private void setGraphTransactor(GraphTransactor transactor) {
        if (this._transactor != null) {
            this._transactor.removeGraphTransactorListener((GraphTransactorListener)this);
        }
        this._transactor = transactor;
        if (this._transactor != null) {
            this._transactor.addGraphTransactorListener((GraphTransactorListener)this);
        }
        this.addListeners();
    }

    public GraphTransactor getGraphTransactor() {
        return this._transactor;
    }

    public void transactionsDone(GraphTransactionBatch batch, GraphTransactionBatch inverseBatch) {
        if (!this._doingTransaction) {
            this.conflictResolver().ifPresent(resolver -> {
                try {
                    Collection<MaltegoLinkSpec> linkSpecs;
                    Collection<MaltegoEntitySpec> entitySpecs = this.getNewEntitySpecs(batch, this.getGraphID());
                    if (!entitySpecs.isEmpty()) {
                        this.sendIconsFor(entitySpecs);
                        this.sendEntitySpecs(entitySpecs);
                    }
                    if (!(linkSpecs = this.getNewLinkSpecs(batch, this.getGraphID())).isEmpty()) {
                        this.sendLinkSpecs(linkSpecs);
                    }
                    GraphTransactionBatch resolvedBatch = resolver.outgoing(batch);
                    GraphTransactionSerializer serializer = new GraphTransactionSerializer();
                    String xml = serializer.toString(resolvedBatch, this.getGraphID());
                    this.tx().sendPayload(null, xml);
                    LOG.log(Level.FINE, "{0} sent = {1}", new Object[]{this.getClientUser().getAlias(), xml});
                }
                catch (CollaborationException ex) {
                    this.error((Exception)((Object)ex));
                    NormalException.showStackTrace((Throwable)((Object)ex));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<MaltegoEntitySpec> getNewEntitySpecs(GraphTransactionBatch batch, GraphID graphID) throws CollaborationException {
        Set<String> set = this._entitySpecs;
        synchronized (set) {
            EntityRegistry registry = EntityRegistry.forGraphID((GraphID)graphID);
            HashSet<MaltegoEntitySpec> specs = new HashSet<MaltegoEntitySpec>();
            for (GraphTransaction xaction : batch.getTransactions()) {
                for (EntityID entityID : xaction.getEntityIDs()) {
                    String type = xaction.getEntity(entityID).getTypeName();
                    if (type == null) continue;
                    List inheritedSpecs = InheritanceHelper.getInheritanceList((SpecRegistry)registry, (String)type);
                    for (String inheritedType : inheritedSpecs) {
                        MaltegoEntitySpec spec;
                        if (this._entitySpecs.contains(inheritedType) || (spec = (MaltegoEntitySpec)registry.get(inheritedType)) == null) continue;
                        specs.add(spec);
                    }
                }
            }
            return specs;
        }
    }

    private void sendIconsFor(Collection<MaltegoEntitySpec> specs) throws CollaborationException {
        try {
            IconCollection icons = this.getIconsToSend(specs);
            if (!icons.isEmpty()) {
                IconsSerializer serializer = new IconsSerializer();
                String payload = serializer.toString(icons);
                this.tx().sendPayload(null, payload);
            }
        }
        catch (GraphSerializationException ex) {
            throw new CollaborationSerializationException((NormalException)ex);
        }
    }

    private IconCollection getIconsToSend(Collection<MaltegoEntitySpec> specs) throws CollaborationException {
        Args.notNull(specs, (String)"specs");
        Set<VirtualIcon> specIcons = this.getSpecIcons(specs);
        this.removeBuiltInIcons(specIcons);
        return this.getIcons(specIcons);
    }

    private Set<VirtualIcon> getSpecIcons(Collection<MaltegoEntitySpec> specs) {
        HashSet<VirtualIcon> iconDetails = new HashSet<VirtualIcon>();
        for (MaltegoEntitySpec spec : specs) {
            VirtualIcon.parse((String)spec.getSmallIconResource()).ifPresent(iconDetails::add);
            VirtualIcon.parse((String)spec.getLargeIconResource()).ifPresent(iconDetails::add);
        }
        return iconDetails;
    }

    private void removeBuiltInIcons(Set<VirtualIcon> iconDetails) {
        IconResourceRegistry resourceRegistry = IconResourceRegistry.getDefault();
        Iterator<VirtualIcon> itr = iconDetails.iterator();
        while (itr.hasNext()) {
            VirtualIcon details = itr.next();
            if (!resourceRegistry.existsCaseInsensitive((String)details.getCategory().orElse(null), details.getNameOrAlias())) continue;
            itr.remove();
        }
    }

    private IconCollection getIcons(Set<VirtualIcon> specIcons) throws CollaborationException {
        IconCollection iconCollection = new IconCollection();
        IconRegistry iconRegistry = IconRegistry.forGraphID((GraphID)this._graphDataObject.getGraphID());
        for (VirtualIcon icon : specIcons) {
            iconRegistry.findRegistryIcon(icon).ifPresent(registryIcon -> {
                String categoryTemp = icon.getCategory().orElse(null);
                String nameTemp = icon.getNameOrAlias();
                Image tiny = iconRegistry.loadImage(registryIcon, IconSize.TINY).orElse(null);
                Image large = iconRegistry.loadImage(registryIcon, IconSize.LARGE).orElse(null);
                if (tiny != null || large != null) {
                    HashMap<String, IconCollection.Icon> icons = (HashMap<String, IconCollection.Icon>)iconCollection.get((Object)categoryTemp);
                    if (icons == null) {
                        icons = new HashMap<String, IconCollection.Icon>();
                        iconCollection.put((Object)categoryTemp, icons);
                    }
                    EnumMap<IconSize, Image> sizes = new EnumMap<IconSize, Image>(IconSize.class);
                    if (tiny != null) {
                        sizes.put(IconSize.TINY, tiny);
                    }
                    if (large != null) {
                        sizes.put(IconSize.LARGE, large);
                    }
                    Set aliases = registryIcon.getAliases();
                    icons.put(nameTemp, new IconCollection.Icon(sizes, aliases));
                }
            });
        }
        return iconCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEntitySpecs(Collection<MaltegoEntitySpec> specs) throws CollaborationException {
        Set<String> set = this._entitySpecs;
        synchronized (set) {
            EntitySpecSerializer serializer = new EntitySpecSerializer();
            String payload = PayloadHelper.createPayload("especs", serializer.toString(specs), false);
            this.tx().sendPayload(null, payload);
            for (MaltegoEntitySpec spec : specs) {
                this._entitySpecs.add(spec.getTypeName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<MaltegoLinkSpec> getNewLinkSpecs(GraphTransactionBatch batch, GraphID graphID) throws CollaborationException {
        Set<String> set = this._linkSpecs;
        synchronized (set) {
            LinkRegistry registry = LinkRegistry.forGraphID((GraphID)graphID);
            HashSet<MaltegoLinkSpec> specs = new HashSet<MaltegoLinkSpec>();
            for (GraphTransaction xaction : batch.getTransactions()) {
                for (LinkID linkID : xaction.getLinkIDs()) {
                    MaltegoLinkSpec spec;
                    String type = xaction.getLink(linkID).getTypeName();
                    if (type == null || this._linkSpecs.contains(type) || (spec = (MaltegoLinkSpec)registry.get(type)) == null) continue;
                    specs.add(spec);
                }
            }
            return specs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLinkSpecs(Collection<MaltegoLinkSpec> specs) throws CollaborationException {
        Set<String> set = this._linkSpecs;
        synchronized (set) {
            LinkSpecSerializer serializer = new LinkSpecSerializer();
            String payload = PayloadHelper.createPayload("lspecs", serializer.toString(specs), false);
            this.tx().sendPayload(null, payload);
            for (MaltegoLinkSpec spec : specs) {
                this._linkSpecs.add(spec.getTypeName());
            }
        }
    }

    @Override
    protected void connectionStatusChanged(ConnectionStatusEvent evt) {
        super.connectionStatusChanged(evt);
        this.updateTabColor(evt.getNewStatus());
    }

    private void updateTabColor(ConnectionStatus status) {
        if (this._graphDataObject != null) {
            Color color = null;
            switch (status) {
                case Blocked: 
                case Connected: {
                    color = UIManager.getLookAndFeelDefaults().getColor("editor-tab-collaboration-connected-fg");
                    break;
                }
                case Disconnecting: 
                case Connecting: 
                case Offline: {
                    color = UIManager.getLookAndFeelDefaults().getColor("editor-tab-collaboration-disconnected-fg");
                }
            }
            this._graphDataObject.setDisplayNameColor(color);
        }
    }

    public static class BlockListener
    extends NodeEditHook {
        public void handle(String id, GraphID graphID) {
            ChatRoomCookie cookie;
            GraphDataObject gdo;
            boolean openedEditor = "labelEditorOpened".equals(id);
            if ((openedEditor || "labelEditorClosed".equals(id)) && (gdo = GraphDataUtils.getGraphDataObject((GraphID)graphID)) != null && (cookie = (ChatRoomCookie)gdo.getLookup().lookup(ChatRoomCookie.class)) != null) {
                ChatRoom chatRoom = cookie.getChatRoom();
                try {
                    chatRoom.setBlocked(openedEditor);
                }
                catch (ConnectionException ex) {
                    NormalException.showStackTrace((Throwable)ex);
                }
            }
        }
    }

    public class GraphLoggerListener
    implements GraphLogListener {
        public void logMessage(GraphID graphID, String message) {
            if (graphID.equals((Object)GraphChatRoom.this.getGraphID())) {
                GraphChatRoom.this.sendInfoNotification(message);
            }
        }
    }

    private class LayoutChangeListener
    implements PropertyChangeListener {
        private LayoutChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LayoutSettingsWrapper wrapper;
            GraphID graphID;
            if (!GraphChatRoom.this._doingLayout && (graphID = (wrapper = (LayoutSettingsWrapper)evt.getNewValue()).getGraphID()) != null && graphID.equals((Object)GraphChatRoom.this.getGraphID())) {
                String viewGraphName = ViewGraphName.get((GraphID)graphID);
                LayoutSettings layoutSettings = wrapper.getLayoutSettings();
                LayoutModeSettings settings = new LayoutModeSettings(viewGraphName, layoutSettings);
                LayoutModeSerializer serializer = new LayoutModeSerializer();
                String payload = PayloadHelper.createPayload("layouts", serializer.toString(Collections.singleton(settings)), false);
                try {
                    GraphChatRoom.this.tx().sendPayload(null, payload);
                }
                catch (CollaborationException ex) {
                    GraphChatRoom.this.error((Exception)((Object)ex));
                    NormalException.showStackTrace((Throwable)((Object)ex));
                }
            }
        }
    }

    private class CollectionSettingsListener
    implements PropertyChangeListener {
        private CollectionSettingsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!GraphChatRoom.this._doingCollectionSettings) {
                GraphID graphID = (GraphID)evt.getNewValue();
                if (GraphChatRoom.this.getGraphID().equals((Object)graphID)) {
                    try {
                        CollectionSettings settings = CollectionSettings.getDefault();
                        CollectionSettingsSerializer serializer = new CollectionSettingsSerializer();
                        String payload = serializer.toString(graphID, settings);
                        GraphChatRoom.this.tx().sendPayload(null, payload);
                    }
                    catch (CollaborationException ex) {
                        GraphChatRoom.this.error((Exception)((Object)ex));
                        NormalException.showStackTrace((Throwable)((Object)ex));
                    }
                }
            }
        }
    }

    private class LogCallbackHandler
    implements LogCallback {
        private LogCallbackHandler() {
        }

        @Override
        public void log(String message, Date timestamp) {
            LogMessageLevel level = LogMessageLevel.Warning;
            if (ChatFilterSettings.isShow(level, GraphChatRoom.this.isDebugMode())) {
                GraphChatRoom.this.logMessage(level, new OutputMessage(message), MessageColors.getColor(level), timestamp);
            }
        }
    }

    private class GraphProviderImpl
    implements GraphProvider {
        private GraphProviderImpl() {
        }

        @Override
        public boolean hasGraph() {
            return true;
        }

        @Override
        public void merge(PayloadCollection payloads) {
            try {
                CollaborationChatRoom.runInEDTNow(() -> this.mergeImpl(payloads));
            }
            catch (InterruptedException | InvocationTargetException ex) {
                NormalException.showStackTrace((Throwable)ex);
            }
        }

        private void mergeImpl(PayloadCollection payloads) {
            final GraphID graphID = GraphChatRoom.this.getGraphDataObject().getGraphID();
            try {
                final GraphID copyGraphID = GraphCopyHelper.copy((GraphID)graphID);
                this.addCreatedAndModifiedProperties(copyGraphID);
                this.clearGraph(graphID);
                GraphChatRoom.this.handleRxPayload(payloads);
                ConnectionStatusListener connectionStatusListener = new ConnectionStatusListener(){

                    public void statusChanged(ConnectionStatusEvent evt) {
                        if (evt.getNewStatus() == ConnectionStatus.Connected) {
                            1 instance = this;
                            Thread t = new Thread(() -> {
                                Object object = GraphChatRoom.this._initializationLock;
                                synchronized (object) {
                                    while (!GraphChatRoom.this._uiActive) {
                                        try {
                                            GraphChatRoom.this._initializationLock.wait();
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                }
                                SwingUtilities.invokeLater(() -> {
                                    SimilarStrings description = new SimilarStrings("Merge existing graph");
                                    InteractiveGraphMerger merger = new InteractiveGraphMerger(graphID, copyGraphID, description);
                                    merger.promptMergeGraphs();
                                    merger.mergeGraphs();
                                    GraphChatRoom.this.removeConnectionStatusListener(instance);
                                });
                            }, "Merge Local Graph Waiting");
                            t.start();
                        }
                    }
                };
                GraphChatRoom.this.addConnectionStatusListener(connectionStatusListener);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private void addCreatedAndModifiedProperties(GraphID graphCopyID) {
            DateTime now = new DateTime();
            String alias = GraphChatRoom.this.getClientUser().getAlias();
            Set entities = GraphStoreHelper.getMaltegoEntities((GraphID)graphCopyID);
            for (MaltegoEntity entity : entities) {
                ModifiedHelper.addCreatedAndModifiedIfMissing((MaltegoPart)entity, (String)alias, (DateTime)now);
            }
            Set links = GraphStoreHelper.getMaltegoLinks((GraphID)graphCopyID);
            for (MaltegoLink link : links) {
                ModifiedHelper.addCreatedAndModifiedIfMissing((MaltegoPart)link, (String)alias, (DateTime)now);
            }
        }

        @Override
        public void replace(PayloadCollection payloads) {
            try {
                CollaborationChatRoom.runInEDTNow(() -> this.replaceImpl(payloads));
            }
            catch (InterruptedException | InvocationTargetException ex) {
                NormalException.showStackTrace((Throwable)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void replaceImpl(PayloadCollection payloads) {
            GraphStore graphStore = null;
            try {
                GraphID graphID = GraphChatRoom.this.getGraphDataObject().getGraphID();
                graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                graphStore.beginUpdate();
                this.clearGraph(graphID);
                GraphChatRoom.this.handleRxPayload(payloads);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (graphStore != null) {
                    graphStore.endUpdate((Object)false);
                }
            }
        }

        private void clearGraph(GraphID graphID) {
            Set entityIDs = GraphStoreHelper.getEntityIDs((GraphID)graphID);
            GraphStoreWriter.removeEntities((GraphID)graphID, (Collection)entityIDs);
        }

        private GraphTransactionBatch createInitialTransactionBatch() {
            SimilarStrings descriptions = new SimilarStrings("Initial graph sync");
            GraphTransactionBatch batch = TransactionBatchFactory.createForGraph((SimilarStrings)descriptions, (GraphID)GraphChatRoom.this.getGraphID());
            if (batch.isEmpty()) {
                return null;
            }
            batch.setSequenceNumber(Integer.valueOf(GraphChatRoom.this.getGraphTransactor().reserve()));
            return batch;
        }

        @Override
        public GraphSnapshot createSnapshot() {
            try {
                GraphSnapshot snapshot = new GraphSnapshot();
                SwingUtilities.invokeAndWait(() -> {
                    try {
                        this.createSnapshot(snapshot, false);
                    }
                    catch (CollaborationException ex) {
                        NormalException.showStackTrace((Throwable)((Object)ex));
                    }
                });
                return snapshot;
            }
            catch (InterruptedException | InvocationTargetException ex) {
                NormalException.showStackTrace((Throwable)ex);
                return null;
            }
        }

        private Collection<MaltegoEntitySpec> getEntitySpecs(GraphTransactionBatch batch, GraphID graphID) throws CollaborationException {
            EntityRegistry registry = EntityRegistry.forGraphID((GraphID)graphID);
            HashSet<MaltegoEntitySpec> specs = new HashSet<MaltegoEntitySpec>();
            for (GraphTransaction xaction : batch.getTransactions()) {
                for (EntityID entityID : xaction.getEntityIDs()) {
                    String type = xaction.getEntity(entityID).getTypeName();
                    if (type == null) continue;
                    List inheritedSpecs = InheritanceHelper.getInheritanceList((SpecRegistry)registry, (String)type);
                    for (String inheritedType : inheritedSpecs) {
                        MaltegoEntitySpec spec = (MaltegoEntitySpec)registry.get(inheritedType);
                        if (spec == null) continue;
                        specs.add(spec);
                    }
                }
            }
            return specs;
        }

        private Collection<MaltegoLinkSpec> getLinkSpecs(GraphTransactionBatch batch, GraphID graphID) throws CollaborationException {
            LinkRegistry registry = LinkRegistry.forGraphID((GraphID)graphID);
            HashSet<MaltegoLinkSpec> specs = new HashSet<MaltegoLinkSpec>();
            for (GraphTransaction xaction : batch.getTransactions()) {
                for (LinkID linkID : xaction.getLinkIDs()) {
                    MaltegoLinkSpec spec;
                    String type = xaction.getLink(linkID).getTypeName();
                    if (type == null || (spec = (MaltegoLinkSpec)registry.get(type)) == null) continue;
                    specs.add(spec);
                }
            }
            return specs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private void createSnapshot(GraphSnapshot snapshot, boolean addToResolver) throws CollaborationException {
            Collection<MaltegoEntitySpec> especs = null;
            Collection<MaltegoLinkSpec> lspecs = null;
            Object object = GraphChatRoom.this._transactionIDLock;
            synchronized (object) {
                void var7_9;
                GraphID graphID = GraphChatRoom.this.getGraphID();
                Object var7_7 = null;
                String entitySpecsXml = null;
                String linkSpecsXml = null;
                String iconsXml = null;
                GraphTransactionBatch batch = null;
                try {
                    batch = this.createInitialTransactionBatch();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (batch != null) {
                    try {
                        GraphTransactionSerializer graphSerializer = new GraphTransactionSerializer();
                        String string = graphSerializer.toString(batch, graphID);
                        EntitySpecSerializer entitySpecSerializer = new EntitySpecSerializer();
                        especs = this.getEntitySpecs(batch, graphID);
                        entitySpecsXml = PayloadHelper.createPayload("especs", entitySpecSerializer.toString(especs), false);
                        LinkSpecSerializer linkSpecSerializer = new LinkSpecSerializer();
                        lspecs = this.getLinkSpecs(batch, graphID);
                        linkSpecsXml = PayloadHelper.createPayload("lspecs", linkSpecSerializer.toString(lspecs), false);
                        IconsSerializer serializer = new IconsSerializer();
                        IconCollection iconsToSend = GraphChatRoom.this.getIconsToSend(especs);
                        iconsXml = serializer.toString(iconsToSend);
                    }
                    catch (GraphSerializationException ex) {
                        throw new CollaborationSerializationException((NormalException)ex);
                    }
                }
                snapshot.setEntitySpecs(entitySpecsXml);
                snapshot.setLinkSpecs(linkSpecsXml);
                snapshot.setIcons(iconsXml);
                snapshot.setTransactions((String)var7_9);
                snapshot.setLayoutSettings(this.createLayoutSettingsPayload(graphID));
                snapshot.setCollectionSettings(this.createCollectionSettingsPayload(graphID));
                snapshot.setLastTransactionID(GraphChatRoom.this._lastAppliedTransactionID);
            }
            if (especs != null && !especs.isEmpty()) {
                object = GraphChatRoom.this._entitySpecs;
                synchronized (object) {
                    for (MaltegoEntitySpec maltegoEntitySpec : especs) {
                        GraphChatRoom.this._entitySpecs.add(maltegoEntitySpec.getTypeName());
                    }
                }
            }
            if (lspecs != null && !lspecs.isEmpty()) {
                object = GraphChatRoom.this._linkSpecs;
                synchronized (object) {
                    for (MaltegoLinkSpec maltegoLinkSpec : lspecs) {
                        GraphChatRoom.this._linkSpecs.add(maltegoLinkSpec.getTypeName());
                    }
                }
            }
        }

        @Override
        public void sendInitialGraph() {
            SwingUtilities.invokeLater(() -> {
                try {
                    GraphChatRoom.this.conflictResolver().ifPresent(resolver -> resolver.reset());
                    GraphSnapshot snapshot = new GraphSnapshot();
                    this.createSnapshot(snapshot, true);
                    String xml = StartGraphMessage.create(snapshot).toXml();
                    LOG.log(Level.FINE, "Initial graph XML:\n{0}", xml);
                    GraphChatRoom.this.tx().sendPayload(null, xml);
                }
                catch (CollaborationException ex) {
                    GraphChatRoom.this.error((Exception)((Object)ex));
                    NormalException.showStackTrace((Throwable)((Object)ex));
                }
            });
        }

        @Override
        public void addToResolverQueue(Collection<String> transactions) {
            GraphChatRoom.this.conflictResolver().ifPresent(resolver -> {
                try {
                    GraphTransactionSerializer serializer = new GraphTransactionSerializer();
                    GraphID graphID = GraphChatRoom.this.getGraphID();
                    for (String payload : transactions) {
                        GraphTransactionBatch batch = serializer.readBatch(payload, graphID);
                        resolver.outgoing(batch);
                    }
                }
                catch (CollaborationSerializationException ex) {
                    NormalException.showStackTrace((Throwable)((Object)ex));
                }
            });
        }

        @Override
        public void resetResolver() {
            GraphChatRoom.this.conflictResolver().ifPresent(resolver -> resolver.reset());
        }

        private String createCollectionSettingsPayload(GraphID graphID) throws CollaborationException {
            CollectionSettingsSerializer serializer = new CollectionSettingsSerializer();
            String payloadStr = serializer.toString(graphID, CollectionSettings.getDefault());
            return payloadStr;
        }

        private String createLayoutSettingsPayload(GraphID graphID) {
            StringBuilder payload = new StringBuilder();
            List<LayoutModeSettings> layoutModeSettings = this.getLayoutModeSettings(graphID);
            LayoutModeSerializer serializer = new LayoutModeSerializer();
            payload.append(PayloadHelper.createPayload("layouts", serializer.toString(layoutModeSettings), false));
            return payload.toString();
        }

        private List<LayoutModeSettings> getLayoutModeSettings(GraphID graphID) {
            ArrayList<LayoutModeSettings> lms = new ArrayList<LayoutModeSettings>();
            String viewGraphName = ViewGraphName.get((GraphID)graphID);
            if (viewGraphName != null) {
                GraphView graphView = GraphViewRegistry.get((GraphID)graphID);
                LayoutSettings layoutSettings = graphView.getLayoutSettings();
                LayoutModeSettings settings = new LayoutModeSettings(viewGraphName, layoutSettings);
                lms.add(settings);
            }
            return lms;
        }
    }
}

