/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraFilter;
import com.pinkmatter.pandora.TypeUtils;
import com.pinkmatter.pandora.lucene.serialize.FilterHelper;
import com.pinkmatter.pandora.lucene.serialize.TypeConverter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTypeConverter<T>
extends TypeConverter {
    private final String _type;
    private final Class<? extends T> _class;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTypeConverter.class);

    public AbstractTypeConverter(String typeName, Class<? extends T> clazz) {
        this._type = typeName;
        this._class = clazz;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public Class getClassType() {
        return this._class;
    }

    @Override
    public boolean isApplicable(Object input) {
        if (input == null) {
            return false;
        }
        return this.isApplicable(input, this._class);
    }

    @Override
    public boolean isApplicable(Class type) {
        return this.isApplicableClass(type, this._class);
    }

    protected boolean isApplicableClass(Class type, Class to) {
        if (type.isArray()) {
            type = type.getComponentType();
        }
        return to.isAssignableFrom(type);
    }

    protected boolean isApplicable(Object input, Class to) {
        Class type = TypeUtils.getDeepType((Object)input);
        return to.isAssignableFrom(type);
    }

    @Override
    public boolean isApplicable(String field) {
        return this._type.equals(this.getFieldType(field));
    }

    protected abstract void writeImpl(T var1, String var2, Document var3) throws PandoraException;

    @Override
    public void write(Object value, String property, Document to) throws PandoraException {
        try {
            if (value != null) {
                LOG.debug("Writing field: {}, value: {}", (Object)property, value);
                if (!value.getClass().isArray()) {
                    this.writeImpl(value, property, to);
                } else {
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        Object val = Array.get(value, i);
                        if (val == null) continue;
                        this.writeImpl(val, property, to);
                    }
                }
            }
        }
        catch (PandoraException | ArrayIndexOutOfBoundsException | IllegalArgumentException ex) {
            throw new PandoraException(String.format("Error writing field: %s with value: %s using converter: %s.", property, value, this._type), ex);
        }
    }

    protected abstract T readImpl(IndexableField var1) throws PandoraException;

    @Override
    public Object read(List<IndexableField> from) throws PandoraException {
        return this.read(from, "");
    }

    @Override
    public Object read(List<IndexableField> from, String prefix) throws PandoraException {
        if (from == null || from.isEmpty()) {
            return null;
        }
        IndexableField field = null;
        try {
            if (from.size() == 1) {
                field = from.get(0);
                LOG.debug("Reading field: {}, prefix: {}", (Object)field.name(), (Object)prefix);
                return this.readImpl(from.get(0));
            }
            Object values = this.createArray(from.size());
            for (int i = 0; i < from.size(); ++i) {
                field = from.get(i);
                LOG.debug("Reading field: {}, prefix: {}", (Object)field.name(), (Object)prefix);
                Array.set(values, i, this.readImpl(field));
            }
            return values;
        }
        catch (PandoraException | ArrayIndexOutOfBoundsException | IllegalArgumentException ex) {
            throw new PandoraException(String.format("Error reading field: %s with prefix: %s using converter: %s.", field != null ? field.name() : "null", prefix, this._type), ex);
        }
    }

    protected Object createArray(int size) {
        return Array.newInstance(this._class, size);
    }

    protected String getFieldType(String field) {
        int start = field.indexOf("[") + 1;
        int end = field.indexOf("]");
        if (end > start) {
            return field.substring(start, end);
        }
        return null;
    }

    @Override
    protected String getIndexField(String property) {
        StringBuilder builder = new StringBuilder();
        builder.append(property);
        builder.append("[");
        builder.append(this._type);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public String getProperty(String field) {
        return field.substring(0, field.indexOf("["));
    }

    @Override
    public Query createFilter(PandoraFilter.Simple descriptor) throws PandoraException {
        Query result = null;
        if (descriptor.isMultiValued()) {
            PandoraFilter.MultiValue pf = (PandoraFilter.MultiValue)descriptor;
            if (pf.isMatchAll()) {
                Query[] filters = this.toFilters((PandoraFilter.Simple[])pf.toSingleValuedFilters());
                result = FilterHelper.createAndFilter(filters);
            } else if (this.isFilterTermsSupported()) {
                result = this.createAnyTermsFilter(pf.getProperty(), pf.getValues());
            } else {
                Query[] filters = this.toFilters((PandoraFilter.Simple[])pf.toSingleValuedFilters());
                result = FilterHelper.createOrQuery(filters);
            }
        } else {
            result = this.createSingleFilter(descriptor);
        }
        if (result == null) {
            throw new UnsupportedOperationException(String.format("Filter of type %s is not supported.", descriptor.getClass()));
        }
        return result;
    }

    private Query[] toFilters(PandoraFilter.Simple[] descriptors) throws PandoraException {
        Query[] filters = new Query[descriptors.length];
        int i = 0;
        for (PandoraFilter.Simple d : descriptors) {
            filters[i] = this.createFilter(d);
            ++i;
        }
        return filters;
    }

    private Query createSingleFilter(PandoraFilter.Simple parameters) throws PandoraException {
        if (parameters instanceof PandoraFilter.Empty) {
            return this.createEmptyFilter(parameters.getProperty());
        }
        if (parameters instanceof PandoraFilter.NotEmpty) {
            return this.createNotEmptyFilter(parameters.getProperty());
        }
        Query filter = this.createFilterImpl(parameters);
        if (filter == null) {
            throw new UnsupportedOperationException(String.format("Filter %s of type %s is not supported on TypeConverter of type %s.", parameters, parameters.getType(), this._type));
        }
        if (parameters.includeEmpty()) {
            Query emptyFilter = this.createEmptyFilter(parameters.getProperty());
            filter = FilterHelper.createOrQuery(filter, emptyFilter);
        }
        return filter;
    }

    protected Query createEmptyFilter(String property) throws PandoraException {
        String field = this.getIndexField(property);
        return FilterHelper.createEmptyFilter(field);
    }

    protected Query createNotEmptyFilter(String property) throws PandoraException {
        String field = this.getIndexField(property);
        return FilterHelper.createNotEmptyFilter(field);
    }

    protected abstract Query createFilterImpl(PandoraFilter.Simple var1) throws PandoraException;

    protected Query createAnyTermsFilter(String property, T[] values) {
        String field = this.getIndexField(property);
        ArrayList<Term> terms = new ArrayList<Term>();
        for (T value : values) {
            BytesRef bytes = this.createFilterTerm(value);
            terms.add(new Term(field, bytes));
        }
        return FilterHelper.createTermsQuery(terms);
    }

    protected BytesRef createFilterTerm(T value) {
        throw new UnsupportedOperationException(String.format("TypeConverter of type %s does not support filter terms.", this._type));
    }

    protected boolean isFilterTermsSupported() {
        return false;
    }

    @Override
    public SortField[] getSortFields(String property, boolean reverse, boolean emptyFirst) {
        return this.getSortFieldsImpl(property, reverse, emptyFirst);
    }

    protected abstract SortField[] getSortFieldsImpl(String var1, boolean var2, boolean var3);

    public String toString() {
        return "TypeConverter{type=" + this._type + ", class=" + this._class + '}';
    }

    public int hashCode() {
        int hash = 5;
        hash = 31 * hash + Objects.hashCode(this._type);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTypeConverter other = (AbstractTypeConverter)obj;
        return Objects.equals(this._type, other._type);
    }
}

