/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractDialog;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.ZapTextField;

public class FindDialog
extends AbstractDialog {
    private static final long serialVersionUID = -3223449799557586758L;
    private static final Logger LOGGER = LogManager.getLogger(FindDialog.class);
    private static Map<Object, FindDialog> parentsMap = new ReferenceMap(2, 0);
    private JPanel jPanel = null;
    private JButton btnFind = null;
    private JButton btnCancel = null;
    private ZapTextField txtFind = null;
    private JPanel jPanel1 = null;
    private JTextComponent lastInvoker = null;
    private JLabel infoLabel;

    public void setLastInvoker(JTextComponent lastInvoker) {
        String selectedText;
        this.lastInvoker = lastInvoker;
        if (lastInvoker != null && (selectedText = lastInvoker.getSelectedText()) != null) {
            this.getTxtFind().setText(selectedText);
        }
    }

    @Deprecated
    public FindDialog() throws HeadlessException {
        this.initialize();
    }

    @Deprecated
    public FindDialog(Frame arg0, boolean arg1) throws HeadlessException {
        super(arg0, arg1);
        this.initialize();
    }

    public FindDialog(Window parent, boolean modal) throws HeadlessException {
        super(parent, modal);
        this.initialize();
    }

    private void initialize() {
        this.setTitle(Constant.messages.getString("edit.find.title"));
        this.infoLabel = new JLabel(Constant.messages.getString("edit.find.label.notfound"));
        this.infoLabel.setVisible(false);
        this.setContentPane(this.getJPanel());
        this.centreDialog();
        this.txtFind.requestFocus();
        this.getRootPane().setDefaultButton(this.btnFind);
        this.pack();
        this.setVisible(true);
    }

    private static Map<Object, FindDialog> getParentsMap() {
        return parentsMap;
    }

    public static FindDialog getDialog(final Window parent, boolean modal) {
        if (parent == null) {
            throw new IllegalArgumentException("The parent must not be null.");
        }
        FindDialog activeDialog = FindDialog.getParentsMap().get(parent);
        if (activeDialog != null) {
            activeDialog.getTxtFind().requestFocus();
            return activeDialog;
        }
        FindDialog newDialog = new FindDialog(parent, modal);
        FindDialog.getParentsMap().put(parent, newDialog);
        newDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                FindDialog.getParentsMap().remove(parent);
            }
        });
        return newDialog;
    }

    private void discard() {
        this.setVisible(false);
        this.dispose();
    }

    private void find() {
        JFrame parent;
        Component c;
        JTextComponent txtComp = this.lastInvoker;
        if (txtComp == null && (c = (parent = (JFrame)this.getParent()).getMostRecentFocusOwner()) instanceof JTextComponent) {
            txtComp = (JTextComponent)c;
        }
        this.infoLabel.setVisible(false);
        if (txtComp == null) {
            return;
        }
        try {
            String findText = this.txtFind.getText().toLowerCase();
            String txt = txtComp.getText().toLowerCase();
            int startPos = txt.indexOf(findText, txtComp.getCaretPosition());
            if (startPos <= 0) {
                txtComp.setCaretPosition(0);
                startPos = txt.indexOf(findText, txtComp.getCaretPosition());
            }
            int length = findText.length();
            if (startPos > -1) {
                txtComp.setSelectionColor(DisplayUtils.getHighlightColor());
                txtComp.select(startPos, startPos + length);
                txtComp.requestFocusInWindow();
                this.txtFind.requestFocusInWindow();
            } else {
                this.infoLabel.setVisible(true);
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while finding:", (Throwable)e);
        }
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            JLabel jLabel = new JLabel(Constant.messages.getString("edit.find.label.what"));
            this.jPanel = new JPanel();
            GroupLayout layout = new GroupLayout(this.jPanel);
            this.jPanel.setLayout(layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            layout.setHonorsVisibility(this.infoLabel, Boolean.FALSE);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getTxtFind()).addComponent(this.infoLabel).addComponent(this.getJPanel1())));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel).addComponent(this.getTxtFind())).addComponent(this.infoLabel).addComponent(this.getJPanel1()));
        }
        return this.jPanel;
    }

    private JButton getBtnFind() {
        if (this.btnFind == null) {
            this.btnFind = new JButton();
            this.btnFind.setText(Constant.messages.getString("edit.find.button.find"));
            this.btnFind.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindDialog.this.find();
                }
            });
        }
        return this.btnFind;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText(Constant.messages.getString("edit.find.button.cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindDialog.this.discard();
                    FindDialog.this.dispatchEvent(new WindowEvent(FindDialog.this, 201));
                }
            });
        }
        return this.btnCancel;
    }

    private ZapTextField getTxtFind() {
        if (this.txtFind == null) {
            this.txtFind = new ZapTextField(15);
        }
        return this.txtFind;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel(new FlowLayout(4));
            this.jPanel1.add(this.getBtnFind());
            this.jPanel1.add(this.getBtnCancel());
        }
        return this.jPanel1;
    }
}

