// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQDMULL_2D_TRACE_AARCH64_H_
#define VIXL_SIM_SQDMULL_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_sqdmull_2D[] = {
  0x000000007c080000, 0x000000007e020000,
  0x000000007d040000, 0x0000007efd060000,
  0x0000007dfd0c0000, 0x0000000000000000,
  0x0000000000000000, 0x000000000000fe00,
  0x000000000000fc00, 0x000000000001fc00,
  0x000000000001f800, 0x00000000001fc000,
  0x00000000001f8000, 0x00000000007c0600,
  0x00000000007b0c00, 0x00000000007d0400,
  0x00000000007c0800, 0x00000000007e0200,
  0x00000000007d0400, 0x000000007efd0600,
  0x000000007dfd0c00, 0x000000007efe0400,
  0x000000007dfe0800, 0x000000007eff0200,
  0x000000007dff0400, 0x000032cccccc9a00,
  0x0000326666663400, 0x000054aaaaaa5600,
  0x000053ffffffac00, 0x00007efffffd0600,
  0x00007dfffffd0c00, 0x00007efffffe0400,
  0x00007dfffffe0800, 0x00007effffff0200,
  0x00007dffffff0400, 0xffff810000000000,
  0xffff820000000000, 0xffff81000000fe00,
  0xffff82000000fc00, 0xffffab555554ac00,
  0xffffabffffff5800, 0xffffcd3333326800,
  0xffffcd999998d000, 0xffffffff81000000,
  0xffffffff82000000, 0xffffffff8100fe00,
  0xffffffff8200fc00, 0xffffffff8101fc00,
  0xffffffff8201f800, 0xffffffff8102fa00,
  0xffffffff8202f400, 0xffffffffff810000,
  0xffffffffff820000, 0xffffffffff81fe00,
  0xffffffffff82fc00, 0xffffffffff82fc00,
  0xffffffffff83f800, 0xffffffffff83fa00,
  0xffffffffff84f400, 0xffffffffffe04000,
  0xffffffffffe08000, 0xfffffffffffd0600,
  0xfffffffffffd0600, 0xfffffffffe000c00,
  0xfffffffffffe0400, 0xffffffffff000600,
  0xffffffffffff0200, 0x0000000000000000,
  0x0000000000000000, 0x0000000000fffa00,
  0x000000000000fe00, 0x0000000001fff400,
  0x000000000001fc00, 0x000000001fff4000,
  0x00000000001fc000, 0x000000007cfd1200,
  0x00000000007c0600, 0x000000007dfd0c00,
  0x00000000007d0400, 0x000000007efd0600,
  0x00000000007e0200, 0x0000007ffa001200,
  0x000000007efd0600, 0x0000007ffb000c00,
  0x000000007efe0400, 0x0000007ffc000600,
  0x000000007eff0200, 0x003331ffffccce00,
  0x000032cccccc9a00, 0x0055535555000200,
  0x000054aaaaaa5600, 0x007ffcfffd001200,
  0x00007efffffd0600, 0x007ffcfffe000c00,
  0x00007efffffe0400, 0x007ffcffff000600,
  0x00007effffff0200, 0xff80030000000000,
  0xffff810000000000, 0xff80030000fffa00,
  0xffff81000000fe00, 0xffaaacaaaa000400,
  0xffffab555554ac00, 0xffcccdffff333800,
  0xffffcd3333326800, 0xffffff8003000000,
  0xffffffff81000000, 0xffffff8003fffa00,
  0xffffffff8100fe00, 0xffffff8004fff400,
  0xffffffff8101fc00, 0xffffff8005ffee00,
  0xffffffff8102fa00, 0xffffffff80030000,
  0xffffffffff810000, 0xffffffff8102fa00,
  0xffffffffff81fe00, 0xffffffff8202f400,
  0xffffffffff82fc00, 0xffffffff8302ee00,
  0xffffffffff83fa00, 0xffffffffe000c000,
  0xffffffffffe04000, 0xfffffffffd001200,
  0xfffffffffd001200, 0x0000000000000000,
  0xfffffffffe000c00, 0x0000000000000000,
  0xffffffffff000600, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000fffa00, 0x0000000000000000,
  0x0000000001fff400, 0x0000000000000000,
  0x000000001fff4000, 0x0000000000000000,
  0x000000007cfd1200, 0x0000000000000000,
  0x000000007dfd0c00, 0x0000000000000000,
  0x000000007efd0600, 0x0000000000000000,
  0x0000007ffa001200, 0x0000000000000000,
  0x0000007ffb000c00, 0x0000000000000000,
  0x0000007ffc000600, 0x0000000000000000,
  0x003331ffffccce00, 0x0000000000000000,
  0x0055535555000200, 0x0000000000000000,
  0x007ffcfffd001200, 0x0000000000000000,
  0x007ffcfffe000c00, 0x0000000000000000,
  0x007ffcffff000600, 0x0000000000000000,
  0xff80030000000000, 0x0000000000000000,
  0xff80030000fffa00, 0x0000000000000000,
  0xffaaacaaaa000400, 0x0000000000000000,
  0xffcccdffff333800, 0x0000000000000000,
  0xffffff8003000000, 0x0000000000000000,
  0xffffff8003fffa00, 0x0000000000000000,
  0xffffff8004fff400, 0x0000000000000000,
  0xffffff8005ffee00, 0x0000000000000000,
  0xffffffff80030000, 0x0000000000000000,
  0xffffffff8102fa00, 0x0000000000000000,
  0xffffffff8202f400, 0x0000000000000000,
  0xffffffff8302ee00, 0x0000000000000000,
  0xffffffffe000c000, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffffffc,
  0x0000000000000000, 0xfffffffffffffffe,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000004,
  0x0000000000000000, 0x0000000000000040,
  0x0000000000000000, 0x00000000000000fa,
  0x0000000000000000, 0x00000000000000fc,
  0x0000000000000000, 0x00000000000000fe,
  0x0000000000000000, 0x000000000000fffa,
  0x0000000000000000, 0x000000000000fffc,
  0x0000000000000000, 0x000000000000fffe,
  0x0000000000000000, 0x0000000066666666,
  0x0000000000000000, 0x00000000aaaaaaaa,
  0x0000000000000000, 0x00000000fffffffa,
  0x0000000000000000, 0x00000000fffffffc,
  0x0000000000000000, 0x00000000fffffffe,
  0x0000000000000000, 0xffffffff00000000,
  0x0000000000000000, 0xffffffff00000002,
  0x0000000000000000, 0xffffffff55555554,
  0x0000000000000000, 0xffffffff99999998,
  0x0000000000000000, 0xffffffffffff0000,
  0x0000000000000000, 0xffffffffffff0002,
  0x0000000000000000, 0xffffffffffff0004,
  0x0000000000000000, 0xffffffffffff0006,
  0x0000000000000000, 0xffffffffffffff00,
  0x0000000000000000, 0xffffffffffffff02,
  0x0000000000000000, 0xffffffffffffff04,
  0x0000000000000000, 0xffffffffffffff06,
  0x0000000000000000, 0xffffffffffffffc0,
  0x0000000000000000, 0xfffffffffffffffa,
  0xfffffffffffffffa, 0xfffffffffffffff8,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffffe, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000004,
  0x0000000000000002, 0x0000000000000008,
  0x0000000000000004, 0x0000000000000080,
  0x0000000000000040, 0x00000000000001f4,
  0x00000000000000fa, 0x00000000000001f8,
  0x00000000000000fc, 0x00000000000001fc,
  0x00000000000000fe, 0x000000000001fff4,
  0x000000000000fffa, 0x000000000001fff8,
  0x000000000000fffc, 0x000000000001fffc,
  0x000000000000fffe, 0x00000000cccccccc,
  0x0000000066666666, 0x0000000155555554,
  0x00000000aaaaaaaa, 0x00000001fffffff4,
  0x00000000fffffffa, 0x00000001fffffff8,
  0x00000000fffffffc, 0x00000001fffffffc,
  0x00000000fffffffe, 0xfffffffe00000000,
  0xffffffff00000000, 0xfffffffe00000004,
  0xffffffff00000002, 0xfffffffeaaaaaaa8,
  0xffffffff55555554, 0xffffffff33333330,
  0xffffffff99999998, 0xfffffffffffe0000,
  0xffffffffffff0000, 0xfffffffffffe0004,
  0xffffffffffff0002, 0xfffffffffffe0008,
  0xffffffffffff0004, 0xfffffffffffe000c,
  0xffffffffffff0006, 0xfffffffffffffe00,
  0xffffffffffffff00, 0xfffffffffffffe04,
  0xffffffffffffff02, 0xfffffffffffffe08,
  0xffffffffffffff04, 0xfffffffffffffe0c,
  0xffffffffffffff06, 0xffffffffffffff80,
  0xffffffffffffffc0, 0xfffffffffffffff4,
  0xfffffffffffffff4, 0xffffffffffffff80,
  0xfffffffffffffff8, 0xffffffffffffffc0,
  0xfffffffffffffffc, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000040,
  0x0000000000000004, 0x0000000000000080,
  0x0000000000000008, 0x0000000000000800,
  0x0000000000000080, 0x0000000000001f40,
  0x00000000000001f4, 0x0000000000001f80,
  0x00000000000001f8, 0x0000000000001fc0,
  0x00000000000001fc, 0x00000000001fff40,
  0x000000000001fff4, 0x00000000001fff80,
  0x000000000001fff8, 0x00000000001fffc0,
  0x000000000001fffc, 0x0000000cccccccc0,
  0x00000000cccccccc, 0x0000001555555540,
  0x0000000155555554, 0x0000001fffffff40,
  0x00000001fffffff4, 0x0000001fffffff80,
  0x00000001fffffff8, 0x0000001fffffffc0,
  0x00000001fffffffc, 0xffffffe000000000,
  0xfffffffe00000000, 0xffffffe000000040,
  0xfffffffe00000004, 0xffffffeaaaaaaa80,
  0xfffffffeaaaaaaa8, 0xfffffff333333300,
  0xffffffff33333330, 0xffffffffffe00000,
  0xfffffffffffe0000, 0xffffffffffe00040,
  0xfffffffffffe0004, 0xffffffffffe00080,
  0xfffffffffffe0008, 0xffffffffffe000c0,
  0xfffffffffffe000c, 0xffffffffffffe000,
  0xfffffffffffffe00, 0xffffffffffffe040,
  0xfffffffffffffe04, 0xffffffffffffe080,
  0xfffffffffffffe08, 0xffffffffffffe0c0,
  0xfffffffffffffe0c, 0xfffffffffffff800,
  0xffffffffffffff80, 0xffffffffffffff40,
  0xffffffffffffff40, 0xfffffffffffffe0c,
  0xffffffffffffff80, 0xffffffffffffff06,
  0xffffffffffffffc0, 0x0000000000000000,
  0x0000000000000000, 0x00000000000000fa,
  0x0000000000000040, 0x00000000000001f4,
  0x0000000000000080, 0x0000000000001f40,
  0x0000000000000800, 0x0000000000007a12,
  0x0000000000001f40, 0x0000000000007b0c,
  0x0000000000001f80, 0x0000000000007c06,
  0x0000000000001fc0, 0x00000000007cfd12,
  0x00000000001fff40, 0x00000000007cfe0c,
  0x00000000001fff80, 0x00000000007cff06,
  0x00000000001fffc0, 0x00000031ffffffce,
  0x0000000cccccccc0, 0x0000005355555502,
  0x0000001555555540, 0x0000007cfffffd12,
  0x0000001fffffff40, 0x0000007cfffffe0c,
  0x0000001fffffff80, 0x0000007cffffff06,
  0x0000001fffffffc0, 0xffffff8300000000,
  0xffffffe000000000, 0xffffff83000000fa,
  0xffffffe000000040, 0xffffffacaaaaaa04,
  0xffffffeaaaaaaa80, 0xffffffcdffffff38,
  0xfffffff333333300, 0xffffffffff830000,
  0xffffffffffe00000, 0xffffffffff8300fa,
  0xffffffffffe00040, 0xffffffffff8301f4,
  0xffffffffffe00080, 0xffffffffff8302ee,
  0xffffffffffe000c0, 0xffffffffffff8300,
  0xffffffffffffe000, 0xffffffffffff83fa,
  0xffffffffffffe040, 0xffffffffffff84f4,
  0xffffffffffffe080, 0xffffffffffff85ee,
  0xffffffffffffe0c0, 0xffffffffffffe0c0,
  0xfffffffffffff800, 0xfffffffffffffd12,
  0xfffffffffffffd12, 0xfffffffffffffe08,
  0xfffffffffffffe0c, 0xffffffffffffff04,
  0xffffffffffffff06, 0x0000000000000000,
  0x0000000000000000, 0x00000000000000fc,
  0x00000000000000fa, 0x00000000000001f8,
  0x00000000000001f4, 0x0000000000001f80,
  0x0000000000001f40, 0x0000000000007b0c,
  0x0000000000007a12, 0x0000000000007c08,
  0x0000000000007b0c, 0x0000000000007d04,
  0x0000000000007c06, 0x00000000007dfd0c,
  0x00000000007cfd12, 0x00000000007dfe08,
  0x00000000007cfe0c, 0x00000000007dff04,
  0x00000000007cff06, 0x0000003266666634,
  0x00000031ffffffce, 0x00000053ffffffac,
  0x0000005355555502, 0x0000007dfffffd0c,
  0x0000007cfffffd12, 0x0000007dfffffe08,
  0x0000007cfffffe0c, 0x0000007dffffff04,
  0x0000007cffffff06, 0xffffff8200000000,
  0xffffff8300000000, 0xffffff82000000fc,
  0xffffff83000000fa, 0xffffffabffffff58,
  0xffffffacaaaaaa04, 0xffffffcd999998d0,
  0xffffffcdffffff38, 0xffffffffff820000,
  0xffffffffff830000, 0xffffffffff8200fc,
  0xffffffffff8300fa, 0xffffffffff8201f8,
  0xffffffffff8301f4, 0xffffffffff8202f4,
  0xffffffffff8302ee, 0xffffffffffff8200,
  0xffffffffffff8300, 0xffffffffffff82fc,
  0xffffffffffff83fa, 0xffffffffffff83f8,
  0xffffffffffff84f4, 0xffffffffffff84f4,
  0xffffffffffff85ee, 0xffffffffffffe080,
  0xffffffffffffe0c0, 0xfffffffffffffd0c,
  0xfffffffffffffd0c, 0xfffffffffffffe04,
  0xfffffffffffffe08, 0xffffffffffffff02,
  0xffffffffffffff04, 0x0000000000000000,
  0x0000000000000000, 0x00000000000000fe,
  0x00000000000000fc, 0x00000000000001fc,
  0x00000000000001f8, 0x0000000000001fc0,
  0x0000000000001f80, 0x0000000000007c06,
  0x0000000000007b0c, 0x0000000000007d04,
  0x0000000000007c08, 0x0000000000007e02,
  0x0000000000007d04, 0x00000000007efd06,
  0x00000000007dfd0c, 0x00000000007efe04,
  0x00000000007dfe08, 0x00000000007eff02,
  0x00000000007dff04, 0x00000032cccccc9a,
  0x0000003266666634, 0x00000054aaaaaa56,
  0x00000053ffffffac, 0x0000007efffffd06,
  0x0000007dfffffd0c, 0x0000007efffffe04,
  0x0000007dfffffe08, 0x0000007effffff02,
  0x0000007dffffff04, 0xffffff8100000000,
  0xffffff8200000000, 0xffffff81000000fe,
  0xffffff82000000fc, 0xffffffab555554ac,
  0xffffffabffffff58, 0xffffffcd33333268,
  0xffffffcd999998d0, 0xffffffffff810000,
  0xffffffffff820000, 0xffffffffff8100fe,
  0xffffffffff8200fc, 0xffffffffff8101fc,
  0xffffffffff8201f8, 0xffffffffff8102fa,
  0xffffffffff8202f4, 0xffffffffffff8100,
  0xffffffffffff8200, 0xffffffffffff81fe,
  0xffffffffffff82fc, 0xffffffffffff82fc,
  0xffffffffffff83f8, 0xffffffffffff83fa,
  0xffffffffffff84f4, 0xffffffffffffe040,
  0xffffffffffffe080, 0xfffffffffffffd06,
  0xfffffffffffffd06, 0xfffffffffffe000c,
  0xfffffffffffffe04, 0xffffffffffff0006,
  0xffffffffffffff02, 0x0000000000000000,
  0x0000000000000000, 0x000000000000fffa,
  0x00000000000000fe, 0x000000000001fff4,
  0x00000000000001fc, 0x00000000001fff40,
  0x0000000000001fc0, 0x00000000007cfd12,
  0x0000000000007c06, 0x00000000007dfd0c,
  0x0000000000007d04, 0x00000000007efd06,
  0x0000000000007e02, 0x000000007ffa0012,
  0x00000000007efd06, 0x000000007ffb000c,
  0x00000000007efe04, 0x000000007ffc0006,
  0x00000000007eff02, 0x00003331ffffccce,
  0x00000032cccccc9a, 0x0000555355550002,
  0x00000054aaaaaa56, 0x00007ffcfffd0012,
  0x0000007efffffd06, 0x00007ffcfffe000c,
  0x0000007efffffe04, 0x00007ffcffff0006,
  0x0000007effffff02, 0xffff800300000000,
  0xffffff8100000000, 0xffff80030000fffa,
  0xffffff81000000fe, 0xffffaaacaaaa0004,
  0xffffffab555554ac, 0xffffcccdffff3338,
  0xffffffcd33333268, 0xffffffff80030000,
  0xffffffffff810000, 0xffffffff8003fffa,
  0xffffffffff8100fe, 0xffffffff8004fff4,
  0xffffffffff8101fc, 0xffffffff8005ffee,
  0xffffffffff8102fa, 0xffffffffff800300,
  0xffffffffffff8100, 0xffffffffff8102fa,
  0xffffffffffff81fe, 0xffffffffff8202f4,
  0xffffffffffff82fc, 0xffffffffff8302ee,
  0xffffffffffff83fa, 0xffffffffffe000c0,
  0xffffffffffffe040, 0xfffffffffffd0012,
  0xfffffffffffd0012, 0xfffffffffffe0008,
  0xfffffffffffe000c, 0xffffffffffff0004,
  0xffffffffffff0006, 0x0000000000000000,
  0x0000000000000000, 0x000000000000fffc,
  0x000000000000fffa, 0x000000000001fff8,
  0x000000000001fff4, 0x00000000001fff80,
  0x00000000001fff40, 0x00000000007cfe0c,
  0x00000000007cfd12, 0x00000000007dfe08,
  0x00000000007dfd0c, 0x00000000007efe04,
  0x00000000007efd06, 0x000000007ffb000c,
  0x000000007ffa0012, 0x000000007ffc0008,
  0x000000007ffb000c, 0x000000007ffd0004,
  0x000000007ffc0006, 0x0000333266663334,
  0x00003331ffffccce, 0x00005553ffffaaac,
  0x0000555355550002, 0x00007ffdfffd000c,
  0x00007ffcfffd0012, 0x00007ffdfffe0008,
  0x00007ffcfffe000c, 0x00007ffdffff0004,
  0x00007ffcffff0006, 0xffff800200000000,
  0xffff800300000000, 0xffff80020000fffc,
  0xffff80030000fffa, 0xffffaaabffff5558,
  0xffffaaacaaaa0004, 0xffffcccd9998ccd0,
  0xffffcccdffff3338, 0xffffffff80020000,
  0xffffffff80030000, 0xffffffff8002fffc,
  0xffffffff8003fffa, 0xffffffff8003fff8,
  0xffffffff8004fff4, 0xffffffff8004fff4,
  0xffffffff8005ffee, 0xffffffffff800200,
  0xffffffffff800300, 0xffffffffff8101fc,
  0xffffffffff8102fa, 0xffffffffff8201f8,
  0xffffffffff8202f4, 0xffffffffff8301f4,
  0xffffffffff8302ee, 0xffffffffffe00080,
  0xffffffffffe000c0, 0xfffffffffffd000c,
  0xfffffffffffd000c, 0xfffffffffffe0004,
  0xfffffffffffe0008, 0xffffffffffff0002,
  0xffffffffffff0004, 0x0000000000000000,
  0x0000000000000000, 0x000000000000fffe,
  0x000000000000fffc, 0x000000000001fffc,
  0x000000000001fff8, 0x00000000001fffc0,
  0x00000000001fff80, 0x00000000007cff06,
  0x00000000007cfe0c, 0x00000000007dff04,
  0x00000000007dfe08, 0x00000000007eff02,
  0x00000000007efe04, 0x000000007ffc0006,
  0x000000007ffb000c, 0x000000007ffd0004,
  0x000000007ffc0008, 0x000000007ffe0002,
  0x000000007ffd0004, 0x00003332cccc999a,
  0x0000333266663334, 0x00005554aaaa5556,
  0x00005553ffffaaac, 0x00007ffefffd0006,
  0x00007ffdfffd000c, 0x00007ffefffe0004,
  0x00007ffdfffe0008, 0x00007ffeffff0002,
  0x00007ffdffff0004, 0xffff800100000000,
  0xffff800200000000, 0xffff80010000fffe,
  0xffff80020000fffc, 0xffffaaab5554aaac,
  0xffffaaabffff5558, 0xffffcccd33326668,
  0xffffcccd9998ccd0, 0xffffffff80010000,
  0xffffffff80020000, 0xffffffff8001fffe,
  0xffffffff8002fffc, 0xffffffff8002fffc,
  0xffffffff8003fff8, 0xffffffff8003fffa,
  0xffffffff8004fff4, 0xffffffffff800100,
  0xffffffffff800200, 0xffffffffff8100fe,
  0xffffffffff8101fc, 0xffffffffff8200fc,
  0xffffffffff8201f8, 0xffffffffff8300fa,
  0xffffffffff8301f4, 0xffffffffffe00040,
  0xffffffffffe00080, 0xfffffffffffd0006,
  0xfffffffffffd0006, 0xffffffff33333334,
  0xfffffffffffe0004, 0xffffffff9999999a,
  0xffffffffffff0002, 0x0000000000000000,
  0x0000000000000000, 0x0000000066666666,
  0x000000000000fffe, 0x00000000cccccccc,
  0x000000000001fffc, 0x0000000cccccccc0,
  0x00000000001fffc0, 0x00000031ffffffce,
  0x00000000007cff06, 0x0000003266666634,
  0x00000000007dff04, 0x00000032cccccc9a,
  0x00000000007eff02, 0x00003331ffffccce,
  0x000000007ffc0006, 0x0000333266663334,
  0x000000007ffd0004, 0x00003332cccc999a,
  0x000000007ffe0002, 0x147ae147851eb852,
  0x00003332cccc999a, 0x22222221ddddddde,
  0x00005554aaaa5556, 0x33333331ccccccce,
  0x00007ffefffd0006, 0x3333333233333334,
  0x00007ffefffe0004, 0x333333329999999a,
  0x00007ffeffff0002, 0xcccccccd00000000,
  0xffff800100000000, 0xcccccccd66666666,
  0xffff80010000fffe, 0xddddddddbbbbbbbc,
  0xffffaaab5554aaac, 0xeb851eb8147ae148,
  0xffffcccd33326668, 0xffffcccccccd0000,
  0xffffffff80010000, 0xffffcccd33336666,
  0xffffffff8001fffe, 0xffffcccd9999cccc,
  0xffffffff8002fffc, 0xffffccce00003332,
  0xffffffff8003fffa, 0xffffffcccccccd00,
  0xffffffffff800100, 0xffffffcd33333366,
  0xffffffffff8100fe, 0xffffffcd999999cc,
  0xffffffffff8200fc, 0xffffffce00000032,
  0xffffffffff8300fa, 0xfffffff333333340,
  0xffffffffffe00040, 0xfffffffeccccccce,
  0xfffffffeccccccce, 0xfffffffeaaaaaaac,
  0xffffffff33333334, 0xffffffff55555556,
  0xffffffff9999999a, 0x0000000000000000,
  0x0000000000000000, 0x00000000aaaaaaaa,
  0x0000000066666666, 0x0000000155555554,
  0x00000000cccccccc, 0x0000001555555540,
  0x0000000cccccccc0, 0x0000005355555502,
  0x00000031ffffffce, 0x00000053ffffffac,
  0x0000003266666634, 0x00000054aaaaaa56,
  0x00000032cccccc9a, 0x0000555355550002,
  0x00003331ffffccce, 0x00005553ffffaaac,
  0x0000333266663334, 0x00005554aaaa5556,
  0x00003332cccc999a, 0x22222221ddddddde,
  0x147ae147851eb852, 0x38e38e3871c71c72,
  0x22222221ddddddde, 0x5555555300000002,
  0x33333331ccccccce, 0x55555553aaaaaaac,
  0x3333333233333334, 0x5555555455555556,
  0x333333329999999a, 0xaaaaaaab00000000,
  0xcccccccd00000000, 0xaaaaaaabaaaaaaaa,
  0xcccccccd66666666, 0xc71c71c6e38e38e4,
  0xddddddddbbbbbbbc, 0xdddddddd77777778,
  0xeb851eb8147ae148, 0xffffaaaaaaab0000,
  0xffffcccccccd0000, 0xffffaaab5555aaaa,
  0xffffcccd33336666, 0xffffaaac00005554,
  0xffffcccd9999cccc, 0xffffaaacaaaafffe,
  0xffffccce00003332, 0xffffffaaaaaaab00,
  0xffffffcccccccd00, 0xffffffab555555aa,
  0xffffffcd33333366, 0xffffffac00000054,
  0xffffffcd999999cc, 0xffffffacaaaaaafe,
  0xffffffce00000032, 0xffffffeaaaaaaac0,
  0xfffffff333333340, 0xfffffffe00000002,
  0xfffffffe00000002, 0xfffffffe0000000c,
  0xfffffffeaaaaaaac, 0xffffffff00000006,
  0xffffffff55555556, 0x0000000000000000,
  0x0000000000000000, 0x00000000fffffffa,
  0x00000000aaaaaaaa, 0x00000001fffffff4,
  0x0000000155555554, 0x0000001fffffff40,
  0x0000001555555540, 0x0000007cfffffd12,
  0x0000005355555502, 0x0000007dfffffd0c,
  0x00000053ffffffac, 0x0000007efffffd06,
  0x00000054aaaaaa56, 0x00007ffcfffd0012,
  0x0000555355550002, 0x00007ffdfffd000c,
  0x00005553ffffaaac, 0x00007ffefffd0006,
  0x00005554aaaa5556, 0x33333331ccccccce,
  0x22222221ddddddde, 0x5555555300000002,
  0x38e38e3871c71c72, 0x7ffffffa00000012,
  0x5555555300000002, 0x7ffffffb0000000c,
  0x55555553aaaaaaac, 0x7ffffffc00000006,
  0x5555555455555556, 0x8000000300000000,
  0xaaaaaaab00000000, 0x80000003fffffffa,
  0xaaaaaaabaaaaaaaa, 0xaaaaaaac00000004,
  0xc71c71c6e38e38e4, 0xcccccccd33333338,
  0xdddddddd77777778, 0xffff800000030000,
  0xffffaaaaaaab0000, 0xffff80010002fffa,
  0xffffaaab5555aaaa, 0xffff80020002fff4,
  0xffffaaac00005554, 0xffff80030002ffee,
  0xffffaaacaaaafffe, 0xffffff8000000300,
  0xffffffaaaaaaab00, 0xffffff81000002fa,
  0xffffffab555555aa, 0xffffff82000002f4,
  0xffffffac00000054, 0xffffff83000002ee,
  0xffffffacaaaaaafe, 0xffffffe0000000c0,
  0xffffffeaaaaaaac0, 0xfffffffd00000012,
  0xfffffffd00000012, 0xfffffffe00000008,
  0xfffffffe0000000c, 0xffffffff00000004,
  0xffffffff00000006, 0x0000000000000000,
  0x0000000000000000, 0x00000000fffffffc,
  0x00000000fffffffa, 0x00000001fffffff8,
  0x00000001fffffff4, 0x0000001fffffff80,
  0x0000001fffffff40, 0x0000007cfffffe0c,
  0x0000007cfffffd12, 0x0000007dfffffe08,
  0x0000007dfffffd0c, 0x0000007efffffe04,
  0x0000007efffffd06, 0x00007ffcfffe000c,
  0x00007ffcfffd0012, 0x00007ffdfffe0008,
  0x00007ffdfffd000c, 0x00007ffefffe0004,
  0x00007ffefffd0006, 0x3333333233333334,
  0x33333331ccccccce, 0x55555553aaaaaaac,
  0x5555555300000002, 0x7ffffffb0000000c,
  0x7ffffffa00000012, 0x7ffffffc00000008,
  0x7ffffffb0000000c, 0x7ffffffd00000004,
  0x7ffffffc00000006, 0x8000000200000000,
  0x8000000300000000, 0x80000002fffffffc,
  0x80000003fffffffa, 0xaaaaaaab55555558,
  0xaaaaaaac00000004, 0xccccccccccccccd0,
  0xcccccccd33333338, 0xffff800000020000,
  0xffff800000030000, 0xffff80010001fffc,
  0xffff80010002fffa, 0xffff80020001fff8,
  0xffff80020002fff4, 0xffff80030001fff4,
  0xffff80030002ffee, 0xffffff8000000200,
  0xffffff8000000300, 0xffffff81000001fc,
  0xffffff81000002fa, 0xffffff82000001f8,
  0xffffff82000002f4, 0xffffff83000001f4,
  0xffffff83000002ee, 0xffffffe000000080,
  0xffffffe0000000c0, 0xfffffffd0000000c,
  0xfffffffd0000000c, 0xfffffffe00000004,
  0xfffffffe00000008, 0xffffffff00000002,
  0xffffffff00000004, 0x0000000000000000,
  0x0000000000000000, 0x00000000fffffffe,
  0x00000000fffffffc, 0x00000001fffffffc,
  0x00000001fffffff8, 0x0000001fffffffc0,
  0x0000001fffffff80, 0x0000007cffffff06,
  0x0000007cfffffe0c, 0x0000007dffffff04,
  0x0000007dfffffe08, 0x0000007effffff02,
  0x0000007efffffe04, 0x00007ffcffff0006,
  0x00007ffcfffe000c, 0x00007ffdffff0004,
  0x00007ffdfffe0008, 0x00007ffeffff0002,
  0x00007ffefffe0004, 0x333333329999999a,
  0x3333333233333334, 0x5555555455555556,
  0x55555553aaaaaaac, 0x7ffffffc00000006,
  0x7ffffffb0000000c, 0x7ffffffd00000004,
  0x7ffffffc00000008, 0x7ffffffe00000002,
  0x7ffffffd00000004, 0x8000000100000000,
  0x8000000200000000, 0x80000001fffffffe,
  0x80000002fffffffc, 0xaaaaaaaaaaaaaaac,
  0xaaaaaaab55555558, 0xcccccccc66666668,
  0xccccccccccccccd0, 0xffff800000010000,
  0xffff800000020000, 0xffff80010000fffe,
  0xffff80010001fffc, 0xffff80020000fffc,
  0xffff80020001fff8, 0xffff80030000fffa,
  0xffff80030001fff4, 0xffffff8000000100,
  0xffffff8000000200, 0xffffff81000000fe,
  0xffffff81000001fc, 0xffffff82000000fc,
  0xffffff82000001f8, 0xffffff83000000fa,
  0xffffff83000001f4, 0xffffffe000000040,
  0xffffffe000000080, 0xfffffffd00000006,
  0xfffffffd00000006, 0x0000000200000000,
  0xfffffffe00000004, 0x0000000100000000,
  0xffffffff00000002, 0x0000000000000000,
  0x0000000000000000, 0xffffffff00000000,
  0x00000000fffffffe, 0xfffffffe00000000,
  0x00000001fffffffc, 0xffffffe000000000,
  0x0000001fffffffc0, 0xffffff8300000000,
  0x0000007cffffff06, 0xffffff8200000000,
  0x0000007dffffff04, 0xffffff8100000000,
  0x0000007effffff02, 0xffff800300000000,
  0x00007ffcffff0006, 0xffff800200000000,
  0x00007ffdffff0004, 0xffff800100000000,
  0x00007ffeffff0002, 0xcccccccd00000000,
  0x333333329999999a, 0xaaaaaaab00000000,
  0x5555555455555556, 0x8000000300000000,
  0x7ffffffc00000006, 0x8000000200000000,
  0x7ffffffd00000004, 0x8000000100000000,
  0x7ffffffe00000002, 0x7fffffffffffffff,
  0x8000000100000000, 0x7fffffff00000000,
  0x80000001fffffffe, 0x5555555600000000,
  0xaaaaaaaaaaaaaaac, 0x3333333400000000,
  0xcccccccc66666668, 0x0000800000000000,
  0xffff800000010000, 0x00007fff00000000,
  0xffff80010000fffe, 0x00007ffe00000000,
  0xffff80020000fffc, 0x00007ffd00000000,
  0xffff80030000fffa, 0x0000008000000000,
  0xffffff8000000100, 0x0000007f00000000,
  0xffffff81000000fe, 0x0000007e00000000,
  0xffffff82000000fc, 0x0000007d00000000,
  0xffffff83000000fa, 0x0000002000000000,
  0xffffffe000000040, 0x0000000300000000,
  0x0000000300000000, 0x00000001fffffffc,
  0x0000000200000000, 0x00000000fffffffe,
  0x0000000100000000, 0x0000000000000000,
  0x0000000000000000, 0xffffffff00000002,
  0xffffffff00000000, 0xfffffffe00000004,
  0xfffffffe00000000, 0xffffffe000000040,
  0xffffffe000000000, 0xffffff83000000fa,
  0xffffff8300000000, 0xffffff82000000fc,
  0xffffff8200000000, 0xffffff81000000fe,
  0xffffff8100000000, 0xffff80030000fffa,
  0xffff800300000000, 0xffff80020000fffc,
  0xffff800200000000, 0xffff80010000fffe,
  0xffff800100000000, 0xcccccccd66666666,
  0xcccccccd00000000, 0xaaaaaaabaaaaaaaa,
  0xaaaaaaab00000000, 0x80000003fffffffa,
  0x8000000300000000, 0x80000002fffffffc,
  0x8000000200000000, 0x80000001fffffffe,
  0x8000000100000000, 0x7fffffff00000000,
  0x7fffffffffffffff, 0x7ffffffe00000002,
  0x7fffffff00000000, 0x5555555555555554,
  0x5555555600000000, 0x3333333399999998,
  0x3333333400000000, 0x00007fffffff0000,
  0x0000800000000000, 0x00007ffeffff0002,
  0x00007fff00000000, 0x00007ffdffff0004,
  0x00007ffe00000000, 0x00007ffcffff0006,
  0x00007ffd00000000, 0x0000007fffffff00,
  0x0000008000000000, 0x0000007effffff02,
  0x0000007f00000000, 0x0000007dffffff04,
  0x0000007e00000000, 0x0000007cffffff06,
  0x0000007d00000000, 0x0000001fffffffc0,
  0x0000002000000000, 0x00000002fffffffa,
  0x00000002fffffffa, 0x0000000155555558,
  0x00000001fffffffc, 0x00000000aaaaaaac,
  0x00000000fffffffe, 0x0000000000000000,
  0x0000000000000000, 0xffffffff55555554,
  0xffffffff00000002, 0xfffffffeaaaaaaa8,
  0xfffffffe00000004, 0xffffffeaaaaaaa80,
  0xffffffe000000040, 0xffffffacaaaaaa04,
  0xffffff83000000fa, 0xffffffabffffff58,
  0xffffff82000000fc, 0xffffffab555554ac,
  0xffffff81000000fe, 0xffffaaacaaaa0004,
  0xffff80030000fffa, 0xffffaaabffff5558,
  0xffff80020000fffc, 0xffffaaab5554aaac,
  0xffff80010000fffe, 0xddddddddbbbbbbbc,
  0xcccccccd66666666, 0xc71c71c6e38e38e4,
  0xaaaaaaabaaaaaaaa, 0xaaaaaaac00000004,
  0x80000003fffffffa, 0xaaaaaaab55555558,
  0x80000002fffffffc, 0xaaaaaaaaaaaaaaac,
  0x80000001fffffffe, 0x5555555600000000,
  0x7fffffff00000000, 0x5555555555555554,
  0x7ffffffe00000002, 0x38e38e39c71c71c8,
  0x5555555555555554, 0x22222222eeeeeef0,
  0x3333333399999998, 0x0000555555560000,
  0x00007fffffff0000, 0x00005554aaab5554,
  0x00007ffeffff0002, 0x000055540000aaa8,
  0x00007ffdffff0004, 0x000055535555fffc,
  0x00007ffcffff0006, 0x0000005555555600,
  0x0000007fffffff00, 0x00000054aaaaab54,
  0x0000007effffff02, 0x00000054000000a8,
  0x0000007dffffff04, 0x00000053555555fc,
  0x0000007cffffff06, 0x0000001555555580,
  0x0000001fffffffc0, 0x0000000200000004,
  0x0000000200000004, 0x00000000ccccccd0,
  0x0000000155555558, 0x0000000066666668,
  0x00000000aaaaaaac, 0x0000000000000000,
  0x0000000000000000, 0xffffffff99999998,
  0xffffffff55555554, 0xffffffff33333330,
  0xfffffffeaaaaaaa8, 0xfffffff333333300,
  0xffffffeaaaaaaa80, 0xffffffcdffffff38,
  0xffffffacaaaaaa04, 0xffffffcd999998d0,
  0xffffffabffffff58, 0xffffffcd33333268,
  0xffffffab555554ac, 0xffffcccdffff3338,
  0xffffaaacaaaa0004, 0xffffcccd9998ccd0,
  0xffffaaabffff5558, 0xffffcccd33326668,
  0xffffaaab5554aaac, 0xeb851eb8147ae148,
  0xddddddddbbbbbbbc, 0xdddddddd77777778,
  0xc71c71c6e38e38e4, 0xcccccccd33333338,
  0xaaaaaaac00000004, 0xccccccccccccccd0,
  0xaaaaaaab55555558, 0xcccccccc66666668,
  0xaaaaaaaaaaaaaaac, 0x3333333400000000,
  0x5555555600000000, 0x3333333399999998,
  0x5555555555555554, 0x22222222eeeeeef0,
  0x38e38e39c71c71c8, 0x147ae14851eb8520,
  0x22222222eeeeeef0, 0x0000333333340000,
  0x0000555555560000, 0x00003332cccd9998,
  0x00005554aaab5554, 0x0000333266673330,
  0x000055540000aaa8, 0x000033320000ccc8,
  0x000055535555fffc, 0x0000003333333400,
  0x0000005555555600, 0x00000032cccccd98,
  0x00000054aaaaab54, 0x0000003266666730,
  0x00000054000000a8, 0x00000032000000c8,
  0x00000053555555fc, 0x0000000ccccccd00,
  0x0000001555555580, 0x0000000133333338,
  0x0000000133333338, 0x0000000000020000,
  0x00000000ccccccd0, 0x0000000000010000,
  0x0000000066666668, 0x0000000000000000,
  0x0000000000000000, 0xffffffffffff0000,
  0xffffffff99999998, 0xfffffffffffe0000,
  0xffffffff33333330, 0xffffffffffe00000,
  0xfffffff333333300, 0xffffffffff830000,
  0xffffffcdffffff38, 0xffffffffff820000,
  0xffffffcd999998d0, 0xffffffffff810000,
  0xffffffcd33333268, 0xffffffff80030000,
  0xffffcccdffff3338, 0xffffffff80020000,
  0xffffcccd9998ccd0, 0xffffffff80010000,
  0xffffcccd33326668, 0xffffcccccccd0000,
  0xeb851eb8147ae148, 0xffffaaaaaaab0000,
  0xdddddddd77777778, 0xffff800000030000,
  0xcccccccd33333338, 0xffff800000020000,
  0xccccccccccccccd0, 0xffff800000010000,
  0xcccccccc66666668, 0x0000800000000000,
  0x3333333400000000, 0x00007fffffff0000,
  0x3333333399999998, 0x0000555555560000,
  0x22222222eeeeeef0, 0x0000333333340000,
  0x147ae14851eb8520, 0x0000000080000000,
  0x0000333333340000, 0x000000007fff0000,
  0x00003332cccd9998, 0x000000007ffe0000,
  0x0000333266673330, 0x000000007ffd0000,
  0x000033320000ccc8, 0x0000000000800000,
  0x0000003333333400, 0x00000000007f0000,
  0x00000032cccccd98, 0x00000000007e0000,
  0x0000003266666730, 0x00000000007d0000,
  0x00000032000000c8, 0x0000000000200000,
  0x0000000ccccccd00, 0x0000000000030000,
  0x0000000000030000, 0x000000000001fffc,
  0x0000000000020000, 0x000000000000fffe,
  0x0000000000010000, 0x0000000000000000,
  0x0000000000000000, 0xffffffffffff0002,
  0xffffffffffff0000, 0xfffffffffffe0004,
  0xfffffffffffe0000, 0xffffffffffe00040,
  0xffffffffffe00000, 0xffffffffff8300fa,
  0xffffffffff830000, 0xffffffffff8200fc,
  0xffffffffff820000, 0xffffffffff8100fe,
  0xffffffffff810000, 0xffffffff8003fffa,
  0xffffffff80030000, 0xffffffff8002fffc,
  0xffffffff80020000, 0xffffffff8001fffe,
  0xffffffff80010000, 0xffffcccd33336666,
  0xffffcccccccd0000, 0xffffaaab5555aaaa,
  0xffffaaaaaaab0000, 0xffff80010002fffa,
  0xffff800000030000, 0xffff80010001fffc,
  0xffff800000020000, 0xffff80010000fffe,
  0xffff800000010000, 0x00007fff00000000,
  0x0000800000000000, 0x00007ffeffff0002,
  0x00007fffffff0000, 0x00005554aaab5554,
  0x0000555555560000, 0x00003332cccd9998,
  0x0000333333340000, 0x000000007fff0000,
  0x0000000080000000, 0x000000007ffe0002,
  0x000000007fff0000, 0x000000007ffd0004,
  0x000000007ffe0000, 0x000000007ffc0006,
  0x000000007ffd0000, 0x00000000007fff00,
  0x0000000000800000, 0x00000000007eff02,
  0x00000000007f0000, 0x00000000007dff04,
  0x00000000007e0000, 0x00000000007cff06,
  0x00000000007d0000, 0x00000000001fffc0,
  0x0000000000200000, 0x000000000002fffa,
  0x000000000002fffa, 0x000000000001fff8,
  0x000000000001fffc, 0x000000000000fffc,
  0x000000000000fffe, 0x0000000000000000,
  0x0000000000000000, 0xffffffffffff0004,
  0xffffffffffff0002, 0xfffffffffffe0008,
  0xfffffffffffe0004, 0xffffffffffe00080,
  0xffffffffffe00040, 0xffffffffff8301f4,
  0xffffffffff8300fa, 0xffffffffff8201f8,
  0xffffffffff8200fc, 0xffffffffff8101fc,
  0xffffffffff8100fe, 0xffffffff8004fff4,
  0xffffffff8003fffa, 0xffffffff8003fff8,
  0xffffffff8002fffc, 0xffffffff8002fffc,
  0xffffffff8001fffe, 0xffffcccd9999cccc,
  0xffffcccd33336666, 0xffffaaac00005554,
  0xffffaaab5555aaaa, 0xffff80020002fff4,
  0xffff80010002fffa, 0xffff80020001fff8,
  0xffff80010001fffc, 0xffff80020000fffc,
  0xffff80010000fffe, 0x00007ffe00000000,
  0x00007fff00000000, 0x00007ffdffff0004,
  0x00007ffeffff0002, 0x000055540000aaa8,
  0x00005554aaab5554, 0x0000333266673330,
  0x00003332cccd9998, 0x000000007ffe0000,
  0x000000007fff0000, 0x000000007ffd0004,
  0x000000007ffe0002, 0x000000007ffc0008,
  0x000000007ffd0004, 0x000000007ffb000c,
  0x000000007ffc0006, 0x00000000007ffe00,
  0x00000000007fff00, 0x00000000007efe04,
  0x00000000007eff02, 0x00000000007dfe08,
  0x00000000007dff04, 0x00000000007cfe0c,
  0x00000000007cff06, 0x00000000001fff80,
  0x00000000001fffc0, 0x000000000002fff4,
  0x000000000002fff4, 0x000000000001fff4,
  0x000000000001fff8, 0x000000000000fffa,
  0x000000000000fffc, 0x0000000000000000,
  0x0000000000000000, 0xffffffffffff0006,
  0xffffffffffff0004, 0xfffffffffffe000c,
  0xfffffffffffe0008, 0xffffffffffe000c0,
  0xffffffffffe00080, 0xffffffffff8302ee,
  0xffffffffff8301f4, 0xffffffffff8202f4,
  0xffffffffff8201f8, 0xffffffffff8102fa,
  0xffffffffff8101fc, 0xffffffff8005ffee,
  0xffffffff8004fff4, 0xffffffff8004fff4,
  0xffffffff8003fff8, 0xffffffff8003fffa,
  0xffffffff8002fffc, 0xffffccce00003332,
  0xffffcccd9999cccc, 0xffffaaacaaaafffe,
  0xffffaaac00005554, 0xffff80030002ffee,
  0xffff80020002fff4, 0xffff80030001fff4,
  0xffff80020001fff8, 0xffff80030000fffa,
  0xffff80020000fffc, 0x00007ffd00000000,
  0x00007ffe00000000, 0x00007ffcffff0006,
  0x00007ffdffff0004, 0x000055535555fffc,
  0x000055540000aaa8, 0x000033320000ccc8,
  0x0000333266673330, 0x000000007ffd0000,
  0x000000007ffe0000, 0x000000007ffc0006,
  0x000000007ffd0004, 0x000000007ffb000c,
  0x000000007ffc0008, 0x000000007ffa0012,
  0x000000007ffb000c, 0x00000000007ffd00,
  0x00000000007ffe00, 0x00000000007efd06,
  0x00000000007efe04, 0x00000000007dfd0c,
  0x00000000007dfe08, 0x00000000007cfd12,
  0x00000000007cfe0c, 0x00000000001fff40,
  0x00000000001fff80, 0x000000000002ffee,
  0x000000000002ffee, 0x0000000000000200,
  0x000000000001fff4, 0x0000000000000100,
  0x000000000000fffa, 0x0000000000000000,
  0x0000000000000000, 0xffffffffffffff00,
  0xffffffffffff0006, 0xfffffffffffffe00,
  0xfffffffffffe000c, 0xffffffffffffe000,
  0xffffffffffe000c0, 0xffffffffffff8300,
  0xffffffffff8302ee, 0xffffffffffff8200,
  0xffffffffff8202f4, 0xffffffffffff8100,
  0xffffffffff8102fa, 0xffffffffff800300,
  0xffffffff8005ffee, 0xffffffffff800200,
  0xffffffff8004fff4, 0xffffffffff800100,
  0xffffffff8003fffa, 0xffffffcccccccd00,
  0xffffccce00003332, 0xffffffaaaaaaab00,
  0xffffaaacaaaafffe, 0xffffff8000000300,
  0xffff80030002ffee, 0xffffff8000000200,
  0xffff80030001fff4, 0xffffff8000000100,
  0xffff80030000fffa, 0x0000008000000000,
  0x00007ffd00000000, 0x0000007fffffff00,
  0x00007ffcffff0006, 0x0000005555555600,
  0x000055535555fffc, 0x0000003333333400,
  0x000033320000ccc8, 0x0000000000800000,
  0x000000007ffd0000, 0x00000000007fff00,
  0x000000007ffc0006, 0x00000000007ffe00,
  0x000000007ffb000c, 0x00000000007ffd00,
  0x000000007ffa0012, 0x0000000000008000,
  0x00000000007ffd00, 0x0000000000007f00,
  0x00000000007efd06, 0x0000000000007e00,
  0x00000000007dfd0c, 0x0000000000007d00,
  0x00000000007cfd12, 0x0000000000002000,
  0x00000000001fff40, 0x0000000000000300,
  0x0000000000000300, 0x00000000000001fc,
  0x0000000000000200, 0x00000000000000fe,
  0x0000000000000100, 0x0000000000000000,
  0x0000000000000000, 0xffffffffffffff02,
  0xffffffffffffff00, 0xfffffffffffffe04,
  0xfffffffffffffe00, 0xffffffffffffe040,
  0xffffffffffffe000, 0xffffffffffff83fa,
  0xffffffffffff8300, 0xffffffffffff82fc,
  0xffffffffffff8200, 0xffffffffffff81fe,
  0xffffffffffff8100, 0xffffffffff8102fa,
  0xffffffffff800300, 0xffffffffff8101fc,
  0xffffffffff800200, 0xffffffffff8100fe,
  0xffffffffff800100, 0xffffffcd33333366,
  0xffffffcccccccd00, 0xffffffab555555aa,
  0xffffffaaaaaaab00, 0xffffff81000002fa,
  0xffffff8000000300, 0xffffff81000001fc,
  0xffffff8000000200, 0xffffff81000000fe,
  0xffffff8000000100, 0x0000007f00000000,
  0x0000008000000000, 0x0000007effffff02,
  0x0000007fffffff00, 0x00000054aaaaab54,
  0x0000005555555600, 0x00000032cccccd98,
  0x0000003333333400, 0x00000000007f0000,
  0x0000000000800000, 0x00000000007eff02,
  0x00000000007fff00, 0x00000000007efe04,
  0x00000000007ffe00, 0x00000000007efd06,
  0x00000000007ffd00, 0x0000000000007f00,
  0x0000000000008000, 0x0000000000007e02,
  0x0000000000007f00, 0x0000000000007d04,
  0x0000000000007e00, 0x0000000000007c06,
  0x0000000000007d00, 0x0000000000001fc0,
  0x0000000000002000, 0x00000000000002fa,
  0x00000000000002fa, 0x00000000000001f8,
  0x00000000000001fc, 0x00000000000000fc,
  0x00000000000000fe, 0x0000000000000000,
  0x0000000000000000, 0xffffffffffffff04,
  0xffffffffffffff02, 0xfffffffffffffe08,
  0xfffffffffffffe04, 0xffffffffffffe080,
  0xffffffffffffe040, 0xffffffffffff84f4,
  0xffffffffffff83fa, 0xffffffffffff83f8,
  0xffffffffffff82fc, 0xffffffffffff82fc,
  0xffffffffffff81fe, 0xffffffffff8202f4,
  0xffffffffff8102fa, 0xffffffffff8201f8,
  0xffffffffff8101fc, 0xffffffffff8200fc,
  0xffffffffff8100fe, 0xffffffcd999999cc,
  0xffffffcd33333366, 0xffffffac00000054,
  0xffffffab555555aa, 0xffffff82000002f4,
  0xffffff81000002fa, 0xffffff82000001f8,
  0xffffff81000001fc, 0xffffff82000000fc,
  0xffffff81000000fe, 0x0000007e00000000,
  0x0000007f00000000, 0x0000007dffffff04,
  0x0000007effffff02, 0x00000054000000a8,
  0x00000054aaaaab54, 0x0000003266666730,
  0x00000032cccccd98, 0x00000000007e0000,
  0x00000000007f0000, 0x00000000007dff04,
  0x00000000007eff02, 0x00000000007dfe08,
  0x00000000007efe04, 0x00000000007dfd0c,
  0x00000000007efd06, 0x0000000000007e00,
  0x0000000000007f00, 0x0000000000007d04,
  0x0000000000007e02, 0x0000000000007c08,
  0x0000000000007d04, 0x0000000000007b0c,
  0x0000000000007c06, 0x0000000000001f80,
  0x0000000000001fc0, 0x00000000000002f4,
  0x00000000000002f4, 0x00000000000001f4,
  0x00000000000001f8, 0x00000000000000fa,
  0x00000000000000fc, 0x0000000000000000,
  0x0000000000000000, 0xffffffffffffff06,
  0xffffffffffffff04, 0xfffffffffffffe0c,
  0xfffffffffffffe08, 0xffffffffffffe0c0,
  0xffffffffffffe080, 0xffffffffffff85ee,
  0xffffffffffff84f4, 0xffffffffffff84f4,
  0xffffffffffff83f8, 0xffffffffffff83fa,
  0xffffffffffff82fc, 0xffffffffff8302ee,
  0xffffffffff8202f4, 0xffffffffff8301f4,
  0xffffffffff8201f8, 0xffffffffff8300fa,
  0xffffffffff8200fc, 0xffffffce00000032,
  0xffffffcd999999cc, 0xffffffacaaaaaafe,
  0xffffffac00000054, 0xffffff83000002ee,
  0xffffff82000002f4, 0xffffff83000001f4,
  0xffffff82000001f8, 0xffffff83000000fa,
  0xffffff82000000fc, 0x0000007d00000000,
  0x0000007e00000000, 0x0000007cffffff06,
  0x0000007dffffff04, 0x00000053555555fc,
  0x00000054000000a8, 0x00000032000000c8,
  0x0000003266666730, 0x00000000007d0000,
  0x00000000007e0000, 0x00000000007cff06,
  0x00000000007dff04, 0x00000000007cfe0c,
  0x00000000007dfe08, 0x00000000007cfd12,
  0x00000000007dfd0c, 0x0000000000007d00,
  0x0000000000007e00, 0x0000000000007c06,
  0x0000000000007d04, 0x0000000000007b0c,
  0x0000000000007c08, 0x0000000000007a12,
  0x0000000000007b0c, 0x0000000000001f40,
  0x0000000000001f80, 0x00000000000002ee,
  0x00000000000002ee, 0x0000000000000080,
  0x00000000000001f4, 0x0000000000000040,
  0x00000000000000fa, 0x0000000000000000,
  0x0000000000000000, 0xffffffffffffffc0,
  0xffffffffffffff06, 0xffffffffffffff80,
  0xfffffffffffffe0c, 0xfffffffffffff800,
  0xffffffffffffe0c0, 0xffffffffffffe0c0,
  0xffffffffffff85ee, 0xffffffffffffe080,
  0xffffffffffff84f4, 0xffffffffffffe040,
  0xffffffffffff83fa, 0xffffffffffe000c0,
  0xffffffffff8302ee, 0xffffffffffe00080,
  0xffffffffff8301f4, 0xffffffffffe00040,
  0xffffffffff8300fa, 0xfffffff333333340,
  0xffffffce00000032, 0xffffffeaaaaaaac0,
  0xffffffacaaaaaafe, 0xffffffe0000000c0,
  0xffffff83000002ee, 0xffffffe000000080,
  0xffffff83000001f4, 0xffffffe000000040,
  0xffffff83000000fa, 0x0000002000000000,
  0x0000007d00000000, 0x0000001fffffffc0,
  0x0000007cffffff06, 0x0000001555555580,
  0x00000053555555fc, 0x0000000ccccccd00,
  0x00000032000000c8, 0x0000000000200000,
  0x00000000007d0000, 0x00000000001fffc0,
  0x00000000007cff06, 0x00000000001fff80,
  0x00000000007cfe0c, 0x00000000001fff40,
  0x00000000007cfd12, 0x0000000000002000,
  0x0000000000007d00, 0x0000000000001fc0,
  0x0000000000007c06, 0x0000000000001f80,
  0x0000000000007b0c, 0x0000000000001f40,
  0x0000000000007a12, 0x0000000000000800,
  0x0000000000001f40, 0x00000000000000c0,
  0x00000000000000c0, 0x000000000000000c,
  0x0000000000000080, 0x0000000000000006,
  0x0000000000000040, 0x0000000000000000,
  0x0000000000000000, 0xfffffffffffffffa,
  0xffffffffffffffc0, 0xfffffffffffffff4,
  0xffffffffffffff80, 0xffffffffffffff40,
  0xfffffffffffff800, 0xfffffffffffffd12,
  0xffffffffffffe0c0, 0xfffffffffffffd0c,
  0xffffffffffffe080, 0xfffffffffffffd06,
  0xffffffffffffe040, 0xfffffffffffd0012,
  0xffffffffffe000c0, 0xfffffffffffd000c,
  0xffffffffffe00080, 0xfffffffffffd0006,
  0xffffffffffe00040, 0xfffffffeccccccce,
  0xfffffff333333340, 0xfffffffe00000002,
  0xffffffeaaaaaaac0, 0xfffffffd00000012,
  0xffffffe0000000c0, 0xfffffffd0000000c,
  0xffffffe000000080, 0xfffffffd00000006,
  0xffffffe000000040, 0x0000000300000000,
  0x0000002000000000, 0x00000002fffffffa,
  0x0000001fffffffc0, 0x0000000200000004,
  0x0000001555555580, 0x0000000133333338,
  0x0000000ccccccd00, 0x0000000000030000,
  0x0000000000200000, 0x000000000002fffa,
  0x00000000001fffc0, 0x000000000002fff4,
  0x00000000001fff80, 0x000000000002ffee,
  0x00000000001fff40, 0x0000000000000300,
  0x0000000000002000, 0x00000000000002fa,
  0x0000000000001fc0, 0x00000000000002f4,
  0x0000000000001f80, 0x00000000000002ee,
  0x0000000000001f40, 0x00000000000000c0,
  0x0000000000000800, 0x0000000000000012,
};
const unsigned kExpectedCount_NEON_sqdmull_2D = 961;

#endif  // VIXL_SIM_SQDMULL_2D_TRACE_AARCH64_H_
