# Adopters

## End users

Known end users with notable contributions to the advancement of the project include:

* Anthem
* Bloomberg
* ByteDance
* Duke Energy
* GitHub
* Netflix
* Niantic
* Pinterest
* Square
* Twilio
* Uber
* Unity Technologies
* Z Lab Corporation

SPIFFE and SPIRE are being used by numerous other companies, both large and small, to build higher layer products and services. The list includes but is not limited to:

* AccuKnox
* Amazon
* Arm
* Cisco
* Decipher Technology Studios
* F5 Networks
* HashiCorp
* Hewlett Packard Enterprise
* Intel
* Google
* IBM
* SAP
* Tigera
* TestifySec
* Transferwise
* VMware

## Ecosystem

SPIFFE and SPIRE have integrations available with a number of open-source projects. The list includes but is not limited to:

* [App Mesh Controller](https://github.com/aws/aws-app-mesh-controller-for-k8s)  
* [Athenz](https://github.com/yahoo/athenz)
* [Cert-Manager](https://github.com/cert-manager/csi-driver-spiffe)
* [Consul](https://github.com/hashicorp/consul)
* [Dapr](https://github.com/dapr)
* [Docker](https://github.com/containerd/containerd)
* [Emissary](https://github.com/github/emissary)
* [Envoy](https://github.com/envoyproxy/envoy)
* [Ghostunnel](https://github.com/square/ghostunnel)
* [gRPC](https://pkg.go.dev/github.com/spiffe/go-spiffe/v2/examples/spiffe-grpc)
* [Hamlet](https://github.com/vmware/hamlet)
* [Istio](https://github.com/istio/istio)
* [Keycloak](https://www.cncf.io/blog/2025/11/07/self-hosted-human-and-machine-identities-in-keycloak-26-4/)
* [Knox](https://github.com/pinterest/knox)
* [Kubernetes](https://github.com/kubernetes/kubernetes)
* [Linkerd](https://github.com/linkerd/linkerd2)
* [NGINX](http://hg.nginx.org/nginx/)
* [Parsec](https://github.com/parallaxsecond/parsec)
* [Sigstore](https://github.com/sigstore/fulcio)
* [Tekton](https://github.com/tektoncd/chains)
* [Tornjak](https://github.com/spiffe/tornjak)
* [Traefik](https://github.com/traefik/traefik)
* [Vault](https://www.hashicorp.com/en/blog/spiffe-securing-the-identity-of-agentic-ai-and-non-human-actors)

## Case Studies/User Stories

* Amazon Web Services blogs about using mTLS with SPIFFE/SPIRE in AWS App Mesh on Amazon EKS:
<https://aws.amazon.com/blogs/containers/using-mtls-with-spiffe-spire-in-app-mesh-on-eks/>

* Anthem writes about developing a zero trust framework at Anthem Using SPIFFE and SPIRE:
<https://upshotstories.com/stories/developing-a-zero-trust-framework-at-anthem-using-spiffe-and-spire>

* ARM and VMware showcase hardware backed security for multi-tenancy at the Edge with SPIFFE & PARSEC:
<https://www.youtube.com/watch?v=-I_rCKMyY7Y>

* Bloomberg talks about TPM node attestation with SPIRE:
<https://youtu.be/30S0sKRxzjM>

* Coinbase details Container Technologies part of their stack:
<https://blog.coinbase.com/container-technologies-at-coinbase-d4ae118dcb6c>

* Duke Energy describes securing the Microgrid using SPIFFE and SPIRE with TPMs:
<https://www.distributech.com/distributech-international-2022-conference-sessions/achieving-the-promise-of-grid-security-with-openfmb-and-cybersecurity-zero-trust-best-practices>

* Google announces standardization on SPIFFE across Google Cloud as the unified workload identity platform offered as a managed service:
<https://www.youtube.com/watch?v=aaPvEUCXvvw>

* NGINX/F5 on how NGINX service mesh leverages SPIFFE and SPIRE:
<https://youtu.be/plRkDK5xFpM>

* Styra demonstrates fortifying microservices with SPIRE and OPA:
<https://www.youtube.com/watch?v=iQ5ctLQswUc>

* Square talks about how Square uses SPIFFE and SPIRE to secure communications across hybrid infrastructure services:
<https://youtu.be/H5IlmYmEDKk?t=2585>

* Square describes how they provide mTLS identities to Lambdas using SPIFFE and SPIRE:
<https://developer.squareup.com/blog/providing-mtls-identities-to-lambdas/>

* Tigera demonstrates how Calico, Envoy and SPIRE are used to deliver unified Layer 4 and Layer 7 authorization policies:
<https://youtu.be/H5IlmYmEDKk?t=7812>

* Uber talks about integrating SPIRE with workload schedulers:
<https://youtu.be/H5IlmYmEDKk?t=4703>

## Adding a name

If you would like to add your name to this file, submit a pull request with your change.
