# 2025-07-15 Triage Log

A busy week with a lot of rollups containing perf. regressions and mixed results. Overall, regressions won slightly, but there were also a few impressive wins on a few primary and secondary benchmarks. A lot of perf. effects are caused by the current rework of attribute parsing, which will hopefully result in slightly improved performance once it's finished.

Triage done by **@kobzol**.
Revision range: [0d11be5a..a9fb6103](https://perf.rust-lang.org/?start=0d11be5aabe0cd49609fff5fce57c4691a22fe55&end=a9fb6103b05c6ad6eee6bed4c0bb5a2e8e1024c6&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.1%, 1.5%]    | 62    |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.1%, 1.8%]    | 78    |
| Improvements ✅ <br /> (primary)   | -0.4% | [-3.9%, -0.1%]  | 40    |
| Improvements ✅ <br /> (secondary) | -1.4% | [-11.6%, -0.0%] | 74    |
| All ❌✅ (primary)                 | 0.1%  | [-3.9%, 1.5%]   | 102   |


5 Regressions, 4 Improvements, 8 Mixed; 5 of them in rollups
47 artifact comparisons made in total

#### Regressions

Rollup of 7 pull requests [#143645](https://github.com/rust-lang/rust/pull/143645) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f838cbc06de60819faff3413f374706b74824ca2&end=ab68b0fb26485ab1fa6977b2d8b59cc8a171c4aa&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.1%, 0.5%] | 16    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |

- Most regressions come from [#143402](https://github.com/rust-lang/rust/pull/143402), which refactors attribute parsing to the new system. It does more validations now, so slight regressions are expected.
- Marked as triaged.

Instantiate auto trait/`Copy`/`Clone`/`Sized` before computing constituent types binder [#143538](https://github.com/rust-lang/rust/pull/143538) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e3fccdd4a16bf3aa223749efef1fa981589e43ae&end=e43d139a82620a268d3828a73e12a8679339e8f8&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.2%, 0.3%] | 3     |
| Regressions ❌ <br /> (secondary)  | 0.0% | [0.0%, 0.0%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.2%, 0.3%] | 3     |

- The tiny regression was deemed to be [acceptable](https://github.com/rust-lang/rust/pull/143538#issuecomment-3047103921).
- Marked as triaged.

Rollup of 12 pull requests [#143731](https://github.com/rust-lang/rust/pull/143731) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=119574f83576dc1f3ae067f9a97986d4e2b0826c&end=78a6e132984dba0303ebad7dcfd1305c93ad5835&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.1%, 0.4%] | 12    |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.1%, 0.9%] | 14    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.1%, 0.4%] | 12    |

- The regression was caused by [#136906](https://github.com/rust-lang/rust/pull/136906), continuing discussion on that PR.
- Marked as triaged.

Rollup of 11 pull requests [#143888](https://github.com/rust-lang/rust/pull/143888) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7e310f4b9a3f166d833ed09cf1d1ff96ab84b72c&end=56835d7ac14da9f966e1ff39fd9ffd2e29b764d1&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.1%, 0.8%] | 15    |
| Regressions ❌ <br /> (secondary)  | 0.8% | [0.8%, 0.8%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.1%, 0.8%] | 15    |

- Regression caused by [#143519](https://github.com/rust-lang/rust/pull/143519).
- The regession was expected due to rustc doing more work. Created an [issue](https://github.com/rust-lang/rust/issues/143945) for tracking a potential improvement.
- Marked as triaged.

Port `#[cfg]` to the new attribute parsing infrastructure [#143460](https://github.com/rust-lang/rust/pull/143460) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7f2065a4bae1faed5bab928c670964eafbf43b55&end=a9fb6103b05c6ad6eee6bed4c0bb5a2e8e1024c6&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.2%, 1.3%] | 6     |
| Regressions ❌ <br /> (secondary)  | 0.8% | [0.5%, 1.3%] | 3     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.2%, 1.3%] | 6     |

- The `syn` regressions are noise.
- The rest of the regressions are real, but tiny, and we expect to improve them soon, with the rest of the attribute parsing rework (https://github.com/rust-lang/rust/pull/143963).
- Marked as triaged.

#### Improvements

Use `join_with_double_colon` in `write_shared.rs`. [#142869](https://github.com/rust-lang/rust/pull/142869) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2783fc43fd13a669f314742890acd64200ad0bbf&end=45b80ac21a454d343833aad763ef604510c88375&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.3% | [-4.0%, -0.6%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -2.3% | [-4.0%, -0.6%] | 2     |


`rustc_pattern_analysis`: always check that deref patterns don't match on the same place as normal constructors [#143472](https://github.com/rust-lang/rust/pull/143472) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=558d25371fe1cc3d907ebcfc4e12d3c27acbe2b7&end=6b3ae3f6e45a33c2d95fa0362c9b2593e567fd34&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.1%, 0.1%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -2.7% | [-2.9%, -2.6%] | 6     |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.2%] | 2     |


Add opaque TypeId handles for CTFE  [#143696](https://github.com/rust-lang/rust/pull/143696) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=32cd9114712a24010b0583624dc52ac302194128&end=cf3fb768db439825e3c8d327f6d9f46e02965668&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.4%, 0.4%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.1%, 0.2%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.1%] | 20    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.6%, -0.1%] | 37    |
| All ❌✅ (primary)                 | -0.1% | [-0.3%, 0.4%]  | 21    |


Propagate from borrowed locals in CopyProp [#143624](https://github.com/rust-lang/rust/pull/143624) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=915e5352448afb3c24f89117468935283bc7d2cf&end=bfc046a4b8d6b57db02540182466e989a9b0fb40&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.5%, 0.5%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.0%  | [0.0%, 0.0%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.6%, -0.1%] | 27    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-1.0%, -0.0%] | 33    |
| All ❌✅ (primary)                 | -0.1% | [-0.6%, 0.5%]  | 28    |


#### Mixed

Add `ty_span` query [#143433](https://github.com/rust-lang/rust/pull/143433) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a2d45f73c70d9dec57140c9412f83586eda895f8&end=688ea65df6a47866d0f72a00f1e18b47a7edf83b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.2%, 0.9%]   | 11    |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.0%, 0.2%]   | 2     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.1%] | 2     |
| All ❌✅ (primary)                 | 0.6%  | [0.2%, 0.9%]   | 11    |

- Small expected regression in libc, as rustc now stores more information per item in the dep graph.
- Marked as triaged.

Use lld by default on `x86_64-unknown-linux-gnu` stable [#140525](https://github.com/rust-lang/rust/pull/140525) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ab68b0fb26485ab1fa6977b2d8b59cc8a171c4aa&end=34097a38afc9efdedf776d3f1c84a190ff334886&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.1%, 0.1%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.1%] | 2     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.2%] | 2     |

- This should be noise, as there should be no observable perf. changes in this PR.
- Marked as triaged.

Apply effects to `otherwise` edge in dataflow analysis [#142707](https://github.com/rust-lang/rust/pull/142707) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=34097a38afc9efdedf776d3f1c84a190ff334886&end=d350797b7e1a5b6952f5035cbad2a21613b32f6c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.4%, 0.7%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.1%, 1.0%]   | 15    |
| Improvements ✅ <br /> (primary)   | -0.4% | [-1.3%, -0.1%] | 18    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.5%, -0.0%] | 10    |
| All ❌✅ (primary)                 | -0.3% | [-1.3%, 0.7%]  | 20    |

- More improvements than regressions, and improvements are mostly in primary benchmarks, while regressions are in secondary benchmarks. [This comment](https://github.com/rust-lang/rust/pull/142707#issuecomment-3050525801) mentions a plan for possible future improvements.
- Marked as triaged.

Rollup of 9 pull requests [#143667](https://github.com/rust-lang/rust/pull/143667) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d350797b7e1a5b6952f5035cbad2a21613b32f6c&end=558d25371fe1cc3d907ebcfc4e12d3c27acbe2b7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.0%, 0.3%]   | 20    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.8% | [-1.1%, -0.0%] | 8     |
| All ❌✅ (primary)                 | -     | -              | 0     |

- The small regressions are caused by [#143520](https://github.com/rust-lang/rust/pull/143520).
- The regressions are only on secondary benchmarks, and this produces a larger win for CTFE benchmarks.
- Marked as triaged.

Rollup of 9 pull requests [#143810](https://github.com/rust-lang/rust/pull/143810) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2f9c9cede68be26774ea44efc79d0391f1c58af2&end=915e5352448afb3c24f89117468935283bc7d2cf&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.1%, 0.3%]   | 34    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.0%, 1.0%]   | 33    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.3%, -0.0%] | 3     |
| All ❌✅ (primary)                 | 0.2%  | [0.1%, 0.3%]   | 34    |

- The regression comes from [#143403](https://github.com/rust-lang/rust/pull/143403).
- Continuing discussion on the PR.
- Marked as triaged.

compute all rpitit of a trait [#143783](https://github.com/rust-lang/rust/pull/143783) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bfc046a4b8d6b57db02540182466e989a9b0fb40&end=288e94c4ba406d612a556520442683d0f1ef5dbb&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.1%  | [1.1%, 1.1%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.2%] | 9     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 4     |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.2%] | 9     |

- Improvements outweigh regressions.
- Marked as triaged.

de-duplicate condition scoping logic between AST→HIR lowering and `ScopeTree` construction [#143213](https://github.com/rust-lang/rust/pull/143213) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b1d2f2c64c6254b2a935d6a2d29b68f4511cf500&end=d2baa49a106fad06fbf6202fb6ea8a0b3d2767cc&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.1%, 0.3%]   | 5     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.2%] | 3     |

- Kind of a wash, a few small wins on a primary benchmark and a few small losses on secondary benchmarks.
- Marked as triaged.

Retire hir::*ItemRef. [#143357](https://github.com/rust-lang/rust/pull/143357) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e9182f195b8505c87c4bd055b9f6e114ccda0981&end=9c3064e131f4939cc95a29bb11413c49bbda1491&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]    | 1     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.3%]    | 6     |
| Improvements ✅ <br /> (primary)   | -0.1% | [-0.1%, -0.1%]  | 1     |
| Improvements ✅ <br /> (secondary) | -4.8% | [-11.6%, -0.2%] | 14    |
| All ❌✅ (primary)                 | 0.0%  | [-0.1%, 0.2%]   | 2     |

- More improvements than regressions, in particular an impressive win on `many-assoc-items`.
- Marked as triaged.
