fn main() {
    if std::env::var("DOCS_RS").is_ok() {
        // prevent linking libraries to avoid documentation failure
        return;
    }

    if let Err(s) = system_deps::Config::new().probe() {
        println!("cargo:warning={s}");
        std::process::exit(1);
    }

    // It's safe to assume we can call this because we found the library OK
    // in find()
    check_features();
}

fn check_features() {
    const PKG_CONFIG_PACKAGE: &str = "gtk4";

    // The pkg-config file defines a `targets` variable listing the
    // various backends that GTK was compiled for.
    // We extract that and create gdk_backend="x11" and the like
    // as configuration variables.
    // In addition we publish this as a variable which cargo will
    // provide to immediate dependents of this crate as an environment
    // variable for their `build.rs` runs called DEP_GDK_BACKENDS
    // For reference, the backend set at time of writing consists of:
    // x11 win32 macos broadway wayland
    if let Ok(targets) = pkg_config::get_variable(PKG_CONFIG_PACKAGE, "targets") {
        println!("cargo:backends={targets}");
        for target in targets.split_whitespace() {
            // For whatever reasons,calling pkg-config --variable=targets gtk4
            // returns broadway\ wayland\ x11. So we drop those from the configured
            // gtk_backend
            println!(
                "cargo:rustc-cfg=gdk_backend=\"{}\"",
                target.trim_end_matches('\\')
            );
        }
    }
}
