
from unittest import mock
from routersploit.modules.exploits.routers.cisco.rv320_command_injection import Exploit


@mock.patch("routersploit.modules.exploits.cameras.multi.cctv_dvr_rce")
def test_check_success(mocked_shell, target):
    """ Test scenario - successful exploitation """

    route_mock1 = target.get_route_mock("/../../../../../../../mnt/mtd/test", methods=["GET"])
    route_mock1.return_value = (
        "TEST"
    )

    route_mock2 = target.get_route_mock("/language/Swedish", methods=["GET"])
    route_mock2.return_value = (
        "TEST"
    )

    exploit = Exploit()

    assert exploit.target == ""
    assert exploit.port == 80

    exploit.target = target.host
    exploit.port = target.port
    exploit.connback = "192.168.100.1:5555"

    assert exploit.check()
    assert exploit.run() is None
