// SPDX-FileCopyrightText: 2012-2020 houndthe <cgkajm@gmail.com>
// SPDX-FileCopyrightText: 2024 Billow <billow.fun@gmail.com>
// SPDX-License-Identifier: LGPL-3.0-only

/// 4.1 https://github.com/ARM-software/abi-aa/blob/2982a9f3b512a5bfdc9e3fea5d3b298f9165c36b/aadwarf32/aadwarf32.rst
static const char *map_dwarf_reg_to_arm32(ut32 reg_num) {
	switch (reg_num) {
		KASE(0, r0);
		KASE(1, r1);
		KASE(2, r2);
		KASE(3, r3);
		KASE(4, r4);
		KASE(5, r5);
		KASE(6, r6);
		KASE(7, r7);
		KASE(8, r8);
		KASE(9, r9);
		KASE(10, r10);
		KASE(11, r11);
		KASE(12, r12);
		KASE(13, r13);
		KASE(14, r14);
		KASE(15, r15);
		/*16-63 None*/
		KASE(64, s0);
		KASE(65, s1);
		KASE(66, s2);
		KASE(67, s3);
		KASE(68, s4);
		KASE(69, s5);
		KASE(70, s6);
		KASE(71, s7);
		KASE(72, s8);
		KASE(73, s9);
		KASE(74, s10);
		KASE(75, s11);
		KASE(76, s12);
		KASE(77, s13);
		KASE(78, s14);
		KASE(79, s15);
		KASE(80, s16);
		KASE(81, s17);
		KASE(82, s18);
		KASE(83, s19);
		KASE(84, s20);
		KASE(85, s21);
		KASE(86, s22);
		KASE(87, s23);
		KASE(88, s24);
		KASE(89, s25);
		KASE(90, s26);
		KASE(91, s27);
		KASE(92, s28);
		KASE(93, s29);
		KASE(94, s30);
		KASE(95, s31);
		KASE(96, f0);
		KASE(97, f1);
		KASE(98, f2);
		KASE(99, f3);
		KASE(100, f4);
		KASE(101, f5);
		KASE(102, f6);
		KASE(103, f7);
		KASE(104, wCGR0);
		KASE(105, wCGR1);
		KASE(106, wCGR2);
		KASE(107, wCGR3);
		KASE(108, wCGR4);
		KASE(109, wCGR5);
		KASE(110, wCGR6);
		KASE(111, wCGR7);
		KASE(112, wR0);
		KASE(113, wR1);
		KASE(114, wR2);
		KASE(115, wR3);
		KASE(116, wR4);
		KASE(117, wR5);
		KASE(118, wR6);
		KASE(119, wR7);
		KASE(120, wR8);
		KASE(121, wR9);
		KASE(122, wR10);
		KASE(123, wR11);
		KASE(124, wR12);
		KASE(125, wR13);
		KASE(126, wR14);
		KASE(127, wR15);
		KASE(128, SPSR);
		KASE(129, SPSR_FIQ);
		KASE(130, SPSR_IRQ);
		KASE(131, SPSR_ABT);
		KASE(132, SPSR_UND);
		KASE(133, SPSR_SVC);
		/*134-142 None*/
		KASE(143, RA_AUTH_CODE);
		KASE(144, R8_USR);
		KASE(145, R9_USR);
		KASE(146, R10_USR);
		KASE(147, R11_USR);
		KASE(148, R12_USR);
		KASE(149, R13_USR);
		KASE(150, R14_USR);
		KASE(151, R8_FIQ);
		KASE(152, R9_FIQ);
		KASE(153, R10_FIQ);
		KASE(154, R11_FIQ);
		KASE(155, R12_FIQ);
		KASE(156, R13_FIQ);
		KASE(157, R14_FIQ);
		KASE(158, R13_IRQ);
		KASE(159, R14_IRQ);
		KASE(160, R13_ABT);
		KASE(161, R14_ABT);
		KASE(162, R13_UND);
		KASE(163, R14_UND);
		KASE(164, R13_SVC);
		KASE(165, R14_SVC);
		/*166-191 None*/
		KASE(192, wC0);
		KASE(193, wC1);
		KASE(194, wC2);
		KASE(195, wC3);
		KASE(196, wC4);
		KASE(197, wC5);
		KASE(198, wC6);
		KASE(199, wC7);
		/*200–255 None*/
		KASE(256, D0);
		KASE(257, D1);
		KASE(258, D2);
		KASE(259, D3);
		KASE(260, D4);
		KASE(261, D5);
		KASE(262, D6);
		KASE(263, D7);
		KASE(264, D8);
		KASE(265, D9);
		KASE(266, D10);
		KASE(267, D11);
		KASE(268, D12);
		KASE(269, D13);
		KASE(270, D14);
		KASE(271, D15);
		KASE(272, D16);
		KASE(273, D17);
		KASE(274, D18);
		KASE(275, D19);
		KASE(276, D20);
		KASE(277, D21);
		KASE(278, D22);
		KASE(279, D23);
		KASE(280, D24);
		KASE(281, D25);
		KASE(282, D26);
		KASE(283, D27);
		KASE(284, D28);
		KASE(285, D29);
		KASE(286, D30);
		KASE(287, D31);
		/*288-319 None*/
		KASE(320, TPIDRURO);
		KASE(321, TPIDRURW);
		KASE(322, TPIDPR);
		KASE(323, HTPIDPR);
		/*324-8191 None*/
	case 8192: return "Vendor co-processor";
	default:
		rz_warn_if_reached();
		return "unsupported_reg";
	}
}

/// 4.1 https://github.com/ARM-software/abi-aa/blob/2982a9f3b512a5bfdc9e3fea5d3b298f9165c36b/aadwarf64/aadwarf64.rst
static const char *map_dwarf_reg_to_arm64(ut32 reg_num) {
	switch (reg_num) {
		KASE(0, X0);
		KASE(1, X1);
		KASE(2, X2);
		KASE(3, X3);
		KASE(4, X4);
		KASE(5, X5);
		KASE(6, X6);
		KASE(7, X7);
		KASE(8, X8);
		KASE(9, X9);
		KASE(10, X10);
		KASE(11, X11);
		KASE(12, X12);
		KASE(13, X13);
		KASE(14, X14);
		KASE(15, X15);
		KASE(16, X16);
		KASE(17, X17);
		KASE(18, X18);
		KASE(19, X19);
		KASE(20, X20);
		KASE(21, X21);
		KASE(22, X22);
		KASE(23, X23);
		KASE(24, X24);
		KASE(25, X25);
		KASE(26, X26);
		KASE(27, X27);
		KASE(28, X28);
		KASE(29, X29);
		KASE(30, X30);
		KASE(31, SP);
		KASE(32, PC);
		KASE(33, ELR_mode);
		KASE(34, RA_SIGN_STATE);
		KASE(35, TPIDRRO_ELO);
		KASE(36, TPIDR_ELO);
		KASE(37, TPIDR_EL1);
		KASE(38, TPIDR_EL2);
		KASE(39, TPIDR_EL3);
	case 40:
	case 41:
	case 42:
	case 43:
	case 44:
		KASE(45, Reserved);
		KASE(46, VG);
		KASE(47, FFR);
		KASE(48, P0);
		KASE(49, P1);
		KASE(50, P2);
		KASE(51, P3);
		KASE(52, P4);
		KASE(53, P5);
		KASE(54, P6);
		KASE(55, P7);
		KASE(56, P8);
		KASE(57, P9);
		KASE(58, P10);
		KASE(59, P11);
		KASE(60, P12);
		KASE(61, P13);
		KASE(62, P14);
		KASE(63, P15);
		KASE(64, V0);
		KASE(65, V1);
		KASE(66, V2);
		KASE(67, V3);
		KASE(68, V4);
		KASE(69, V5);
		KASE(70, V6);
		KASE(71, V7);
		KASE(72, V8);
		KASE(73, V9);
		KASE(74, V10);
		KASE(75, V11);
		KASE(76, V12);
		KASE(77, V13);
		KASE(78, V14);
		KASE(79, V15);
		KASE(80, V16);
		KASE(81, V17);
		KASE(82, V18);
		KASE(83, V19);
		KASE(84, V20);
		KASE(85, V21);
		KASE(86, V22);
		KASE(87, V23);
		KASE(88, V24);
		KASE(89, V25);
		KASE(90, V26);
		KASE(91, V27);
		KASE(92, V28);
		KASE(93, V29);
		KASE(94, V30);
		KASE(95, V31);
		KASE(96, Z0);
		KASE(97, Z1);
		KASE(98, Z2);
		KASE(99, Z3);
		KASE(100, Z4);
		KASE(101, Z5);
		KASE(102, Z6);
		KASE(103, Z7);
		KASE(104, Z8);
		KASE(105, Z9);
		KASE(106, Z10);
		KASE(107, Z11);
		KASE(108, Z12);
		KASE(109, Z13);
		KASE(110, Z14);
		KASE(111, Z15);
		KASE(112, Z16);
		KASE(113, Z17);
		KASE(114, Z18);
		KASE(115, Z19);
		KASE(116, Z20);
		KASE(117, Z21);
		KASE(118, Z22);
		KASE(119, Z23);
		KASE(120, Z24);
		KASE(121, Z25);
		KASE(122, Z26);
		KASE(123, Z27);
		KASE(124, Z28);
		KASE(125, Z29);
		KASE(126, Z30);
		KASE(127, Z31);
	default:
		rz_warn_if_reached();
		return "unsupported_reg";
	}
}
