#
# PySNMP MIB module RFC1271-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/RFC1271-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:04:40 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( ObjectIdentifier, Integer, OctetString, ) = mibBuilder.importSymbols("ASN1", "ObjectIdentifier", "Integer", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ValueSizeConstraint, ConstraintsUnion, SingleValueConstraint, ConstraintsIntersection, ValueRangeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ValueSizeConstraint", "ConstraintsUnion", "SingleValueConstraint", "ConstraintsIntersection", "ValueRangeConstraint")
( NotificationGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ModuleCompliance")
( MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, mib_2, Counter32, NotificationType, ObjectIdentity, MibIdentifier, iso, IpAddress, Integer32, Gauge32, NotificationType, Unsigned32, Bits, ModuleIdentity, Counter64, ) = mibBuilder.importSymbols("SNMPv2-SMI", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "mib-2", "Counter32", "NotificationType", "ObjectIdentity", "MibIdentifier", "iso", "IpAddress", "Integer32", "Gauge32", "NotificationType", "Unsigned32", "Bits", "ModuleIdentity", "Counter64")
( DisplayString, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "TextualConvention")
rmon = MibIdentifier((1, 3, 6, 1, 2, 1, 16))
class OwnerString(DisplayString):
    pass

class EntryStatus(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))
    namedValues = NamedValues(("valid", 1), ("createRequest", 2), ("underCreation", 3), ("invalid", 4),)

statistics = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 1))
history = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 2))
alarm = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 3))
hosts = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 4))
hostTopN = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 5))
matrix = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 6))
filter = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 7))
capture = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 8))
event = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 9))
etherStatsTable = MibTable((1, 3, 6, 1, 2, 1, 16, 1, 1), )
if mibBuilder.loadTexts: etherStatsTable.setDescription('A list of Ethernet statistics entries.')
etherStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 1, 1, 1), ).setIndexNames((0, "RFC1271-MIB", "etherStatsIndex"))
if mibBuilder.loadTexts: etherStatsEntry.setDescription('A collection of statistics kept for a particular\n                  Ethernet interface.')
etherStatsIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsIndex.setDescription('The value of this object uniquely identifies this\n                  etherStats entry.')
etherStatsDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 2), ObjectIdentifier()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: etherStatsDataSource.setDescription('This object identifies the source of the data that\n                  this etherStats entry is configured to analyze.  This\n                  source can be any ethernet interface on this device.\n                  In order to identify a particular interface, this\n                  object shall identify the instance of the ifIndex\n                  object, defined in [4,6], for the desired interface.\n                  For example, if an entry were to receive data from\n                  interface #1, this object would be set to ifIndex.1.\n\n                  The statistics in this group reflect all packets\n                  on the local network segment attached to the\n                  identified interface.\n\n                  This object may not be modified if the associated\n                  etherStatsStatus object is equal to valid(1).')
etherStatsDropEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsDropEvents.setDescription('The total number of events in which packets\n                  were dropped by the probe due to lack of resources.\n                  Note that this number is not necessarily the number of\n                  packets dropped; it is just the number of times this\n                  condition has been detected.')
etherStatsOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsOctets.setDescription('The total number of octets of data (including\n                  those in bad packets) received on the\n                  network (excluding framing bits but including\n                  FCS octets).')
etherStatsPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts.setDescription('The total number of packets (including error packets)\n                  received.')
etherStatsBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsBroadcastPkts.setDescription('The total number of good packets received that were\n                  directed to the broadcast address.')
etherStatsMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsMulticastPkts.setDescription('The total number of good packets received that were\n                  directed to a multicast address.  Note that this\n                  number does not include packets directed to the\n                  broadcast address.')
etherStatsCRCAlignErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsCRCAlignErrors.setDescription('The total number of packets received that\n                  had a length (excluding framing bits, but\n                  including FCS octets) of between 64 and 1518\n                  octets, inclusive, but were not an integral number\n                  of octets in length or had a bad Frame Check\n                  Sequence (FCS).')
etherStatsUndersizePkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsUndersizePkts.setDescription('The total number of packets received that were\n                  less than 64 octets long (excluding framing bits,\n                  but including FCS octets) and were otherwise well\n                  formed.')
etherStatsOversizePkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsOversizePkts.setDescription('The total number of packets received that were\n                  longer than 1518 octets (excluding framing bits,\n                  but including FCS octets) and were otherwise\n                  well formed.')
etherStatsFragments = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsFragments.setDescription('The total number of packets received that were not an\n                  integral number of octets in length or that had a bad\n                  Frame Check Sequence (FCS), and were less than 64\n                  octets in length (excluding framing bits but\n                  including FCS octets).')
etherStatsJabbers = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsJabbers.setDescription('The total number of packets received that were\n                  longer than 1518 octets (excluding framing bits,\n                  but including FCS octets), and were not an\n                  integral number of octets in length or had\n                  a bad Frame Check Sequence (FCS).')
etherStatsCollisions = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsCollisions.setDescription('The best estimate of the total number of collisions\n                  on this Ethernet segment.')
etherStatsPkts64Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts64Octets.setDescription('The total number of packets (including error\n                  packets) received that were 64 octets in length\n                  (excluding framing bits but including FCS octets).')
etherStatsPkts65to127Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts65to127Octets.setDescription('The total number of packets (including error\n                  packets) received that were between\n                  65 and 127 octets in length inclusive\n                  (excluding framing bits but including FCS octets).')
etherStatsPkts128to255Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts128to255Octets.setDescription('The total number of packets (including error\n                  packets) received that were between\n                  128 and 255 octets in length inclusive\n                  (excluding framing bits but including FCS octets).')
etherStatsPkts256to511Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts256to511Octets.setDescription('The total number of packets (including error\n                  packets) received that were between\n                  256 and 511 octets in length inclusive\n                  (excluding framing bits but including FCS octets).')
etherStatsPkts512to1023Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts512to1023Octets.setDescription('The total number of packets (including error\n                  packets) received that were between\n                  512 and 1023 octets in length inclusive\n                  (excluding framing bits but including FCS octets).')
etherStatsPkts1024to1518Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherStatsPkts1024to1518Octets.setDescription('The total number of packets (including error\n                  packets) received that were between\n                  1024 and 1518 octets in length inclusive\n                  (excluding framing bits but including FCS octets).')
etherStatsOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 20), OwnerString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: etherStatsOwner.setDescription('The entity that configured this entry and is\n                  therefore using the resources assigned to it.')
etherStatsStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 1, 1, 21), EntryStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: etherStatsStatus.setDescription('The status of this etherStats entry.')
historyControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 2, 1), )
if mibBuilder.loadTexts: historyControlTable.setDescription('A list of history control entries.')
historyControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 2, 1, 1), ).setIndexNames((0, "RFC1271-MIB", "historyControlIndex"))
if mibBuilder.loadTexts: historyControlEntry.setDescription('A list of parameters that set up a periodic\n                  sampling of statistics.')
historyControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: historyControlIndex.setDescription('An index that uniquely identifies an entry in the\n                  historyControl table.  Each such entry defines a\n                  set of samples at a particular interval for an\n                  interface on the device.')
historyControlDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 2), ObjectIdentifier()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: historyControlDataSource.setDescription('This object identifies the source of the data for\n                  which historical data was collected and\n                  placed in a media-specific table on behalf of this\n                  historyControlEntry.  This source can be any\n                  interface on this device.  In order to identify\n                  a particular interface, this object shall identify\n                  the instance of the ifIndex object, defined\n                  in [4,6], for the desired interface.  For example,\n                  if an entry were to receive data from interface #1,\n                  this object would be set to ifIndex.1.\n\n                  The statistics in this group reflect all packets\n                  on the local network segment attached to the\n                  identified interface.\n\n                  This object may not be modified if the associated\n                  historyControlStatus object is equal to valid(1).')
historyControlBucketsRequested = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535)).clone(50)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: historyControlBucketsRequested.setDescription('The requested number of discrete time intervals\n                  over which data is to be saved in the part of the\n                  media-specific table associated with this\n                  historyControl entry.\n\n                  When this object is created or modified, the probe\n                  should set historyControlBucketsGranted as closely to\n                  this object as is possible for the particular probe\n                  implementation and available resources.')
historyControlBucketsGranted = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: historyControlBucketsGranted.setDescription('The number of discrete sampling intervals\n                  over which data shall be saved in the part of\n                  the media-specific table associated with this\n                  historyControl entry.\n\n                  When the associated historyControlBucketsRequested\n                  object is created or modified, the probe\n                  should set this object as closely to the requested\n                  value as is possible for the particular\n                  probe implementation and available resources.  The\n                  probe must not lower this value except as a result\n                  of a modification to the associated\n                  historyControlBucketsRequested object.\n\n                  There will be times when the actual number of\n                  buckets associated with this entry is less than\n                  the value of this object.  In this case, at the\n                  end of each sampling interval, a new bucket will\n                  be added to the media-specific table.\n\n                  When the number of buckets reaches the value of\n                  this object and a new bucket is to be added to the\n                  media-specific table, the oldest bucket associated\n                  with this historyControlEntry shall be deleted by\n                  the agent so that the new bucket can be added.\n\n                  When the value of this object changes to a value less\n                  than the current value, entries are deleted\n                  from the media-specific table associated with this\n                  historyControlEntry.  Enough of the oldest of these\n                  entries shall be deleted by the agent so that their\n                  number remains less than or equal to the new value of\n                  this object.\n\n                  When the value of this object changes to a value\n                  greater than the current value, the number of\n                  associated media-specific entries may be allowed\n                  to grow.')
historyControlInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,3600)).clone(1800)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: historyControlInterval.setDescription("The interval in seconds over which the data is\n                  sampled for each bucket in the part of the\n                  media-specific table associated with this\n                  historyControl entry.  This interval can\n                  be set to any number of seconds between 1 and\n                  3600 (1 hour).\n\n                  Because the counters in a bucket may overflow at their\n                  maximum value with no indication, a prudent manager\n                  will take into account the possibility of overflow\n                  in any of the associated counters.  It is important\n                  to consider the minimum time in which any counter\n                  could overflow on a particular media type and set\n                  the historyControlInterval object to a value less\n                  than this interval.  This is typically most\n                  important for the 'octets' counter in any\n                  media-specific table.  For example, on an Ethernet\n                  network, the etherHistoryOctets counter could overflow\n                  in about one hour at the Ethernet's maximum\n                  utilization.\n\n                  This object may not be modified if the associated\n                  historyControlStatus object is equal to valid(1).")
historyControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 6), OwnerString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: historyControlOwner.setDescription('The entity that configured this entry and is therefore\n                  using the resources assigned to it.')
historyControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 1, 1, 7), EntryStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: historyControlStatus.setDescription('The status of this historyControl entry.\n\n                  Each instance of the media-specific table associated\n                  with this historyControlEntry will be deleted by the\n                  agent if this historyControlEntry is not equal to\n                  valid(1).')
etherHistoryTable = MibTable((1, 3, 6, 1, 2, 1, 16, 2, 2), )
if mibBuilder.loadTexts: etherHistoryTable.setDescription('A list of Ethernet history entries.')
etherHistoryEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 2, 2, 1), ).setIndexNames((0, "RFC1271-MIB", "etherHistoryIndex"), (0, "RFC1271-MIB", "etherHistorySampleIndex"))
if mibBuilder.loadTexts: etherHistoryEntry.setDescription('An historical sample of Ethernet statistics on a\n                  particular Ethernet interface.  This sample is\n                  associated with the historyControlEntry which set\n                  up the parameters for a regular collection of these\n                  samples.')
etherHistoryIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryIndex.setDescription('The history of which this entry is a part.  The\n                  history identified by a particular value of this\n                  index is the same history as identified\n                  by the same value of historyControlIndex.')
etherHistorySampleIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistorySampleIndex.setDescription('An index that uniquely identifies the particular\n                  sample this entry represents among all samples\n                  associated with the same historyControlEntry.\n                  This index starts at 1 and increases by one\n                  as each new sample is taken.')
etherHistoryIntervalStart = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 3), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryIntervalStart.setDescription('The value of sysUpTime at the start of the interval\n                  over which this sample was measured.  If the probe\n                  keeps track of the time of day, it should start\n                  the first sample of the history at a time such that\n                  when the next hour of the day begins, a sample is\n                  started at that instant.  Note that following this\n                  rule may require the probe to delay collecting the\n                  first sample of the history, as each sample must be\n                  of the same interval.  Also note that the sample which\n                  is currently being collected is not accessible in this\n                  table until the end of its interval.')
etherHistoryDropEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryDropEvents.setDescription('The total number of events in which packets\n                  were dropped by the probe due to lack of resources\n                  during this interval.  Note that this number is not\n                  necessarily the number of packets dropped, it is just\n                  the number of times this condition has been detected.')
etherHistoryOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryOctets.setDescription('The total number of octets of data (including\n                  those in bad packets) received on the\n                  network (excluding framing bits but including\n                  FCS octets).')
etherHistoryPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryPkts.setDescription('The number of packets (including error packets)\n                  received during this sampling interval.')
etherHistoryBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryBroadcastPkts.setDescription('The number of good packets received during this\n                  sampling interval that were directed to the\n                  broadcast address.')
etherHistoryMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryMulticastPkts.setDescription('The number of good packets received during this\n                  sampling interval that were directed to a\n                  multicast address.  Note that this number does not\n                  include packets addressed to the broadcast address.')
etherHistoryCRCAlignErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryCRCAlignErrors.setDescription('The number of packets received during this\n                  sampling interval that had a length (excluding\n                  framing bits but including FCS octets) between\n                  64 and 1518 octets, inclusive, but were not an\n                  integral number of octets in length or had a\n                  bad Frame Check Sequence (FCS).')
etherHistoryUndersizePkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryUndersizePkts.setDescription('The number of packets received during this\n                  interval that were less than 64 octets long\n                  (excluding framing bits but including FCS\n                  octets) and were otherwise well formed.')
etherHistoryOversizePkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryOversizePkts.setDescription('The number of packets received during this\n                  interval that were longer than 1518 octets\n                  (excluding framing bits but including FCS\n                  octets) but were otherwise well formed.')
etherHistoryFragments = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryFragments.setDescription('The total number of packets received during this\n                  sampling interval that were not an integral\n                  number of octets in length or that\n                  had a bad Frame Check Sequence (FCS), and\n                  were less than 64 octets in length (excluding\n                  framing bits but including FCS octets).')
etherHistoryJabbers = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryJabbers.setDescription('The number of packets received during this\n                  interval that were longer than 1518 octets\n                  (excluding framing bits but including FCS octets),\n                  and were not an integral number of octets in\n                  length or had a bad Frame Check Sequence (FCS).')
etherHistoryCollisions = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryCollisions.setDescription('The best estimate of the total number of collisions\n                  on this Ethernet segment during this interval.')
etherHistoryUtilization = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 2, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,10000))).setMaxAccess("readonly")
if mibBuilder.loadTexts: etherHistoryUtilization.setDescription('The best estimate of the mean physical layer\n                  network utilization on this interface during this\n                  interval, in hundredths of a percent.')
alarmTable = MibTable((1, 3, 6, 1, 2, 1, 16, 3, 1), )
if mibBuilder.loadTexts: alarmTable.setDescription('A list of alarm entries.')
alarmEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 3, 1, 1), ).setIndexNames((0, "RFC1271-MIB", "alarmIndex"))
if mibBuilder.loadTexts: alarmEntry.setDescription('A list of parameters that set up a periodic checking\n                  for alarm conditions.')
alarmIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: alarmIndex.setDescription('An index that uniquely identifies an entry in the\n                  alarm table.  Each such entry defines a\n                  diagnostic sample at a particular interval\n                  for an object on the device.')
alarmInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 2), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: alarmInterval.setDescription('The interval in seconds over which the data is\n                  sampled and compared with the rising and falling\n                  thresholds.  When setting this variable, care\n                  should be given to ensure that the variable being\n                  monitored will not exceed 2^31 - 1 and roll\n                  over the alarmValue object during the interval.\n\n                  This object may not be modified if the associated\n                  alarmStatus object is equal to valid(1).')
alarmVariable = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 3), ObjectIdentifier()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: alarmVariable.setDescription('The object identifier of the particular variable to\n                  be sampled.  Only variables that resolve to an ASN.1\n                  primitive type of INTEGER (INTEGER, Counter, Gauge,\n                  or TimeTicks) may be sampled.\n\n                  Because SNMP access control is articulated entirely\n                  in terms of the contents of MIB views, no access\n                  control mechanism exists that can restrict the value of\n                  this object to identify only those objects that exist\n                  in a particular MIB view.  Because there is thus no\n                  acceptable means of restricting the read access that\n                  could be obtained through the alarm mechanism, the\n                  probe must only grant write access to this object in\n                  those views that have read access to all objects on\n                  the probe.\n\n                  During a set operation, if the supplied variable\n                  name is not available in the selected MIB view, a\n                  badValue error must be returned.  If at any time\n                  the variable name of an established alarmEntry is\n                  no longer available in the selected MIB view, the\n                  probe must change the status of this alarmEntry\n                  to invalid(4).\n\n                  This object may not be modified if the associated\n                  alarmStatus object is equal to valid(1).')
alarmSampleType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("absoluteValue", 1), ("deltaValue", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: alarmSampleType.setDescription('The method of sampling the selected variable and\n                  calculating the value to be compared against the\n                  thresholds.  If the value of this object is\n                  absoluteValue(1), the value of the selected variable\n                  will be compared directly with the thresholds at the\n                  end of the sampling interval.  If the value of this\n                  object is deltaValue(2), the value of the selected\n                  variable at the last sample will be subtracted from\n                  the current value, and the difference compared with\n                  the thresholds.\n\n                  This object may not be modified if the associated\n                  alarmStatus object is equal to valid(1).')
alarmValue = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: alarmValue.setDescription('The value of the statistic during the last sampling\n                  period.  The value during the current sampling period\n                  is not made available until the period is completed.')
alarmStartupAlarm = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("risingAlarm", 1), ("fallingAlarm", 2), ("risingOrFallingAlarm", 3),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: alarmStartupAlarm.setDescription('The alarm that may be sent when this entry is first\n                  set to valid.  If the first sample after this entry\n                  becomes valid is greater than or equal to the\n                  risingThreshold and alarmStartupAlarm is equal to\n                  risingAlarm(1) or risingOrFallingAlarm(3), then a\n                  single rising alarm will be generated.  If the first\n                  sample after this entry becomes valid is less than\n                  or equal to the fallingThreshold and\n                  alarmStartupAlarm is equal to fallingAlarm(2) or\n                  risingOrFallingAlarm(3), then a single falling\n                  alarm will be generated.\n\n                  This object may not be modified if the associated\n                  alarmStatus object is equal to valid(1).')
alarmRisingThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 7), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: alarmRisingThreshold.setDescription('A threshold for the sampled statistic.  When the\n                  current sampled value is greater than or equal to\n                  this threshold, and the value at the last sampling\n                  interval was less than this threshold, a single\n                  event will be generated.\n                  A single event will also be generated if the first\n                  sample after this entry becomes valid is greater\n                  than or equal to this threshold and the associated\n                  alarmStartupAlarm is equal to risingAlarm(1) or\n                  risingOrFallingAlarm(3).\n\n                  After a rising event is generated, another such event\n                  will not be generated until the sampled value\n                  falls below this threshold and reaches the\n                  alarmFallingThreshold.\n\n                  This object may not be modified if the associated\n                  alarmStatus object is equal to valid(1).')
alarmFallingThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 8), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: alarmFallingThreshold.setDescription('A threshold for the sampled statistic.  When the\n                  current sampled value is less than or equal to\n                  this threshold, and the value at the last sampling\n                  interval was greater than this threshold, a single\n                  event will be generated.\n                  A single event will also be generated if the first\n                  sample after this entry becomes valid is less than or\n                  equal to this threshold and the associated\n                  alarmStartupAlarm is equal to fallingAlarm(2) or\n                  risingOrFallingAlarm(3).\n\n                  After a falling event is generated, another such event\n                  will not be generated until the sampled value\n                  rises above this threshold and reaches the\n                  alarmRisingThreshold.\n\n                  This object may not be modified if the associated\n                  alarmStatus object is equal to valid(1).')
alarmRisingEventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: alarmRisingEventIndex.setDescription('The index of the eventEntry that is\n                  used when a rising threshold is crossed.  The\n                  eventEntry identified by a particular value of\n                  this index is the same as identified by the same value\n                  of the eventIndex object.  If there is no\n                  corresponding entry in the eventTable, then\n                  no association exists.  In particular, if this value\n                  is zero, no associated event will be generated, as\n                  zero is not a valid event index.\n\n                  This object may not be modified if the associated\n                  alarmStatus object is equal to valid(1).')
alarmFallingEventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: alarmFallingEventIndex.setDescription('The index of the eventEntry that is\n                  used when a falling threshold is crossed.  The\n                  eventEntry identified by a particular value of\n                  this index is the same as identified by the same value\n                  of the eventIndex object.  If there is no\n                  corresponding entry in the eventTable, then\n                  no association exists.  In particular, if this value\n                  is zero, no associated event will be generated, as\n                  zero is not a valid event index.\n\n                  This object may not be modified if the associated\n                  alarmStatus object is equal to valid(1).')
alarmOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 11), OwnerString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: alarmOwner.setDescription('The entity that configured this entry and is\n                  therefore using the resources assigned to it.')
alarmStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 3, 1, 1, 12), EntryStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: alarmStatus.setDescription('The status of this alarm entry.')
hostControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 4, 1), )
if mibBuilder.loadTexts: hostControlTable.setDescription('A list of host table control entries.')
hostControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 4, 1, 1), ).setIndexNames((0, "RFC1271-MIB", "hostControlIndex"))
if mibBuilder.loadTexts: hostControlEntry.setDescription('A list of parameters that set up the discovery of\n                  hosts on a particular interface and the collection\n                  of statistics about these hosts.')
hostControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostControlIndex.setDescription('An index that uniquely identifies an entry in the\n                  hostControl table.  Each such entry defines\n                  a function that discovers hosts on a particular\n                  interface and places statistics about them in the\n                  hostTable and the hostTimeTable on behalf of this\n                  hostControlEntry.')
hostControlDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 1, 1, 2), ObjectIdentifier()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hostControlDataSource.setDescription('This object identifies the source of the data for\n                  this instance of the host function.  This source\n                  can be any interface on this device.  In order\n                  to identify a particular interface, this object shall\n                  identify the instance of the ifIndex object, defined\n                  in [4,6], for the desired interface.  For example,\n                  if an entry were to receive data from interface #1,\n                  this object would be set to ifIndex.1.\n\n                  The statistics in this group reflect all packets\n                  on the local network segment attached to the\n                  identified interface.\n\n                  This object may not be modified if the associated\n                  hostControlStatus object is equal to valid(1).')
hostControlTableSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 1, 1, 3), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostControlTableSize.setDescription('The number of hostEntries in the hostTable and the\n                  hostTimeTable associated with this hostControlEntry.')
hostControlLastDeleteTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 1, 1, 4), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostControlLastDeleteTime.setDescription('The value of sysUpTime when the last entry\n                  was deleted from the portion of the hostTable\n                  associated with this hostControlEntry.  If no\n                  deletions have occurred, this value shall be zero.')
hostControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 1, 1, 5), OwnerString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hostControlOwner.setDescription('The entity that configured this entry and is\n                  therefore using the resources assigned to it.')
hostControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 1, 1, 6), EntryStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hostControlStatus.setDescription('The status of this hostControl entry.\n\n                  If this object is not equal to valid(1), all\n                  associated entries in the hostTable,\n                  hostTimeTable, and the hostTopNTable shall be\n                  deleted by the agent.')
hostTable = MibTable((1, 3, 6, 1, 2, 1, 16, 4, 2), )
if mibBuilder.loadTexts: hostTable.setDescription('A list of host entries.')
hostEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 4, 2, 1), ).setIndexNames((0, "RFC1271-MIB", "hostIndex"), (0, "RFC1271-MIB", "hostAddress"))
if mibBuilder.loadTexts: hostEntry.setDescription('A collection of statistics for a particular host\n                  that has been discovered on an interface of this\n                  device.')
hostAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 1), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostAddress.setDescription('The physical address of this host.')
hostCreationOrder = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostCreationOrder.setDescription("An index that defines the relative ordering of\n                  the creation time of hosts captured for a\n                  particular hostControlEntry.  This index shall\n                  be between 1 and N, where N is the value of\n                  the associated hostControlTableSize.  The ordering\n                  of the indexes is based on the order of each entry's\n                  insertion into the table, in which entries added\n                  earlier have a lower index value than entries added\n                  later.\n\n                  It is important to note that the order for a\n                  particular entry may change as an (earlier) entry\n                  is deleted from the table.  Because this order may\n                  change, management stations should make use of the\n                  hostControlLastDeleteTime variable in the\n                  hostControlEntry associated with the relevant\n                  portion of the hostTable.  By observing\n                  this variable, the management station may detect\n                  the circumstances where a previous association\n                  between a value of hostCreationOrder\n                  and a hostEntry may no longer hold.")
hostIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostIndex.setDescription('The set of collected host statistics of which\n                  this entry is a part.  The set of hosts\n                  identified by a particular value of this\n                  index is associated with the hostControlEntry\n                  as identified by the same value of hostControlIndex.')
hostInPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostInPkts.setDescription('The number of packets without errors transmitted to\n                  this address since it was added to the hostTable.')
hostOutPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostOutPkts.setDescription('The number of packets including errors transmitted\n                  by this address since it was added to the hostTable.')
hostInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostInOctets.setDescription('The number of octets transmitted to this address\n                  since it was added to the hostTable (excluding\n                  framing bits but including FCS octets), except for\n                  those octets in packets that contained errors.')
hostOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostOutOctets.setDescription('The number of octets transmitted by this address\n                  since it was added to the hostTable (excluding\n                  framing bits but including FCS octets), including\n                  those octets in packets that contained errors.')
hostOutErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostOutErrors.setDescription('The number of error packets transmitted by this\n                  address since this host was added to the hostTable.')
hostOutBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostOutBroadcastPkts.setDescription('The number of good packets transmitted by this\n                  address that were directed to the broadcast address\n                  since this host was added to the hostTable.')
hostOutMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 2, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostOutMulticastPkts.setDescription('The number of good packets transmitted by this\n                  address that were directed to a multicast address\n                  since this host was added to the hostTable.\n                  Note that this number does not include packets\n                  directed to the broadcast address.')
hostTimeTable = MibTable((1, 3, 6, 1, 2, 1, 16, 4, 3), )
if mibBuilder.loadTexts: hostTimeTable.setDescription('A list of time-ordered host table entries.')
hostTimeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 4, 3, 1), ).setIndexNames((0, "RFC1271-MIB", "hostTimeIndex"), (0, "RFC1271-MIB", "hostTimeCreationOrder"))
if mibBuilder.loadTexts: hostTimeEntry.setDescription('A collection of statistics for a particular host\n                  that has been discovered on an interface of this\n                  device.  This collection includes the relative\n                  ordering of the creation time of this object.')
hostTimeAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 1), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeAddress.setDescription('The physical address of this host.')
hostTimeCreationOrder = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeCreationOrder.setDescription("An index that uniquely identifies an entry in\n                  the hostTime table among those entries associated\n                  with the same hostControlEntry.  This index shall\n                  be between 1 and N, where N is the value of\n                  the associated hostControlTableSize.  The ordering\n                  of the indexes is based on the order of each entry's\n                  insertion into the table, in which entries added\n                  earlier have a lower index value than entries added\n                  later.  Thus the management station has the ability\n                  to learn of new entries added to this table without\n                  downloading the entire table.\n\n                  It is important to note that the index for a\n                  particular entry may change as an (earlier) entry\n                  is deleted from the table.  Because this order may\n                  change, management stations should make use of the\n                  hostControlLastDeleteTime variable in the\n                  hostControlEntry associated with the relevant\n                  portion of the hostTimeTable.  By observing\n                  this variable, the management station may detect\n                  the circumstances where a download of the table\n                  may have missed entries, and where a previous\n                  association between a value of hostTimeCreationOrder\n                  and a hostTimeEntry may no longer hold.")
hostTimeIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeIndex.setDescription('The set of collected host statistics of which\n                  this entry is a part.  The set of hosts\n                  identified by a particular value of this\n                  index is associated with the hostControlEntry\n                  as identified by the same value of hostControlIndex.')
hostTimeInPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeInPkts.setDescription('The number of packets without errors transmitted to\n                  this address since it was added to the hostTimeTable.')
hostTimeOutPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeOutPkts.setDescription('The number of packets including errors transmitted\n                  by this address since it was added to the\n                  hostTimeTable.')
hostTimeInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeInOctets.setDescription('The number of octets transmitted to this address\n                  since it was added to the hostTimeTable (excluding\n                  framing bits but including FCS octets), except for\n                  those octets in packets that contained errors.')
hostTimeOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeOutOctets.setDescription('The number of octets transmitted by this address since\n                  it was added to the hostTimeTable (excluding framing\n                  bits but including FCS octets), including those\n                  octets in packets that contained errors.')
hostTimeOutErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeOutErrors.setDescription('The number of error packets transmitted by this\n                  address since this host was added to the\n                  hostTimeTable.')
hostTimeOutBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeOutBroadcastPkts.setDescription('The number of good packets transmitted by this\n                  address that were directed to the broadcast address\n                  since this host was added to the hostTimeTable.')
hostTimeOutMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 4, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTimeOutMulticastPkts.setDescription('The number of good packets transmitted by this\n                  address that were directed to a multicast address\n                  since this host was added to the hostTimeTable.\n                  Note that this number does not include packets\n                  directed to the broadcast address.')
hostTopNControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 5, 1), )
if mibBuilder.loadTexts: hostTopNControlTable.setDescription('A list of top N host control entries.')
hostTopNControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 5, 1, 1), ).setIndexNames((0, "RFC1271-MIB", "hostTopNControlIndex"))
if mibBuilder.loadTexts: hostTopNControlEntry.setDescription('A set of parameters that control the creation of a\n                  report of the top N hosts according to several\n                  metrics.')
hostTopNControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNControlIndex.setDescription('An index that uniquely identifies an entry\n                  in the hostTopNControl table.  Each such\n                  entry defines one top N report prepared for\n                  one interface.')
hostTopNHostIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hostTopNHostIndex.setDescription('The host table for which a top N report will be\n                  prepared on behalf of this entry.  The host table\n                  identified by a particular value of this index is\n                  associated with the same host table as identified\n                  by the same value of hostIndex.\n\n                  This object may not be modified if the associated\n                  hostTopNStatus object is equal to valid(1).')
hostTopNRateBase = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7,))).clone(namedValues=NamedValues(("hostTopNInPkts", 1), ("hostTopNOutPkts", 2), ("hostTopNInOctets", 3), ("hostTopNOutOctets", 4), ("hostTopNOutErrors", 5), ("hostTopNOutBroadcastPkts", 6), ("hostTopNOutMulticastPkts", 7),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hostTopNRateBase.setDescription('The variable for each host that the hostTopNRate\n                  variable is based upon.\n\n                  This object may not be modified if the associated\n                  hostTopNStatus object is equal to valid(1).')
hostTopNTimeRemaining = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 4), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hostTopNTimeRemaining.setDescription('The number of seconds left in the report currently\n                  being collected.  When this object is modified by\n                  the management station, a new collection is started,\n                  possibly aborting a currently running report.  The\n                  new value is used as the requested duration of this\n                  report, which is loaded into the associated\n                  hostTopNDuration object.\n\n                  When this object is set to a non-zero value, any\n                  associated hostTopNEntries shall be made\n                  inaccessible by the monitor.  While the value of this\n                  object is non-zero, it decrements by one per second\n                  until it reaches zero.  During this time, all\n                  associated hostTopNEntries shall remain\n                  inaccessible.  At the time that this object\n                  decrements to zero, the report is made\n                  accessible in the hostTopNTable.  Thus, the hostTopN\n                  table needs to be created only at the end of the\n                  collection interval.')
hostTopNDuration = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNDuration.setDescription('The number of seconds that this report has collected\n                  during the last sampling interval, or if this\n                  report is currently being collected, the number\n                  of seconds that this report is being collected\n                  during this sampling interval.\n\n                  When the associated hostTopNTimeRemaining object is\n                  set, this object shall be set by the probe to the\n                  same value and shall not be modified until the next\n                  time the hostTopNTimeRemaining is set.\n\n                  This value shall be zero if no reports have been\n                  requested for this hostTopNControlEntry.')
hostTopNRequestedSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 6), Integer32().clone(10)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hostTopNRequestedSize.setDescription('The maximum number of hosts requested for the top N\n                  table.\n\n                  When this object is created or modified, the probe\n                  should set hostTopNGrantedSize as closely to this\n                  object as is possible for the particular probe\n                  implementation and available resources.')
hostTopNGrantedSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNGrantedSize.setDescription('The maximum number of hosts in the top N table.\n\n                  When the associated hostTopNRequestedSize object is\n                  created or modified, the probe should set this\n                  object as closely to the requested value as is\n                  possible for the particular implementation and\n                  available resources. The probe must not lower this\n                  value except as a result of a set to the associated\n                  hostTopNRequestedSize object.\n\n                  Hosts with the highest value of hostTopNRate shall be\n                  placed in this table in decreasing order of this rate\n                  until there is no more room or until there are no more\n                  hosts.')
hostTopNStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 8), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNStartTime.setDescription('The value of sysUpTime when this top N report was\n                  last started.  In other words, this is the time that\n                  the associated hostTopNTimeRemaining object was\n                  modified to start the requested report.')
hostTopNOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 9), OwnerString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hostTopNOwner.setDescription('The entity that configured this entry and is\n                  therefore using the resources assigned to it.')
hostTopNStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 1, 1, 10), EntryStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hostTopNStatus.setDescription('The status of this hostTopNControl entry.\n                  If this object is not equal to valid(1), all\n                  associated hostTopNEntries shall be deleted by\n                  the agent.')
hostTopNTable = MibTable((1, 3, 6, 1, 2, 1, 16, 5, 2), )
if mibBuilder.loadTexts: hostTopNTable.setDescription('A list of top N host entries.')
hostTopNEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 5, 2, 1), ).setIndexNames((0, "RFC1271-MIB", "hostTopNReport"), (0, "RFC1271-MIB", "hostTopNIndex"))
if mibBuilder.loadTexts: hostTopNEntry.setDescription('A set of statistics for a host that is part of a\n                  top N report.')
hostTopNReport = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNReport.setDescription('This object identifies the top N report of which\n                  this entry is a part.  The set of hosts\n                  identified by a particular value of this\n                  object is part of the same report as identified\n                  by the same value of the hostTopNControlIndex object.')
hostTopNIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNIndex.setDescription('An index that uniquely identifies an entry in\n                  the hostTopN table among those in the same report.\n                  This index is between 1 and N, where N is the\n                  number of entries in this table.  Increasing values\n                  of hostTopNIndex shall be assigned to entries with\n                  decreasing values of hostTopNRate until index N\n                  is assigned to the entry with the lowest value of\n                  hostTopNRate or there are no more hostTopNEntries.')
hostTopNAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 2, 1, 3), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNAddress.setDescription('The physical address of this host.')
hostTopNRate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 5, 2, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hostTopNRate.setDescription("The amount of change in the selected variable\n                  during this sampling interval.  The selected\n                  variable is this host's instance of the object\n                  selected by hostTopNRateBase.")
matrixControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 6, 1), )
if mibBuilder.loadTexts: matrixControlTable.setDescription('A list of information entries for the\n                  traffic matrix on each interface.')
matrixControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 6, 1, 1), ).setIndexNames((0, "RFC1271-MIB", "matrixControlIndex"))
if mibBuilder.loadTexts: matrixControlEntry.setDescription('Information about a traffic matrix on a\n                  particular interface.')
matrixControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixControlIndex.setDescription('An index that uniquely identifies an entry in the\n                  matrixControl table.  Each such entry defines\n                  a function that discovers conversations on a particular\n                  interface and places statistics about them in the\n                  matrixSDTable and the matrixDSTable on behalf of this\n                  matrixControlEntry.')
matrixControlDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 1, 1, 2), ObjectIdentifier()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: matrixControlDataSource.setDescription('This object identifies the source of\n                  the data from which this entry creates a traffic matrix.\n                  This source can be any interface on this device.  In\n                  order to identify a particular interface, this object\n                  shall identify the instance of the ifIndex object,\n                  defined in [4,6], for the desired interface.  For\n                  example, if an entry were to receive data from\n                  interface #1, this object would be set to ifIndex.1.\n\n                  The statistics in this group reflect all packets\n                  on the local network segment attached to the\n                  identified interface.\n\n                  This object may not be modified if the associated\n                  matrixControlStatus object is equal to valid(1).')
matrixControlTableSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 1, 1, 3), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixControlTableSize.setDescription('The number of matrixSDEntries in the matrixSDTable\n                  for this interface.  This must also be the value of\n                  the number of entries in the matrixDSTable for this\n                  interface.')
matrixControlLastDeleteTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 1, 1, 4), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixControlLastDeleteTime.setDescription('The value of sysUpTime when the last entry\n                  was deleted from the portion of the matrixSDTable\n                  or matrixDSTable associated with this\n                  matrixControlEntry.\n                  If no deletions have occurred, this value shall be\n                  zero.')
matrixControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 1, 1, 5), OwnerString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: matrixControlOwner.setDescription('The entity that configured this entry and is\n                  therefore using the resources assigned to it.')
matrixControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 1, 1, 6), EntryStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: matrixControlStatus.setDescription('The status of this matrixControl entry.\n\n                  If this object is not equal to valid(1), all\n                  associated entries in the matrixSDTable and the\n                  matrixDSTable shall be deleted by the agent.')
matrixSDTable = MibTable((1, 3, 6, 1, 2, 1, 16, 6, 2), )
if mibBuilder.loadTexts: matrixSDTable.setDescription('A list of traffic matrix entries indexed by\n                  source and destination MAC address.')
matrixSDEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 6, 2, 1), ).setIndexNames((0, "RFC1271-MIB", "matrixSDIndex"), (0, "RFC1271-MIB", "matrixSDSourceAddress"), (0, "RFC1271-MIB", "matrixSDDestAddress"))
if mibBuilder.loadTexts: matrixSDEntry.setDescription('A collection of statistics for communications between\n                  two addresses on a particular interface.')
matrixSDSourceAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 2, 1, 1), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixSDSourceAddress.setDescription('The source physical address.')
matrixSDDestAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 2, 1, 2), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixSDDestAddress.setDescription('The destination physical address.')
matrixSDIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 2, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixSDIndex.setDescription('The set of collected matrix statistics of which\n                  this entry is a part.  The set of matrix statistics\n                  identified by a particular value of this index\n                  is associated with the same matrixControlEntry\n                  as identified by the same value of matrixControlIndex.')
matrixSDPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixSDPkts.setDescription('The number of packets transmitted from the source\n                  address to the destination address (this number\n                  includes error packets).')
matrixSDOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixSDOctets.setDescription('The number of octets (excluding framing bits but\n                  including FCS octets) contained in all packets\n                  transmitted from the source address to the\n                  destination address.')
matrixSDErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixSDErrors.setDescription('The number of error packets transmitted from\n                  the source address to the destination address.')
matrixDSTable = MibTable((1, 3, 6, 1, 2, 1, 16, 6, 3), )
if mibBuilder.loadTexts: matrixDSTable.setDescription('A list of traffic matrix entries indexed by\n                  destination and source MAC address.')
matrixDSEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 6, 3, 1), ).setIndexNames((0, "RFC1271-MIB", "matrixDSIndex"), (0, "RFC1271-MIB", "matrixDSDestAddress"), (0, "RFC1271-MIB", "matrixDSSourceAddress"))
if mibBuilder.loadTexts: matrixDSEntry.setDescription('A collection of statistics for communications between\n                  two address on a particular interface.')
matrixDSSourceAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 3, 1, 1), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixDSSourceAddress.setDescription('The source physical address.')
matrixDSDestAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 3, 1, 2), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixDSDestAddress.setDescription('The destination physical address.')
matrixDSIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 3, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixDSIndex.setDescription('The set of collected matrix statistics of which\n                  this entry is a part.  The set of matrix statistics\n                  identified by a particular value of this index\n                  is associated with the same matrixControlEntry\n                  as identified by the same value of matrixControlIndex.')
matrixDSPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 3, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixDSPkts.setDescription('The number of packets transmitted from the source\n                  address to the destination address (this number\n                  includes error packets).')
matrixDSOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixDSOctets.setDescription('The number of octets (excluding framing bits\n                  but including FCS octets) contained in all packets\n                  transmitted from the source address to the\n                  destination address.')
matrixDSErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 6, 3, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: matrixDSErrors.setDescription('The number of error packets transmitted from\n                  the source address to the destination address.')
filterTable = MibTable((1, 3, 6, 1, 2, 1, 16, 7, 1), )
if mibBuilder.loadTexts: filterTable.setDescription('A list of packet filter entries.')
filterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 7, 1, 1), ).setIndexNames((0, "RFC1271-MIB", "filterIndex"))
if mibBuilder.loadTexts: filterEntry.setDescription('A set of parameters for a packet filter applied on a\n                  particular interface.')
filterIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: filterIndex.setDescription('An index that uniquely identifies an entry\n                  in the filter table.  Each such entry defines\n                  one filter that is to be applied to every packet\n                  received on an interface.')
filterChannelIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: filterChannelIndex.setDescription('This object identifies the channel of which this\n                  filter is a part.  The filters identified by a\n                  particular value of this object are associated\n                  with the same channel as identified by the same\n                  value of the channelIndex object.')
filterPktDataOffset = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 3), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: filterPktDataOffset.setDescription('The offset from the beginning of each packet where\n                  a match of packet data will be attempted.  This offset\n                  is measured from the point in the physical layer\n                  packet after the framing bits, if any.  For example,\n                  in an Ethernet frame, this point is at the beginning\n                  of the destination MAC address.\n\n                  This object may not be modified if the associated\n                  filterStatus object is equal to valid(1).')
filterPktData = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 4), OctetString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: filterPktData.setDescription('The data that is to be matched with the input packet.\n                  For each packet received, this filter and the\n                  accompanying filterPktDataMask and\n                  filterPktDataNotMask will be adjusted for the\n                  offset.  The only bits relevant to this\n                  match algorithm are those that have the corresponding\n                  filterPktDataMask bit equal to one.  The following\n                  three rules are then applied to every packet:\n\n                  (1) If the packet is too short and does not have data\n                      corresponding to part of the filterPktData, the\n                      packet will fail this data match.\n\n                  (2) For each relevant bit from the packet with the\n                      corresponding filterPktDataNotMask bit set to\n                      zero, if the bit from the packet is not equal to\n                      the corresponding bit from the filterPktData,\n                      then the packet will fail this data match.\n\n                  (3) If for every relevant bit from the packet with the\n                      corresponding filterPktDataNotMask bit set to one,\n                      the bit from the packet is equal to the\n                      corresponding bit from the filterPktData, then\n                      the packet will fail this data match.\n\n                  Any packets that have not failed any of the three\n                  matches above have passed this data match.\n\n                  This object may not be modified if the associated\n                  filterStatus object is equal to valid(1).')
filterPktDataMask = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 5), OctetString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: filterPktDataMask.setDescription("The mask that is applied to the match process.\n                  After adjusting this mask for the offset, only those\n                  bits in the received packet that correspond to bits\n                  set in this mask are relevant for further processing\n                  by the match algorithm.  The offset is applied to\n                  filterPktDataMask in the same way it is applied to\n                  the filter.  For the purposes of the matching\n                  algorithm, if the associated filterPktData object\n                  is longer than this mask, this mask is conceptually\n                  extended with '1' bits until it reaches the\n                  length of the filterPktData object.\n                  This object may not be modified if the associated\n                  filterStatus object is equal to valid(1).")
filterPktDataNotMask = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 6), OctetString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: filterPktDataNotMask.setDescription("The inversion mask that is applied to the match\n                  process.  After adjusting this mask for the offset,\n                  those relevant bits in the received packet that\n                  correspond to bits cleared in this mask must all\n                  be equal to their corresponding bits in the\n                  filterPktData object for the packet to be accepted.\n                  In addition, at least one of those relevant\n                  bits in the received packet that correspond to bits\n                  set in this mask must be different to its\n                  corresponding bit in the filterPktData object.\n\n                  For the purposes of the matching algorithm, if\n                  the associated filterPktData object is longer than\n                  this mask, this mask is conceptually extended with\n                  '0' bits until it reaches the length of the\n                  filterPktData object.\n\n                  This object may not be modified if the associated\n                  filterStatus object is equal to valid(1).")
filterPktStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 7), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: filterPktStatus.setDescription("The status that is to be matched with the input\n                  packet.  The only bits relevant to this match\n                  algorithm are those that have the corresponding\n                  filterPktStatusMask bit equal to one.\n\n                  The following two rules are then applied to every\n                  packet:\n\n                  (1) For each relevant bit from the packet status\n                      with the corresponding filterPktStatusNotMask\n                      bit set to zero, if the bit from the packet\n                      status is not equal to the corresponding bit\n                      from the filterPktStatus, then the packet will\n                      fail this status match.\n\n                  (2) If for every relevant bit from the packet status\n                      with the corresponding filterPktStatusNotMask\n                      bit set to one, the bit from the packet status\n                      is equal to the corresponding bit from the\n                      filterPktStatus, then the packet will fail\n                      this status match.\n\n                  Any packets that have not failed either of the two\n                  matches above have passed this status match.\n\n                  The value of the packet status is a sum.  This sum\n                  initially takes the value zero.  Then, for each\n                  error, E, that has been discovered in this packet,\n                  2 raised to a value representing E is added to the sum.\n                  The errors and the bits that represent them are\n                  dependent on the media type of the interface that\n                  this channel is receiving packets from.\n\n                  The errors defined for a packet captured off of an\n                  Ethernet interface are as follows:\n\n                      bit #    Error\n                          0    Packet is longer than 1518 octets\n                          1    Packet is shorter than 64 octets\n                          2    Packet experienced a CRC or Alignment\n                               error\n\n                  For example, an Ethernet fragment would have a\n                  value of 6 (2^1 + 2^2).\n\n                  As this MIB is expanded to new media types, this\n                  object will have other media-specific errors defined.\n\n                  For the purposes of this status matching algorithm, if\n                  the packet status is longer than this\n                  object, filterPktStatus this object is conceptually\n                  extended with '0' bits until it reaches the size of\n                  the packet status.\n\n                  This object may not be modified if the associated\n                  filterStatus object is equal to valid(1).")
filterPktStatusMask = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 8), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: filterPktStatusMask.setDescription("The mask that is applied to the status match process.\n                  Only those bits in the received packet that correspond\n                  to bits set in this mask are relevant for further\n                  processing by the status match algorithm.  For the\n                  purposes of the matching algorithm, if the\n                  associated filterPktStatus object is longer than\n                  this mask, this mask is conceptually extended with\n                  '1' bits until it reaches the size of the\n                  filterPktStatus.  In addition, if a packet status is\n                  longer than this mask, this mask is conceptually\n                  extended with '0' bits until it reaches the size of\n                  the packet status.\n\n                  This object may not be modified if the associated\n                  filterStatus object is equal to valid(1).")
filterPktStatusNotMask = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 9), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: filterPktStatusNotMask.setDescription("The inversion mask that is applied to the status match\n                  process.  Those relevant bits in the received packet\n                  status that correspond to bits cleared in this mask\n                  must all be equal to their corresponding bits in the\n                  filterPktStatus object for the packet to be accepted.\n                  In addition, at least one of those relevant bits in the\n                  received packet status that correspond to bits set in\n                  this mask must be different to its corresponding bit\n                  in the filterPktStatus object for the packet to be\n                  accepted.\n\n                  For the purposes of the matching algorithm, if the\n                  associated filterPktStatus object or a packet status\n                  is longer than this mask, this mask is conceptually\n                  extended with '0' bits until it reaches the longer of\n                  the lengths of the filterPktStatus object and the\n                  packet status.\n\n                  This object may not be modified if the associated\n                  filterStatus object is equal to valid(1).")
filterOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 10), OwnerString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: filterOwner.setDescription('The entity that configured this entry and is\n                  therefore using the resources assigned to it.')
filterStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 1, 1, 11), EntryStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: filterStatus.setDescription('The status of this filter entry.')
channelTable = MibTable((1, 3, 6, 1, 2, 1, 16, 7, 2), )
if mibBuilder.loadTexts: channelTable.setDescription('A list of packet channel entries.')
channelEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 7, 2, 1), ).setIndexNames((0, "RFC1271-MIB", "channelIndex"))
if mibBuilder.loadTexts: channelEntry.setDescription('A set of parameters for a packet channel applied on a\n                  particular interface.')
channelIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: channelIndex.setDescription('An index that uniquely identifies an entry\n                  in the channel table.  Each such\n                  entry defines one channel, a logical data\n                  and event stream.')
channelIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: channelIfIndex.setDescription('The value of this object uniquely identifies the\n                  interface on this remote network monitoring device\n                  to which the associated filters are applied to allow\n                  data into this channel.  The interface identified by\n                  a particular value of this object is the same\n                  interface as identified by the same value of the\n                  ifIndex object, defined in [4,6].  The filters in\n                  this group are applied to all packets on the local\n                  network segment attached to the identified\n                  interface.\n\n                  This object may not be modified if the associated\n                  channelStatus object is equal to valid(1).')
channelAcceptType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("acceptMatched", 1), ("acceptFailed", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: channelAcceptType.setDescription('This object controls the action of the filters\n                  associated with this channel.  If this object is equal\n                  to acceptMatched(1), packets will be accepted to this\n                  channel if they are accepted by both the packet data\n                  and packet status matches of an associated filter. If\n                  this object is equal to acceptFailed(2), packets will\n                  be accepted to this channel only if they fail either\n                  the packet data match or the packet status match of\n                  each of the associated filters.\n                  This object may not be modified if the associated\n                  channelStatus object is equal to valid(1).')
channelDataControl = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("on", 1), ("off", 2),)).clone('off')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: channelDataControl.setDescription('This object controls the flow of data through this\n                  channel.  If this object is on(1), data, status and\n                  events flow through this channel.  If this object is\n                  off(2), data, status and events will not flow through\n                  this channel.')
channelTurnOnEventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: channelTurnOnEventIndex.setDescription('The value of this object identifies the event\n                  that is configured to turn the associated\n                  channelDataControl from off to on when the event is\n                  generated.  The event identified by a particular value\n                  of this object is the same event as identified by the\n                  same value of the eventIndex object.  If there is no\n                  corresponding entry in the eventTable, then no\n                  association exists.  In fact, if no event is intended\n                  for this channel, channelTurnOnEventIndex must be\n                  set to zero, a non-existent event index.\n\n                  This object may not be modified if the associated\n                  channelStatus object is equal to valid(1).')
channelTurnOffEventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: channelTurnOffEventIndex.setDescription('The value of this object identifies the event\n                  that is configured to turn the associated\n                  channelDataControl from on to off when the event is\n                  generated.  The event identified by a particular value\n                  of this object is the same event as identified by the\n                  same value of the eventIndex object.  If there is no\n                  corresponding entry in the eventTable, then no\n                  association exists.  In fact, if no event is intended\n                  for this channel, channelTurnOffEventIndex must be\n                  set to zero, a non-existent event index.\n\n                  This object may not be modified if the associated\n                  channelStatus object is equal to valid(1).')
channelEventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: channelEventIndex.setDescription('The value of this object identifies the event\n                  that is configured to be generated when the\n                  associated channelDataControl is on and a packet\n                  is matched.  The event identified by a particular value\n                  of this object is the same event as identified by the\n                  same value of the eventIndex object.  If there is no\n                  corresponding entry in the eventTable, then no\n                  association exists.  In fact, if no event is intended\n                  for this channel, channelEventIndex must be\n                  set to zero, a non-existent event index.\n\n                  This object may not be modified if the associated\n                  channelStatus object is equal to valid(1).')
channelEventStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 8), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("eventReady", 1), ("eventFired", 2), ("eventAlwaysReady", 3),)).clone('eventReady')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: channelEventStatus.setDescription('The event status of this channel.\n\n                  If this channel is configured to generate events\n                  when packets are matched, a means of controlling\n                  the flow of those events is often needed.  When\n                  this object is equal to eventReady(1), a single\n                  event may be generated, after which this object\n                  will be set by the probe to eventFired(2).  While\n                  in the eventFired(2) state, no events will be\n                  generated until the object is modified to\n                  eventReady(1) (or eventAlwaysReady(3)).  The\n                  management station can thus easily respond to a\n                  notification of an event by re-enabling this object.\n\n                  If the management station wishes to disable this\n                  flow control and allow events to be generated\n                  at will, this object may be set to\n                  eventAlwaysReady(3).  Disabling the flow control\n                  is discouraged as it can result in high network\n                  traffic or other performance problems.')
channelMatches = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: channelMatches.setDescription('The number of times this channel has matched a packet.\n                  Note that this object is updated even when\n                  channelDataControl is set to off.')
channelDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 10), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,127))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: channelDescription.setDescription('A comment describing this channel.')
channelOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 11), OwnerString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: channelOwner.setDescription('The entity that configured this entry and is therefore\n                  using the resources assigned to it.')
channelStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 7, 2, 1, 12), EntryStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: channelStatus.setDescription('The status of this channel entry.')
bufferControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 8, 1), )
if mibBuilder.loadTexts: bufferControlTable.setDescription('A list of buffers control entries.')
bufferControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 8, 1, 1), ).setIndexNames((0, "RFC1271-MIB", "bufferControlIndex"))
if mibBuilder.loadTexts: bufferControlEntry.setDescription('A set of parameters that control the collection of\n                  a stream of packets that have matched filters.')
bufferControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bufferControlIndex.setDescription('An index that uniquely identifies an entry\n                  in the bufferControl table.  The value of this\n                  index shall never be zero.  Each such\n                  entry defines one set of packets that is\n                  captured and controlled by one or more filters.')
bufferControlChannelIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: bufferControlChannelIndex.setDescription('An index that identifies the channel that is the\n                  source of packets for this bufferControl table.\n                  The channel identified by a particular value of this\n                  index is the same as identified by the same value of\n                  the channelIndex object.\n\n                  This object may not be modified if the associated\n                  bufferControlStatus object is equal to valid(1).')
bufferControlFullStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("spaceAvailable", 1), ("full", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: bufferControlFullStatus.setDescription('This object shows whether the buffer has room to\n                  accept new packets or if it is full.\n\n                  If the status is spaceAvailable(1), the buffer is\n                  accepting new packets normally.  If the status is\n                  full(2) and the associated bufferControlFullAction\n                  object is wrapWhenFull, the buffer is accepting new\n                  packets by deleting enough of the oldest packets\n                  to make room for new ones as they arrive.  Otherwise,\n                  if the status is full(2) and the\n                  bufferControlFullAction object is lockWhenFull,\n                  then the buffer has stopped collecting packets.\n\n                  When this object is set to full(2) the probe must\n                  not later set it to spaceAvailable(1) except in the\n                  case of a significant gain in resources such as\n                  an increase of bufferControlOctetsGranted.  In\n                  particular, the wrap-mode action of deleting old\n                  packets to make room for newly arrived packets\n                  must not affect the value of this object.')
bufferControlFullAction = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("lockWhenFull", 1), ("wrapWhenFull", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: bufferControlFullAction.setDescription('Controls the action of the buffer when it\n                  reaches the full status.  When in the lockWhenFull(1)\n                  state a packet is added to the buffer that\n                  fills the buffer, the bufferControlFullStatus will\n                  be set to full(2) and this buffer will stop capturing\n                  packets.')
bufferControlCaptureSliceSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 5), Integer32().clone(100)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: bufferControlCaptureSliceSize.setDescription('The maximum number of octets of each packet\n                  that will be saved in this capture buffer.\n                  For example, if a 1500 octet packet is received by\n                  the probe and this object is set to 500, then only\n                  500 octets of the packet will be stored in the\n                  associated capture buffer.  If this variable is set\n                  to 0, the capture buffer will save as many octets\n                  as is possible.\n\n                  This object may not be modified if the associated\n                  bufferControlStatus object is equal to valid(1).')
bufferControlDownloadSliceSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 6), Integer32().clone(100)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: bufferControlDownloadSliceSize.setDescription('The maximum number of octets of each packet\n                  in this capture buffer that will be returned in\n                  an SNMP retrieval of that packet.  For example,\n                  if 500 octets of a packet have been stored in the\n                  associated capture buffer, the associated\n                  bufferControlDownloadOffset is 0, and this\n                  object is set to 100, then the captureBufferPacket\n                  object that contains the packet will contain only\n                  the first 100 octets of the packet.\n\n                  A prudent manager will take into account possible\n                  interoperability or fragmentation problems that may\n                  occur if the download slice size is set too large.\n                  In particular, conformant SNMP implementations are not\n                  required to accept messages whose length exceeds 484\n                  octets, although they are encouraged to support larger\n                  datagrams whenever feasible.')
bufferControlDownloadOffset = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 7), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: bufferControlDownloadOffset.setDescription('The offset of the first octet of each packet\n                  in this capture buffer that will be returned in\n                  an SNMP retrieval of that packet.  For example,\n                  if 500 octets of a packet have been stored in the\n                  associated capture buffer and this object is set to\n                  100, then the captureBufferPacket object that\n                  contains the packet will contain bytes starting\n                  100 octets into the packet.')
bufferControlMaxOctetsRequested = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 8), Integer32().clone(-1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: bufferControlMaxOctetsRequested.setDescription('The requested maximum number of octets to be\n                  saved in this captureBuffer, including any\n                  implementation-specific overhead. If this variable\n                  is set to -1, the capture buffer will save as many\n                  octets as is possible.\n\n                  When this object is created or modified, the probe\n                  should set bufferControlMaxOctetsGranted as closely\n                  to this object as is possible for the particular probe\n                  implementation and available resources.  However, if\n                  the object has the special value of -1, the probe\n                  must set bufferControlMaxOctetsGranted to -1.')
bufferControlMaxOctetsGranted = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 9), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bufferControlMaxOctetsGranted.setDescription('The maximum number of octets that can be\n                  saved in this captureBuffer, including overhead.\n                  If this variable is -1, the capture buffer will save\n                  as many octets as possible.\n\n                  When the bufferControlMaxOctetsRequested object is\n                  created or modified, the probe should set this object\n                  as closely to the requested value as is possible for\n                  the particular probe implementation and available\n                  resources.  However, if the request object has the\n                  special value of -1, the probe must set this object\n                  to -1.  The probe must not lower this value except\n                  as a result of a modification to the associated\n                  bufferControlMaxOctetsRequested object.\n\n                  When this maximum number of octets is reached\n                  and a new packet is to be added to this\n                  capture buffer and the corresponding\n                  bufferControlFullAction is set to wrapWhenFull(2),\n                  enough of the oldest packets associated with this\n                  capture buffer shall be deleted by the agent so\n                  that the new packet can be added.  If the\n                  corresponding bufferControlFullAction is set to\n                  lockWhenFull(1), the new packet shall be discarded.\n                  In either case, the probe must set\n                  bufferControlFullStatus to full(2).\n\n                  When the value of this object changes to a value less\n                  than the current value, entries are deleted from\n                  the captureBufferTable associated with this\n                  bufferControlEntry.  Enough of the\n                  oldest of these captureBufferEntries shall be\n                  deleted by the agent so that the number of octets\n                  used remains less than or equal to the new value of\n                  this object.\n\n                  When the value of this object changes to a value greater\n                  than the current value, the number of associated\n                  captureBufferEntries may be allowed to grow.')
bufferControlCapturedPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 10), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bufferControlCapturedPackets.setDescription('The number of packets currently in this captureBuffer.')
bufferControlTurnOnTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 11), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: bufferControlTurnOnTime.setDescription('The value of sysUpTime when this capture buffer was\n                  first turned on.')
bufferControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 12), OwnerString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: bufferControlOwner.setDescription('The entity that configured this entry and is therefore\n                  using the resources assigned to it.')
bufferControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 1, 1, 13), EntryStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: bufferControlStatus.setDescription('The status of this buffer Control Entry.')
captureBufferTable = MibTable((1, 3, 6, 1, 2, 1, 16, 8, 2), )
if mibBuilder.loadTexts: captureBufferTable.setDescription('A list of packets captured off of a channel.')
captureBufferEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 8, 2, 1), ).setIndexNames((0, "RFC1271-MIB", "captureBufferControlIndex"), (0, "RFC1271-MIB", "captureBufferIndex"))
if mibBuilder.loadTexts: captureBufferEntry.setDescription('A packet captured off of an attached network.')
captureBufferControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferControlIndex.setDescription('The index of the bufferControlEntry with which\n                  this packet is associated.')
captureBufferIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferIndex.setDescription('An index that uniquely identifies an entry\n                  in the captureBuffer table associated with a\n                  particular bufferControlEntry.  This index will\n                  start at 1 and increase by one for each new packet\n                  added with the same captureBufferControlIndex.')
captureBufferPacketID = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 3), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferPacketID.setDescription("An index that describes the order of packets\n                  that are received on a particular interface.\n                  The packetID of a packet captured on an\n                  interface is defined to be greater than the\n                  packetID's of all packets captured previously on\n                  the same interface.  As the captureBufferPacketID\n                  object has a maximum positive value of 2^31 - 1,\n                  any captureBufferPacketID object shall have the\n                  value of the associated packet's packetID mod 2^31.")
captureBufferPacketData = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 4), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferPacketData.setDescription('The data inside the packet, starting at the beginning\n                  of the packet plus any offset specified in the\n                  associated bufferControlDownloadOffset, including any\n                  link level headers.  The length of the data in this\n                  object is the minimum of the length of the captured\n                  packet minus the offset, the length of the associated\n                  bufferControlCaptureSliceSize minus the offset, and the\n                  associated bufferControlDownloadSliceSize.  If this\n                  minimum is less than zero, this object shall have a\n                  length of zero.')
captureBufferPacketLength = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferPacketLength.setDescription('The actual length (off the wire) of the packet stored\n                  in this entry, including FCS octets.')
captureBufferPacketTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferPacketTime.setDescription('The number of milliseconds that had passed since\n                  this capture buffer was first turned on when this\n                  packet was captured.')
captureBufferPacketStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 8, 2, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: captureBufferPacketStatus.setDescription('A value which indicates the error status of this\n                  packet.\n\n                  The value of this object is defined in the same way as\n                  filterPacketStatus.  The value is a sum.  This sum\n                  initially takes the value zero.  Then, for each\n                  error, E, that has been discovered in this packet,\n                  2 raised to a value representing E is added to the sum.\n\n                  The errors defined for a packet captured off of an\n                  Ethernet interface are as follows:\n\n                      bit #    Error\n                          0    Packet is longer than 1518 octets\n                          1    Packet is shorter than 64 octets\n                          2    Packet experienced a CRC or Alignment\n                               error\n                          3    First packet in this capture buffer after\n                               it was detected that some packets were\n                               not processed correctly.\n\n                  For example, an Ethernet fragment would have a\n                  value of 6 (2^1 + 2^2).\n\n                  As this MIB is expanded to new media types, this object\n                  will have other media-specific errors defined.')
eventTable = MibTable((1, 3, 6, 1, 2, 1, 16, 9, 1), )
if mibBuilder.loadTexts: eventTable.setDescription('A list of events to be generated.')
eventEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 9, 1, 1), ).setIndexNames((0, "RFC1271-MIB", "eventIndex"))
if mibBuilder.loadTexts: eventEntry.setDescription('A set of parameters that describe an event to be\n                  generated when certain conditions are met.')
eventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: eventIndex.setDescription('An index that uniquely identifies an entry in the\n                  event table.  Each such entry defines one event that\n                  is to be generated when the appropriate conditions\n                  occur.')
eventDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,127))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: eventDescription.setDescription('A comment describing this event entry.')
eventType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("none", 1), ("log", 2), ("snmp-trap", 3), ("log-and-trap", 4),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: eventType.setDescription('The type of notification that the probe will make\n                  about this event.  In the case of log, an entry is\n                  made in the log table for each event.  In the case of\n                  snmp-trap, an SNMP trap is sent to one or more\n                  management stations.')
eventCommunity = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,127))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: eventCommunity.setDescription('If an SNMP trap is to be sent, it will be sent to\n                  the SNMP community specified by this octet string.\n                  In the future this table will be extended to include\n                  the party security mechanism.  This object shall be\n                  set to a string of length zero if it is intended that\n                  that mechanism be used to specify the destination of\n                  the trap.')
eventLastTimeSent = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 5), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: eventLastTimeSent.setDescription('The value of sysUpTime at the time this event\n                  entry last generated an event.  If this entry has\n                  not generated any events, this value will be\n                  zero.')
eventOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 6), OwnerString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: eventOwner.setDescription("The entity that configured this entry and is therefore\n                  using the resources assigned to it.\n\n                  If this object contains a string starting with 'monitor'\n                  and has associated entries in the log table, all\n                  connected management stations should retrieve those\n                  log entries, as they may have significance to all\n                  management stations connected to this device")
eventStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 1, 1, 7), EntryStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: eventStatus.setDescription('The status of this event entry.\n\n                  If this object is not equal to valid(1), all associated\n                  log entries shall be deleted by the agent.')
logTable = MibTable((1, 3, 6, 1, 2, 1, 16, 9, 2), )
if mibBuilder.loadTexts: logTable.setDescription('A list of events that have been logged.')
logEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 9, 2, 1), ).setIndexNames((0, "RFC1271-MIB", "logEventIndex"), (0, "RFC1271-MIB", "logIndex"))
if mibBuilder.loadTexts: logEntry.setDescription('A set of data describing an event that has been\n                  logged.')
logEventIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: logEventIndex.setDescription('The event entry that generated this log\n                  entry.  The log identified by a particular\n                  value of this index is associated with the same\n                  eventEntry as identified by the same value\n                  of eventIndex.')
logIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 2, 1, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: logIndex.setDescription('An index that uniquely identifies an entry\n                  in the log table amongst those generated by the\n                  same eventEntries.  These indexes are\n                  assigned beginning with 1 and increase by one\n                  with each new log entry.  The association\n                  between values of logIndex and logEntries\n                  is fixed for the lifetime of each logEntry.\n                  The agent may choose to delete the oldest\n                  instances of logEntry as required because of\n                  lack of memory.  It is an implementation-specific\n                  matter as to when this deletion may occur.')
logTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 2, 1, 3), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: logTime.setDescription('The value of sysUpTime when this log entry was\n                  created.')
logDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 9, 2, 1, 4), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: logDescription.setDescription('An implementation dependent description of the\n                  event that activated this log entry.')
risingAlarm = NotificationType((1, 3, 6, 1, 2, 1, 16) + (0,1)).setObjects(*(("RFC1271-MIB", "alarmIndex"), ("RFC1271-MIB", "alarmVariable"), ("RFC1271-MIB", "alarmSampleType"), ("RFC1271-MIB", "alarmValue"), ("RFC1271-MIB", "alarmRisingThreshold"),))
if mibBuilder.loadTexts: risingAlarm.setDescription('The SNMP trap that is generated when an alarm\n                  entry crosses its rising threshold and generates\n                  an event that is configured for sending SNMP\n                  traps.')
fallingAlarm = NotificationType((1, 3, 6, 1, 2, 1, 16) + (0,2)).setObjects(*(("RFC1271-MIB", "alarmIndex"), ("RFC1271-MIB", "alarmVariable"), ("RFC1271-MIB", "alarmSampleType"), ("RFC1271-MIB", "alarmValue"), ("RFC1271-MIB", "alarmFallingThreshold"),))
if mibBuilder.loadTexts: fallingAlarm.setDescription('The SNMP trap that is generated when an alarm\n                  entry crosses its falling threshold and generates\n                  an event that is configured for sending SNMP\n                  traps.')
mibBuilder.exportSymbols("RFC1271-MIB", alarmFallingThreshold=alarmFallingThreshold, hostTopNEntry=hostTopNEntry, alarmSampleType=alarmSampleType, hostTopNGrantedSize=hostTopNGrantedSize, rmon=rmon, hostTopN=hostTopN, hostEntry=hostEntry, filterPktData=filterPktData, etherHistoryBroadcastPkts=etherHistoryBroadcastPkts, bufferControlIndex=bufferControlIndex, etherHistoryDropEvents=etherHistoryDropEvents, etherStatsPkts128to255Octets=etherStatsPkts128to255Octets, channelStatus=channelStatus, historyControlStatus=historyControlStatus, eventIndex=eventIndex, channelMatches=channelMatches, hostTopNAddress=hostTopNAddress, etherHistoryCRCAlignErrors=etherHistoryCRCAlignErrors, channelEntry=channelEntry, hostTimeInPkts=hostTimeInPkts, bufferControlOwner=bufferControlOwner, hostTopNStartTime=hostTopNStartTime, etherStatsBroadcastPkts=etherStatsBroadcastPkts, bufferControlDownloadSliceSize=bufferControlDownloadSliceSize, matrix=matrix, etherHistoryTable=etherHistoryTable, historyControlBucketsRequested=historyControlBucketsRequested, alarmOwner=alarmOwner, matrixControlTableSize=matrixControlTableSize, etherStatsEntry=etherStatsEntry, etherStatsJabbers=etherStatsJabbers, hostTopNTable=hostTopNTable, hostControlIndex=hostControlIndex, logIndex=logIndex, captureBufferControlIndex=captureBufferControlIndex, fallingAlarm=fallingAlarm, hostControlEntry=hostControlEntry, EntryStatus=EntryStatus, etherStatsCRCAlignErrors=etherStatsCRCAlignErrors, matrixSDIndex=matrixSDIndex, hostTimeOutPkts=hostTimeOutPkts, captureBufferPacketLength=captureBufferPacketLength, hostOutBroadcastPkts=hostOutBroadcastPkts, etherHistoryCollisions=etherHistoryCollisions, hostTopNIndex=hostTopNIndex, hostTopNReport=hostTopNReport, hostCreationOrder=hostCreationOrder, hostControlOwner=hostControlOwner, channelDataControl=channelDataControl, historyControlDataSource=historyControlDataSource, hostTopNHostIndex=hostTopNHostIndex, filterTable=filterTable, logDescription=logDescription, matrixControlOwner=matrixControlOwner, alarmTable=alarmTable, etherHistoryOctets=etherHistoryOctets, hostTopNRequestedSize=hostTopNRequestedSize, hostTimeAddress=hostTimeAddress, captureBufferPacketID=captureBufferPacketID, matrixSDPkts=matrixSDPkts, matrixDSSourceAddress=matrixDSSourceAddress, bufferControlDownloadOffset=bufferControlDownloadOffset, bufferControlTurnOnTime=bufferControlTurnOnTime, capture=capture, channelTable=channelTable, hostTimeCreationOrder=hostTimeCreationOrder, hostTimeOutErrors=hostTimeOutErrors, OwnerString=OwnerString, hostTimeIndex=hostTimeIndex, channelIndex=channelIndex, etherHistoryUtilization=etherHistoryUtilization, alarmValue=alarmValue, matrixControlIndex=matrixControlIndex, eventDescription=eventDescription, bufferControlCapturedPackets=bufferControlCapturedPackets, filterPktStatus=filterPktStatus, filterStatus=filterStatus, hostTopNDuration=hostTopNDuration, filterChannelIndex=filterChannelIndex, filterPktDataOffset=filterPktDataOffset, channelAcceptType=channelAcceptType, etherHistoryIndex=etherHistoryIndex, channelDescription=channelDescription, hostControlStatus=hostControlStatus, etherStatsOversizePkts=etherStatsOversizePkts, captureBufferEntry=captureBufferEntry, historyControlIndex=historyControlIndex, matrixSDTable=matrixSDTable, hostTimeOutBroadcastPkts=hostTimeOutBroadcastPkts, etherStatsMulticastPkts=etherStatsMulticastPkts, alarmIndex=alarmIndex, matrixSDEntry=matrixSDEntry, matrixDSOctets=matrixDSOctets, alarmFallingEventIndex=alarmFallingEventIndex, alarmEntry=alarmEntry, etherStatsPkts65to127Octets=etherStatsPkts65to127Octets, captureBufferPacketTime=captureBufferPacketTime, eventCommunity=eventCommunity, filterPktDataNotMask=filterPktDataNotMask, eventStatus=eventStatus, hostInPkts=hostInPkts, etherStatsPkts64Octets=etherStatsPkts64Octets, alarmStartupAlarm=alarmStartupAlarm, hostTopNControlIndex=hostTopNControlIndex, matrixControlTable=matrixControlTable, hostControlTable=hostControlTable, etherStatsDataSource=etherStatsDataSource, filterPktStatusMask=filterPktStatusMask, hostIndex=hostIndex, alarmRisingEventIndex=alarmRisingEventIndex, bufferControlTable=bufferControlTable, channelTurnOffEventIndex=channelTurnOffEventIndex, filterEntry=filterEntry, hostAddress=hostAddress, risingAlarm=risingAlarm, historyControlOwner=historyControlOwner, etherHistoryOversizePkts=etherHistoryOversizePkts, alarm=alarm, hostInOctets=hostInOctets, etherHistoryFragments=etherHistoryFragments, hostOutMulticastPkts=hostOutMulticastPkts, eventType=eventType, etherStatsDropEvents=etherStatsDropEvents, hostTimeOutOctets=hostTimeOutOctets, matrixSDSourceAddress=matrixSDSourceAddress, etherHistorySampleIndex=etherHistorySampleIndex, etherStatsUndersizePkts=etherStatsUndersizePkts, filterIndex=filterIndex, hostOutPkts=hostOutPkts, etherHistoryMulticastPkts=etherHistoryMulticastPkts, hostOutErrors=hostOutErrors, eventEntry=eventEntry, logEntry=logEntry, etherStatsPkts1024to1518Octets=etherStatsPkts1024to1518Octets, channelEventStatus=channelEventStatus, filterOwner=filterOwner, alarmInterval=alarmInterval, bufferControlFullStatus=bufferControlFullStatus, bufferControlStatus=bufferControlStatus, historyControlEntry=historyControlEntry, bufferControlEntry=bufferControlEntry, matrixControlDataSource=matrixControlDataSource, etherStatsPkts=etherStatsPkts, matrixSDDestAddress=matrixSDDestAddress, matrixDSEntry=matrixDSEntry, filterPktStatusNotMask=filterPktStatusNotMask, etherStatsOwner=etherStatsOwner, etherStatsCollisions=etherStatsCollisions, hostTopNOwner=hostTopNOwner, hostTopNStatus=hostTopNStatus, hostTopNTimeRemaining=hostTopNTimeRemaining, alarmRisingThreshold=alarmRisingThreshold, matrixControlStatus=matrixControlStatus, hostTopNRateBase=hostTopNRateBase, matrixDSErrors=matrixDSErrors, bufferControlCaptureSliceSize=bufferControlCaptureSliceSize, matrixControlEntry=matrixControlEntry, etherHistoryJabbers=etherHistoryJabbers, hostTopNRate=hostTopNRate, matrixDSDestAddress=matrixDSDestAddress, channelIfIndex=channelIfIndex, hostTopNControlTable=hostTopNControlTable, etherHistoryPkts=etherHistoryPkts, filterPktDataMask=filterPktDataMask, etherStatsTable=etherStatsTable, bufferControlMaxOctetsRequested=bufferControlMaxOctetsRequested, hostTopNControlEntry=hostTopNControlEntry, etherStatsFragments=etherStatsFragments, etherStatsStatus=etherStatsStatus, captureBufferTable=captureBufferTable, hosts=hosts, statistics=statistics, matrixDSTable=matrixDSTable, captureBufferPacketData=captureBufferPacketData, filter=filter, historyControlBucketsGranted=historyControlBucketsGranted, eventLastTimeSent=eventLastTimeSent, channelEventIndex=channelEventIndex, matrixDSPkts=matrixDSPkts, alarmStatus=alarmStatus, event=event, logTime=logTime, channelOwner=channelOwner, hostTable=hostTable, hostControlDataSource=hostControlDataSource, etherStatsOctets=etherStatsOctets, hostTimeOutMulticastPkts=hostTimeOutMulticastPkts, matrixSDOctets=matrixSDOctets, channelTurnOnEventIndex=channelTurnOnEventIndex, hostTimeInOctets=hostTimeInOctets, captureBufferPacketStatus=captureBufferPacketStatus, etherHistoryIntervalStart=etherHistoryIntervalStart, etherStatsPkts512to1023Octets=etherStatsPkts512to1023Octets, hostTimeEntry=hostTimeEntry, historyControlInterval=historyControlInterval, etherStatsIndex=etherStatsIndex, captureBufferIndex=captureBufferIndex, eventTable=eventTable, bufferControlChannelIndex=bufferControlChannelIndex, history=history, alarmVariable=alarmVariable, etherHistoryEntry=etherHistoryEntry, hostControlLastDeleteTime=hostControlLastDeleteTime, hostTimeTable=hostTimeTable, etherStatsPkts256to511Octets=etherStatsPkts256to511Octets, eventOwner=eventOwner, bufferControlFullAction=bufferControlFullAction, hostControlTableSize=hostControlTableSize, logEventIndex=logEventIndex, etherHistoryUndersizePkts=etherHistoryUndersizePkts, bufferControlMaxOctetsGranted=bufferControlMaxOctetsGranted, hostOutOctets=hostOutOctets, historyControlTable=historyControlTable, matrixControlLastDeleteTime=matrixControlLastDeleteTime, logTable=logTable, matrixDSIndex=matrixDSIndex, matrixSDErrors=matrixSDErrors)
