#
# PySNMP MIB module Finisher-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/Finisher-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:12:48 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( ObjectIdentifier, Integer, OctetString, ) = mibBuilder.importSymbols("ASN1", "ObjectIdentifier", "Integer", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsUnion, ValueRangeConstraint, SingleValueConstraint, ValueSizeConstraint, ConstraintsIntersection, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "ValueRangeConstraint", "SingleValueConstraint", "ValueSizeConstraint", "ConstraintsIntersection")
( hrDeviceIndex, ) = mibBuilder.importSymbols("HOST-RESOURCES-MIB", "hrDeviceIndex")
( PrtMarkerSuppliesSupplyUnitTC, PrtMediaUnitTC, prtMIBConformance, PrtInputTypeTC, PresentOnOff, printmib, PrtCapacityUnitTC, PrtMarkerSuppliesTypeTC, PrtMarkerSuppliesClassTC, PrtSubUnitStatusTC, ) = mibBuilder.importSymbols("Printer-MIB", "PrtMarkerSuppliesSupplyUnitTC", "PrtMediaUnitTC", "prtMIBConformance", "PrtInputTypeTC", "PresentOnOff", "printmib", "PrtCapacityUnitTC", "PrtMarkerSuppliesTypeTC", "PrtMarkerSuppliesClassTC", "PrtSubUnitStatusTC")
( NotificationGroup, ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ModuleCompliance", "ObjectGroup")
( Bits, ModuleIdentity, Counter32, IpAddress, Unsigned32, MibIdentifier, ObjectIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, iso, mib_2, experimental, NotificationType, Counter64, TimeTicks, Gauge32, Integer32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "ModuleIdentity", "Counter32", "IpAddress", "Unsigned32", "MibIdentifier", "ObjectIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "iso", "mib-2", "experimental", "NotificationType", "Counter64", "TimeTicks", "Gauge32", "Integer32")
( TextualConvention, DisplayString, ) = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention", "DisplayString")
finisherMIB = ModuleIdentity((1, 3, 6, 1, 3, 64))
if mibBuilder.loadTexts: finisherMIB.setLastUpdated('9810090000Z')
if mibBuilder.loadTexts: finisherMIB.setOrganization('IETF Printer MIB Working Group')
if mibBuilder.loadTexts: finisherMIB.setContactInfo("Ron Bergman\n         Dataproducts Corp.\n         1757 Tapo Canyon Road\n         Simi Valley, CA 91063-3394\n         rbergma@dpc.com\n\n        Send comments to the printmib WG using the Finisher MIB\n        Project (FIN) Mailing List:  fin@pwg.org\n\n        For further information, access the PWG web page under 'FIN':\n              http://www.pwg.org/\n\n        Implementers of this specification are encouraged to join the\n        fin mailing list in order to participate in discussions on any\n        clarifications needed and registration proposals being reviewed\n        in order to achieve consensus.")
if mibBuilder.loadTexts: finisherMIB.setDescription('The MIB module for management of printer finisher units.\n         The Finisher MIB is an extension of the Printer MIB.')
class FinDeviceTypeTC(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17,))
    namedValues = NamedValues(("other", 1), ("unknown", 2), ("stitcher", 3), ("folder", 4), ("binder", 5), ("trimmer", 6), ("dieCutter", 7), ("puncher", 8), ("perforater", 9), ("slitter", 10), ("separationCutter", 11), ("imprinter", 12), ("wrapper", 13), ("bander", 14), ("makeEnvelope", 15), ("stacker", 16), ("sheetRotator", 17),)

class FinAttributeTypeTC(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 30, 31, 40, 50, 80, 81, 82, 83, 100, 130, 160, 161, 162,))
    namedValues = NamedValues(("other", 1), ("deviceName", 3), ("deviceVendorName", 4), ("deviceModel", 5), ("deviceVersion", 6), ("deviceSerialNumber", 7), ("maximumSheets", 8), ("finProcessOffsetUnits", 9), ("finReferenceEdge", 10), ("finAxisOffset", 11), ("finJogEdge", 12), ("finHeadLocation", 13), ("finOperationRestrictions", 14), ("finNumberOfPositions", 15), ("namedConfiguration", 16), ("finMediaTypeRestriction", 17), ("finPrinterInputTraySupported", 18), ("finPreviousFinishingOperation", 19), ("finNextFinishingOperation", 20), ("stitchingType", 30), ("stitchingDirection", 31), ("foldingType", 40), ("bindingType", 50), ("punchHoleType", 80), ("punchHoleSizeLongDim", 81), ("punchHoleSizeShortDim", 82), ("punchPattern", 83), ("slittingType", 100), ("wrappingType", 130), ("stackOutputType", 160), ("stackOffset", 161), ("stackRotation", 162),)

class FinEdgeTC(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(3, 4, 5, 6,))
    namedValues = NamedValues(("topEdge", 3), ("bottomEdge", 4), ("leftEdge", 5), ("rightEdge", 6),)

class FinStitchingTypeTC(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 4, 5, 6, 7, 8, 9, 10,))
    namedValues = NamedValues(("other", 1), ("unknown", 2), ("stapleTopLeft", 4), ("stapleBottomLeft", 5), ("stapleTopRight", 6), ("stapleBottomRight", 7), ("saddleStitch", 8), ("edgeStitch", 9), ("stapleDual", 10),)

class StitchingDirTypeTC(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(2, 3, 4,))
    namedValues = NamedValues(("unknown", 2), ("topDown", 3), ("bottomUp", 4),)

class StitchingAngleTypeTC(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(2, 3, 4, 5,))
    namedValues = NamedValues(("unknown", 2), ("horizontal", 3), ("vertical", 4), ("slanted", 5),)

class FinFoldingTypeTC(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))
    namedValues = NamedValues(("other", 1), ("unknown", 2), ("zFold", 3), ("halfFold", 4), ("letterFold", 5),)

class FinBindingTypeTC(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 4, 5, 6, 7, 8, 9, 10, 11,))
    namedValues = NamedValues(("other", 1), ("unknown", 2), ("tape", 4), ("plastic", 5), ("velo", 6), ("perfect", 7), ("spiral", 8), ("adhesive", 9), ("comb", 10), ("padding", 11),)

class FinPunchHoleTypeTC(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7,))
    namedValues = NamedValues(("other", 1), ("unknown", 2), ("round", 3), ("oblong", 4), ("square", 5), ("rectangular", 6), ("star", 7),)

class FinPunchPatternTC(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,))
    namedValues = NamedValues(("other", 1), ("unknown", 2), ("twoHoleUSTop", 4), ("threeHoleUS", 5), ("twoHoleDIN", 6), ("fourHoleDIN", 7), ("twentyTwoHoleUS", 8), ("nineteenHoleUS", 9), ("twoHoleMetric", 10), ("swedish4Hole", 11), ("twoHoleUSSide", 12), ("fiveHoleUS", 13), ("sevenHoleUS", 14), ("mixed7H4S", 15), ("norweg6Hole", 16), ("metric26Hole", 17), ("metric30Hole", 18),)

class FinSlittingTypeTC(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 4, 5,))
    namedValues = NamedValues(("other", 1), ("unknown", 2), ("slitAndSeparate", 4), ("slitAndMerge", 5),)

class FinWrappingTypeTC(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 4, 5,))
    namedValues = NamedValues(("other", 1), ("unknown", 2), ("shrinkWrap", 4), ("paperWrap", 5),)

class FinStackOutputTypeTC(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 4, 5, 6,))
    namedValues = NamedValues(("other", 1), ("unknown", 2), ("straight", 4), ("offset", 5), ("crissCross", 6),)

finDevice = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 30))
finDeviceTable = MibTable((1, 3, 6, 1, 2, 1, 43, 30, 1), )
if mibBuilder.loadTexts: finDeviceTable.setDescription('This table defines the finishing device subunits,\n       including information regarding possible configuration\n       options and the status for each finisher device subunit.')
finDeviceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 30, 1, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Finisher-MIB", "finDeviceIndex"))
if mibBuilder.loadTexts: finDeviceEntry.setDescription('There is an entry in the finishing device table for each\n       possible finisher process.')
finDeviceIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 30, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535)))
if mibBuilder.loadTexts: finDeviceIndex.setDescription('A unique value used to identify a finisher process.\n       Although these values may change due to a major\n       reconfiguration of the printer system (e.g. the addition\n       of new finishing processes), the values are normally\n       expected to remain stable across successive power cycles.')
finDeviceType = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 30, 1, 1, 2), FinDeviceTypeTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: finDeviceType.setDescription('Defines the type of finishing process associated with this\n       table row entry.')
finDevicePresentOnOff = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 30, 1, 1, 3), PresentOnOff().clone('notPresent')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: finDevicePresentOnOff.setDescription('Indicates if this finishing device subunit is available\n       and whether the device subunit is enabled.')
finDeviceCapacityUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 30, 1, 1, 4), PrtCapacityUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: finDeviceCapacityUnit.setDescription('The unit of measure for specifying the capacity of this\n       finisher device subunit.')
finDeviceMaxCapacity = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 30, 1, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2,2147483647)).clone(-2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: finDeviceMaxCapacity.setDescription('The maximum capacity of this finisher device subunit in\n       finDeviceCapacityUnits.  If the device can reliably sense\n       this value, the value is sensed by the finisher device\n       and is read-only: otherwise the value may be written by a\n       management or control console application.  The value (-1)\n       means other and specifically indicates that the device\n       places no restrictions on this parameter.  The value (-2)\n       means unknown.')
finDeviceCurrentCapacity = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 30, 1, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2,2147483647)).clone(-2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: finDeviceCurrentCapacity.setDescription('The current capacity of this finisher device subunit in\n       finDeviceCapacityUnits.  If the device can reliably sense\n       this value, the value is sensed by the finisher and is\n       read-only: otherwise the value may be written by a\n       management or control console application.  The value (-1)\n       means other and specifically indicates that the device\n       places no restrictions on this parameter.  The value (-2)\n       means unknown.')
finDeviceAssociatedMediaPaths = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 30, 1, 1, 7), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: finDeviceAssociatedMediaPaths.setDescription('Indicates the media paths which can supply media for this\n       finisher device.  The value of this object is a bit map in an\n       octet string with each position representing the value of a\n       prtMediaPathIndex.  For a media path that can be a source\n       for this finisher device subunit, the bit position equal\n       to one less than the value of prtMediaPathIndex will be set.\n       The bits are numbered starting with the most significant bit of\n       the first byte being bit 0, the least significant bit of the\n       first byte being bit 7, the most significant of the second byte\n       being bit 8, and so on.')
finDeviceAssociatedOutputs = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 30, 1, 1, 8), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: finDeviceAssociatedOutputs.setDescription('Indicates the printer output subunits this finisher device\n       subunit services.  The value of this object is a bit map in an\n       octet string with each position representing the value of a\n       prtOutputIndex.  For an output subunit that is serviced\n       by this finisher device subunit, the bit position equal to\n       to one less than the value of prtOutputIndex will be set.\n       The bits are numbered starting with the most significant bit of\n       the first byte being bit 0, the least significant bit of the\n       first byte being bit 7, the most significant of the second byte\n       being bit 8, and so on.')
finDeviceStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 30, 1, 1, 9), PrtSubUnitStatusTC().clone(5)).setMaxAccess("readonly")
if mibBuilder.loadTexts: finDeviceStatus.setDescription('Indicates the current status of this finisher device\n       subunit.')
finDeviceDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 30, 1, 1, 10), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: finDeviceDescription.setDescription('A free form text description of this device subunit in the\n       localization specified by prtGeneralCurrentLocalization.')
finSupply = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 31))
finSupplyTable = MibTable((1, 3, 6, 1, 2, 1, 43, 31, 1), )
if mibBuilder.loadTexts: finSupplyTable.setDescription('Each unique source of supply is an entry in the finisher\n       supply table. Each supply entry has its own\n       characteristics associated with it such as colorant and\n       current supply level.')
finSupplyEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 31, 1, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Finisher-MIB", "finSupplyIndex"))
if mibBuilder.loadTexts: finSupplyEntry.setDescription('A list of finisher devices, with their associated\n       supplies and supplies characteristics.')
finSupplyIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 31, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535)))
if mibBuilder.loadTexts: finSupplyIndex.setDescription('A unique value used by a finisher to identify this supply\n       container/receptacle.  Although these values may change\n       due to a major reconfiguration of the finisher (e.g. the\n       addition of new supply sources to the finisher), values\n       are normally expected to remain stable across successive\n       power cycles.')
finSupplyDeviceIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 31, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: finSupplyDeviceIndex.setDescription('The value of finDeviceIndex corresponding to the finishing\n       device subunit with which this finisher supply is associated.')
finSupplyClass = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 31, 1, 1, 3), PrtMarkerSuppliesClassTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: finSupplyClass.setDescription('This value indicates whether this supply entity\n       represents a supply that is consumed or a container that\n       is filled.')
finSupplyType = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 31, 1, 1, 4), PrtMarkerSuppliesTypeTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: finSupplyType.setDescription('The type of this supply.')
finSupplyDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 31, 1, 1, 5), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: finSupplyDescription.setDescription('The description of this supply/receptacle in text useful\n       for operators and management applications and in the\n       localization specified by prtGeneralCurrentLocalization.')
finSupplyUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 31, 1, 1, 6), PrtMarkerSuppliesSupplyUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: finSupplyUnit.setDescription('Unit of measure of this finisher supply container or\n       receptacle.')
finSupplyMaxCapacity = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 31, 1, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2,2147483647)).clone(-2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: finSupplyMaxCapacity.setDescription('The maximum capacity of this supply container/receptacle\n       expressed in Supply Units.  If this supply container/\n       receptacle can reliably sense this value, the value is\n       sensed  and is read-only; otherwise the value may be\n       written by a control panel or management application.  The\n       value (-1) means other and places no restrictions on this\n       parameter.  The value (-2) means unknown.')
finSupplyCurrentLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 31, 1, 1, 8), Integer32().clone(-2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: finSupplyCurrentLevel.setDescription('The current level if this supply is a container; the\n       remaining space if this supply is a receptacle. If this\n       supply container/receptacle can reliably sense this value,\n       the value is sensed  and is read-only; otherwise the value\n       may be written by a control panel or management\n       application.  The value (-1) means other and places no\n       restrictions on this parameter. The value (-2) means\n       unknown.  A value of (-3) means that the printer knows there\n       is some supply or remaining space.')
finSupplyColorName = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 31, 1, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: finSupplyColorName.setDescription('The name of the color of this colorant using standardized\n       string names from ISO 10175 (DPA) and ISO 10180 (SPDL)\n       which are: other, unknown, white, red, green, blue, cyan,\n       magenta, yellow and black.  Implementors may add\n       additional string values.  The naming conventions in ISO\n       9070 are recommended in order to avoid potential name\n       clashes.')
finSupplyMediaInput = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 32))
finSupplyMediaInputTable = MibTable((1, 3, 6, 1, 2, 1, 43, 32, 1), )
if mibBuilder.loadTexts: finSupplyMediaInputTable.setDescription('The input subunits associated with a finisher supply media\n       are each represented by an entry in this table.')
finSupplyMediaInputEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 32, 1, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Finisher-MIB", "finSupplyMediaInputIndex"))
if mibBuilder.loadTexts: finSupplyMediaInputEntry.setDescription('A list of finisher supply media input subunit features and\n       characteristics.')
finSupplyMediaInputIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 32, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535)))
if mibBuilder.loadTexts: finSupplyMediaInputIndex.setDescription('A unique value used by a finisher to identify this supply\n       media input subunit.  Although these values may change\n       due to a major reconfiguration of the finisher (e.g. the\n       addition of new supply media input sources to the\n       finisher), values are normally expected to remain stable\n       across successive power cycles.')
finSupplyMediaInputDeviceIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 32, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: finSupplyMediaInputDeviceIndex.setDescription('The value of finDeviceIndex corresponding to the finishing\n       device subunit with which this finisher media supply is\n       associated.')
finSupplyMediaInputSupplyIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 32, 1, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: finSupplyMediaInputSupplyIndex.setDescription('The value of finSupplyIndex corresponding to the finishing\n       supply subunit with which this finisher media supply is\n       associated.')
finSupplyMediaInputType = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 32, 1, 1, 4), PrtInputTypeTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: finSupplyMediaInputType.setDescription('The type of technology (discriminated primarily according\n       to the feeder mechanism type) employed by the input\n       subunit.')
finSupplyMediaInputDimUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 32, 1, 1, 5), PrtMediaUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: finSupplyMediaInputDimUnit.setDescription('The unit of measure for specifying dimensional values for\n       this input device.')
finSupplyMediaInputMediaDimFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 32, 1, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2,2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: finSupplyMediaInputMediaDimFeedDir.setDescription('This object provides the value of the dimension in the\n       feed direction of the media that is placed or will be\n       placed in this input device.  Feed dimension measurements\n       are taken parallel to the feed direction of the device and\n       measured in finSupplyMediaInputDimUnits.  If this input\n       device can reliably sense this value, the value is sensed\n       and is read-only access. Otherwise the value is read-write\n       access and may be written by management or control panel\n       applications. The value (-1) means other and specifically\n       indicates that this device places no restrictions on this\n       parameter. The value (-2) indicates unknown. ')
finSupplyMediaInputMediaDimXFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 32, 1, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2,2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: finSupplyMediaInputMediaDimXFeedDir.setDescription('This object provides the value of the dimension across the\n       feed direction of the media that is placed or will be\n       placed in this input device.  The cross feed direction is\n       ninety degrees relative to the feed direction on this\n       device and measured in finSupplyMediaInputDimUnits.  If\n       this input device can reliably sense this value, the value\n       is sensed and is read-only access. Otherwise the value is\n       read-write access and may be written by management or\n       control panel applications. The value (-1) means other and\n       specifically indicates that this device places no\n       restrictions on this parameter. The value (-2) indicates\n       unknown. ')
finSupplyMediaInputStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 32, 1, 1, 8), PrtSubUnitStatusTC().clone(5)).setMaxAccess("readonly")
if mibBuilder.loadTexts: finSupplyMediaInputStatus.setDescription('This value indicates the current status of this input\n       device.')
finSupplyMediaInputMediaName = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 32, 1, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: finSupplyMediaInputMediaName.setDescription('The name of the current media contained in this input\n       device. Examples are Engineering Manual Cover, Section A Tab\n       Divider or any ISO standard names.')
finSupplyMediaInputName = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 32, 1, 1, 10), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: finSupplyMediaInputName.setDescription('The name assigned to this input subunit.')
finSupplyMediaInputDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 32, 1, 1, 11), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: finSupplyMediaInputDescription.setDescription('A free form text description of this input subunit in the\n       localization specified by prtGeneralCurrentLocalization.')
finSupplyMediaInputSecurity = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 32, 1, 1, 12), PresentOnOff()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: finSupplyMediaInputSecurity.setDescription('Indicates if this subunit has some security associated\n       with it.')
finSupplyMediaInputMediaWeight = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 32, 1, 1, 13), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: finSupplyMediaInputMediaWeight.setDescription('The weight of the media associated with this Input device\n       in grams per meter squared.  The value (-1) means other\n       and specifically indicates that the device places no\n       restriction on this parameter.  The value (-2) means\n       unknown.  This object can be used to calculate the weight\n       of individual pages processed by the document finisher.\n       This value, when multiplied by the number of pages in a\n       finished set, can be used to calculate the weight of a set\n       before it is inserted into a mailing envelope.')
finSupplyMediaInputMediaThickness = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 32, 1, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2,2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: finSupplyMediaInputMediaThickness.setDescription('This object identifies the thickness of the input media\n       processed by this document input subunit measured in\n       micrometers.  This value may be used by devices (or\n       operators) to set up proper machine tolerances for the\n       feeder operation.  The value (-2) indicates that the media\n       thickness is unknown or not used in the setup for this\n       input subunit.')
finSupplyMediaInputMediaType = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 32, 1, 1, 15), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: finSupplyMediaInputMediaType.setDescription('The name of the type of medium associated with this input\n       subunit.  Valid values are standardized strings from ISO 10175\n       (DPA) and ISO 10180 (SPDL) which are: stationary, transparency,\n       envelope, envelope-plain, envelope window, continuous-long,\n       continuous-short, tab-stock, labels, multi-layer.')
finDeviceAttribute = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 33))
finDeviceAttributeTable = MibTable((1, 3, 6, 1, 2, 1, 43, 33, 1), )
if mibBuilder.loadTexts: finDeviceAttributeTable.setDescription('The attribute table defines special parameters that are\n       applicable only to a minority of the finisher devices.\n       An attribute table entry is used, rather than unique\n       objects, to minimize the number of MIB objects and to\n       allow for expansion without the addition of MIB objects.\n       Each finisher device is represented by a separate row\n       in the device subunit attribute table.')
finDeviceAttributeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 33, 1, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Finisher-MIB", "finDeviceIndex"), (0, "Finisher-MIB", "finDeviceAttributeTypeIndex"), (0, "Finisher-MIB", "finDeviceAttributeInstanceIndex"))
if mibBuilder.loadTexts: finDeviceAttributeEntry.setDescription('Each entry defines a finisher function parameter that\n       cannot be represented by an object in the finisher\n       device subunit table.')
finDeviceAttributeTypeIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 33, 1, 1, 1), FinAttributeTypeTC())
if mibBuilder.loadTexts: finDeviceAttributeTypeIndex.setDescription('Defines the attribute type represented by this row.')
finDeviceAttributeInstanceIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 33, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535)))
if mibBuilder.loadTexts: finDeviceAttributeInstanceIndex.setDescription('An index that allows the discrimination of an attribute\n       instance when the same attribute occurs multiple times for\n       a specific instance of a finisher function.  The value of\n       this index shall be 1 if only a single instance of the\n       attribute occurs for the specific finisher function.')
finDeviceAttributeValueAsInteger = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 33, 1, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2,2147483647)).clone(-2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: finDeviceAttributeValueAsInteger.setDescription("Defines the integer value of the attribute.  The value of\n       the attribute is represented as an integer if the\n       finAttributeTypeTC description for the attribute has the\n       tag 'INTEGER:'.\n\n       Depending upon the attribute enum definition, this object\n       may be either an integer, a counter, an index, or an enum.\n       Attributes for which the concept of an integer value is\n       not meaningful SHALL return a value of -1 for this\n       attribute.")
finDeviceAttributeValueAsOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 33, 1, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,63)).clone(hexValue="")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: finDeviceAttributeValueAsOctets.setDescription("Contains the octet string value of the attribute.  The\n       value of the attribute is represented as a string if the\n       finAttributeTypeTC description for the attribute has the\n       tag 'OCTETS:'.\n\n       Depending upon the attribute enum definition, this object\n       may be either a coded character set string (text) or a\n       binary octet string.  Attributes for which the concept of\n       an octet string value is not meaningful SHALL contain a\n       zero length string.")
finMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 43, 2, 3)).setObjects(*(("Finisher-MIB", "finDeviceGroup"), ("Finisher-MIB", "finSupplyGroup"), ("Finisher-MIB", "finDeviceAttributeGroup"),))
if mibBuilder.loadTexts: finMIBCompliance.setDescription('The compliance statement for agents that implement the\n        finisher MIB.')
finMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 2, 4))
finDeviceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 4, 1)).setObjects(*(("Finisher-MIB", "finDeviceType"), ("Finisher-MIB", "finDevicePresentOnOff"), ("Finisher-MIB", "finDeviceCapacityUnit"), ("Finisher-MIB", "finDeviceMaxCapacity"), ("Finisher-MIB", "finDeviceCurrentCapacity"), ("Finisher-MIB", "finDeviceAssociatedMediaPaths"), ("Finisher-MIB", "finDeviceAssociatedOutputs"), ("Finisher-MIB", "finDeviceStatus"), ("Finisher-MIB", "finDeviceDescription"),))
if mibBuilder.loadTexts: finDeviceGroup.setDescription('The finisher device group.')
finSupplyGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 4, 2)).setObjects(*(("Finisher-MIB", "finSupplyDeviceIndex"), ("Finisher-MIB", "finSupplyClass"), ("Finisher-MIB", "finSupplyType"), ("Finisher-MIB", "finSupplyDescription"), ("Finisher-MIB", "finSupplyUnit"), ("Finisher-MIB", "finSupplyMaxCapacity"), ("Finisher-MIB", "finSupplyCurrentLevel"), ("Finisher-MIB", "finSupplyColorName"),))
if mibBuilder.loadTexts: finSupplyGroup.setDescription('The finisher supply group.')
finSupplyMediaInputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 4, 3)).setObjects(*(("Finisher-MIB", "finSupplyMediaInputDeviceIndex"), ("Finisher-MIB", "finSupplyMediaInputSupplyIndex"), ("Finisher-MIB", "finSupplyMediaInputType"), ("Finisher-MIB", "finSupplyMediaInputDimUnit"), ("Finisher-MIB", "finSupplyMediaInputMediaDimFeedDir"), ("Finisher-MIB", "finSupplyMediaInputMediaDimXFeedDir"), ("Finisher-MIB", "finSupplyMediaInputStatus"), ("Finisher-MIB", "finSupplyMediaInputMediaName"), ("Finisher-MIB", "finSupplyMediaInputName"), ("Finisher-MIB", "finSupplyMediaInputDescription"), ("Finisher-MIB", "finSupplyMediaInputSecurity"), ("Finisher-MIB", "finSupplyMediaInputMediaWeight"), ("Finisher-MIB", "finSupplyMediaInputMediaThickness"), ("Finisher-MIB", "finSupplyMediaInputMediaType"),))
if mibBuilder.loadTexts: finSupplyMediaInputGroup.setDescription('The finisher supply, media input group.')
finDeviceAttributeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 4, 4)).setObjects(*(("Finisher-MIB", "finDeviceAttributeValueAsInteger"), ("Finisher-MIB", "finDeviceAttributeValueAsOctets"),))
if mibBuilder.loadTexts: finDeviceAttributeGroup.setDescription('The finisher device attribute group.')
mibBuilder.exportSymbols("Finisher-MIB", finDeviceMaxCapacity=finDeviceMaxCapacity, finSupplyTable=finSupplyTable, finSupplyMediaInputIndex=finSupplyMediaInputIndex, finSupplyMediaInputMediaName=finSupplyMediaInputMediaName, finDevice=finDevice, finSupplyIndex=finSupplyIndex, finSupplyDescription=finSupplyDescription, FinStackOutputTypeTC=FinStackOutputTypeTC, FinBindingTypeTC=FinBindingTypeTC, finisherMIB=finisherMIB, finSupplyMediaInputDimUnit=finSupplyMediaInputDimUnit, finSupplyMediaInputSecurity=finSupplyMediaInputSecurity, finSupplyMaxCapacity=finSupplyMaxCapacity, finDeviceEntry=finDeviceEntry, FinEdgeTC=FinEdgeTC, FinFoldingTypeTC=FinFoldingTypeTC, finDeviceIndex=finDeviceIndex, FinAttributeTypeTC=FinAttributeTypeTC, finDeviceAttributeEntry=finDeviceAttributeEntry, finDeviceAttributeValueAsOctets=finDeviceAttributeValueAsOctets, finSupplyMediaInputMediaType=finSupplyMediaInputMediaType, FinPunchHoleTypeTC=FinPunchHoleTypeTC, finMIBCompliance=finMIBCompliance, finDeviceAttributeInstanceIndex=finDeviceAttributeInstanceIndex, FinPunchPatternTC=FinPunchPatternTC, FinStitchingTypeTC=FinStitchingTypeTC, finSupplyMediaInputDescription=finSupplyMediaInputDescription, finSupplyUnit=finSupplyUnit, finSupplyMediaInputName=finSupplyMediaInputName, finDeviceTable=finDeviceTable, finSupplyMediaInputEntry=finSupplyMediaInputEntry, finSupplyMediaInputMediaWeight=finSupplyMediaInputMediaWeight, StitchingDirTypeTC=StitchingDirTypeTC, finSupplyMediaInputSupplyIndex=finSupplyMediaInputSupplyIndex, finSupplyEntry=finSupplyEntry, FinDeviceTypeTC=FinDeviceTypeTC, finSupplyCurrentLevel=finSupplyCurrentLevel, finDeviceDescription=finDeviceDescription, finDeviceStatus=finDeviceStatus, finSupplyType=finSupplyType, finSupplyMediaInputTable=finSupplyMediaInputTable, finSupplyMediaInputMediaDimXFeedDir=finSupplyMediaInputMediaDimXFeedDir, finDeviceCurrentCapacity=finDeviceCurrentCapacity, PYSNMP_MODULE_ID=finisherMIB, StitchingAngleTypeTC=StitchingAngleTypeTC, finSupplyDeviceIndex=finSupplyDeviceIndex, finDeviceAssociatedOutputs=finDeviceAssociatedOutputs, finSupplyClass=finSupplyClass, finDeviceAttributeValueAsInteger=finDeviceAttributeValueAsInteger, finMIBGroups=finMIBGroups, finSupplyMediaInputGroup=finSupplyMediaInputGroup, finDevicePresentOnOff=finDevicePresentOnOff, finSupply=finSupply, finDeviceCapacityUnit=finDeviceCapacityUnit, finDeviceGroup=finDeviceGroup, finSupplyGroup=finSupplyGroup, finDeviceAttributeTypeIndex=finDeviceAttributeTypeIndex, finDeviceAttributeGroup=finDeviceAttributeGroup, finSupplyMediaInputMediaDimFeedDir=finSupplyMediaInputMediaDimFeedDir, FinWrappingTypeTC=FinWrappingTypeTC, finSupplyColorName=finSupplyColorName, finDeviceAttributeTable=finDeviceAttributeTable, finSupplyMediaInput=finSupplyMediaInput, finSupplyMediaInputMediaThickness=finSupplyMediaInputMediaThickness, finSupplyMediaInputStatus=finSupplyMediaInputStatus, finSupplyMediaInputType=finSupplyMediaInputType, finDeviceType=finDeviceType, finSupplyMediaInputDeviceIndex=finSupplyMediaInputDeviceIndex, finDeviceAssociatedMediaPaths=finDeviceAssociatedMediaPaths, finDeviceAttribute=finDeviceAttribute, FinSlittingTypeTC=FinSlittingTypeTC)
