/*
 * Decompiled with CFR 0.152.
 */
package ork.plugins;

import cqure.repeng.ReportObject;
import cqure.repeng.ReportTree;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import ork.CommonValuesDB;
import ork.Logger;
import ork.OracleDBConnection;
import ork.SIDList;
import ork.ScannerConfig;
import ork.ServerResult;
import ork.plugins.PluginHelper;
import ork.plugins.PluginIface;

public class CheckOracleVersion
implements PluginIface {
    private CommonValuesDB m_oDB;
    private OracleDBConnection m_oOraDBConn;
    private ServerResult m_oRes = null;
    private Logger m_oLogger = new Logger();
    private String m_sServer = null;
    private int m_nPort = -1;
    private SIDList m_oSIDList = null;
    private PluginHelper m_oPlugHelp;
    private ScannerConfig m_oConfig = null;
    private ReportTree m_oTree = null;

    public void setCommonValuesDB(CommonValuesDB oDB) {
        this.m_oDB = oDB;
    }

    public void setServerResult(ServerResult oRes) {
        this.m_oRes = oRes;
    }

    public void setLogger(Logger oLogger) {
        this.m_oLogger = oLogger;
    }

    public void setParameters(Object o) {
    }

    public void setConfig(ScannerConfig o) {
        this.m_oConfig = o;
    }

    public void setReportTree(ReportTree o) {
        this.m_oTree = o;
    }

    public CheckOracleVersion(ServerResult oRes) {
        this.m_oRes = oRes;
        this.m_nPort = this.m_oRes.getPort();
        this.m_sServer = this.m_oRes.getServer();
        this.m_oPlugHelp = new PluginHelper(oRes);
    }

    public int scan() {
        Connection oConn = null;
        String sSQL = "SELECT * FROM v$version";
        Statement oStmt = null;
        ResultSet oRs = null;
        String sVersion = "";
        oConn = this.m_oPlugHelp.getAnyConnection();
        if (oConn == null) {
            return -1;
        }
        this.m_oLogger.log("[-] Querying database for version information");
        try {
            oStmt = oConn.createStatement();
            oRs = oStmt.executeQuery(sSQL);
            while (oRs != null && oRs.next()) {
                sVersion = String.valueOf(sVersion) + oRs.getString("banner") + "\n";
            }
            if (oRs != null) {
                oRs.close();
            }
            if (oStmt != null) {
                oStmt.close();
            }
            oConn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
        ReportObject oRo = this.m_oTree.findReportItem(this.m_sServer);
        if (oRo != null) {
            oRo.addProperty("Version", sVersion);
        }
        return 0;
    }
}

