import { ContextualKeyword } from "./keywords";
import { TokenType } from "./types";
export declare enum IdentifierRole {
    Access = 0,
    ExportAccess = 1,
    TopLevelDeclaration = 2,
    FunctionScopedDeclaration = 3,
    BlockScopedDeclaration = 4,
    ObjectShorthandTopLevelDeclaration = 5,
    ObjectShorthandFunctionScopedDeclaration = 6,
    ObjectShorthandBlockScopedDeclaration = 7,
    ObjectShorthand = 8,
    ImportDeclaration = 9,
    ObjectKey = 10,
    ImportAccess = 11
}
export declare function isDeclaration(token: Token): boolean;
export declare function isNonTopLevelDeclaration(token: Token): boolean;
export declare function isTopLevelDeclaration(token: Token): boolean;
export declare function isBlockScopedDeclaration(token: Token): boolean;
export declare function isFunctionScopedDeclaration(token: Token): boolean;
export declare function isObjectShorthandDeclaration(token: Token): boolean;
export declare class Token {
    constructor();
    type: TokenType;
    contextualKeyword: ContextualKeyword;
    start: number;
    end: number;
    scopeDepth: number;
    isType: boolean;
    identifierRole: IdentifierRole | null;
    shadowsGlobal: boolean;
    isAsyncOperation: boolean;
    contextId: number | null;
    rhsEndIndex: number | null;
    isExpression: boolean;
    numNullishCoalesceStarts: number;
    numNullishCoalesceEnds: number;
    isOptionalChainStart: boolean;
    isOptionalChainEnd: boolean;
    subscriptStartIndex: number | null;
    nullishStartIndex: number | null;
}
export declare function next(): void;
export declare function nextTemplateToken(): void;
export declare function retokenizeSlashAsRegex(): void;
export declare function pushTypeContext(existingTokensInType: number): boolean;
export declare function popTypeContext(oldIsType: boolean): void;
export declare function eat(type: TokenType): boolean;
export declare function match(type: TokenType): boolean;
export declare function lookaheadType(): TokenType;
export declare class TypeAndKeyword {
    type: TokenType;
    contextualKeyword: ContextualKeyword;
    constructor(type: TokenType, contextualKeyword: ContextualKeyword);
}
export declare function lookaheadTypeAndKeyword(): TypeAndKeyword;
export declare function nextToken(): void;
export declare function skipLineComment(startSkip: number): void;
export declare function skipSpace(): void;
export declare function finishToken(type: TokenType, contextualKeyword?: ContextualKeyword): void;
export declare function getTokenFromCode(code: number): void;
export declare function skipWord(): void;
