/* !!! THIS FILE WAS AUTO-GENERATED BY `npm run gen` !!! */
import { Type, Omit } from "../types";
import * as K from "./kinds";

export namespace namedTypes {
  export interface Printable {
    loc?: K.SourceLocationKind | null;
  }

  export interface SourceLocation {
    start: K.PositionKind;
    end: K.PositionKind;
    source?: string | null;
  }

  export interface Node extends Printable {
    type: string;
    comments?: K.CommentKind[] | null;
  }

  export interface Comment extends Printable {
    value: string;
    leading?: boolean;
    trailing?: boolean;
  }

  export interface Position {
    line: number;
    column: number;
  }

  export interface File extends Omit<Node, "type"> {
    type: "File";
    program: K.ProgramKind;
    name?: string | null;
  }

  export interface Program extends Omit<Node, "type"> {
    type: "Program";
    body: K.StatementKind[];
    directives?: K.DirectiveKind[];
    interpreter?: K.InterpreterDirectiveKind | null;
  }

  export interface Statement extends Node {}

  export interface Function extends Node {
    id?: K.IdentifierKind | null;
    params: K.PatternKind[];
    body: K.BlockStatementKind;
    generator?: boolean;
    async?: boolean;
    expression?: boolean;
    defaults?: (K.ExpressionKind | null)[];
    rest?: K.IdentifierKind | null;
    returnType?: K.TypeAnnotationKind | K.TSTypeAnnotationKind | null;
    typeParameters?: K.TypeParameterDeclarationKind | K.TSTypeParameterDeclarationKind | null;
    predicate?: K.FlowPredicateKind | null;
  }

  export interface Expression extends Node {}
  export interface Pattern extends Node {}

  export interface Identifier extends Omit<Expression, "type">, Omit<Pattern, "type"> {
    type: "Identifier";
    name: string;
    optional?: boolean;
    typeAnnotation?: K.TypeAnnotationKind | K.TSTypeAnnotationKind | null;
  }

  export interface BlockStatement extends Omit<Statement, "type"> {
    type: "BlockStatement";
    body: K.StatementKind[];
    directives?: K.DirectiveKind[];
  }

  export interface EmptyStatement extends Omit<Statement, "type"> {
    type: "EmptyStatement";
  }

  export interface ExpressionStatement extends Omit<Statement, "type"> {
    type: "ExpressionStatement";
    expression: K.ExpressionKind;
  }

  export interface IfStatement extends Omit<Statement, "type"> {
    type: "IfStatement";
    test: K.ExpressionKind;
    consequent: K.StatementKind;
    alternate?: K.StatementKind | null;
  }

  export interface LabeledStatement extends Omit<Statement, "type"> {
    type: "LabeledStatement";
    label: K.IdentifierKind;
    body: K.StatementKind;
  }

  export interface BreakStatement extends Omit<Statement, "type"> {
    type: "BreakStatement";
    label?: K.IdentifierKind | null;
  }

  export interface ContinueStatement extends Omit<Statement, "type"> {
    type: "ContinueStatement";
    label?: K.IdentifierKind | null;
  }

  export interface WithStatement extends Omit<Statement, "type"> {
    type: "WithStatement";
    object: K.ExpressionKind;
    body: K.StatementKind;
  }

  export interface SwitchStatement extends Omit<Statement, "type"> {
    type: "SwitchStatement";
    discriminant: K.ExpressionKind;
    cases: K.SwitchCaseKind[];
    lexical?: boolean;
  }

  export interface SwitchCase extends Omit<Node, "type"> {
    type: "SwitchCase";
    test: K.ExpressionKind | null;
    consequent: K.StatementKind[];
  }

  export interface ReturnStatement extends Omit<Statement, "type"> {
    type: "ReturnStatement";
    argument: K.ExpressionKind | null;
  }

  export interface ThrowStatement extends Omit<Statement, "type"> {
    type: "ThrowStatement";
    argument: K.ExpressionKind;
  }

  export interface TryStatement extends Omit<Statement, "type"> {
    type: "TryStatement";
    block: K.BlockStatementKind;
    handler?: K.CatchClauseKind | null;
    handlers?: K.CatchClauseKind[];
    guardedHandlers?: K.CatchClauseKind[];
    finalizer?: K.BlockStatementKind | null;
  }

  export interface CatchClause extends Omit<Node, "type"> {
    type: "CatchClause";
    param?: K.PatternKind | null;
    guard?: K.ExpressionKind | null;
    body: K.BlockStatementKind;
  }

  export interface WhileStatement extends Omit<Statement, "type"> {
    type: "WhileStatement";
    test: K.ExpressionKind;
    body: K.StatementKind;
  }

  export interface DoWhileStatement extends Omit<Statement, "type"> {
    type: "DoWhileStatement";
    body: K.StatementKind;
    test: K.ExpressionKind;
  }

  export interface ForStatement extends Omit<Statement, "type"> {
    type: "ForStatement";
    init: K.VariableDeclarationKind | K.ExpressionKind | null;
    test: K.ExpressionKind | null;
    update: K.ExpressionKind | null;
    body: K.StatementKind;
  }

  export interface Declaration extends Statement {}

  export interface VariableDeclaration extends Omit<Declaration, "type"> {
    type: "VariableDeclaration";
    kind: "var" | "let" | "const";
    declarations: (K.VariableDeclaratorKind | K.IdentifierKind)[];
  }

  export interface ForInStatement extends Omit<Statement, "type"> {
    type: "ForInStatement";
    left: K.VariableDeclarationKind | K.ExpressionKind;
    right: K.ExpressionKind;
    body: K.StatementKind;
  }

  export interface DebuggerStatement extends Omit<Statement, "type"> {
    type: "DebuggerStatement";
  }

  export interface FunctionDeclaration extends Omit<Function, "type" | "id">, Omit<Declaration, "type"> {
    type: "FunctionDeclaration";
    id: K.IdentifierKind | null;
  }

  export interface FunctionExpression extends Omit<Function, "type">, Omit<Expression, "type"> {
    type: "FunctionExpression";
  }

  export interface VariableDeclarator extends Omit<Node, "type"> {
    type: "VariableDeclarator";
    id: K.PatternKind;
    init?: K.ExpressionKind | null;
  }

  export interface ThisExpression extends Omit<Expression, "type"> {
    type: "ThisExpression";
  }

  export interface ArrayExpression extends Omit<Expression, "type"> {
    type: "ArrayExpression";
    elements: (K.ExpressionKind | K.SpreadElementKind | K.RestElementKind | null)[];
  }

  export interface ObjectExpression extends Omit<Expression, "type"> {
    type: "ObjectExpression";
    properties: (K.PropertyKind | K.ObjectMethodKind | K.ObjectPropertyKind | K.SpreadPropertyKind | K.SpreadElementKind)[];
  }

  export interface Property extends Omit<Node, "type"> {
    type: "Property";
    kind: "init" | "get" | "set";
    key: K.LiteralKind | K.IdentifierKind | K.ExpressionKind;
    value: K.ExpressionKind | K.PatternKind;
    method?: boolean;
    shorthand?: boolean;
    computed?: boolean;
    decorators?: K.DecoratorKind[] | null;
  }

  export interface Literal extends Omit<Expression, "type"> {
    type: "Literal";
    value: string | boolean | null | number | RegExp | BigInt;
  }

  export interface SequenceExpression extends Omit<Expression, "type"> {
    type: "SequenceExpression";
    expressions: K.ExpressionKind[];
  }

  export interface UnaryExpression extends Omit<Expression, "type"> {
    type: "UnaryExpression";
    operator: "-" | "+" | "!" | "~" | "typeof" | "void" | "delete";
    argument: K.ExpressionKind;
    prefix?: boolean;
  }

  export interface BinaryExpression extends Omit<Expression, "type"> {
    type: "BinaryExpression";
    operator: "==" | "!=" | "===" | "!==" | "<" | "<=" | ">" | ">=" | "<<" | ">>" | ">>>" | "+" | "-" | "*" | "/" | "%" | "&" | "|" | "^" | "in" | "instanceof" | "**";
    left: K.ExpressionKind;
    right: K.ExpressionKind;
  }

  export interface AssignmentExpression extends Omit<Expression, "type"> {
    type: "AssignmentExpression";
    operator: "=" | "+=" | "-=" | "*=" | "/=" | "%=" | "<<=" | ">>=" | ">>>=" | "|=" | "^=" | "&=" | "**=" | "||=" | "&&=" | "??=";
    left: K.PatternKind | K.MemberExpressionKind;
    right: K.ExpressionKind;
  }

  export interface ChainElement extends Node {
    optional?: boolean;
  }

  export interface MemberExpression extends Omit<Expression, "type">, Omit<ChainElement, "type"> {
    type: "MemberExpression";
    object: K.ExpressionKind;
    property: K.IdentifierKind | K.ExpressionKind;
    computed?: boolean;
  }

  export interface UpdateExpression extends Omit<Expression, "type"> {
    type: "UpdateExpression";
    operator: "++" | "--";
    argument: K.ExpressionKind;
    prefix: boolean;
  }

  export interface LogicalExpression extends Omit<Expression, "type"> {
    type: "LogicalExpression";
    operator: "||" | "&&" | "??";
    left: K.ExpressionKind;
    right: K.ExpressionKind;
  }

  export interface ConditionalExpression extends Omit<Expression, "type"> {
    type: "ConditionalExpression";
    test: K.ExpressionKind;
    consequent: K.ExpressionKind;
    alternate: K.ExpressionKind;
  }

  export interface NewExpression extends Omit<Expression, "type"> {
    type: "NewExpression";
    callee: K.ExpressionKind;
    arguments: (K.ExpressionKind | K.SpreadElementKind)[];
    typeArguments?: null | K.TypeParameterInstantiationKind;
  }

  export interface CallExpression extends Omit<Expression, "type">, Omit<ChainElement, "type"> {
    type: "CallExpression";
    callee: K.ExpressionKind;
    arguments: (K.ExpressionKind | K.SpreadElementKind)[];
    typeArguments?: null | K.TypeParameterInstantiationKind;
  }

  export interface RestElement extends Omit<Pattern, "type"> {
    type: "RestElement";
    argument: K.PatternKind;
    typeAnnotation?: K.TypeAnnotationKind | K.TSTypeAnnotationKind | null;
  }

  export interface TypeAnnotation extends Omit<Node, "type"> {
    type: "TypeAnnotation";
    typeAnnotation: K.FlowTypeKind;
  }

  export interface TSTypeAnnotation extends Omit<Node, "type"> {
    type: "TSTypeAnnotation";
    typeAnnotation: K.TSTypeKind | K.TSTypeAnnotationKind;
  }

  export interface SpreadElementPattern extends Omit<Pattern, "type"> {
    type: "SpreadElementPattern";
    argument: K.PatternKind;
  }

  export interface ArrowFunctionExpression extends Omit<Function, "type" | "id" | "body" | "generator">, Omit<Expression, "type"> {
    type: "ArrowFunctionExpression";
    id?: null;
    body: K.BlockStatementKind | K.ExpressionKind;
    generator?: false;
  }

  export interface ForOfStatement extends Omit<Statement, "type"> {
    type: "ForOfStatement";
    left: K.VariableDeclarationKind | K.PatternKind;
    right: K.ExpressionKind;
    body: K.StatementKind;
    await?: boolean;
  }

  export interface YieldExpression extends Omit<Expression, "type"> {
    type: "YieldExpression";
    argument: K.ExpressionKind | null;
    delegate?: boolean;
  }

  export interface GeneratorExpression extends Omit<Expression, "type"> {
    type: "GeneratorExpression";
    body: K.ExpressionKind;
    blocks: K.ComprehensionBlockKind[];
    filter: K.ExpressionKind | null;
  }

  export interface ComprehensionBlock extends Omit<Node, "type"> {
    type: "ComprehensionBlock";
    left: K.PatternKind;
    right: K.ExpressionKind;
    each: boolean;
  }

  export interface ComprehensionExpression extends Omit<Expression, "type"> {
    type: "ComprehensionExpression";
    body: K.ExpressionKind;
    blocks: K.ComprehensionBlockKind[];
    filter: K.ExpressionKind | null;
  }

  export interface ObjectProperty extends Omit<Node, "type"> {
    shorthand?: boolean;
    type: "ObjectProperty";
    key: K.LiteralKind | K.IdentifierKind | K.ExpressionKind;
    value: K.ExpressionKind | K.PatternKind;
    accessibility?: K.LiteralKind | null;
    computed?: boolean;
  }

  export interface PropertyPattern extends Omit<Pattern, "type"> {
    type: "PropertyPattern";
    key: K.LiteralKind | K.IdentifierKind | K.ExpressionKind;
    pattern: K.PatternKind;
    computed?: boolean;
  }

  export interface ObjectPattern extends Omit<Pattern, "type"> {
    type: "ObjectPattern";
    properties: (K.PropertyKind | K.PropertyPatternKind | K.SpreadPropertyPatternKind | K.SpreadPropertyKind | K.ObjectPropertyKind | K.RestPropertyKind | K.RestElementKind)[];
    typeAnnotation?: K.TypeAnnotationKind | K.TSTypeAnnotationKind | null;
    decorators?: K.DecoratorKind[] | null;
  }

  export interface ArrayPattern extends Omit<Pattern, "type"> {
    type: "ArrayPattern";
    elements: (K.PatternKind | K.SpreadElementKind | null)[];
  }

  export interface SpreadElement extends Omit<Node, "type"> {
    type: "SpreadElement";
    argument: K.ExpressionKind;
  }

  export interface AssignmentPattern extends Omit<Pattern, "type"> {
    type: "AssignmentPattern";
    left: K.PatternKind;
    right: K.ExpressionKind;
  }

  export interface MethodDefinition extends Omit<Declaration, "type"> {
    type: "MethodDefinition";
    kind: "constructor" | "method" | "get" | "set";
    key: K.ExpressionKind;
    value: K.FunctionKind;
    computed?: boolean;
    static?: boolean;
    decorators?: K.DecoratorKind[] | null;
  }

  export interface ClassPropertyDefinition extends Omit<Declaration, "type"> {
    type: "ClassPropertyDefinition";
    definition: K.MethodDefinitionKind | K.VariableDeclaratorKind | K.ClassPropertyDefinitionKind | K.ClassPropertyKind | K.StaticBlockKind;
  }

  export interface ClassProperty extends Omit<Declaration, "type"> {
    type: "ClassProperty";
    key: K.LiteralKind | K.IdentifierKind | K.ExpressionKind;
    computed?: boolean;
    value: K.ExpressionKind | null;
    static?: boolean;
    typeAnnotation?: K.TypeAnnotationKind | K.TSTypeAnnotationKind | null;
    variance?: K.VarianceKind | "plus" | "minus" | null;
    access?: "public" | "private" | "protected" | undefined;
  }

  export interface StaticBlock extends Omit<Declaration, "type"> {
    type: "StaticBlock";
    body: K.StatementKind[];
  }

  export interface ClassBody extends Omit<Declaration, "type"> {
    type: "ClassBody";
    body: (K.MethodDefinitionKind | K.VariableDeclaratorKind | K.ClassPropertyDefinitionKind | K.ClassPropertyKind | K.ClassPrivatePropertyKind | K.ClassAccessorPropertyKind | K.ClassMethodKind | K.ClassPrivateMethodKind | K.StaticBlockKind | K.TSDeclareMethodKind | K.TSCallSignatureDeclarationKind | K.TSConstructSignatureDeclarationKind | K.TSIndexSignatureKind | K.TSMethodSignatureKind | K.TSPropertySignatureKind)[];
  }

  export interface ClassDeclaration extends Omit<Declaration, "type"> {
    type: "ClassDeclaration";
    id: K.IdentifierKind | null;
    body: K.ClassBodyKind;
    superClass?: K.ExpressionKind | null;
    typeParameters?: K.TypeParameterDeclarationKind | K.TSTypeParameterDeclarationKind | null;
    superTypeParameters?: K.TypeParameterInstantiationKind | K.TSTypeParameterInstantiationKind | null;
    implements?: K.ClassImplementsKind[] | K.TSExpressionWithTypeArgumentsKind[];
  }

  export interface ClassExpression extends Omit<Expression, "type"> {
    type: "ClassExpression";
    id?: K.IdentifierKind | null;
    body: K.ClassBodyKind;
    superClass?: K.ExpressionKind | null;
    typeParameters?: K.TypeParameterDeclarationKind | K.TSTypeParameterDeclarationKind | null;
    superTypeParameters?: K.TypeParameterInstantiationKind | K.TSTypeParameterInstantiationKind | null;
    implements?: K.ClassImplementsKind[] | K.TSExpressionWithTypeArgumentsKind[];
  }

  export interface Super extends Omit<Expression, "type"> {
    type: "Super";
  }

  export interface Specifier extends Node {}

  export interface ModuleSpecifier extends Specifier {
    local?: K.IdentifierKind | null;
    id?: K.IdentifierKind | null;
    name?: K.IdentifierKind | null;
  }

  export interface ImportSpecifier extends Omit<ModuleSpecifier, "type"> {
    type: "ImportSpecifier";
    imported: K.IdentifierKind;
  }

  export interface ImportDefaultSpecifier extends Omit<ModuleSpecifier, "type"> {
    type: "ImportDefaultSpecifier";
  }

  export interface ImportNamespaceSpecifier extends Omit<ModuleSpecifier, "type"> {
    type: "ImportNamespaceSpecifier";
  }

  export interface ImportDeclaration extends Omit<Declaration, "type"> {
    type: "ImportDeclaration";
    specifiers?: (K.ImportSpecifierKind | K.ImportNamespaceSpecifierKind | K.ImportDefaultSpecifierKind)[];
    source: K.LiteralKind;
    importKind?: "value" | "type" | "typeof";
    assertions?: K.ImportAttributeKind[];
  }

  export interface ExportNamedDeclaration extends Omit<Declaration, "type"> {
    type: "ExportNamedDeclaration";
    declaration: K.DeclarationKind | null;
    specifiers?: K.ExportSpecifierKind[];
    source?: K.LiteralKind | null;
    assertions?: K.ImportAttributeKind[];
  }

  export interface ExportSpecifier extends Omit<ModuleSpecifier, "type"> {
    type: "ExportSpecifier";
    exported: K.IdentifierKind;
  }

  export interface ExportDefaultDeclaration extends Omit<Declaration, "type"> {
    type: "ExportDefaultDeclaration";
    declaration: K.DeclarationKind | K.ExpressionKind;
  }

  export interface ExportAllDeclaration extends Omit<Declaration, "type"> {
    type: "ExportAllDeclaration";
    source: K.LiteralKind;
    exported?: K.IdentifierKind | null | undefined;
    assertions?: K.ImportAttributeKind[];
  }

  export interface TaggedTemplateExpression extends Omit<Expression, "type"> {
    type: "TaggedTemplateExpression";
    tag: K.ExpressionKind;
    quasi: K.TemplateLiteralKind;
  }

  export interface TemplateLiteral extends Omit<Expression, "type"> {
    type: "TemplateLiteral";
    quasis: K.TemplateElementKind[];
    expressions: K.ExpressionKind[] | K.TSTypeKind[];
  }

  export interface TemplateElement extends Omit<Node, "type"> {
    type: "TemplateElement";
    value: {
      cooked: string | null;
      raw: string;
    };
    tail: boolean;
  }

  export interface MetaProperty extends Omit<Expression, "type"> {
    type: "MetaProperty";
    meta: K.IdentifierKind;
    property: K.IdentifierKind;
  }

  export interface AwaitExpression extends Omit<Expression, "type"> {
    type: "AwaitExpression";
    argument: K.ExpressionKind | null;
    all?: boolean;
  }

  export interface SpreadProperty extends Omit<Node, "type"> {
    type: "SpreadProperty";
    argument: K.ExpressionKind;
  }

  export interface SpreadPropertyPattern extends Omit<Pattern, "type"> {
    type: "SpreadPropertyPattern";
    argument: K.PatternKind;
  }

  export interface ImportExpression extends Omit<Expression, "type"> {
    type: "ImportExpression";
    source: K.ExpressionKind;
  }

  export interface ChainExpression extends Omit<Expression, "type"> {
    type: "ChainExpression";
    expression: K.ChainElementKind;
  }

  export interface OptionalCallExpression extends Omit<CallExpression, "type" | "optional"> {
    type: "OptionalCallExpression";
    optional?: boolean;
  }

  export interface OptionalMemberExpression extends Omit<MemberExpression, "type" | "optional"> {
    type: "OptionalMemberExpression";
    optional?: boolean;
  }

  export interface Decorator extends Omit<Node, "type"> {
    type: "Decorator";
    expression: K.ExpressionKind;
  }

  export interface PrivateName extends Omit<Expression, "type">, Omit<Pattern, "type"> {
    type: "PrivateName";
    id: K.IdentifierKind;
  }

  export interface ClassPrivateProperty extends Omit<ClassProperty, "type" | "key" | "value"> {
    type: "ClassPrivateProperty";
    key: K.PrivateNameKind;
    value?: K.ExpressionKind | null;
  }

  export interface ImportAttribute extends Omit<Node, "type"> {
    type: "ImportAttribute";
    key: K.IdentifierKind | K.LiteralKind;
    value: K.ExpressionKind;
  }

  export interface RecordExpression extends Omit<Expression, "type"> {
    type: "RecordExpression";
    properties: (K.ObjectPropertyKind | K.ObjectMethodKind | K.SpreadElementKind)[];
  }

  export interface ObjectMethod extends Omit<Node, "type">, Omit<Function, "type" | "params" | "body" | "generator" | "async"> {
    type: "ObjectMethod";
    kind: "method" | "get" | "set";
    key: K.LiteralKind | K.IdentifierKind | K.ExpressionKind;
    params: K.PatternKind[];
    body: K.BlockStatementKind;
    computed?: boolean;
    generator?: boolean;
    async?: boolean;
    accessibility?: K.LiteralKind | null;
    decorators?: K.DecoratorKind[] | null;
  }

  export interface TupleExpression extends Omit<Expression, "type"> {
    type: "TupleExpression";
    elements: (K.ExpressionKind | K.SpreadElementKind | null)[];
  }

  export interface ModuleExpression extends Omit<Node, "type"> {
    type: "ModuleExpression";
    body: K.ProgramKind;
  }

  export interface JSXAttribute extends Omit<Node, "type"> {
    type: "JSXAttribute";
    name: K.JSXIdentifierKind | K.JSXNamespacedNameKind;
    value?: K.LiteralKind | K.JSXExpressionContainerKind | K.JSXElementKind | K.JSXFragmentKind | null;
  }

  export interface JSXIdentifier extends Omit<Identifier, "type" | "name"> {
    type: "JSXIdentifier";
    name: string;
  }

  export interface JSXNamespacedName extends Omit<Node, "type"> {
    type: "JSXNamespacedName";
    namespace: K.JSXIdentifierKind;
    name: K.JSXIdentifierKind;
  }

  export interface JSXExpressionContainer extends Omit<Expression, "type"> {
    type: "JSXExpressionContainer";
    expression: K.ExpressionKind | K.JSXEmptyExpressionKind;
  }

  export interface JSXElement extends Omit<Expression, "type"> {
    type: "JSXElement";
    openingElement: K.JSXOpeningElementKind;
    closingElement?: K.JSXClosingElementKind | null;
    children?: (K.JSXTextKind | K.JSXExpressionContainerKind | K.JSXSpreadChildKind | K.JSXElementKind | K.JSXFragmentKind | K.LiteralKind)[];
    name?: K.JSXIdentifierKind | K.JSXNamespacedNameKind | K.JSXMemberExpressionKind;
    selfClosing?: boolean;
    attributes?: (K.JSXAttributeKind | K.JSXSpreadAttributeKind)[];
  }

  export interface JSXFragment extends Omit<Expression, "type"> {
    type: "JSXFragment";
    openingFragment: K.JSXOpeningFragmentKind;
    closingFragment: K.JSXClosingFragmentKind;
    children?: (K.JSXTextKind | K.JSXExpressionContainerKind | K.JSXSpreadChildKind | K.JSXElementKind | K.JSXFragmentKind | K.LiteralKind)[];
  }

  export interface JSXMemberExpression extends Omit<MemberExpression, "type" | "object" | "property" | "computed"> {
    type: "JSXMemberExpression";
    object: K.JSXIdentifierKind | K.JSXMemberExpressionKind;
    property: K.JSXIdentifierKind;
    computed?: boolean;
  }

  export interface JSXSpreadAttribute extends Omit<Node, "type"> {
    type: "JSXSpreadAttribute";
    argument: K.ExpressionKind;
  }

  export interface JSXEmptyExpression extends Omit<Node, "type"> {
    type: "JSXEmptyExpression";
  }

  export interface JSXText extends Omit<Literal, "type" | "value"> {
    type: "JSXText";
    value: string;
    raw?: string;
  }

  export interface JSXSpreadChild extends Omit<Node, "type"> {
    type: "JSXSpreadChild";
    expression: K.ExpressionKind;
  }

  export interface JSXOpeningElement extends Omit<Node, "type"> {
    type: "JSXOpeningElement";
    name: K.JSXIdentifierKind | K.JSXNamespacedNameKind | K.JSXMemberExpressionKind;
    attributes?: (K.JSXAttributeKind | K.JSXSpreadAttributeKind)[];
    selfClosing?: boolean;
  }

  export interface JSXClosingElement extends Omit<Node, "type"> {
    type: "JSXClosingElement";
    name: K.JSXIdentifierKind | K.JSXNamespacedNameKind | K.JSXMemberExpressionKind;
  }

  export interface JSXOpeningFragment extends Omit<Node, "type"> {
    type: "JSXOpeningFragment";
  }

  export interface JSXClosingFragment extends Omit<Node, "type"> {
    type: "JSXClosingFragment";
  }

  export interface TypeParameterDeclaration extends Omit<Node, "type"> {
    type: "TypeParameterDeclaration";
    params: K.TypeParameterKind[];
  }

  export interface TSTypeParameterDeclaration extends Omit<Declaration, "type"> {
    type: "TSTypeParameterDeclaration";
    params: K.TSTypeParameterKind[];
  }

  export interface TypeParameterInstantiation extends Omit<Node, "type"> {
    type: "TypeParameterInstantiation";
    params: K.FlowTypeKind[];
  }

  export interface TSTypeParameterInstantiation extends Omit<Node, "type"> {
    type: "TSTypeParameterInstantiation";
    params: K.TSTypeKind[];
  }

  export interface ClassImplements extends Omit<Node, "type"> {
    type: "ClassImplements";
    id: K.IdentifierKind;
    superClass?: K.ExpressionKind | null;
    typeParameters?: K.TypeParameterInstantiationKind | null;
  }

  export interface TSType extends Node {}

  export interface TSHasOptionalTypeParameterInstantiation {
    typeParameters?: K.TSTypeParameterInstantiationKind | null;
  }

  export interface TSExpressionWithTypeArguments extends Omit<TSType, "type">, TSHasOptionalTypeParameterInstantiation {
    type: "TSExpressionWithTypeArguments";
    expression: K.IdentifierKind | K.TSQualifiedNameKind;
  }

  export interface Flow extends Node {}
  export interface FlowType extends Flow {}

  export interface AnyTypeAnnotation extends Omit<FlowType, "type"> {
    type: "AnyTypeAnnotation";
  }

  export interface EmptyTypeAnnotation extends Omit<FlowType, "type"> {
    type: "EmptyTypeAnnotation";
  }

  export interface MixedTypeAnnotation extends Omit<FlowType, "type"> {
    type: "MixedTypeAnnotation";
  }

  export interface VoidTypeAnnotation extends Omit<FlowType, "type"> {
    type: "VoidTypeAnnotation";
  }

  export interface SymbolTypeAnnotation extends Omit<FlowType, "type"> {
    type: "SymbolTypeAnnotation";
  }

  export interface NumberTypeAnnotation extends Omit<FlowType, "type"> {
    type: "NumberTypeAnnotation";
  }

  export interface BigIntTypeAnnotation extends Omit<FlowType, "type"> {
    type: "BigIntTypeAnnotation";
  }

  export interface NumberLiteralTypeAnnotation extends Omit<FlowType, "type"> {
    type: "NumberLiteralTypeAnnotation";
    value: number;
    raw: string;
  }

  export interface NumericLiteralTypeAnnotation extends Omit<FlowType, "type"> {
    type: "NumericLiteralTypeAnnotation";
    value: number;
    raw: string;
  }

  export interface BigIntLiteralTypeAnnotation extends Omit<FlowType, "type"> {
    type: "BigIntLiteralTypeAnnotation";
    value: null;
    raw: string;
  }

  export interface StringTypeAnnotation extends Omit<FlowType, "type"> {
    type: "StringTypeAnnotation";
  }

  export interface StringLiteralTypeAnnotation extends Omit<FlowType, "type"> {
    type: "StringLiteralTypeAnnotation";
    value: string;
    raw: string;
  }

  export interface BooleanTypeAnnotation extends Omit<FlowType, "type"> {
    type: "BooleanTypeAnnotation";
  }

  export interface BooleanLiteralTypeAnnotation extends Omit<FlowType, "type"> {
    type: "BooleanLiteralTypeAnnotation";
    value: boolean;
    raw: string;
  }

  export interface NullableTypeAnnotation extends Omit<FlowType, "type"> {
    type: "NullableTypeAnnotation";
    typeAnnotation: K.FlowTypeKind;
  }

  export interface NullLiteralTypeAnnotation extends Omit<FlowType, "type"> {
    type: "NullLiteralTypeAnnotation";
  }

  export interface NullTypeAnnotation extends Omit<FlowType, "type"> {
    type: "NullTypeAnnotation";
  }

  export interface ThisTypeAnnotation extends Omit<FlowType, "type"> {
    type: "ThisTypeAnnotation";
  }

  export interface ExistsTypeAnnotation extends Omit<FlowType, "type"> {
    type: "ExistsTypeAnnotation";
  }

  export interface ExistentialTypeParam extends Omit<FlowType, "type"> {
    type: "ExistentialTypeParam";
  }

  export interface FunctionTypeAnnotation extends Omit<FlowType, "type"> {
    type: "FunctionTypeAnnotation";
    params: K.FunctionTypeParamKind[];
    returnType: K.FlowTypeKind;
    rest: K.FunctionTypeParamKind | null;
    typeParameters: K.TypeParameterDeclarationKind | null;
  }

  export interface FunctionTypeParam extends Omit<Node, "type"> {
    type: "FunctionTypeParam";
    name: K.IdentifierKind | null;
    typeAnnotation: K.FlowTypeKind;
    optional: boolean;
  }

  export interface ArrayTypeAnnotation extends Omit<FlowType, "type"> {
    type: "ArrayTypeAnnotation";
    elementType: K.FlowTypeKind;
  }

  export interface ObjectTypeAnnotation extends Omit<FlowType, "type"> {
    type: "ObjectTypeAnnotation";
    properties: (K.ObjectTypePropertyKind | K.ObjectTypeSpreadPropertyKind)[];
    indexers?: K.ObjectTypeIndexerKind[];
    callProperties?: K.ObjectTypeCallPropertyKind[];
    inexact?: boolean | undefined;
    exact?: boolean;
    internalSlots?: K.ObjectTypeInternalSlotKind[];
  }

  export interface ObjectTypeProperty extends Omit<Node, "type"> {
    type: "ObjectTypeProperty";
    key: K.LiteralKind | K.IdentifierKind;
    value: K.FlowTypeKind;
    optional: boolean;
    variance?: K.VarianceKind | "plus" | "minus" | null;
  }

  export interface ObjectTypeSpreadProperty extends Omit<Node, "type"> {
    type: "ObjectTypeSpreadProperty";
    argument: K.FlowTypeKind;
  }

  export interface ObjectTypeIndexer extends Omit<Node, "type"> {
    type: "ObjectTypeIndexer";
    id: K.IdentifierKind;
    key: K.FlowTypeKind;
    value: K.FlowTypeKind;
    variance?: K.VarianceKind | "plus" | "minus" | null;
    static?: boolean;
  }

  export interface ObjectTypeCallProperty extends Omit<Node, "type"> {
    type: "ObjectTypeCallProperty";
    value: K.FunctionTypeAnnotationKind;
    static?: boolean;
  }

  export interface ObjectTypeInternalSlot extends Omit<Node, "type"> {
    type: "ObjectTypeInternalSlot";
    id: K.IdentifierKind;
    value: K.FlowTypeKind;
    optional: boolean;
    static: boolean;
    method: boolean;
  }

  export interface Variance extends Omit<Node, "type"> {
    type: "Variance";
    kind: "plus" | "minus";
  }

  export interface QualifiedTypeIdentifier extends Omit<Node, "type"> {
    type: "QualifiedTypeIdentifier";
    qualification: K.IdentifierKind | K.QualifiedTypeIdentifierKind;
    id: K.IdentifierKind;
  }

  export interface GenericTypeAnnotation extends Omit<FlowType, "type"> {
    type: "GenericTypeAnnotation";
    id: K.IdentifierKind | K.QualifiedTypeIdentifierKind;
    typeParameters: K.TypeParameterInstantiationKind | null;
  }

  export interface MemberTypeAnnotation extends Omit<FlowType, "type"> {
    type: "MemberTypeAnnotation";
    object: K.IdentifierKind;
    property: K.MemberTypeAnnotationKind | K.GenericTypeAnnotationKind;
  }

  export interface IndexedAccessType extends Omit<FlowType, "type"> {
    type: "IndexedAccessType";
    objectType: K.FlowTypeKind;
    indexType: K.FlowTypeKind;
  }

  export interface OptionalIndexedAccessType extends Omit<FlowType, "type"> {
    type: "OptionalIndexedAccessType";
    objectType: K.FlowTypeKind;
    indexType: K.FlowTypeKind;
    optional: boolean;
  }

  export interface UnionTypeAnnotation extends Omit<FlowType, "type"> {
    type: "UnionTypeAnnotation";
    types: K.FlowTypeKind[];
  }

  export interface IntersectionTypeAnnotation extends Omit<FlowType, "type"> {
    type: "IntersectionTypeAnnotation";
    types: K.FlowTypeKind[];
  }

  export interface TypeofTypeAnnotation extends Omit<FlowType, "type"> {
    type: "TypeofTypeAnnotation";
    argument: K.FlowTypeKind;
  }

  export interface TypeParameter extends Omit<FlowType, "type"> {
    type: "TypeParameter";
    name: string;
    variance?: K.VarianceKind | "plus" | "minus" | null;
    bound?: K.TypeAnnotationKind | null;
    default?: K.FlowTypeKind | null;
  }

  export interface InterfaceTypeAnnotation extends Omit<FlowType, "type"> {
    type: "InterfaceTypeAnnotation";
    body: K.ObjectTypeAnnotationKind;
    extends?: K.InterfaceExtendsKind[] | null;
  }

  export interface InterfaceExtends extends Omit<Node, "type"> {
    type: "InterfaceExtends";
    id: K.IdentifierKind;
    typeParameters?: K.TypeParameterInstantiationKind | null;
  }

  export interface InterfaceDeclaration extends Omit<Declaration, "type"> {
    type: "InterfaceDeclaration";
    id: K.IdentifierKind;
    typeParameters?: K.TypeParameterDeclarationKind | null;
    body: K.ObjectTypeAnnotationKind;
    extends: K.InterfaceExtendsKind[];
  }

  export interface DeclareInterface extends Omit<InterfaceDeclaration, "type"> {
    type: "DeclareInterface";
  }

  export interface TypeAlias extends Omit<Declaration, "type"> {
    type: "TypeAlias";
    id: K.IdentifierKind;
    typeParameters: K.TypeParameterDeclarationKind | null;
    right: K.FlowTypeKind;
  }

  export interface DeclareTypeAlias extends Omit<TypeAlias, "type"> {
    type: "DeclareTypeAlias";
  }

  export interface OpaqueType extends Omit<Declaration, "type"> {
    type: "OpaqueType";
    id: K.IdentifierKind;
    typeParameters: K.TypeParameterDeclarationKind | null;
    impltype: K.FlowTypeKind;
    supertype: K.FlowTypeKind | null;
  }

  export interface DeclareOpaqueType extends Omit<OpaqueType, "type" | "impltype"> {
    type: "DeclareOpaqueType";
    impltype: K.FlowTypeKind | null;
  }

  export interface TypeCastExpression extends Omit<Expression, "type"> {
    type: "TypeCastExpression";
    expression: K.ExpressionKind;
    typeAnnotation: K.TypeAnnotationKind;
  }

  export interface TupleTypeAnnotation extends Omit<FlowType, "type"> {
    type: "TupleTypeAnnotation";
    types: K.FlowTypeKind[];
  }

  export interface DeclareVariable extends Omit<Statement, "type"> {
    type: "DeclareVariable";
    id: K.IdentifierKind;
  }

  export interface DeclareFunction extends Omit<Statement, "type"> {
    type: "DeclareFunction";
    id: K.IdentifierKind;
    predicate?: K.FlowPredicateKind | null;
  }

  export interface FlowPredicate extends Flow {}

  export interface DeclareClass extends Omit<InterfaceDeclaration, "type"> {
    type: "DeclareClass";
  }

  export interface DeclareModule extends Omit<Statement, "type"> {
    type: "DeclareModule";
    id: K.IdentifierKind | K.LiteralKind;
    body: K.BlockStatementKind;
  }

  export interface DeclareModuleExports extends Omit<Statement, "type"> {
    type: "DeclareModuleExports";
    typeAnnotation: K.TypeAnnotationKind;
  }

  export interface DeclareExportDeclaration extends Omit<Declaration, "type"> {
    type: "DeclareExportDeclaration";
    default: boolean;
    declaration: K.DeclareVariableKind | K.DeclareFunctionKind | K.DeclareClassKind | K.FlowTypeKind | K.TypeAliasKind | K.DeclareOpaqueTypeKind | K.InterfaceDeclarationKind | null;
    specifiers?: (K.ExportSpecifierKind | K.ExportBatchSpecifierKind)[];
    source?: K.LiteralKind | null;
  }

  export interface ExportBatchSpecifier extends Omit<Specifier, "type"> {
    type: "ExportBatchSpecifier";
  }

  export interface DeclareExportAllDeclaration extends Omit<Declaration, "type"> {
    type: "DeclareExportAllDeclaration";
    source?: K.LiteralKind | null;
  }

  export interface InferredPredicate extends Omit<FlowPredicate, "type"> {
    type: "InferredPredicate";
  }

  export interface DeclaredPredicate extends Omit<FlowPredicate, "type"> {
    type: "DeclaredPredicate";
    value: K.ExpressionKind;
  }

  export interface EnumDeclaration extends Omit<Declaration, "type"> {
    type: "EnumDeclaration";
    id: K.IdentifierKind;
    body: K.EnumBooleanBodyKind | K.EnumNumberBodyKind | K.EnumStringBodyKind | K.EnumSymbolBodyKind;
  }

  export interface EnumBooleanBody {
    type: "EnumBooleanBody";
    members: K.EnumBooleanMemberKind[];
    explicitType: boolean;
  }

  export interface EnumNumberBody {
    type: "EnumNumberBody";
    members: K.EnumNumberMemberKind[];
    explicitType: boolean;
  }

  export interface EnumStringBody {
    type: "EnumStringBody";
    members: K.EnumStringMemberKind[] | K.EnumDefaultedMemberKind[];
    explicitType: boolean;
  }

  export interface EnumSymbolBody {
    type: "EnumSymbolBody";
    members: K.EnumDefaultedMemberKind[];
  }

  export interface EnumBooleanMember {
    type: "EnumBooleanMember";
    id: K.IdentifierKind;
    init: K.LiteralKind | boolean;
  }

  export interface EnumNumberMember {
    type: "EnumNumberMember";
    id: K.IdentifierKind;
    init: K.LiteralKind;
  }

  export interface EnumStringMember {
    type: "EnumStringMember";
    id: K.IdentifierKind;
    init: K.LiteralKind;
  }

  export interface EnumDefaultedMember {
    type: "EnumDefaultedMember";
    id: K.IdentifierKind;
  }

  export interface ExportDeclaration extends Omit<Declaration, "type"> {
    type: "ExportDeclaration";
    default: boolean;
    declaration: K.DeclarationKind | K.ExpressionKind | null;
    specifiers?: (K.ExportSpecifierKind | K.ExportBatchSpecifierKind)[];
    source?: K.LiteralKind | null;
  }

  export interface Block extends Comment {
    type: "Block";
  }

  export interface Line extends Comment {
    type: "Line";
  }

  export interface Noop extends Omit<Statement, "type"> {
    type: "Noop";
  }

  export interface DoExpression extends Omit<Expression, "type"> {
    type: "DoExpression";
    body: K.StatementKind[];
  }

  export interface BindExpression extends Omit<Expression, "type"> {
    type: "BindExpression";
    object: K.ExpressionKind | null;
    callee: K.ExpressionKind;
  }

  export interface ParenthesizedExpression extends Omit<Expression, "type"> {
    type: "ParenthesizedExpression";
    expression: K.ExpressionKind;
  }

  export interface ExportNamespaceSpecifier extends Omit<Specifier, "type"> {
    type: "ExportNamespaceSpecifier";
    exported: K.IdentifierKind;
  }

  export interface ExportDefaultSpecifier extends Omit<Specifier, "type"> {
    type: "ExportDefaultSpecifier";
    exported: K.IdentifierKind;
  }

  export interface CommentBlock extends Comment {
    type: "CommentBlock";
  }

  export interface CommentLine extends Comment {
    type: "CommentLine";
  }

  export interface Directive extends Omit<Node, "type"> {
    type: "Directive";
    value: K.DirectiveLiteralKind;
  }

  export interface DirectiveLiteral extends Omit<Node, "type">, Omit<Expression, "type"> {
    type: "DirectiveLiteral";
    value?: string;
  }

  export interface InterpreterDirective extends Omit<Node, "type"> {
    type: "InterpreterDirective";
    value: string;
  }

  export interface StringLiteral extends Omit<Literal, "type" | "value"> {
    type: "StringLiteral";
    value: string;
    extra?: {
      rawValue: string;
      raw: string;
    };
  }

  export interface NumericLiteral extends Omit<Literal, "type" | "value"> {
    type: "NumericLiteral";
    value: number;
    raw?: string | null;
    extra?: {
      rawValue: number;
      raw: string;
    };
  }

  export interface BigIntLiteral extends Omit<Literal, "type" | "value"> {
    type: "BigIntLiteral";
    value: string | number;
    extra?: {
      rawValue: string;
      raw: string;
    };
  }

  export interface DecimalLiteral extends Omit<Literal, "type" | "value"> {
    type: "DecimalLiteral";
    value: string;
    extra?: {
      rawValue: string;
      raw: string;
    };
  }

  export interface NullLiteral extends Omit<Literal, "type" | "value"> {
    type: "NullLiteral";
    value?: null;
  }

  export interface BooleanLiteral extends Omit<Literal, "type" | "value"> {
    type: "BooleanLiteral";
    value: boolean;
  }

  export interface RegExpLiteral extends Omit<Literal, "type" | "value"> {
    type: "RegExpLiteral";
    pattern: string;
    flags: string;
    value?: RegExp;
    extra?: {
      rawValue: RegExp | undefined;
      raw: string;
    };
    regex?: {
      pattern: string;
      flags: string;
    };
  }

  export interface ClassMethod extends Omit<Declaration, "type">, Omit<Function, "type" | "body"> {
    type: "ClassMethod";
    key: K.LiteralKind | K.IdentifierKind | K.ExpressionKind;
    kind?: "get" | "set" | "method" | "constructor";
    body: K.BlockStatementKind;
    access?: "public" | "private" | "protected" | null;
    computed?: boolean;
    static?: boolean;
    abstract?: boolean;
    accessibility?: "public" | "private" | "protected" | null;
    decorators?: K.DecoratorKind[] | null;
    definite?: boolean;
    optional?: boolean;
    override?: boolean;
    readonly?: boolean;
  }

  export interface ClassPrivateMethod extends Omit<Declaration, "type">, Omit<Function, "type" | "body"> {
    type: "ClassPrivateMethod";
    key: K.PrivateNameKind;
    kind?: "get" | "set" | "method" | "constructor";
    body: K.BlockStatementKind;
    access?: "public" | "private" | "protected" | null;
    computed?: boolean;
    static?: boolean;
    abstract?: boolean;
    accessibility?: "public" | "private" | "protected" | null;
    decorators?: K.DecoratorKind[] | null;
    definite?: boolean;
    optional?: boolean;
    override?: boolean;
    readonly?: boolean;
  }

  export interface TSHasOptionalTypeAnnotation {
    typeAnnotation?: K.TSTypeAnnotationKind | null;
  }

  export interface ClassAccessorProperty extends Omit<Declaration, "type">, TSHasOptionalTypeAnnotation {
    type: "ClassAccessorProperty";
    key: K.LiteralKind | K.IdentifierKind | K.PrivateNameKind | K.ExpressionKind;
    value?: K.ExpressionKind | null;
    computed?: boolean;
    static?: boolean;
    abstract?: boolean;
    accessibility?: "public" | "private" | "protected" | null;
    decorators?: K.DecoratorKind[] | null;
    definite?: boolean;
    optional?: boolean;
    override?: boolean;
    readonly?: boolean;
  }

  export interface RestProperty extends Omit<Node, "type"> {
    type: "RestProperty";
    argument: K.ExpressionKind;
  }

  export interface ForAwaitStatement extends Omit<Statement, "type"> {
    type: "ForAwaitStatement";
    left: K.VariableDeclarationKind | K.ExpressionKind;
    right: K.ExpressionKind;
    body: K.StatementKind;
  }

  export interface Import extends Omit<Expression, "type"> {
    type: "Import";
  }

  export interface V8IntrinsicIdentifier extends Omit<Expression, "type"> {
    type: "V8IntrinsicIdentifier";
    name: string;
  }

  export interface TopicReference extends Omit<Expression, "type"> {
    type: "TopicReference";
  }

  export interface TSQualifiedName extends Omit<Node, "type"> {
    type: "TSQualifiedName";
    left: K.IdentifierKind | K.TSQualifiedNameKind;
    right: K.IdentifierKind | K.TSQualifiedNameKind;
  }

  export interface TSTypeReference extends Omit<TSType, "type">, TSHasOptionalTypeParameterInstantiation {
    type: "TSTypeReference";
    typeName: K.IdentifierKind | K.TSQualifiedNameKind;
  }

  export interface TSHasOptionalTypeParameters {
    typeParameters?: K.TSTypeParameterDeclarationKind | null | undefined;
  }

  export interface TSAsExpression extends Omit<Expression, "type">, Omit<Pattern, "type"> {
    type: "TSAsExpression";
    expression: K.ExpressionKind;
    typeAnnotation: K.TSTypeKind;
    extra?: {
      parenthesized: boolean;
    } | null;
  }

  export interface TSTypeCastExpression extends Omit<Expression, "type"> {
    type: "TSTypeCastExpression";
    expression: K.ExpressionKind;
    typeAnnotation: K.TSTypeKind;
  }

  export interface TSSatisfiesExpression extends Omit<Expression, "type">, Omit<Pattern, "type"> {
    type: "TSSatisfiesExpression";
    expression: K.ExpressionKind;
    typeAnnotation: K.TSTypeKind;
  }

  export interface TSNonNullExpression extends Omit<Expression, "type">, Omit<Pattern, "type"> {
    type: "TSNonNullExpression";
    expression: K.ExpressionKind;
  }

  export interface TSAnyKeyword extends Omit<TSType, "type"> {
    type: "TSAnyKeyword";
  }

  export interface TSBigIntKeyword extends Omit<TSType, "type"> {
    type: "TSBigIntKeyword";
  }

  export interface TSBooleanKeyword extends Omit<TSType, "type"> {
    type: "TSBooleanKeyword";
  }

  export interface TSNeverKeyword extends Omit<TSType, "type"> {
    type: "TSNeverKeyword";
  }

  export interface TSNullKeyword extends Omit<TSType, "type"> {
    type: "TSNullKeyword";
  }

  export interface TSNumberKeyword extends Omit<TSType, "type"> {
    type: "TSNumberKeyword";
  }

  export interface TSObjectKeyword extends Omit<TSType, "type"> {
    type: "TSObjectKeyword";
  }

  export interface TSStringKeyword extends Omit<TSType, "type"> {
    type: "TSStringKeyword";
  }

  export interface TSSymbolKeyword extends Omit<TSType, "type"> {
    type: "TSSymbolKeyword";
  }

  export interface TSUndefinedKeyword extends Omit<TSType, "type"> {
    type: "TSUndefinedKeyword";
  }

  export interface TSUnknownKeyword extends Omit<TSType, "type"> {
    type: "TSUnknownKeyword";
  }

  export interface TSVoidKeyword extends Omit<TSType, "type"> {
    type: "TSVoidKeyword";
  }

  export interface TSIntrinsicKeyword extends Omit<TSType, "type"> {
    type: "TSIntrinsicKeyword";
  }

  export interface TSThisType extends Omit<TSType, "type"> {
    type: "TSThisType";
  }

  export interface TSArrayType extends Omit<TSType, "type"> {
    type: "TSArrayType";
    elementType: K.TSTypeKind;
  }

  export interface TSLiteralType extends Omit<TSType, "type"> {
    type: "TSLiteralType";
    literal: K.NumericLiteralKind | K.StringLiteralKind | K.BooleanLiteralKind | K.TemplateLiteralKind | K.UnaryExpressionKind | K.BigIntLiteralKind;
  }

  export interface TSUnionType extends Omit<TSType, "type"> {
    type: "TSUnionType";
    types: K.TSTypeKind[];
  }

  export interface TSIntersectionType extends Omit<TSType, "type"> {
    type: "TSIntersectionType";
    types: K.TSTypeKind[];
  }

  export interface TSConditionalType extends Omit<TSType, "type"> {
    type: "TSConditionalType";
    checkType: K.TSTypeKind;
    extendsType: K.TSTypeKind;
    trueType: K.TSTypeKind;
    falseType: K.TSTypeKind;
  }

  export interface TSInferType extends Omit<TSType, "type"> {
    type: "TSInferType";
    typeParameter: K.TSTypeParameterKind;
  }

  export interface TSTypeParameter extends Omit<Identifier, "type" | "name"> {
    type: "TSTypeParameter";
    name: K.IdentifierKind | string;
    constraint?: K.TSTypeKind | undefined;
    default?: K.TSTypeKind | undefined;
  }

  export interface TSParenthesizedType extends Omit<TSType, "type"> {
    type: "TSParenthesizedType";
    typeAnnotation: K.TSTypeKind;
  }

  export interface TSFunctionType extends Omit<TSType, "type">, TSHasOptionalTypeParameters, TSHasOptionalTypeAnnotation {
    type: "TSFunctionType";
    parameters: (K.IdentifierKind | K.RestElementKind | K.ArrayPatternKind | K.ObjectPatternKind)[];
  }

  export interface TSConstructorType extends Omit<TSType, "type">, TSHasOptionalTypeParameters, TSHasOptionalTypeAnnotation {
    type: "TSConstructorType";
    parameters: (K.IdentifierKind | K.RestElementKind | K.ArrayPatternKind | K.ObjectPatternKind)[];
  }

  export interface TSDeclareFunction extends Omit<Declaration, "type">, TSHasOptionalTypeParameters {
    type: "TSDeclareFunction";
    declare?: boolean;
    async?: boolean;
    generator?: boolean;
    id?: K.IdentifierKind | null;
    params: K.PatternKind[];
    returnType?: K.TSTypeAnnotationKind | K.NoopKind | null;
  }

  export interface TSDeclareMethod extends Omit<Declaration, "type">, TSHasOptionalTypeParameters {
    type: "TSDeclareMethod";
    async?: boolean;
    generator?: boolean;
    params: K.PatternKind[];
    abstract?: boolean;
    accessibility?: "public" | "private" | "protected" | undefined;
    static?: boolean;
    computed?: boolean;
    optional?: boolean;
    key: K.IdentifierKind | K.StringLiteralKind | K.NumericLiteralKind | K.ExpressionKind;
    kind?: "get" | "set" | "method" | "constructor";
    access?: "public" | "private" | "protected" | undefined;
    decorators?: K.DecoratorKind[] | null;
    returnType?: K.TSTypeAnnotationKind | K.NoopKind | null;
  }

  export interface TSMappedType extends Omit<TSType, "type"> {
    type: "TSMappedType";
    readonly?: boolean | "+" | "-";
    typeParameter: K.TSTypeParameterKind;
    optional?: boolean | "+" | "-";
    typeAnnotation?: K.TSTypeKind | null;
  }

  export interface TSTupleType extends Omit<TSType, "type"> {
    type: "TSTupleType";
    elementTypes: (K.TSTypeKind | K.TSNamedTupleMemberKind)[];
  }

  export interface TSNamedTupleMember extends Omit<TSType, "type"> {
    type: "TSNamedTupleMember";
    label: K.IdentifierKind;
    optional?: boolean;
    elementType: K.TSTypeKind;
  }

  export interface TSRestType extends Omit<TSType, "type"> {
    type: "TSRestType";
    typeAnnotation: K.TSTypeKind;
  }

  export interface TSOptionalType extends Omit<TSType, "type"> {
    type: "TSOptionalType";
    typeAnnotation: K.TSTypeKind;
  }

  export interface TSIndexedAccessType extends Omit<TSType, "type"> {
    type: "TSIndexedAccessType";
    objectType: K.TSTypeKind;
    indexType: K.TSTypeKind;
  }

  export interface TSTypeOperator extends Omit<TSType, "type"> {
    type: "TSTypeOperator";
    operator: string;
    typeAnnotation: K.TSTypeKind;
  }

  export interface TSIndexSignature extends Omit<Declaration, "type">, TSHasOptionalTypeAnnotation {
    type: "TSIndexSignature";
    parameters: K.IdentifierKind[];
    readonly?: boolean;
  }

  export interface TSPropertySignature extends Omit<Declaration, "type">, TSHasOptionalTypeAnnotation {
    type: "TSPropertySignature";
    key: K.ExpressionKind;
    computed?: boolean;
    readonly?: boolean;
    optional?: boolean;
    initializer?: K.ExpressionKind | null;
  }

  export interface TSMethodSignature extends Omit<Declaration, "type">, TSHasOptionalTypeParameters, TSHasOptionalTypeAnnotation {
    type: "TSMethodSignature";
    key: K.ExpressionKind;
    computed?: boolean;
    optional?: boolean;
    parameters: (K.IdentifierKind | K.RestElementKind | K.ArrayPatternKind | K.ObjectPatternKind)[];
  }

  export interface TSTypePredicate extends Omit<TSTypeAnnotation, "type" | "typeAnnotation">, Omit<TSType, "type"> {
    type: "TSTypePredicate";
    parameterName: K.IdentifierKind | K.TSThisTypeKind;
    typeAnnotation?: K.TSTypeAnnotationKind | null;
    asserts?: boolean;
  }

  export interface TSCallSignatureDeclaration extends Omit<Declaration, "type">, TSHasOptionalTypeParameters, TSHasOptionalTypeAnnotation {
    type: "TSCallSignatureDeclaration";
    parameters: (K.IdentifierKind | K.RestElementKind | K.ArrayPatternKind | K.ObjectPatternKind)[];
  }

  export interface TSConstructSignatureDeclaration extends Omit<Declaration, "type">, TSHasOptionalTypeParameters, TSHasOptionalTypeAnnotation {
    type: "TSConstructSignatureDeclaration";
    parameters: (K.IdentifierKind | K.RestElementKind | K.ArrayPatternKind | K.ObjectPatternKind)[];
  }

  export interface TSEnumMember extends Omit<Node, "type"> {
    type: "TSEnumMember";
    id: K.IdentifierKind | K.StringLiteralKind;
    initializer?: K.ExpressionKind | null;
  }

  export interface TSTypeQuery extends Omit<TSType, "type"> {
    type: "TSTypeQuery";
    exprName: K.IdentifierKind | K.TSQualifiedNameKind | K.TSImportTypeKind;
  }

  export interface TSImportType extends Omit<TSType, "type">, TSHasOptionalTypeParameterInstantiation {
    type: "TSImportType";
    argument: K.StringLiteralKind;
    qualifier?: K.IdentifierKind | K.TSQualifiedNameKind | undefined;
  }

  export interface TSTypeLiteral extends Omit<TSType, "type"> {
    type: "TSTypeLiteral";
    members: (K.TSCallSignatureDeclarationKind | K.TSConstructSignatureDeclarationKind | K.TSIndexSignatureKind | K.TSMethodSignatureKind | K.TSPropertySignatureKind)[];
  }

  export interface TSTypeAssertion extends Omit<Expression, "type">, Omit<Pattern, "type"> {
    type: "TSTypeAssertion";
    typeAnnotation: K.TSTypeKind;
    expression: K.ExpressionKind;
    extra?: {
      parenthesized: boolean;
    } | null;
  }

  export interface TSInstantiationExpression extends Omit<Expression, "type">, TSHasOptionalTypeParameterInstantiation {
    type: "TSInstantiationExpression";
    expression: K.ExpressionKind;
  }

  export interface TSEnumDeclaration extends Omit<Declaration, "type"> {
    type: "TSEnumDeclaration";
    id: K.IdentifierKind;
    const?: boolean;
    declare?: boolean;
    members: K.TSEnumMemberKind[];
    initializer?: K.ExpressionKind | null;
  }

  export interface TSTypeAliasDeclaration extends Omit<Declaration, "type">, TSHasOptionalTypeParameters {
    type: "TSTypeAliasDeclaration";
    id: K.IdentifierKind;
    declare?: boolean;
    typeAnnotation: K.TSTypeKind;
  }

  export interface TSModuleBlock extends Omit<Node, "type"> {
    type: "TSModuleBlock";
    body: K.StatementKind[];
  }

  export interface TSModuleDeclaration extends Omit<Declaration, "type"> {
    type: "TSModuleDeclaration";
    id: K.StringLiteralKind | K.IdentifierKind | K.TSQualifiedNameKind;
    declare?: boolean;
    global?: boolean;
    body?: K.TSModuleBlockKind | K.TSModuleDeclarationKind | null;
  }

  export interface TSImportEqualsDeclaration extends Omit<Declaration, "type"> {
    type: "TSImportEqualsDeclaration";
    id: K.IdentifierKind;
    isExport?: boolean;
    moduleReference: K.IdentifierKind | K.TSQualifiedNameKind | K.TSExternalModuleReferenceKind;
  }

  export interface TSExternalModuleReference extends Omit<Declaration, "type"> {
    type: "TSExternalModuleReference";
    expression: K.StringLiteralKind;
  }

  export interface TSExportAssignment extends Omit<Statement, "type"> {
    type: "TSExportAssignment";
    expression: K.ExpressionKind;
  }

  export interface TSNamespaceExportDeclaration extends Omit<Declaration, "type"> {
    type: "TSNamespaceExportDeclaration";
    id: K.IdentifierKind;
  }

  export interface TSInterfaceBody extends Omit<Node, "type"> {
    type: "TSInterfaceBody";
    body: (K.TSCallSignatureDeclarationKind | K.TSConstructSignatureDeclarationKind | K.TSIndexSignatureKind | K.TSMethodSignatureKind | K.TSPropertySignatureKind)[];
  }

  export interface TSInterfaceDeclaration extends Omit<Declaration, "type">, TSHasOptionalTypeParameters {
    type: "TSInterfaceDeclaration";
    id: K.IdentifierKind | K.TSQualifiedNameKind;
    declare?: boolean;
    extends?: K.TSExpressionWithTypeArgumentsKind[] | null;
    body: K.TSInterfaceBodyKind;
  }

  export interface TSParameterProperty extends Omit<Pattern, "type"> {
    type: "TSParameterProperty";
    accessibility?: "public" | "private" | "protected" | undefined;
    readonly?: boolean;
    parameter: K.IdentifierKind | K.AssignmentPatternKind;
  }

  export type ASTNode = File | Program | Identifier | BlockStatement | EmptyStatement | ExpressionStatement | IfStatement | LabeledStatement | BreakStatement | ContinueStatement | WithStatement | SwitchStatement | SwitchCase | ReturnStatement | ThrowStatement | TryStatement | CatchClause | WhileStatement | DoWhileStatement | ForStatement | VariableDeclaration | ForInStatement | DebuggerStatement | FunctionDeclaration | FunctionExpression | VariableDeclarator | ThisExpression | ArrayExpression | ObjectExpression | Property | Literal | SequenceExpression | UnaryExpression | BinaryExpression | AssignmentExpression | MemberExpression | UpdateExpression | LogicalExpression | ConditionalExpression | NewExpression | CallExpression | RestElement | TypeAnnotation | TSTypeAnnotation | SpreadElementPattern | ArrowFunctionExpression | ForOfStatement | YieldExpression | GeneratorExpression | ComprehensionBlock | ComprehensionExpression | ObjectProperty | PropertyPattern | ObjectPattern | ArrayPattern | SpreadElement | AssignmentPattern | MethodDefinition | ClassPropertyDefinition | ClassProperty | StaticBlock | ClassBody | ClassDeclaration | ClassExpression | Super | ImportSpecifier | ImportDefaultSpecifier | ImportNamespaceSpecifier | ImportDeclaration | ExportNamedDeclaration | ExportSpecifier | ExportDefaultDeclaration | ExportAllDeclaration | TaggedTemplateExpression | TemplateLiteral | TemplateElement | MetaProperty | AwaitExpression | SpreadProperty | SpreadPropertyPattern | ImportExpression | ChainExpression | OptionalCallExpression | OptionalMemberExpression | Decorator | PrivateName | ClassPrivateProperty | ImportAttribute | RecordExpression | ObjectMethod | TupleExpression | ModuleExpression | JSXAttribute | JSXIdentifier | JSXNamespacedName | JSXExpressionContainer | JSXElement | JSXFragment | JSXMemberExpression | JSXSpreadAttribute | JSXEmptyExpression | JSXText | JSXSpreadChild | JSXOpeningElement | JSXClosingElement | JSXOpeningFragment | JSXClosingFragment | TypeParameterDeclaration | TSTypeParameterDeclaration | TypeParameterInstantiation | TSTypeParameterInstantiation | ClassImplements | TSExpressionWithTypeArguments | AnyTypeAnnotation | EmptyTypeAnnotation | MixedTypeAnnotation | VoidTypeAnnotation | SymbolTypeAnnotation | NumberTypeAnnotation | BigIntTypeAnnotation | NumberLiteralTypeAnnotation | NumericLiteralTypeAnnotation | BigIntLiteralTypeAnnotation | StringTypeAnnotation | StringLiteralTypeAnnotation | BooleanTypeAnnotation | BooleanLiteralTypeAnnotation | NullableTypeAnnotation | NullLiteralTypeAnnotation | NullTypeAnnotation | ThisTypeAnnotation | ExistsTypeAnnotation | ExistentialTypeParam | FunctionTypeAnnotation | FunctionTypeParam | ArrayTypeAnnotation | ObjectTypeAnnotation | ObjectTypeProperty | ObjectTypeSpreadProperty | ObjectTypeIndexer | ObjectTypeCallProperty | ObjectTypeInternalSlot | Variance | QualifiedTypeIdentifier | GenericTypeAnnotation | MemberTypeAnnotation | IndexedAccessType | OptionalIndexedAccessType | UnionTypeAnnotation | IntersectionTypeAnnotation | TypeofTypeAnnotation | TypeParameter | InterfaceTypeAnnotation | InterfaceExtends | InterfaceDeclaration | DeclareInterface | TypeAlias | DeclareTypeAlias | OpaqueType | DeclareOpaqueType | TypeCastExpression | TupleTypeAnnotation | DeclareVariable | DeclareFunction | DeclareClass | DeclareModule | DeclareModuleExports | DeclareExportDeclaration | ExportBatchSpecifier | DeclareExportAllDeclaration | InferredPredicate | DeclaredPredicate | EnumDeclaration | EnumBooleanBody | EnumNumberBody | EnumStringBody | EnumSymbolBody | EnumBooleanMember | EnumNumberMember | EnumStringMember | EnumDefaultedMember | ExportDeclaration | Block | Line | Noop | DoExpression | BindExpression | ParenthesizedExpression | ExportNamespaceSpecifier | ExportDefaultSpecifier | CommentBlock | CommentLine | Directive | DirectiveLiteral | InterpreterDirective | StringLiteral | NumericLiteral | BigIntLiteral | DecimalLiteral | NullLiteral | BooleanLiteral | RegExpLiteral | ClassMethod | ClassPrivateMethod | ClassAccessorProperty | RestProperty | ForAwaitStatement | Import | V8IntrinsicIdentifier | TopicReference | TSQualifiedName | TSTypeReference | TSAsExpression | TSTypeCastExpression | TSSatisfiesExpression | TSNonNullExpression | TSAnyKeyword | TSBigIntKeyword | TSBooleanKeyword | TSNeverKeyword | TSNullKeyword | TSNumberKeyword | TSObjectKeyword | TSStringKeyword | TSSymbolKeyword | TSUndefinedKeyword | TSUnknownKeyword | TSVoidKeyword | TSIntrinsicKeyword | TSThisType | TSArrayType | TSLiteralType | TSUnionType | TSIntersectionType | TSConditionalType | TSInferType | TSTypeParameter | TSParenthesizedType | TSFunctionType | TSConstructorType | TSDeclareFunction | TSDeclareMethod | TSMappedType | TSTupleType | TSNamedTupleMember | TSRestType | TSOptionalType | TSIndexedAccessType | TSTypeOperator | TSIndexSignature | TSPropertySignature | TSMethodSignature | TSTypePredicate | TSCallSignatureDeclaration | TSConstructSignatureDeclaration | TSEnumMember | TSTypeQuery | TSImportType | TSTypeLiteral | TSTypeAssertion | TSInstantiationExpression | TSEnumDeclaration | TSTypeAliasDeclaration | TSModuleBlock | TSModuleDeclaration | TSImportEqualsDeclaration | TSExternalModuleReference | TSExportAssignment | TSNamespaceExportDeclaration | TSInterfaceBody | TSInterfaceDeclaration | TSParameterProperty;
  export let Printable: Type<Printable>;
  export let SourceLocation: Type<SourceLocation>;
  export let Node: Type<Node>;
  export let Comment: Type<Comment>;
  export let Position: Type<Position>;
  export let File: Type<File>;
  export let Program: Type<Program>;
  export let Statement: Type<Statement>;
  export let Function: Type<Function>;
  export let Expression: Type<Expression>;
  export let Pattern: Type<Pattern>;
  export let Identifier: Type<Identifier>;
  export let BlockStatement: Type<BlockStatement>;
  export let EmptyStatement: Type<EmptyStatement>;
  export let ExpressionStatement: Type<ExpressionStatement>;
  export let IfStatement: Type<IfStatement>;
  export let LabeledStatement: Type<LabeledStatement>;
  export let BreakStatement: Type<BreakStatement>;
  export let ContinueStatement: Type<ContinueStatement>;
  export let WithStatement: Type<WithStatement>;
  export let SwitchStatement: Type<SwitchStatement>;
  export let SwitchCase: Type<SwitchCase>;
  export let ReturnStatement: Type<ReturnStatement>;
  export let ThrowStatement: Type<ThrowStatement>;
  export let TryStatement: Type<TryStatement>;
  export let CatchClause: Type<CatchClause>;
  export let WhileStatement: Type<WhileStatement>;
  export let DoWhileStatement: Type<DoWhileStatement>;
  export let ForStatement: Type<ForStatement>;
  export let Declaration: Type<Declaration>;
  export let VariableDeclaration: Type<VariableDeclaration>;
  export let ForInStatement: Type<ForInStatement>;
  export let DebuggerStatement: Type<DebuggerStatement>;
  export let FunctionDeclaration: Type<FunctionDeclaration>;
  export let FunctionExpression: Type<FunctionExpression>;
  export let VariableDeclarator: Type<VariableDeclarator>;
  export let ThisExpression: Type<ThisExpression>;
  export let ArrayExpression: Type<ArrayExpression>;
  export let ObjectExpression: Type<ObjectExpression>;
  export let Property: Type<Property>;
  export let Literal: Type<Literal>;
  export let SequenceExpression: Type<SequenceExpression>;
  export let UnaryExpression: Type<UnaryExpression>;
  export let BinaryExpression: Type<BinaryExpression>;
  export let AssignmentExpression: Type<AssignmentExpression>;
  export let ChainElement: Type<ChainElement>;
  export let MemberExpression: Type<MemberExpression>;
  export let UpdateExpression: Type<UpdateExpression>;
  export let LogicalExpression: Type<LogicalExpression>;
  export let ConditionalExpression: Type<ConditionalExpression>;
  export let NewExpression: Type<NewExpression>;
  export let CallExpression: Type<CallExpression>;
  export let RestElement: Type<RestElement>;
  export let TypeAnnotation: Type<TypeAnnotation>;
  export let TSTypeAnnotation: Type<TSTypeAnnotation>;
  export let SpreadElementPattern: Type<SpreadElementPattern>;
  export let ArrowFunctionExpression: Type<ArrowFunctionExpression>;
  export let ForOfStatement: Type<ForOfStatement>;
  export let YieldExpression: Type<YieldExpression>;
  export let GeneratorExpression: Type<GeneratorExpression>;
  export let ComprehensionBlock: Type<ComprehensionBlock>;
  export let ComprehensionExpression: Type<ComprehensionExpression>;
  export let ObjectProperty: Type<ObjectProperty>;
  export let PropertyPattern: Type<PropertyPattern>;
  export let ObjectPattern: Type<ObjectPattern>;
  export let ArrayPattern: Type<ArrayPattern>;
  export let SpreadElement: Type<SpreadElement>;
  export let AssignmentPattern: Type<AssignmentPattern>;
  export let MethodDefinition: Type<MethodDefinition>;
  export let ClassPropertyDefinition: Type<ClassPropertyDefinition>;
  export let ClassProperty: Type<ClassProperty>;
  export let StaticBlock: Type<StaticBlock>;
  export let ClassBody: Type<ClassBody>;
  export let ClassDeclaration: Type<ClassDeclaration>;
  export let ClassExpression: Type<ClassExpression>;
  export let Super: Type<Super>;
  export let Specifier: Type<Specifier>;
  export let ModuleSpecifier: Type<ModuleSpecifier>;
  export let ImportSpecifier: Type<ImportSpecifier>;
  export let ImportDefaultSpecifier: Type<ImportDefaultSpecifier>;
  export let ImportNamespaceSpecifier: Type<ImportNamespaceSpecifier>;
  export let ImportDeclaration: Type<ImportDeclaration>;
  export let ExportNamedDeclaration: Type<ExportNamedDeclaration>;
  export let ExportSpecifier: Type<ExportSpecifier>;
  export let ExportDefaultDeclaration: Type<ExportDefaultDeclaration>;
  export let ExportAllDeclaration: Type<ExportAllDeclaration>;
  export let TaggedTemplateExpression: Type<TaggedTemplateExpression>;
  export let TemplateLiteral: Type<TemplateLiteral>;
  export let TemplateElement: Type<TemplateElement>;
  export let MetaProperty: Type<MetaProperty>;
  export let AwaitExpression: Type<AwaitExpression>;
  export let SpreadProperty: Type<SpreadProperty>;
  export let SpreadPropertyPattern: Type<SpreadPropertyPattern>;
  export let ImportExpression: Type<ImportExpression>;
  export let ChainExpression: Type<ChainExpression>;
  export let OptionalCallExpression: Type<OptionalCallExpression>;
  export let OptionalMemberExpression: Type<OptionalMemberExpression>;
  export let Decorator: Type<Decorator>;
  export let PrivateName: Type<PrivateName>;
  export let ClassPrivateProperty: Type<ClassPrivateProperty>;
  export let ImportAttribute: Type<ImportAttribute>;
  export let RecordExpression: Type<RecordExpression>;
  export let ObjectMethod: Type<ObjectMethod>;
  export let TupleExpression: Type<TupleExpression>;
  export let ModuleExpression: Type<ModuleExpression>;
  export let JSXAttribute: Type<JSXAttribute>;
  export let JSXIdentifier: Type<JSXIdentifier>;
  export let JSXNamespacedName: Type<JSXNamespacedName>;
  export let JSXExpressionContainer: Type<JSXExpressionContainer>;
  export let JSXElement: Type<JSXElement>;
  export let JSXFragment: Type<JSXFragment>;
  export let JSXMemberExpression: Type<JSXMemberExpression>;
  export let JSXSpreadAttribute: Type<JSXSpreadAttribute>;
  export let JSXEmptyExpression: Type<JSXEmptyExpression>;
  export let JSXText: Type<JSXText>;
  export let JSXSpreadChild: Type<JSXSpreadChild>;
  export let JSXOpeningElement: Type<JSXOpeningElement>;
  export let JSXClosingElement: Type<JSXClosingElement>;
  export let JSXOpeningFragment: Type<JSXOpeningFragment>;
  export let JSXClosingFragment: Type<JSXClosingFragment>;
  export let TypeParameterDeclaration: Type<TypeParameterDeclaration>;
  export let TSTypeParameterDeclaration: Type<TSTypeParameterDeclaration>;
  export let TypeParameterInstantiation: Type<TypeParameterInstantiation>;
  export let TSTypeParameterInstantiation: Type<TSTypeParameterInstantiation>;
  export let ClassImplements: Type<ClassImplements>;
  export let TSType: Type<TSType>;
  export let TSHasOptionalTypeParameterInstantiation: Type<TSHasOptionalTypeParameterInstantiation>;
  export let TSExpressionWithTypeArguments: Type<TSExpressionWithTypeArguments>;
  export let Flow: Type<Flow>;
  export let FlowType: Type<FlowType>;
  export let AnyTypeAnnotation: Type<AnyTypeAnnotation>;
  export let EmptyTypeAnnotation: Type<EmptyTypeAnnotation>;
  export let MixedTypeAnnotation: Type<MixedTypeAnnotation>;
  export let VoidTypeAnnotation: Type<VoidTypeAnnotation>;
  export let SymbolTypeAnnotation: Type<SymbolTypeAnnotation>;
  export let NumberTypeAnnotation: Type<NumberTypeAnnotation>;
  export let BigIntTypeAnnotation: Type<BigIntTypeAnnotation>;
  export let NumberLiteralTypeAnnotation: Type<NumberLiteralTypeAnnotation>;
  export let NumericLiteralTypeAnnotation: Type<NumericLiteralTypeAnnotation>;
  export let BigIntLiteralTypeAnnotation: Type<BigIntLiteralTypeAnnotation>;
  export let StringTypeAnnotation: Type<StringTypeAnnotation>;
  export let StringLiteralTypeAnnotation: Type<StringLiteralTypeAnnotation>;
  export let BooleanTypeAnnotation: Type<BooleanTypeAnnotation>;
  export let BooleanLiteralTypeAnnotation: Type<BooleanLiteralTypeAnnotation>;
  export let NullableTypeAnnotation: Type<NullableTypeAnnotation>;
  export let NullLiteralTypeAnnotation: Type<NullLiteralTypeAnnotation>;
  export let NullTypeAnnotation: Type<NullTypeAnnotation>;
  export let ThisTypeAnnotation: Type<ThisTypeAnnotation>;
  export let ExistsTypeAnnotation: Type<ExistsTypeAnnotation>;
  export let ExistentialTypeParam: Type<ExistentialTypeParam>;
  export let FunctionTypeAnnotation: Type<FunctionTypeAnnotation>;
  export let FunctionTypeParam: Type<FunctionTypeParam>;
  export let ArrayTypeAnnotation: Type<ArrayTypeAnnotation>;
  export let ObjectTypeAnnotation: Type<ObjectTypeAnnotation>;
  export let ObjectTypeProperty: Type<ObjectTypeProperty>;
  export let ObjectTypeSpreadProperty: Type<ObjectTypeSpreadProperty>;
  export let ObjectTypeIndexer: Type<ObjectTypeIndexer>;
  export let ObjectTypeCallProperty: Type<ObjectTypeCallProperty>;
  export let ObjectTypeInternalSlot: Type<ObjectTypeInternalSlot>;
  export let Variance: Type<Variance>;
  export let QualifiedTypeIdentifier: Type<QualifiedTypeIdentifier>;
  export let GenericTypeAnnotation: Type<GenericTypeAnnotation>;
  export let MemberTypeAnnotation: Type<MemberTypeAnnotation>;
  export let IndexedAccessType: Type<IndexedAccessType>;
  export let OptionalIndexedAccessType: Type<OptionalIndexedAccessType>;
  export let UnionTypeAnnotation: Type<UnionTypeAnnotation>;
  export let IntersectionTypeAnnotation: Type<IntersectionTypeAnnotation>;
  export let TypeofTypeAnnotation: Type<TypeofTypeAnnotation>;
  export let TypeParameter: Type<TypeParameter>;
  export let InterfaceTypeAnnotation: Type<InterfaceTypeAnnotation>;
  export let InterfaceExtends: Type<InterfaceExtends>;
  export let InterfaceDeclaration: Type<InterfaceDeclaration>;
  export let DeclareInterface: Type<DeclareInterface>;
  export let TypeAlias: Type<TypeAlias>;
  export let DeclareTypeAlias: Type<DeclareTypeAlias>;
  export let OpaqueType: Type<OpaqueType>;
  export let DeclareOpaqueType: Type<DeclareOpaqueType>;
  export let TypeCastExpression: Type<TypeCastExpression>;
  export let TupleTypeAnnotation: Type<TupleTypeAnnotation>;
  export let DeclareVariable: Type<DeclareVariable>;
  export let DeclareFunction: Type<DeclareFunction>;
  export let FlowPredicate: Type<FlowPredicate>;
  export let DeclareClass: Type<DeclareClass>;
  export let DeclareModule: Type<DeclareModule>;
  export let DeclareModuleExports: Type<DeclareModuleExports>;
  export let DeclareExportDeclaration: Type<DeclareExportDeclaration>;
  export let ExportBatchSpecifier: Type<ExportBatchSpecifier>;
  export let DeclareExportAllDeclaration: Type<DeclareExportAllDeclaration>;
  export let InferredPredicate: Type<InferredPredicate>;
  export let DeclaredPredicate: Type<DeclaredPredicate>;
  export let EnumDeclaration: Type<EnumDeclaration>;
  export let EnumBooleanBody: Type<EnumBooleanBody>;
  export let EnumNumberBody: Type<EnumNumberBody>;
  export let EnumStringBody: Type<EnumStringBody>;
  export let EnumSymbolBody: Type<EnumSymbolBody>;
  export let EnumBooleanMember: Type<EnumBooleanMember>;
  export let EnumNumberMember: Type<EnumNumberMember>;
  export let EnumStringMember: Type<EnumStringMember>;
  export let EnumDefaultedMember: Type<EnumDefaultedMember>;
  export let ExportDeclaration: Type<ExportDeclaration>;
  export let Block: Type<Block>;
  export let Line: Type<Line>;
  export let Noop: Type<Noop>;
  export let DoExpression: Type<DoExpression>;
  export let BindExpression: Type<BindExpression>;
  export let ParenthesizedExpression: Type<ParenthesizedExpression>;
  export let ExportNamespaceSpecifier: Type<ExportNamespaceSpecifier>;
  export let ExportDefaultSpecifier: Type<ExportDefaultSpecifier>;
  export let CommentBlock: Type<CommentBlock>;
  export let CommentLine: Type<CommentLine>;
  export let Directive: Type<Directive>;
  export let DirectiveLiteral: Type<DirectiveLiteral>;
  export let InterpreterDirective: Type<InterpreterDirective>;
  export let StringLiteral: Type<StringLiteral>;
  export let NumericLiteral: Type<NumericLiteral>;
  export let BigIntLiteral: Type<BigIntLiteral>;
  export let DecimalLiteral: Type<DecimalLiteral>;
  export let NullLiteral: Type<NullLiteral>;
  export let BooleanLiteral: Type<BooleanLiteral>;
  export let RegExpLiteral: Type<RegExpLiteral>;
  export let ClassMethod: Type<ClassMethod>;
  export let ClassPrivateMethod: Type<ClassPrivateMethod>;
  export let TSHasOptionalTypeAnnotation: Type<TSHasOptionalTypeAnnotation>;
  export let ClassAccessorProperty: Type<ClassAccessorProperty>;
  export let RestProperty: Type<RestProperty>;
  export let ForAwaitStatement: Type<ForAwaitStatement>;
  export let Import: Type<Import>;
  export let V8IntrinsicIdentifier: Type<V8IntrinsicIdentifier>;
  export let TopicReference: Type<TopicReference>;
  export let TSQualifiedName: Type<TSQualifiedName>;
  export let TSTypeReference: Type<TSTypeReference>;
  export let TSHasOptionalTypeParameters: Type<TSHasOptionalTypeParameters>;
  export let TSAsExpression: Type<TSAsExpression>;
  export let TSTypeCastExpression: Type<TSTypeCastExpression>;
  export let TSSatisfiesExpression: Type<TSSatisfiesExpression>;
  export let TSNonNullExpression: Type<TSNonNullExpression>;
  export let TSAnyKeyword: Type<TSAnyKeyword>;
  export let TSBigIntKeyword: Type<TSBigIntKeyword>;
  export let TSBooleanKeyword: Type<TSBooleanKeyword>;
  export let TSNeverKeyword: Type<TSNeverKeyword>;
  export let TSNullKeyword: Type<TSNullKeyword>;
  export let TSNumberKeyword: Type<TSNumberKeyword>;
  export let TSObjectKeyword: Type<TSObjectKeyword>;
  export let TSStringKeyword: Type<TSStringKeyword>;
  export let TSSymbolKeyword: Type<TSSymbolKeyword>;
  export let TSUndefinedKeyword: Type<TSUndefinedKeyword>;
  export let TSUnknownKeyword: Type<TSUnknownKeyword>;
  export let TSVoidKeyword: Type<TSVoidKeyword>;
  export let TSIntrinsicKeyword: Type<TSIntrinsicKeyword>;
  export let TSThisType: Type<TSThisType>;
  export let TSArrayType: Type<TSArrayType>;
  export let TSLiteralType: Type<TSLiteralType>;
  export let TSUnionType: Type<TSUnionType>;
  export let TSIntersectionType: Type<TSIntersectionType>;
  export let TSConditionalType: Type<TSConditionalType>;
  export let TSInferType: Type<TSInferType>;
  export let TSTypeParameter: Type<TSTypeParameter>;
  export let TSParenthesizedType: Type<TSParenthesizedType>;
  export let TSFunctionType: Type<TSFunctionType>;
  export let TSConstructorType: Type<TSConstructorType>;
  export let TSDeclareFunction: Type<TSDeclareFunction>;
  export let TSDeclareMethod: Type<TSDeclareMethod>;
  export let TSMappedType: Type<TSMappedType>;
  export let TSTupleType: Type<TSTupleType>;
  export let TSNamedTupleMember: Type<TSNamedTupleMember>;
  export let TSRestType: Type<TSRestType>;
  export let TSOptionalType: Type<TSOptionalType>;
  export let TSIndexedAccessType: Type<TSIndexedAccessType>;
  export let TSTypeOperator: Type<TSTypeOperator>;
  export let TSIndexSignature: Type<TSIndexSignature>;
  export let TSPropertySignature: Type<TSPropertySignature>;
  export let TSMethodSignature: Type<TSMethodSignature>;
  export let TSTypePredicate: Type<TSTypePredicate>;
  export let TSCallSignatureDeclaration: Type<TSCallSignatureDeclaration>;
  export let TSConstructSignatureDeclaration: Type<TSConstructSignatureDeclaration>;
  export let TSEnumMember: Type<TSEnumMember>;
  export let TSTypeQuery: Type<TSTypeQuery>;
  export let TSImportType: Type<TSImportType>;
  export let TSTypeLiteral: Type<TSTypeLiteral>;
  export let TSTypeAssertion: Type<TSTypeAssertion>;
  export let TSInstantiationExpression: Type<TSInstantiationExpression>;
  export let TSEnumDeclaration: Type<TSEnumDeclaration>;
  export let TSTypeAliasDeclaration: Type<TSTypeAliasDeclaration>;
  export let TSModuleBlock: Type<TSModuleBlock>;
  export let TSModuleDeclaration: Type<TSModuleDeclaration>;
  export let TSImportEqualsDeclaration: Type<TSImportEqualsDeclaration>;
  export let TSExternalModuleReference: Type<TSExternalModuleReference>;
  export let TSExportAssignment: Type<TSExportAssignment>;
  export let TSNamespaceExportDeclaration: Type<TSNamespaceExportDeclaration>;
  export let TSInterfaceBody: Type<TSInterfaceBody>;
  export let TSInterfaceDeclaration: Type<TSInterfaceDeclaration>;
  export let TSParameterProperty: Type<TSParameterProperty>;
}

export interface NamedTypes {
  Printable: Type<namedTypes.Printable>;
  SourceLocation: Type<namedTypes.SourceLocation>;
  Node: Type<namedTypes.Node>;
  Comment: Type<namedTypes.Comment>;
  Position: Type<namedTypes.Position>;
  File: Type<namedTypes.File>;
  Program: Type<namedTypes.Program>;
  Statement: Type<namedTypes.Statement>;
  Function: Type<namedTypes.Function>;
  Expression: Type<namedTypes.Expression>;
  Pattern: Type<namedTypes.Pattern>;
  Identifier: Type<namedTypes.Identifier>;
  BlockStatement: Type<namedTypes.BlockStatement>;
  EmptyStatement: Type<namedTypes.EmptyStatement>;
  ExpressionStatement: Type<namedTypes.ExpressionStatement>;
  IfStatement: Type<namedTypes.IfStatement>;
  LabeledStatement: Type<namedTypes.LabeledStatement>;
  BreakStatement: Type<namedTypes.BreakStatement>;
  ContinueStatement: Type<namedTypes.ContinueStatement>;
  WithStatement: Type<namedTypes.WithStatement>;
  SwitchStatement: Type<namedTypes.SwitchStatement>;
  SwitchCase: Type<namedTypes.SwitchCase>;
  ReturnStatement: Type<namedTypes.ReturnStatement>;
  ThrowStatement: Type<namedTypes.ThrowStatement>;
  TryStatement: Type<namedTypes.TryStatement>;
  CatchClause: Type<namedTypes.CatchClause>;
  WhileStatement: Type<namedTypes.WhileStatement>;
  DoWhileStatement: Type<namedTypes.DoWhileStatement>;
  ForStatement: Type<namedTypes.ForStatement>;
  Declaration: Type<namedTypes.Declaration>;
  VariableDeclaration: Type<namedTypes.VariableDeclaration>;
  ForInStatement: Type<namedTypes.ForInStatement>;
  DebuggerStatement: Type<namedTypes.DebuggerStatement>;
  FunctionDeclaration: Type<namedTypes.FunctionDeclaration>;
  FunctionExpression: Type<namedTypes.FunctionExpression>;
  VariableDeclarator: Type<namedTypes.VariableDeclarator>;
  ThisExpression: Type<namedTypes.ThisExpression>;
  ArrayExpression: Type<namedTypes.ArrayExpression>;
  ObjectExpression: Type<namedTypes.ObjectExpression>;
  Property: Type<namedTypes.Property>;
  Literal: Type<namedTypes.Literal>;
  SequenceExpression: Type<namedTypes.SequenceExpression>;
  UnaryExpression: Type<namedTypes.UnaryExpression>;
  BinaryExpression: Type<namedTypes.BinaryExpression>;
  AssignmentExpression: Type<namedTypes.AssignmentExpression>;
  ChainElement: Type<namedTypes.ChainElement>;
  MemberExpression: Type<namedTypes.MemberExpression>;
  UpdateExpression: Type<namedTypes.UpdateExpression>;
  LogicalExpression: Type<namedTypes.LogicalExpression>;
  ConditionalExpression: Type<namedTypes.ConditionalExpression>;
  NewExpression: Type<namedTypes.NewExpression>;
  CallExpression: Type<namedTypes.CallExpression>;
  RestElement: Type<namedTypes.RestElement>;
  TypeAnnotation: Type<namedTypes.TypeAnnotation>;
  TSTypeAnnotation: Type<namedTypes.TSTypeAnnotation>;
  SpreadElementPattern: Type<namedTypes.SpreadElementPattern>;
  ArrowFunctionExpression: Type<namedTypes.ArrowFunctionExpression>;
  ForOfStatement: Type<namedTypes.ForOfStatement>;
  YieldExpression: Type<namedTypes.YieldExpression>;
  GeneratorExpression: Type<namedTypes.GeneratorExpression>;
  ComprehensionBlock: Type<namedTypes.ComprehensionBlock>;
  ComprehensionExpression: Type<namedTypes.ComprehensionExpression>;
  ObjectProperty: Type<namedTypes.ObjectProperty>;
  PropertyPattern: Type<namedTypes.PropertyPattern>;
  ObjectPattern: Type<namedTypes.ObjectPattern>;
  ArrayPattern: Type<namedTypes.ArrayPattern>;
  SpreadElement: Type<namedTypes.SpreadElement>;
  AssignmentPattern: Type<namedTypes.AssignmentPattern>;
  MethodDefinition: Type<namedTypes.MethodDefinition>;
  ClassPropertyDefinition: Type<namedTypes.ClassPropertyDefinition>;
  ClassProperty: Type<namedTypes.ClassProperty>;
  StaticBlock: Type<namedTypes.StaticBlock>;
  ClassBody: Type<namedTypes.ClassBody>;
  ClassDeclaration: Type<namedTypes.ClassDeclaration>;
  ClassExpression: Type<namedTypes.ClassExpression>;
  Super: Type<namedTypes.Super>;
  Specifier: Type<namedTypes.Specifier>;
  ModuleSpecifier: Type<namedTypes.ModuleSpecifier>;
  ImportSpecifier: Type<namedTypes.ImportSpecifier>;
  ImportDefaultSpecifier: Type<namedTypes.ImportDefaultSpecifier>;
  ImportNamespaceSpecifier: Type<namedTypes.ImportNamespaceSpecifier>;
  ImportDeclaration: Type<namedTypes.ImportDeclaration>;
  ExportNamedDeclaration: Type<namedTypes.ExportNamedDeclaration>;
  ExportSpecifier: Type<namedTypes.ExportSpecifier>;
  ExportDefaultDeclaration: Type<namedTypes.ExportDefaultDeclaration>;
  ExportAllDeclaration: Type<namedTypes.ExportAllDeclaration>;
  TaggedTemplateExpression: Type<namedTypes.TaggedTemplateExpression>;
  TemplateLiteral: Type<namedTypes.TemplateLiteral>;
  TemplateElement: Type<namedTypes.TemplateElement>;
  MetaProperty: Type<namedTypes.MetaProperty>;
  AwaitExpression: Type<namedTypes.AwaitExpression>;
  SpreadProperty: Type<namedTypes.SpreadProperty>;
  SpreadPropertyPattern: Type<namedTypes.SpreadPropertyPattern>;
  ImportExpression: Type<namedTypes.ImportExpression>;
  ChainExpression: Type<namedTypes.ChainExpression>;
  OptionalCallExpression: Type<namedTypes.OptionalCallExpression>;
  OptionalMemberExpression: Type<namedTypes.OptionalMemberExpression>;
  Decorator: Type<namedTypes.Decorator>;
  PrivateName: Type<namedTypes.PrivateName>;
  ClassPrivateProperty: Type<namedTypes.ClassPrivateProperty>;
  ImportAttribute: Type<namedTypes.ImportAttribute>;
  RecordExpression: Type<namedTypes.RecordExpression>;
  ObjectMethod: Type<namedTypes.ObjectMethod>;
  TupleExpression: Type<namedTypes.TupleExpression>;
  ModuleExpression: Type<namedTypes.ModuleExpression>;
  JSXAttribute: Type<namedTypes.JSXAttribute>;
  JSXIdentifier: Type<namedTypes.JSXIdentifier>;
  JSXNamespacedName: Type<namedTypes.JSXNamespacedName>;
  JSXExpressionContainer: Type<namedTypes.JSXExpressionContainer>;
  JSXElement: Type<namedTypes.JSXElement>;
  JSXFragment: Type<namedTypes.JSXFragment>;
  JSXMemberExpression: Type<namedTypes.JSXMemberExpression>;
  JSXSpreadAttribute: Type<namedTypes.JSXSpreadAttribute>;
  JSXEmptyExpression: Type<namedTypes.JSXEmptyExpression>;
  JSXText: Type<namedTypes.JSXText>;
  JSXSpreadChild: Type<namedTypes.JSXSpreadChild>;
  JSXOpeningElement: Type<namedTypes.JSXOpeningElement>;
  JSXClosingElement: Type<namedTypes.JSXClosingElement>;
  JSXOpeningFragment: Type<namedTypes.JSXOpeningFragment>;
  JSXClosingFragment: Type<namedTypes.JSXClosingFragment>;
  TypeParameterDeclaration: Type<namedTypes.TypeParameterDeclaration>;
  TSTypeParameterDeclaration: Type<namedTypes.TSTypeParameterDeclaration>;
  TypeParameterInstantiation: Type<namedTypes.TypeParameterInstantiation>;
  TSTypeParameterInstantiation: Type<namedTypes.TSTypeParameterInstantiation>;
  ClassImplements: Type<namedTypes.ClassImplements>;
  TSType: Type<namedTypes.TSType>;
  TSHasOptionalTypeParameterInstantiation: Type<namedTypes.TSHasOptionalTypeParameterInstantiation>;
  TSExpressionWithTypeArguments: Type<namedTypes.TSExpressionWithTypeArguments>;
  Flow: Type<namedTypes.Flow>;
  FlowType: Type<namedTypes.FlowType>;
  AnyTypeAnnotation: Type<namedTypes.AnyTypeAnnotation>;
  EmptyTypeAnnotation: Type<namedTypes.EmptyTypeAnnotation>;
  MixedTypeAnnotation: Type<namedTypes.MixedTypeAnnotation>;
  VoidTypeAnnotation: Type<namedTypes.VoidTypeAnnotation>;
  SymbolTypeAnnotation: Type<namedTypes.SymbolTypeAnnotation>;
  NumberTypeAnnotation: Type<namedTypes.NumberTypeAnnotation>;
  BigIntTypeAnnotation: Type<namedTypes.BigIntTypeAnnotation>;
  NumberLiteralTypeAnnotation: Type<namedTypes.NumberLiteralTypeAnnotation>;
  NumericLiteralTypeAnnotation: Type<namedTypes.NumericLiteralTypeAnnotation>;
  BigIntLiteralTypeAnnotation: Type<namedTypes.BigIntLiteralTypeAnnotation>;
  StringTypeAnnotation: Type<namedTypes.StringTypeAnnotation>;
  StringLiteralTypeAnnotation: Type<namedTypes.StringLiteralTypeAnnotation>;
  BooleanTypeAnnotation: Type<namedTypes.BooleanTypeAnnotation>;
  BooleanLiteralTypeAnnotation: Type<namedTypes.BooleanLiteralTypeAnnotation>;
  NullableTypeAnnotation: Type<namedTypes.NullableTypeAnnotation>;
  NullLiteralTypeAnnotation: Type<namedTypes.NullLiteralTypeAnnotation>;
  NullTypeAnnotation: Type<namedTypes.NullTypeAnnotation>;
  ThisTypeAnnotation: Type<namedTypes.ThisTypeAnnotation>;
  ExistsTypeAnnotation: Type<namedTypes.ExistsTypeAnnotation>;
  ExistentialTypeParam: Type<namedTypes.ExistentialTypeParam>;
  FunctionTypeAnnotation: Type<namedTypes.FunctionTypeAnnotation>;
  FunctionTypeParam: Type<namedTypes.FunctionTypeParam>;
  ArrayTypeAnnotation: Type<namedTypes.ArrayTypeAnnotation>;
  ObjectTypeAnnotation: Type<namedTypes.ObjectTypeAnnotation>;
  ObjectTypeProperty: Type<namedTypes.ObjectTypeProperty>;
  ObjectTypeSpreadProperty: Type<namedTypes.ObjectTypeSpreadProperty>;
  ObjectTypeIndexer: Type<namedTypes.ObjectTypeIndexer>;
  ObjectTypeCallProperty: Type<namedTypes.ObjectTypeCallProperty>;
  ObjectTypeInternalSlot: Type<namedTypes.ObjectTypeInternalSlot>;
  Variance: Type<namedTypes.Variance>;
  QualifiedTypeIdentifier: Type<namedTypes.QualifiedTypeIdentifier>;
  GenericTypeAnnotation: Type<namedTypes.GenericTypeAnnotation>;
  MemberTypeAnnotation: Type<namedTypes.MemberTypeAnnotation>;
  IndexedAccessType: Type<namedTypes.IndexedAccessType>;
  OptionalIndexedAccessType: Type<namedTypes.OptionalIndexedAccessType>;
  UnionTypeAnnotation: Type<namedTypes.UnionTypeAnnotation>;
  IntersectionTypeAnnotation: Type<namedTypes.IntersectionTypeAnnotation>;
  TypeofTypeAnnotation: Type<namedTypes.TypeofTypeAnnotation>;
  TypeParameter: Type<namedTypes.TypeParameter>;
  InterfaceTypeAnnotation: Type<namedTypes.InterfaceTypeAnnotation>;
  InterfaceExtends: Type<namedTypes.InterfaceExtends>;
  InterfaceDeclaration: Type<namedTypes.InterfaceDeclaration>;
  DeclareInterface: Type<namedTypes.DeclareInterface>;
  TypeAlias: Type<namedTypes.TypeAlias>;
  DeclareTypeAlias: Type<namedTypes.DeclareTypeAlias>;
  OpaqueType: Type<namedTypes.OpaqueType>;
  DeclareOpaqueType: Type<namedTypes.DeclareOpaqueType>;
  TypeCastExpression: Type<namedTypes.TypeCastExpression>;
  TupleTypeAnnotation: Type<namedTypes.TupleTypeAnnotation>;
  DeclareVariable: Type<namedTypes.DeclareVariable>;
  DeclareFunction: Type<namedTypes.DeclareFunction>;
  FlowPredicate: Type<namedTypes.FlowPredicate>;
  DeclareClass: Type<namedTypes.DeclareClass>;
  DeclareModule: Type<namedTypes.DeclareModule>;
  DeclareModuleExports: Type<namedTypes.DeclareModuleExports>;
  DeclareExportDeclaration: Type<namedTypes.DeclareExportDeclaration>;
  ExportBatchSpecifier: Type<namedTypes.ExportBatchSpecifier>;
  DeclareExportAllDeclaration: Type<namedTypes.DeclareExportAllDeclaration>;
  InferredPredicate: Type<namedTypes.InferredPredicate>;
  DeclaredPredicate: Type<namedTypes.DeclaredPredicate>;
  EnumDeclaration: Type<namedTypes.EnumDeclaration>;
  EnumBooleanBody: Type<namedTypes.EnumBooleanBody>;
  EnumNumberBody: Type<namedTypes.EnumNumberBody>;
  EnumStringBody: Type<namedTypes.EnumStringBody>;
  EnumSymbolBody: Type<namedTypes.EnumSymbolBody>;
  EnumBooleanMember: Type<namedTypes.EnumBooleanMember>;
  EnumNumberMember: Type<namedTypes.EnumNumberMember>;
  EnumStringMember: Type<namedTypes.EnumStringMember>;
  EnumDefaultedMember: Type<namedTypes.EnumDefaultedMember>;
  ExportDeclaration: Type<namedTypes.ExportDeclaration>;
  Block: Type<namedTypes.Block>;
  Line: Type<namedTypes.Line>;
  Noop: Type<namedTypes.Noop>;
  DoExpression: Type<namedTypes.DoExpression>;
  BindExpression: Type<namedTypes.BindExpression>;
  ParenthesizedExpression: Type<namedTypes.ParenthesizedExpression>;
  ExportNamespaceSpecifier: Type<namedTypes.ExportNamespaceSpecifier>;
  ExportDefaultSpecifier: Type<namedTypes.ExportDefaultSpecifier>;
  CommentBlock: Type<namedTypes.CommentBlock>;
  CommentLine: Type<namedTypes.CommentLine>;
  Directive: Type<namedTypes.Directive>;
  DirectiveLiteral: Type<namedTypes.DirectiveLiteral>;
  InterpreterDirective: Type<namedTypes.InterpreterDirective>;
  StringLiteral: Type<namedTypes.StringLiteral>;
  NumericLiteral: Type<namedTypes.NumericLiteral>;
  BigIntLiteral: Type<namedTypes.BigIntLiteral>;
  DecimalLiteral: Type<namedTypes.DecimalLiteral>;
  NullLiteral: Type<namedTypes.NullLiteral>;
  BooleanLiteral: Type<namedTypes.BooleanLiteral>;
  RegExpLiteral: Type<namedTypes.RegExpLiteral>;
  ClassMethod: Type<namedTypes.ClassMethod>;
  ClassPrivateMethod: Type<namedTypes.ClassPrivateMethod>;
  TSHasOptionalTypeAnnotation: Type<namedTypes.TSHasOptionalTypeAnnotation>;
  ClassAccessorProperty: Type<namedTypes.ClassAccessorProperty>;
  RestProperty: Type<namedTypes.RestProperty>;
  ForAwaitStatement: Type<namedTypes.ForAwaitStatement>;
  Import: Type<namedTypes.Import>;
  V8IntrinsicIdentifier: Type<namedTypes.V8IntrinsicIdentifier>;
  TopicReference: Type<namedTypes.TopicReference>;
  TSQualifiedName: Type<namedTypes.TSQualifiedName>;
  TSTypeReference: Type<namedTypes.TSTypeReference>;
  TSHasOptionalTypeParameters: Type<namedTypes.TSHasOptionalTypeParameters>;
  TSAsExpression: Type<namedTypes.TSAsExpression>;
  TSTypeCastExpression: Type<namedTypes.TSTypeCastExpression>;
  TSSatisfiesExpression: Type<namedTypes.TSSatisfiesExpression>;
  TSNonNullExpression: Type<namedTypes.TSNonNullExpression>;
  TSAnyKeyword: Type<namedTypes.TSAnyKeyword>;
  TSBigIntKeyword: Type<namedTypes.TSBigIntKeyword>;
  TSBooleanKeyword: Type<namedTypes.TSBooleanKeyword>;
  TSNeverKeyword: Type<namedTypes.TSNeverKeyword>;
  TSNullKeyword: Type<namedTypes.TSNullKeyword>;
  TSNumberKeyword: Type<namedTypes.TSNumberKeyword>;
  TSObjectKeyword: Type<namedTypes.TSObjectKeyword>;
  TSStringKeyword: Type<namedTypes.TSStringKeyword>;
  TSSymbolKeyword: Type<namedTypes.TSSymbolKeyword>;
  TSUndefinedKeyword: Type<namedTypes.TSUndefinedKeyword>;
  TSUnknownKeyword: Type<namedTypes.TSUnknownKeyword>;
  TSVoidKeyword: Type<namedTypes.TSVoidKeyword>;
  TSIntrinsicKeyword: Type<namedTypes.TSIntrinsicKeyword>;
  TSThisType: Type<namedTypes.TSThisType>;
  TSArrayType: Type<namedTypes.TSArrayType>;
  TSLiteralType: Type<namedTypes.TSLiteralType>;
  TSUnionType: Type<namedTypes.TSUnionType>;
  TSIntersectionType: Type<namedTypes.TSIntersectionType>;
  TSConditionalType: Type<namedTypes.TSConditionalType>;
  TSInferType: Type<namedTypes.TSInferType>;
  TSTypeParameter: Type<namedTypes.TSTypeParameter>;
  TSParenthesizedType: Type<namedTypes.TSParenthesizedType>;
  TSFunctionType: Type<namedTypes.TSFunctionType>;
  TSConstructorType: Type<namedTypes.TSConstructorType>;
  TSDeclareFunction: Type<namedTypes.TSDeclareFunction>;
  TSDeclareMethod: Type<namedTypes.TSDeclareMethod>;
  TSMappedType: Type<namedTypes.TSMappedType>;
  TSTupleType: Type<namedTypes.TSTupleType>;
  TSNamedTupleMember: Type<namedTypes.TSNamedTupleMember>;
  TSRestType: Type<namedTypes.TSRestType>;
  TSOptionalType: Type<namedTypes.TSOptionalType>;
  TSIndexedAccessType: Type<namedTypes.TSIndexedAccessType>;
  TSTypeOperator: Type<namedTypes.TSTypeOperator>;
  TSIndexSignature: Type<namedTypes.TSIndexSignature>;
  TSPropertySignature: Type<namedTypes.TSPropertySignature>;
  TSMethodSignature: Type<namedTypes.TSMethodSignature>;
  TSTypePredicate: Type<namedTypes.TSTypePredicate>;
  TSCallSignatureDeclaration: Type<namedTypes.TSCallSignatureDeclaration>;
  TSConstructSignatureDeclaration: Type<namedTypes.TSConstructSignatureDeclaration>;
  TSEnumMember: Type<namedTypes.TSEnumMember>;
  TSTypeQuery: Type<namedTypes.TSTypeQuery>;
  TSImportType: Type<namedTypes.TSImportType>;
  TSTypeLiteral: Type<namedTypes.TSTypeLiteral>;
  TSTypeAssertion: Type<namedTypes.TSTypeAssertion>;
  TSInstantiationExpression: Type<namedTypes.TSInstantiationExpression>;
  TSEnumDeclaration: Type<namedTypes.TSEnumDeclaration>;
  TSTypeAliasDeclaration: Type<namedTypes.TSTypeAliasDeclaration>;
  TSModuleBlock: Type<namedTypes.TSModuleBlock>;
  TSModuleDeclaration: Type<namedTypes.TSModuleDeclaration>;
  TSImportEqualsDeclaration: Type<namedTypes.TSImportEqualsDeclaration>;
  TSExternalModuleReference: Type<namedTypes.TSExternalModuleReference>;
  TSExportAssignment: Type<namedTypes.TSExportAssignment>;
  TSNamespaceExportDeclaration: Type<namedTypes.TSNamespaceExportDeclaration>;
  TSInterfaceBody: Type<namedTypes.TSInterfaceBody>;
  TSInterfaceDeclaration: Type<namedTypes.TSInterfaceDeclaration>;
  TSParameterProperty: Type<namedTypes.TSParameterProperty>;
}