```
${NVIM_VERSION}
```

## Install

### Windows

#### Zip

1. Download **nvim-win64.zip**
2. Extract the zip
3. Run `nvim.exe` on your CLI of choice

#### MSI

1. Download **nvim-win64.msi**
2. Run the MSI
3. Run `nvim.exe` on your CLI of choice

### macOS (x86_64)

1. Download **nvim-macos-x86_64.tar.gz**
2. Run `xattr -c ./nvim-macos-x86_64.tar.gz` (to avoid "unknown developer" warning)
3. Extract: `tar xzvf nvim-macos-x86_64.tar.gz`
4. Run `./nvim-macos-x86_64/bin/nvim`

### macOS (arm64)

1. Download **nvim-macos-arm64.tar.gz**
2. Run `xattr -c ./nvim-macos-arm64.tar.gz` (to avoid "unknown developer" warning)
3. Extract: `tar xzvf nvim-macos-arm64.tar.gz`
4. Run `./nvim-macos-arm64/bin/nvim`

### Linux (x86_64)

Minimum glibc version to run these releases is 2.31. People requiring releases
that work on older glibc versions can find them at
https://github.com/neovim/neovim-releases.

#### AppImage

1. Download **nvim-linux-x86_64.appimage**
2. Run `chmod u+x nvim-linux-x86_64.appimage && ./nvim-linux-x86_64.appimage`
   - If your system does not have FUSE you can [extract the appimage](https://github.com/AppImage/AppImageKit/wiki/FUSE#type-2-appimage):
     ```
     ./nvim-linux-x86_64.appimage --appimage-extract
     ./squashfs-root/usr/bin/nvim
     ```

#### Tarball

1. Download **nvim-linux-x86_64.tar.gz**
2. Extract: `tar xzvf nvim-linux-x86_64.tar.gz`
3. Run `./nvim-linux-x86_64/bin/nvim`

### Linux (arm64)

#### AppImage

1. Download **nvim-linux-arm64.appimage**
2. Run `chmod u+x nvim-linux-arm64.appimage && ./nvim-linux-arm64.appimage`
   - If your system does not have FUSE you can [extract the appimage](https://github.com/AppImage/AppImageKit/wiki/FUSE#type-2-appimage):
     ```
     ./nvim-linux-arm64.appimage --appimage-extract
     ./squashfs-root/usr/bin/nvim
     ```

#### Tarball

1. Download **nvim-linux-arm64.tar.gz**
2. Extract: `tar xzvf nvim-linux-arm64.tar.gz`
3. Run `./nvim-linux-arm64/bin/nvim`

### Other

- Install by [package manager](https://github.com/neovim/neovim/blob/master/INSTALL.md#install-from-package)

## SHA256 Checksums

```
${SHA_APPIMAGE_ARM64}
${SHA_APPIMAGE_ARM64_ZSYNC}
${SHA_LINUX_ARM64_TAR}
${SHA_APPIMAGE_X86_64}
${SHA_APPIMAGE_X86_64_ZSYNC}
${SHA_LINUX_X86_64_TAR}
${SHA_MACOS_ARM64}
${SHA_MACOS_X86_64}
${SHA_WIN_64_MSI}
${SHA_WIN_64_ZIP}
```
