/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.panel.address;

import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.manager.util.StateButton;
import com.jsql.view.swing.panel.PanelAddressBar;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActionStart
implements ActionListener {
    private static final Logger LOGGER = LogManager.getRootLogger();
    protected final PanelAddressBar panelAddressBar;

    public ActionStart(PanelAddressBar panelAddressBar) {
        this.panelAddressBar = panelAddressBar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.panelAddressBar.getPanelTrailingAddress().getButtonStart().getState() == StateButton.STARTABLE) {
            this.startInjection();
        } else if (this.panelAddressBar.getPanelTrailingAddress().getButtonStart().getState() == StateButton.STOPPABLE) {
            this.stopInjection();
        }
    }

    protected void startInjection() {
        int option = 0;
        if (MediatorHelper.model().shouldErasePreviousInjection()) {
            try {
                option = JOptionPane.showConfirmDialog(MediatorHelper.frame(), I18nUtil.valueByKey("DIALOG_NEW_INJECTION_TEXT"), I18nUtil.valueByKey("DIALOG_NEW_INJECTION_TITLE"), 2);
            }
            catch (ClassCastException | IllegalArgumentException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            }
        }
        if (option == 0) {
            this.panelAddressBar.getPanelTrailingAddress().getButtonStart().setToolTipText(I18nUtil.valueByKey("BUTTON_STOP_TOOLTIP"));
            this.panelAddressBar.getPanelTrailingAddress().getButtonStart().setInjectionRunning();
            this.panelAddressBar.getPanelTrailingAddress().getLoader().setVisible(true);
            MediatorHelper.frame().resetInterface();
            MediatorHelper.model().getMediatorUtils().getParameterUtil().controlInput(this.panelAddressBar.getTextFieldAddress().getText().trim(), this.panelAddressBar.getTextFieldRequest().getText().trim(), this.panelAddressBar.getTextFieldHeader().getText().trim(), this.panelAddressBar.getMethodInjection(), this.panelAddressBar.getTypeRequest(), false);
        }
    }

    private void stopInjection() {
        this.panelAddressBar.getPanelTrailingAddress().getLoader().setVisible(false);
        this.panelAddressBar.getPanelTrailingAddress().getButtonStart().setInjectionStopping();
        MediatorHelper.model().setIsStoppedByUser(true);
    }
}

