/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.console;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.console.SimpleConsoleAdapter;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="JTextPaneAppender", category="Core", elementType="appender", printObject=true)
public class JTextPaneAppender
extends AbstractAppender {
    private static SimpleConsoleAdapter consoleTextPane;
    private static SimpleConsoleAdapter javaTextPane;
    public static final SimpleAttributeSet ATTRIBUTE_WARN;
    public static final SimpleAttributeSet ATTRIBUTE_INFORM;
    public static final SimpleAttributeSet ATTRIBUTE_SUCCESS;
    public static final SimpleAttributeSet ATTRIBUTE_ALL;

    private JTextPaneAppender(String name, Layout<?> layout, Filter filter, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
    }

    @PluginFactory
    public static JTextPaneAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginElement(value="Layout") Layout layout, @PluginElement(value="Filters") Filter filter) {
        if (name == null) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, "No name provided for JTextPaneAppender");
            return null;
        }
        Layout layoutTextPane = Optional.ofNullable(layout).orElse(PatternLayout.createDefaultLayout());
        return new JTextPaneAppender(name, layoutTextPane, filter, ignoreExceptions);
    }

    @Override
    public void append(LogEvent event) {
        if (consoleTextPane == null || javaTextPane == null) {
            return;
        }
        String[] messageLogEvent = new String[]{new String(this.getLayout().toByteArray(event), StandardCharsets.UTF_8)};
        if (messageLogEvent.length == 0) {
            return;
        }
        int level = event.getLevel().intLevel();
        SwingUtilities.invokeLater(() -> {
            String message = messageLogEvent[0];
            if (level == LogLevelUtil.CONSOLE_JAVA.intLevel()) {
                javaTextPane.append(message, ATTRIBUTE_WARN);
            } else if (level == LogLevelUtil.CONSOLE_ERROR.intLevel()) {
                consoleTextPane.append(message, ATTRIBUTE_WARN);
            } else if (level == LogLevelUtil.CONSOLE_INFORM.intLevel()) {
                consoleTextPane.append(message, ATTRIBUTE_INFORM);
            } else if (level == LogLevelUtil.CONSOLE_SUCCESS.intLevel()) {
                consoleTextPane.append(message, ATTRIBUTE_SUCCESS);
            } else if (level != LogLevelUtil.IGNORE.intLevel() && level != Level.ERROR.intLevel()) {
                consoleTextPane.append(message, ATTRIBUTE_ALL);
            }
        });
    }

    public static void registerJavaConsole(SimpleConsoleAdapter javaConsole) {
        javaTextPane = javaConsole;
    }

    public static void register(SimpleConsoleAdapter consoleColored) {
        consoleTextPane = consoleColored;
    }

    static {
        ATTRIBUTE_WARN = new SimpleAttributeSet();
        ATTRIBUTE_INFORM = new SimpleAttributeSet();
        ATTRIBUTE_SUCCESS = new SimpleAttributeSet();
        ATTRIBUTE_ALL = new SimpleAttributeSet();
    }
}

