/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.exception.JSqlRuntimeException;
import com.jsql.util.LogLevelUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertiesUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final Properties properties = new Properties();

    public PropertiesUtil() {
        String filename = "config.properties";
        try (InputStream input = PropertiesUtil.class.getClassLoader().getResourceAsStream(filename);){
            if (input == null) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Properties file {} not found", (Object)filename);
                return;
            }
            this.properties.load(input);
        }
        catch (IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    public void displayStatus(Locale newLocale) {
        AtomicInteger countJvm = new AtomicInteger();
        String statusJvm = "";
        AtomicInteger countGui = new AtomicInteger();
        String statusGui = "";
        Properties propertiesRoot = PropertiesUtil.getProperties("i18n/jsql.properties");
        if (!Arrays.asList("", "en").contains(newLocale.getLanguage())) {
            Properties bundleUser = PropertiesUtil.getProperties("i18n/jsql_" + newLocale.getLanguage() + ".properties");
            propertiesRoot.entrySet().stream().filter(key -> bundleUser.isEmpty() || !bundleUser.containsKey(key.getKey())).forEach(key -> countGui.getAndIncrement());
            statusGui = String.format("gui %s %s%% %s", newLocale.getDisplayLanguage(newLocale), countGui.get() * 100 / propertiesRoot.entrySet().size(), countGui.get() <= 0 ? "" : "(" + countGui.get() + " items)");
        }
        if (!Locale.getDefault().getLanguage().equals("en")) {
            Properties propertiesJvm = PropertiesUtil.getProperties("i18n/jsql_" + Locale.getDefault().getLanguage() + ".properties");
            propertiesRoot.entrySet().stream().filter(key -> propertiesJvm.isEmpty() || !propertiesJvm.containsKey(key.getKey())).forEach(key -> countJvm.getAndIncrement());
            statusJvm = String.format("jvm %s %s%% %s", Locale.getDefault().getDisplayLanguage(newLocale), countJvm.get() * 100 / propertiesRoot.entrySet().size(), countJvm.get() <= 0 ? "" : " (" + countJvm.get() + " items)");
        }
        if (countJvm.get() > 0 || countGui.get() > 0) {
            LOGGER.info("i18n status: {}{}", (Object)(countJvm.get() > 0 ? statusJvm : ""), (Object)(countGui.get() > 0 ? statusGui : ""));
        }
    }

    private static Properties getProperties(String name) {
        Properties properties = new Properties();
        try {
            URI uri = ClassLoader.getSystemResource(name).toURI();
            Path path = Paths.get(uri);
            byte[] root = Files.readAllBytes(path);
            String rootI18n = new String(root, StandardCharsets.UTF_8);
            String rootI18nFixed = Pattern.compile("\\\\[\n\r]+").matcher(Matcher.quoteReplacement(rootI18n)).replaceAll("a");
            properties.load(new StringReader(rootI18nFixed));
        }
        catch (IOException | URISyntaxException e) {
            throw new JSqlRuntimeException(e);
        }
        return properties;
    }

    public String getVersionJsql() {
        return this.properties.getProperty("jsql.version");
    }

    public String getProperty(String property) {
        return this.properties.getProperty(property);
    }
}

