# Joplin for Research

Joplin enables you to store all your notes, ideas, and lists in one convenient location. With its synchronisation feature, you can access your information at home or on the go. Gather all the data you need and keep it organised and accessible.

Here are several ways you can enhance and streamline your research process using Joplin:

## 1\. Organise Your Research

Establish a well-structured note-taking system. Create a dedicated notebook in Joplin for each project, and consider creating sub-notebooks for individual topics or categories. Structure your notes clearly by using headers, bullet points, or numbered lists. You can also create tables, edit colours, highlight text, or add hand-written notes and drawings. Use tags to indicate the status of a note (e.g., “to-do”, “in progress”, “done”), its relevance to specific research questions, or other aspects crucial to your work. To maximise efficiency, maintain consistency in your formatting.

<img src="https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/use_cases/research/organise.png"  max-width="500px" />

## 2\. Leverage the Search Functionality

Search your notes by keyword, tag, or even text within images. With Optical Character Recognition (OCR), Joplin allows you to search for specific words or phrases in images. This feature can save a significant amount of time when you’re looking for particular information in a large document or across multiple documents.

<img src="https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/use_cases/research/search.png"  max-width="500px" />

## 3\. Incorporate a Variety of Resources into Your Research

Enhance your notes with visual aids such as photos, documents, or hand-written notes and drawings. You can also take photographs of interesting articles or inspirational materials and store them in Joplin. Additionally, use the Voice Typing feature to convert spoken words into text in real-time.

<img src="https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/use_cases/research/resources.png"  max-width="500px" />

## 4\. Use the Web Clipper Extension to Save Important Articles or Blog Posts

Joplin's Web Clipper is an invaluable tool for research. Here are some tips for using it effectively:

- **Clip Relevant Pages**  
When you find a web page with useful information, save it using the Web Clipper. This could include blog posts, news articles, research papers, or other types of content.

- **Save Pay-Per-View Content**  
If you have temporary access to subscription-based content, use the Web Clipper to save articles or journals relevant to your work. This ensures you can access the material even after your subscription expires.

- **Organise Your Clips**  
Sort your clips into notebooks and arrange them by topic, source, or any other category that suits your research.

- **Add Tags and Notes**  
After clipping a page, add tags and notes to remember why you saved it and its relevance to your research. This makes it easier to locate and utilise the clip later. Additionally, tagging helps track the source of the information in case you need to reference it again.

## 5\. Share Findings with Your Research Group

Collaborate with your colleagues by sharing notes and notebooks. Create a shared notebook that all group members can access and contribute to, serving as a central repository for ideas and information related to the project.

<img src="https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/use_cases/research/share.png"  max-width="500px" />

**Tip:** Group related ideas together using tags or colour themes. This will help you identify patterns and themes, making it easier to structure your project or research.