---
tweet: What's new in Joplin 3.3
forum_url: https://discourse.joplinapp.org/t/45098
---

# What's new in Joplin 3.3

## Desktop application

### Accessibility improvements

The Joplin 3.3 release introduces significant accessibility enhancements designed to make the application more inclusive and user-friendly. Users can now benefit from improved keyboard navigation, thanks to newly added shortcuts and clearer labels that streamline interaction across the interface. We've also added a "go to viewer" menu item that moves focus from the note editor to the note viewer. Focus is moved to the location in the viewer corresponding to the location of the cursor in the editor.

Screen reader support has been bolstered, ensuring elements like the note list and sidebar are easier to toggle and interact with. These updates make the application more usable for individuals relying on assistive technologies.

Additionally, visual improvements, including increased contrast for UI components such as URLs, sidebars, and scrollbars, enhance readability for users with visual impairments. This focus on clarity ensures a more comfortable user experience.

The Rich Text Editor has also received accessibility-focused updates, allowing for more seamless interaction with code blocks using either a keyboard or touchscreen. These refinements highlight Joplin's dedication to creating an accessible and equitable experience for all users.

### Button to collapse and expand all notebooks

Joplin 3.3 introduces a convenient "Collapse/Expand All" button for notebooks, allowing you to quickly adjust the visibility of your notebook hierarchy. This feature simplifies navigation by letting you expand all notebooks to locate specific notes or collapse them for a tidier interface!

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20250428-collapse-all.png)

### New dialog to select a note and link to it

A new dialog has been added to make linking to notes easier. By pressing Shift+Option+L on macOS or Shift+Alt+L on Windows and Linux, you can quickly bring up a search box. Simply type the name of the note you want to link to, and the link will be added to your current note!

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20250428-link-notes.png)

### Support for multiple instances of Joplin

Joplin Desktop now [lets you run multiple instances at once](https://joplinapp.org/help/apps/multiple_instances)! This means you can easily separate your work and personal notes, or use Joplin across different virtual desktops. Each instance runs independently with its own settings, plugins, and notes, so nothing overlaps. You can open a second instance through in menu **File => Open secondary app instance...**, and customise it however you like!

### Improved Rich Text editor

This version includes multiple improvements and bug fixes to the Rich Text Editor. In particular it has now been upgraded to TinyMCE v6, and it adds support for Markdown auto-replacement. For example, typing `==highlight==` creates highlighted text. Auto-replacement can be disabled in settings.

## Mobile application

### Accessibility improvements

Like the desktop app, the mobile app includes several accessibility improvements designed to enhance the user experience for those relying on assistive technologies. Focus handling has been improved in the note actions menu and modal dialogs, ensuring smoother navigation for screen reader users. Additionally, the default modal close button is now accessible, and issues with invisible buttons being focusable have been resolved.

Other updates include better contrast for faded URLs in the Markdown editor, making them more readable for users with visual impairments. The encryption configuration screen has been improved for better accessibility, and screen reader support has been added for creating and editing profiles. These changes collectively improve navigation, readability, and usability for all users.

### Support attaching audio recordings

You can now easily capture and include audio recordings directly within your notes. To use this feature, open the kebab menu and select "Record audio." You can then to record your audio input. When finished, the app automatically attaches the recorded audio file to the note. This functionality is perfect for capturing ideas, reminders, or supplementary audio information in a quick and intuitive way.

### Improved voice typing feature

The voice typing feature in Android has undergone a significant improvement, making it more accurate. Previously introduced in version 2.11, the feature allowed you to transcribe speech into text but lacked punctuation and struggled with accuracy in certain scenarios. The revamped version now leverages Whisper, an advanced AI model, to deliver improved recognition, including automatic punctuation and paragraph formatting.

Despite its advancements, the feature is currently in beta due to the demanding nature of the required AI models. While it defaults to a smaller, less accurate model to accommodate older devices, you can [manually download and switch to more accurate models](https://github.com/joplin/voice-typing-models/releases) for better performance.

As previously, the feature remains entirely offline, ensuring that private recordings are never sent to third-party servers, a distinct privacy advantage over similar solutions from Google or Apple. Additionally it means you can use the feature even when you don't have an internet connection. We plan to refine this feature further, eventually defaulting to the more accurate model as stability improves.

### Improved new note menu

The redesigned "New Note" menu takes note creation to a whole new level of flexibility and convenience. Previously, this menu only offered options to create a new note or a new to-do. With the latest update, you now have quick access to a variety of shortcuts, enabling you to attach files, record audio, capture photo notes, or even create drawings directly from the menu. This intuitive redesign makes it easier to choose the format that best suits your needs.

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20250428-new-note-menu.png)

## Security and bug fixes

As always, we continue to reinforce the security of Joplin. This version implements a robust content security policy for the Rich Text Editor, safeguarding the application against malicious content.

In total, this version delivers 39 bug fixes on desktop and 17 on mobile, enhancing both the security and stability of the application.

## Full changelogs

This is just an overview of the main features. The full changelogs are available there:

- Desktop: https://joplinapp.org/help/about/changelog/desktop
- Android: https://joplinapp.org/help/about/changelog/android/
- iOS: https://joplinapp.org/help/about/changelog/ios/