# Desktop application styling

The desktop application went through three styling methods:

- Directly setting the style on the element - eg. `<div style={{ fontWeight: 'bold' }}/>`. We no longer use this method as it lacks flexibility, and it makes it hard to change the style via a custom stylesheet.

- Using the styled-components package. This makes the style cleaner and more reusable. However, creating special components for each style is a bit of an overhead, and styled-components has a few glitches that can make styling fail.

- The third and current method is simply using SCSS and plain CSS classes. This method is described below, and in general that's what should be used for new components. It makes customisation easier and has less overhead than styled-components

## SCSS support

The application stylesheet is generated by building `packages/app-desktop/style.scss`

When creating a new component, create a new stylesheet file too, for example in `MyComponent/style.scss`, then add this file to the root style.scss file.

Additionally global styles can go in the root `main.scss` file.

Whenever the app is built, this root style.scss file is compiled and a style.css file is generated. It's this final style.css file that's included into the app.

## CSS class framework

We use [rscss](https://ricostacruz.com/rscss/index.html) to structure the components and classes. The main things to remember are:

- Components should be named with **at least two words**. eg `.search-form`

- Component element classes should have only **one word**. eg `.field`, `textinput`

- Always use the `>` child selector. This prevents bleeding through nested components.

For example, in the code below there are two components (`order-form` and `slider-box`), and each has one or more elements.

```html
<form class="order-form">
	<input class="firstname" type="text"/>
	<input class="lastname" type="text"/>
	<div class="slider-box">
		Select quantity: <div class="knob">
	</div>
</form>
```

The components and their elements would be styled this way:

```css
.order-form > firstname,
.order-form > lastname {
	padding: 10px;
}

.slider-box > knob {
	border-width: 1px;
}
```

What if you want to apply a style to `slider-box` when it is inside `order-form`?

Do **NOT** do this:

    .order-form > .slider-box { } /* WRONG */

`slider-box` is a component but also an element of `order-form`. So in that case, name the element, for example as `quantityslider`, then you can style it:

```html
<div class="slider-box quantityslider">
	Select quantity: <div class="knob">
</div>
```

```css
.order-form > .quantityslider {
	margin-left: 10px;
}
```

The goal of this approach is to specifically target the elements that you need and nothing else. Over the long term is makes managing the CSS easier.

For more details, see the [RSCSS documentation](https://ricostacruz.com/rscss/index.html).
