---
created: 2023-07-14T12:00:00.000+00:00
tweet: What's new in Joplin 2.11
forum_url: https://discourse.joplinapp.org/t/31674
---

# What's new in Joplin 2.11

## Desktop

### Add support for plugin user data

Developers of plugins now have the ability to associate additional information with notes, notebooks, and tags. This data is then synchronized across multiple devices. For instance, it is possible to envision attaching OCR data to an image or incorporating plugin-specific parameters to a note, which can subsequently be synchronized across all devices.

### Improved end-to-end encryption

End-to-end encryption (E2EE) plays a vital role in safeguarding your data privacy. Our aim is to make it effortlessly user-friendly, seamlessly integrated, and possibly enabled by default.

To achieve this objective, we have implemented several enhancements in this version. These improvements encompass more streamlined management of encryption keys and simplified setup processes for both new and existing devices utilising end-to-end encryption.

Moreover, we have upgraded the encryption algorithm from AES-128 to AES-256, ensuring heightened security for your data in the long run.

### Export a Mermaid graph

There is now a context menu on Mermaid graphs which you can use to export your graph as PNG, SVG, or by copying the vector data to the clipboard.

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20230711-mermaid-export.png)

### Auto-detect language on startup

A small but useful change - the application language is now automatically detected startup. Of course, if needed you can later change it in the configuration screen.

## Android

As always most of these changes also apply to the mobile applications, such as the improved end-to-end encryption support, language auto-detection, and various bug fixes and improvements. But besides those, we also have several mobile-specific updates:

### Support for offline voice typing

The Android mobile app now support offline voice typing - it means your voice recording does not need to be uploaded to Google or Samsung server - it all takes place on your device for added security. To make use of it, open any note, tap on the three dots menu, then "Voice typing".

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20230711-voice-typing-1.png)

The first time, the app will need to download the language files to your device:

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20230711-voice-typing-2.png)

Once they are there, simply record your message and it will appear in the note:

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20230711-voice-typing-3.png)

### Create and move sub-notebooks

@jcgurango implemented support for creating sub-notebooks, and moving notebooks around in the mobile app. To do so, long press on any notebook and press "Edit". You can now choose to move it under any other notebook using the provided dropdown list.

## Full changelog

This is just an overview of the main features. The full changelog is available there:

- Desktop: https://joplinapp.org/help/about/changelog/desktop
- Android: https://joplinapp.org/help/about/changelog/android
- iOS: https://joplinapp.org/help/about/changelog/ios
