/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.org.jdesktop.application;

import com.aspect.org.jdesktop.application.AbstractBean;
import com.aspect.org.jdesktop.application.Application;
import com.aspect.org.jdesktop.application.ApplicationAction;
import com.aspect.org.jdesktop.application.ApplicationContext;
import com.aspect.org.jdesktop.application.ResourceMap;
import com.aspect.org.jdesktop.application.TaskEvent;
import com.aspect.org.jdesktop.application.TaskListener;
import com.aspect.org.jdesktop.application.TaskService;
import com.aspect.org.jdesktop.swingworker.SwingWorker;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Task<T, V>
extends SwingWorker<T, V> {
    private static final Logger logger = Logger.getLogger(Task.class.getName());
    private final Application application;
    private String resourcePrefix;
    private ResourceMap resourceMap;
    private List<TaskListener<T, V>> taskListeners;
    private InputBlocker inputBlocker;
    private String name = null;
    private String title = null;
    private String description = null;
    private long messageTime = -1L;
    private String message = null;
    private long startTime = -1L;
    private long doneTime = -1L;
    private boolean userCanCancel = true;
    private boolean progressPropertyIsValid = false;
    private TaskService taskService = null;

    private void initTask(ResourceMap resourceMap, String string) {
        this.resourceMap = resourceMap;
        this.resourcePrefix = string == null || string.length() == 0 ? "" : (string.endsWith(".") ? string : string + ".");
        if (resourceMap != null) {
            this.title = resourceMap.getString(this.resourceName("title"), new Object[0]);
            this.description = resourceMap.getString(this.resourceName("description"), new Object[0]);
            this.message = resourceMap.getString(this.resourceName("message"), new Object[0]);
            if (this.message != null) {
                this.messageTime = System.currentTimeMillis();
            }
        }
        this.addPropertyChangeListener(new StatePCL());
        this.taskListeners = new CopyOnWriteArrayList<TaskListener<T, V>>();
    }

    private ResourceMap defaultResourceMap(Application application) {
        return application.getContext().getResourceMap(((Object)((Object)this)).getClass(), Task.class);
    }

    @Deprecated
    public Task(Application application, ResourceMap resourceMap, String string) {
        this.application = application;
        this.initTask(resourceMap, string);
    }

    @Deprecated
    public Task(Application application, String string) {
        this.application = application;
        this.initTask(this.defaultResourceMap(application), string);
    }

    public Task(Application application) {
        this.application = application;
        this.initTask(this.defaultResourceMap(application), "");
    }

    public final Application getApplication() {
        return this.application;
    }

    public final ApplicationContext getContext() {
        return this.getApplication().getContext();
    }

    public synchronized TaskService getTaskService() {
        return this.taskService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setTaskService(TaskService taskService) {
        TaskService taskService2;
        TaskService taskService3;
        Task task = this;
        synchronized (task) {
            taskService3 = this.taskService;
            taskService2 = this.taskService = taskService;
        }
        this.firePropertyChange("taskService", taskService3, taskService2);
    }

    protected final String resourceName(String string) {
        return this.resourcePrefix + string;
    }

    public final ResourceMap getResourceMap() {
        return this.resourceMap;
    }

    public synchronized String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTitle(String string) {
        String string2;
        String string3;
        Task task = this;
        synchronized (task) {
            string3 = this.title;
            string2 = this.title = string;
        }
        this.firePropertyChange("title", string3, string2);
    }

    public synchronized String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDescription(String string) {
        String string2;
        String string3;
        Task task = this;
        synchronized (task) {
            string3 = this.description;
            string2 = this.description = string;
        }
        this.firePropertyChange("description", string3, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExecutionDuration(TimeUnit timeUnit) {
        long l;
        long l2;
        Task task = this;
        synchronized (task) {
            l2 = this.startTime;
            l = this.doneTime;
        }
        long l3 = l2 == -1L ? 0L : (l == -1L ? System.currentTimeMillis() - l2 : l - l2);
        return timeUnit.convert(Math.max(0L, l3), TimeUnit.MILLISECONDS);
    }

    public String getMessage() {
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMessage(String string) {
        String string2;
        String string3;
        Task task = this;
        synchronized (task) {
            string3 = this.message;
            string2 = this.message = string;
            this.messageTime = System.currentTimeMillis();
        }
        this.firePropertyChange("message", string3, string2);
    }

    protected final void message(String string, Object ... objectArray) {
        ResourceMap resourceMap = this.getResourceMap();
        if (resourceMap != null) {
            this.setMessage(resourceMap.getString(this.resourceName(string), objectArray));
        } else {
            this.setMessage(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessageDuration(TimeUnit timeUnit) {
        long l;
        Task task = this;
        synchronized (task) {
            l = this.messageTime;
        }
        long l2 = l == -1L ? 0L : Math.max(0L, System.currentTimeMillis() - l);
        return timeUnit.convert(l2, TimeUnit.MILLISECONDS);
    }

    public synchronized boolean getUserCanCancel() {
        return this.userCanCancel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUserCanCancel(boolean bl) {
        boolean bl2;
        boolean bl3;
        Task task = this;
        synchronized (task) {
            bl3 = this.userCanCancel;
            bl2 = this.userCanCancel = bl;
        }
        this.firePropertyChange("userCanCancel", bl3, bl2);
    }

    public synchronized boolean isProgressPropertyValid() {
        return this.progressPropertyIsValid;
    }

    protected final void setProgress(int n, int n2, int n3) {
        if (n2 >= n3) {
            throw new IllegalArgumentException("invalid range: min >= max");
        }
        if (n < n2 || n > n3) {
            throw new IllegalArgumentException("invalid value");
        }
        float f = (float)(n - n2) / (float)(n3 - n2);
        this.setProgress(Math.round(f * 100.0f));
    }

    protected final void setProgress(float f) {
        if ((double)f < 0.0 || (double)f > 1.0) {
            throw new IllegalArgumentException("invalid percentage");
        }
        this.setProgress(Math.round(f * 100.0f));
    }

    protected final void setProgress(float f, float f2, float f3) {
        if (f2 >= f3) {
            throw new IllegalArgumentException("invalid range: min >= max");
        }
        if (f < f2 || f > f3) {
            throw new IllegalArgumentException("invalid value");
        }
        float f4 = (f - f2) / (f3 - f2);
        this.setProgress(Math.round(f4 * 100.0f));
    }

    public final boolean isPending() {
        return this.getState() == SwingWorker.StateValue.PENDING;
    }

    public final boolean isStarted() {
        return this.getState() == SwingWorker.StateValue.STARTED;
    }

    protected void process(List<V> list) {
        this.fireProcessListeners(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void done() {
        try {
            if (this.isCancelled()) {
                this.cancelled();
            } else {
                try {
                    this.succeeded(this.get());
                }
                catch (InterruptedException interruptedException) {
                    this.interrupted(interruptedException);
                }
                catch (ExecutionException executionException) {
                    this.failed(executionException.getCause());
                }
            }
        }
        finally {
            try {
                this.finished();
            }
            finally {
                this.setTaskService(null);
            }
        }
    }

    protected void cancelled() {
    }

    protected void succeeded(T t) {
    }

    protected void interrupted(InterruptedException interruptedException) {
    }

    protected void failed(Throwable throwable) {
        String string = String.format("%s failed: %s", new Object[]{this, throwable});
        logger.log(Level.SEVERE, string, throwable);
    }

    protected void finished() {
    }

    public void addTaskListener(TaskListener<T, V> taskListener) {
        if (taskListener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.taskListeners.add(taskListener);
    }

    public void removeTaskListener(TaskListener<T, V> taskListener) {
        if (taskListener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.taskListeners.remove(taskListener);
    }

    public TaskListener<T, V>[] getTaskListeners() {
        return this.taskListeners.toArray(new TaskListener[this.taskListeners.size()]);
    }

    private void fireProcessListeners(List<V> list) {
        TaskEvent<List<V>> taskEvent = new TaskEvent<List<V>>(this, list);
        for (TaskListener<T, V> taskListener : this.taskListeners) {
            taskListener.process(taskEvent);
        }
    }

    private void fireDoInBackgroundListeners() {
        TaskEvent<Object> taskEvent = new TaskEvent<Object>(this, null);
        for (TaskListener<T, V> taskListener : this.taskListeners) {
            taskListener.doInBackground(taskEvent);
        }
    }

    private void fireSucceededListeners(T t) {
        TaskEvent<T> taskEvent = new TaskEvent<T>(this, t);
        for (TaskListener<T, V> taskListener : this.taskListeners) {
            taskListener.succeeded(taskEvent);
        }
    }

    private void fireCancelledListeners() {
        TaskEvent<Object> taskEvent = new TaskEvent<Object>(this, null);
        for (TaskListener<T, V> taskListener : this.taskListeners) {
            taskListener.cancelled(taskEvent);
        }
    }

    private void fireInterruptedListeners(InterruptedException interruptedException) {
        TaskEvent<InterruptedException> taskEvent = new TaskEvent<InterruptedException>(this, interruptedException);
        for (TaskListener<T, V> taskListener : this.taskListeners) {
            taskListener.interrupted(taskEvent);
        }
    }

    private void fireFailedListeners(Throwable throwable) {
        TaskEvent<Throwable> taskEvent = new TaskEvent<Throwable>(this, throwable);
        for (TaskListener<T, V> taskListener : this.taskListeners) {
            taskListener.failed(taskEvent);
        }
    }

    private void fireFinishedListeners() {
        TaskEvent<Object> taskEvent = new TaskEvent<Object>(this, null);
        for (TaskListener<T, V> taskListener : this.taskListeners) {
            taskListener.finished(taskEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCompletionListeners() {
        try {
            if (this.isCancelled()) {
                this.fireCancelledListeners();
            } else {
                try {
                    this.fireSucceededListeners(this.get());
                }
                catch (InterruptedException interruptedException) {
                    this.fireInterruptedListeners(interruptedException);
                }
                catch (ExecutionException executionException) {
                    this.fireFailedListeners(executionException.getCause());
                }
            }
        }
        finally {
            this.fireFinishedListeners();
        }
    }

    public final InputBlocker getInputBlocker() {
        return this.inputBlocker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInputBlocker(InputBlocker inputBlocker) {
        InputBlocker inputBlocker2;
        InputBlocker inputBlocker3;
        if (this.getTaskService() != null) {
            throw new IllegalStateException("task already being executed");
        }
        Task task = this;
        synchronized (task) {
            inputBlocker3 = this.inputBlocker;
            inputBlocker2 = this.inputBlocker = inputBlocker;
        }
        this.firePropertyChange("inputBlocker", inputBlocker3, inputBlocker2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BlockingScope {
        NONE,
        ACTION,
        COMPONENT,
        WINDOW,
        APPLICATION;

    }

    public static abstract class InputBlocker
    extends AbstractBean {
        private final Task task;
        private final BlockingScope scope;
        private final Object target;
        private final ApplicationAction action;

        public InputBlocker(Task task, BlockingScope blockingScope, Object object, ApplicationAction applicationAction) {
            if (task == null) {
                throw new IllegalArgumentException("null task");
            }
            if (task.getTaskService() != null) {
                throw new IllegalStateException("task already being executed");
            }
            switch (blockingScope) {
                case ACTION: {
                    if (object instanceof Action) break;
                    throw new IllegalArgumentException("target not an Action");
                }
                case COMPONENT: 
                case WINDOW: {
                    if (object instanceof Component) break;
                    throw new IllegalArgumentException("target not a Component");
                }
            }
            this.task = task;
            this.scope = blockingScope;
            this.target = object;
            this.action = applicationAction;
        }

        public InputBlocker(Task task, BlockingScope blockingScope, Object object) {
            this(task, blockingScope, object, object instanceof ApplicationAction ? (ApplicationAction)object : null);
        }

        public final Task getTask() {
            return this.task;
        }

        public final BlockingScope getScope() {
            return this.scope;
        }

        public final Object getTarget() {
            return this.target;
        }

        public final ApplicationAction getAction() {
            return this.action;
        }

        protected abstract void block();

        protected abstract void unblock();
    }

    private class StatePCL
    implements PropertyChangeListener {
        private StatePCL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("state".equals(string)) {
                SwingWorker.StateValue stateValue = (SwingWorker.StateValue)propertyChangeEvent.getNewValue();
                Task task = (Task)((Object)propertyChangeEvent.getSource());
                switch (stateValue) {
                    case STARTED: {
                        this.taskStarted(task);
                        break;
                    }
                    case DONE: {
                        this.taskDone(task);
                    }
                }
            } else if ("progress".equals(string)) {
                Task task = Task.this;
                synchronized (task) {
                    Task.this.progressPropertyIsValid = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void taskStarted(Task task) {
            Task task2 = Task.this;
            synchronized (task2) {
                Task.this.startTime = System.currentTimeMillis();
            }
            Task.this.firePropertyChange("started", false, true);
            Task.this.fireDoInBackgroundListeners();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void taskDone(Task task) {
            Task task2 = Task.this;
            synchronized (task2) {
                Task.this.doneTime = System.currentTimeMillis();
            }
            try {
                task.removePropertyChangeListener(this);
                Task.this.firePropertyChange("done", false, true);
                Task.this.fireCompletionListeners();
            }
            finally {
                Task.this.firePropertyChange("completed", false, true);
            }
        }
    }
}

