/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.condition;

import com.aspect.snoop.Condition;
import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.ui.condition.AddEditConditionView;
import com.aspect.snoop.util.ModelUIUtil;
import com.aspect.snoop.util.UIUtil;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.table.AbstractTableModel;

public class ConditionTableModel
extends AbstractTableModel {
    List<Condition> conditions;
    private static String[] columnNames = new String[]{"Enabled", "Parameter", "Operator", "Operand", ""};
    private static Class[] columnTypes = new Class[]{Boolean.class, String.class, String.class, String.class, JButton.class};

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    public ConditionTableModel() {
        this.conditions = new ArrayList<Condition>();
    }

    public ConditionTableModel(List<Condition> conditions) {
        this.conditions = conditions;
    }

    @Override
    public int getRowCount() {
        if (this.conditions == null) {
            return 0;
        }
        return this.conditions.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnTypes[columnIndex];
    }

    @Override
    public void setValueAt(Object o, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            boolean b = (Boolean)o;
            this.conditions.get(rowIndex).setEnabled(b);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Condition c = this.conditions.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return c.isEnabled();
            }
            case 1: {
                return " " + (c.getParameter() + 1);
            }
            case 2: {
                return " " + ModelUIUtil.getDescriptionByOperator(c.getOperator());
            }
            case 3: {
                return " " + c.getOperand();
            }
            case 4: {
                final Condition c2 = c;
                JButton manageButton = new JButton("Manage");
                manageButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JFrame mainFrame = JavaSnoop.getApplication().getMainFrame();
                        AddEditConditionView view = new AddEditConditionView((Frame)mainFrame, true, null, c2);
                        view.setVisible(true);
                        UIUtil.waitForInput(view);
                        if (view.getOperand() != null) {
                            c2.setOperator(view.getOperator());
                            c2.setOperand(view.getOperand());
                            c2.setParameter(view.getParameter());
                            mainFrame.repaint();
                        }
                    }
                });
                return manageButton;
            }
        }
        return null;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0 || columnIndex == 4;
    }

    public Condition getConditionAt(int selectedRow) {
        return this.conditions.get(selectedRow);
    }
}

