#ifndef CAPSTONE_SYSZ_H
#define CAPSTONE_SYSZ_H

/* Capstone Disassembly Engine */
/* By Nguyen Anh Quynh <aquynh@gmail.com>, 2014-2015 */
/* By Rot127 <unisono@quyllur.org>, 2024 */

#ifdef __cplusplus
extern "C" {
#endif

#include "systemz.h"
#include "platform.h"
#include "cs_operand.h"

typedef enum {
	SYSZ_CC_O = SYSTEMZ_CC_O,
	SYSZ_CC_H = SYSTEMZ_CC_H,
	SYSZ_CC_NLE = SYSTEMZ_CC_NLE,
	SYSZ_CC_L = SYSTEMZ_CC_L,
	SYSZ_CC_NHE = SYSTEMZ_CC_NHE,
	SYSZ_CC_LH = SYSTEMZ_CC_LH,
	SYSZ_CC_NE = SYSTEMZ_CC_NE,
	SYSZ_CC_E = SYSTEMZ_CC_E,
	SYSZ_CC_NLH = SYSTEMZ_CC_NLH,
	SYSZ_CC_HE = SYSTEMZ_CC_HE,
	SYSZ_CC_NL = SYSTEMZ_CC_NL,
	SYSZ_CC_LE = SYSTEMZ_CC_LE,
	SYSZ_CC_NH = SYSTEMZ_CC_NH,
	SYSZ_CC_NO = SYSTEMZ_CC_NO,
	SYSZ_CC_INVALID = SYSTEMZ_CC_INVALID,
} sysz_cc;

typedef enum {
	SYSZ_OP_INVALID = SYSTEMZ_OP_INVALID,
	SYSZ_OP_REG = SYSTEMZ_OP_REG,
	SYSZ_OP_IMM = SYSTEMZ_OP_IMM,
	SYSZ_OP_MEM = SYSTEMZ_OP_MEM,
} sysz_op_type;

typedef enum {

	SYSZ_REG_INVALID = SYSTEMZ_REG_INVALID,
	SYSZ_REG_CC = SYSTEMZ_REG_CC,
	SYSZ_REG_FPC = SYSTEMZ_REG_FPC,
	SYSZ_REG_A0 = SYSTEMZ_REG_A0,
	SYSZ_REG_A1 = SYSTEMZ_REG_A1,
	SYSZ_REG_A2 = SYSTEMZ_REG_A2,
	SYSZ_REG_A3 = SYSTEMZ_REG_A3,
	SYSZ_REG_A4 = SYSTEMZ_REG_A4,
	SYSZ_REG_A5 = SYSTEMZ_REG_A5,
	SYSZ_REG_A6 = SYSTEMZ_REG_A6,
	SYSZ_REG_A7 = SYSTEMZ_REG_A7,
	SYSZ_REG_A8 = SYSTEMZ_REG_A8,
	SYSZ_REG_A9 = SYSTEMZ_REG_A9,
	SYSZ_REG_A10 = SYSTEMZ_REG_A10,
	SYSZ_REG_A11 = SYSTEMZ_REG_A11,
	SYSZ_REG_A12 = SYSTEMZ_REG_A12,
	SYSZ_REG_A13 = SYSTEMZ_REG_A13,
	SYSZ_REG_A14 = SYSTEMZ_REG_A14,
	SYSZ_REG_A15 = SYSTEMZ_REG_A15,
	SYSZ_REG_C0 = SYSTEMZ_REG_C0,
	SYSZ_REG_C1 = SYSTEMZ_REG_C1,
	SYSZ_REG_C2 = SYSTEMZ_REG_C2,
	SYSZ_REG_C3 = SYSTEMZ_REG_C3,
	SYSZ_REG_C4 = SYSTEMZ_REG_C4,
	SYSZ_REG_C5 = SYSTEMZ_REG_C5,
	SYSZ_REG_C6 = SYSTEMZ_REG_C6,
	SYSZ_REG_C7 = SYSTEMZ_REG_C7,
	SYSZ_REG_C8 = SYSTEMZ_REG_C8,
	SYSZ_REG_C9 = SYSTEMZ_REG_C9,
	SYSZ_REG_C10 = SYSTEMZ_REG_C10,
	SYSZ_REG_C11 = SYSTEMZ_REG_C11,
	SYSZ_REG_C12 = SYSTEMZ_REG_C12,
	SYSZ_REG_C13 = SYSTEMZ_REG_C13,
	SYSZ_REG_C14 = SYSTEMZ_REG_C14,
	SYSZ_REG_C15 = SYSTEMZ_REG_C15,
	SYSZ_REG_V0 = SYSTEMZ_REG_V0,
	SYSZ_REG_V1 = SYSTEMZ_REG_V1,
	SYSZ_REG_V2 = SYSTEMZ_REG_V2,
	SYSZ_REG_V3 = SYSTEMZ_REG_V3,
	SYSZ_REG_V4 = SYSTEMZ_REG_V4,
	SYSZ_REG_V5 = SYSTEMZ_REG_V5,
	SYSZ_REG_V6 = SYSTEMZ_REG_V6,
	SYSZ_REG_V7 = SYSTEMZ_REG_V7,
	SYSZ_REG_V8 = SYSTEMZ_REG_V8,
	SYSZ_REG_V9 = SYSTEMZ_REG_V9,
	SYSZ_REG_V10 = SYSTEMZ_REG_V10,
	SYSZ_REG_V11 = SYSTEMZ_REG_V11,
	SYSZ_REG_V12 = SYSTEMZ_REG_V12,
	SYSZ_REG_V13 = SYSTEMZ_REG_V13,
	SYSZ_REG_V14 = SYSTEMZ_REG_V14,
	SYSZ_REG_V15 = SYSTEMZ_REG_V15,
	SYSZ_REG_V16 = SYSTEMZ_REG_V16,
	SYSZ_REG_V17 = SYSTEMZ_REG_V17,
	SYSZ_REG_V18 = SYSTEMZ_REG_V18,
	SYSZ_REG_V19 = SYSTEMZ_REG_V19,
	SYSZ_REG_V20 = SYSTEMZ_REG_V20,
	SYSZ_REG_V21 = SYSTEMZ_REG_V21,
	SYSZ_REG_V22 = SYSTEMZ_REG_V22,
	SYSZ_REG_V23 = SYSTEMZ_REG_V23,
	SYSZ_REG_V24 = SYSTEMZ_REG_V24,
	SYSZ_REG_V25 = SYSTEMZ_REG_V25,
	SYSZ_REG_V26 = SYSTEMZ_REG_V26,
	SYSZ_REG_V27 = SYSTEMZ_REG_V27,
	SYSZ_REG_V28 = SYSTEMZ_REG_V28,
	SYSZ_REG_V29 = SYSTEMZ_REG_V29,
	SYSZ_REG_V30 = SYSTEMZ_REG_V30,
	SYSZ_REG_V31 = SYSTEMZ_REG_V31,
	SYSZ_REG_F0D = SYSTEMZ_REG_F0D,
	SYSZ_REG_F1D = SYSTEMZ_REG_F1D,
	SYSZ_REG_F2D = SYSTEMZ_REG_F2D,
	SYSZ_REG_F3D = SYSTEMZ_REG_F3D,
	SYSZ_REG_F4D = SYSTEMZ_REG_F4D,
	SYSZ_REG_F5D = SYSTEMZ_REG_F5D,
	SYSZ_REG_F6D = SYSTEMZ_REG_F6D,
	SYSZ_REG_F7D = SYSTEMZ_REG_F7D,
	SYSZ_REG_F8D = SYSTEMZ_REG_F8D,
	SYSZ_REG_F9D = SYSTEMZ_REG_F9D,
	SYSZ_REG_F10D = SYSTEMZ_REG_F10D,
	SYSZ_REG_F11D = SYSTEMZ_REG_F11D,
	SYSZ_REG_F12D = SYSTEMZ_REG_F12D,
	SYSZ_REG_F13D = SYSTEMZ_REG_F13D,
	SYSZ_REG_F14D = SYSTEMZ_REG_F14D,
	SYSZ_REG_F15D = SYSTEMZ_REG_F15D,
	SYSZ_REG_F16D = SYSTEMZ_REG_F16D,
	SYSZ_REG_F17D = SYSTEMZ_REG_F17D,
	SYSZ_REG_F18D = SYSTEMZ_REG_F18D,
	SYSZ_REG_F19D = SYSTEMZ_REG_F19D,
	SYSZ_REG_F20D = SYSTEMZ_REG_F20D,
	SYSZ_REG_F21D = SYSTEMZ_REG_F21D,
	SYSZ_REG_F22D = SYSTEMZ_REG_F22D,
	SYSZ_REG_F23D = SYSTEMZ_REG_F23D,
	SYSZ_REG_F24D = SYSTEMZ_REG_F24D,
	SYSZ_REG_F25D = SYSTEMZ_REG_F25D,
	SYSZ_REG_F26D = SYSTEMZ_REG_F26D,
	SYSZ_REG_F27D = SYSTEMZ_REG_F27D,
	SYSZ_REG_F28D = SYSTEMZ_REG_F28D,
	SYSZ_REG_F29D = SYSTEMZ_REG_F29D,
	SYSZ_REG_F30D = SYSTEMZ_REG_F30D,
	SYSZ_REG_F31D = SYSTEMZ_REG_F31D,
	SYSZ_REG_F0Q = SYSTEMZ_REG_F0Q,
	SYSZ_REG_F1Q = SYSTEMZ_REG_F1Q,
	SYSZ_REG_F4Q = SYSTEMZ_REG_F4Q,
	SYSZ_REG_F5Q = SYSTEMZ_REG_F5Q,
	SYSZ_REG_F8Q = SYSTEMZ_REG_F8Q,
	SYSZ_REG_F9Q = SYSTEMZ_REG_F9Q,
	SYSZ_REG_F12Q = SYSTEMZ_REG_F12Q,
	SYSZ_REG_F13Q = SYSTEMZ_REG_F13Q,
	SYSZ_REG_F0S = SYSTEMZ_REG_F0S,
	SYSZ_REG_F1S = SYSTEMZ_REG_F1S,
	SYSZ_REG_F2S = SYSTEMZ_REG_F2S,
	SYSZ_REG_F3S = SYSTEMZ_REG_F3S,
	SYSZ_REG_F4S = SYSTEMZ_REG_F4S,
	SYSZ_REG_F5S = SYSTEMZ_REG_F5S,
	SYSZ_REG_F6S = SYSTEMZ_REG_F6S,
	SYSZ_REG_F7S = SYSTEMZ_REG_F7S,
	SYSZ_REG_F8S = SYSTEMZ_REG_F8S,
	SYSZ_REG_F9S = SYSTEMZ_REG_F9S,
	SYSZ_REG_F10S = SYSTEMZ_REG_F10S,
	SYSZ_REG_F11S = SYSTEMZ_REG_F11S,
	SYSZ_REG_F12S = SYSTEMZ_REG_F12S,
	SYSZ_REG_F13S = SYSTEMZ_REG_F13S,
	SYSZ_REG_F14S = SYSTEMZ_REG_F14S,
	SYSZ_REG_F15S = SYSTEMZ_REG_F15S,
	SYSZ_REG_F16S = SYSTEMZ_REG_F16S,
	SYSZ_REG_F17S = SYSTEMZ_REG_F17S,
	SYSZ_REG_F18S = SYSTEMZ_REG_F18S,
	SYSZ_REG_F19S = SYSTEMZ_REG_F19S,
	SYSZ_REG_F20S = SYSTEMZ_REG_F20S,
	SYSZ_REG_F21S = SYSTEMZ_REG_F21S,
	SYSZ_REG_F22S = SYSTEMZ_REG_F22S,
	SYSZ_REG_F23S = SYSTEMZ_REG_F23S,
	SYSZ_REG_F24S = SYSTEMZ_REG_F24S,
	SYSZ_REG_F25S = SYSTEMZ_REG_F25S,
	SYSZ_REG_F26S = SYSTEMZ_REG_F26S,
	SYSZ_REG_F27S = SYSTEMZ_REG_F27S,
	SYSZ_REG_F28S = SYSTEMZ_REG_F28S,
	SYSZ_REG_F29S = SYSTEMZ_REG_F29S,
	SYSZ_REG_F30S = SYSTEMZ_REG_F30S,
	SYSZ_REG_F31S = SYSTEMZ_REG_F31S,
	SYSZ_REG_R0D = SYSTEMZ_REG_R0D,
	SYSZ_REG_R1D = SYSTEMZ_REG_R1D,
	SYSZ_REG_R2D = SYSTEMZ_REG_R2D,
	SYSZ_REG_R3D = SYSTEMZ_REG_R3D,
	SYSZ_REG_R4D = SYSTEMZ_REG_R4D,
	SYSZ_REG_R5D = SYSTEMZ_REG_R5D,
	SYSZ_REG_R6D = SYSTEMZ_REG_R6D,
	SYSZ_REG_R7D = SYSTEMZ_REG_R7D,
	SYSZ_REG_R8D = SYSTEMZ_REG_R8D,
	SYSZ_REG_R9D = SYSTEMZ_REG_R9D,
	SYSZ_REG_R10D = SYSTEMZ_REG_R10D,
	SYSZ_REG_R11D = SYSTEMZ_REG_R11D,
	SYSZ_REG_R12D = SYSTEMZ_REG_R12D,
	SYSZ_REG_R13D = SYSTEMZ_REG_R13D,
	SYSZ_REG_R14D = SYSTEMZ_REG_R14D,
	SYSZ_REG_R15D = SYSTEMZ_REG_R15D,
	SYSZ_REG_R0H = SYSTEMZ_REG_R0H,
	SYSZ_REG_R1H = SYSTEMZ_REG_R1H,
	SYSZ_REG_R2H = SYSTEMZ_REG_R2H,
	SYSZ_REG_R3H = SYSTEMZ_REG_R3H,
	SYSZ_REG_R4H = SYSTEMZ_REG_R4H,
	SYSZ_REG_R5H = SYSTEMZ_REG_R5H,
	SYSZ_REG_R6H = SYSTEMZ_REG_R6H,
	SYSZ_REG_R7H = SYSTEMZ_REG_R7H,
	SYSZ_REG_R8H = SYSTEMZ_REG_R8H,
	SYSZ_REG_R9H = SYSTEMZ_REG_R9H,
	SYSZ_REG_R10H = SYSTEMZ_REG_R10H,
	SYSZ_REG_R11H = SYSTEMZ_REG_R11H,
	SYSZ_REG_R12H = SYSTEMZ_REG_R12H,
	SYSZ_REG_R13H = SYSTEMZ_REG_R13H,
	SYSZ_REG_R14H = SYSTEMZ_REG_R14H,
	SYSZ_REG_R15H = SYSTEMZ_REG_R15H,
	SYSZ_REG_R0L = SYSTEMZ_REG_R0L,
	SYSZ_REG_R1L = SYSTEMZ_REG_R1L,
	SYSZ_REG_R2L = SYSTEMZ_REG_R2L,
	SYSZ_REG_R3L = SYSTEMZ_REG_R3L,
	SYSZ_REG_R4L = SYSTEMZ_REG_R4L,
	SYSZ_REG_R5L = SYSTEMZ_REG_R5L,
	SYSZ_REG_R6L = SYSTEMZ_REG_R6L,
	SYSZ_REG_R7L = SYSTEMZ_REG_R7L,
	SYSZ_REG_R8L = SYSTEMZ_REG_R8L,
	SYSZ_REG_R9L = SYSTEMZ_REG_R9L,
	SYSZ_REG_R10L = SYSTEMZ_REG_R10L,
	SYSZ_REG_R11L = SYSTEMZ_REG_R11L,
	SYSZ_REG_R12L = SYSTEMZ_REG_R12L,
	SYSZ_REG_R13L = SYSTEMZ_REG_R13L,
	SYSZ_REG_R14L = SYSTEMZ_REG_R14L,
	SYSZ_REG_R15L = SYSTEMZ_REG_R15L,
	SYSZ_REG_R0Q = SYSTEMZ_REG_R0Q,
	SYSZ_REG_R2Q = SYSTEMZ_REG_R2Q,
	SYSZ_REG_R4Q = SYSTEMZ_REG_R4Q,
	SYSZ_REG_R6Q = SYSTEMZ_REG_R6Q,
	SYSZ_REG_R8Q = SYSTEMZ_REG_R8Q,
	SYSZ_REG_R10Q = SYSTEMZ_REG_R10Q,
	SYSZ_REG_R12Q = SYSTEMZ_REG_R12Q,
	SYSZ_REG_R14Q = SYSTEMZ_REG_R14Q,
	SYSZ_REG_ENDING = SYSTEMZ_REG_ENDING,

} sysz_reg;

typedef enum {
	SYSZ_INSN_FORM_INVALID = SYSTEMZ_INSN_FORM_INVALID,

	SYSZ_INSN_FORM_INSTRXA = SYSTEMZ_INSN_FORM_INSTRXA,
	SYSZ_INSN_FORM_INSTRXE = SYSTEMZ_INSN_FORM_INSTRXE,
	SYSZ_INSN_FORM_INSTRRE = SYSTEMZ_INSN_FORM_INSTRRE,
	SYSZ_INSN_FORM_INSTRR = SYSTEMZ_INSN_FORM_INSTRR,
	SYSZ_INSN_FORM_INSTRRFA = SYSTEMZ_INSN_FORM_INSTRRFA,
	SYSZ_INSN_FORM_INSTRILA = SYSTEMZ_INSN_FORM_INSTRILA,
	SYSZ_INSN_FORM_INSTRXYA = SYSTEMZ_INSN_FORM_INSTRXYA,
	SYSZ_INSN_FORM_INSTRIA = SYSTEMZ_INSN_FORM_INSTRIA,
	SYSZ_INSN_FORM_INSTRIED = SYSTEMZ_INSN_FORM_INSTRIED,
	SYSZ_INSN_FORM_INSTSIY = SYSTEMZ_INSN_FORM_INSTSIY,
	SYSZ_INSN_FORM_INSTSSB = SYSTEMZ_INSN_FORM_INSTSSB,
	SYSZ_INSN_FORM_INSTRXB = SYSTEMZ_INSN_FORM_INSTRXB,
	SYSZ_INSN_FORM_INSTRXYB = SYSTEMZ_INSN_FORM_INSTRXYB,
	SYSZ_INSN_FORM_INSTSMI = SYSTEMZ_INSN_FORM_INSTSMI,
	SYSZ_INSN_FORM_INSTMII = SYSTEMZ_INSN_FORM_INSTMII,
	SYSZ_INSN_FORM_INSTRIB = SYSTEMZ_INSN_FORM_INSTRIB,
	SYSZ_INSN_FORM_INSTRILB = SYSTEMZ_INSN_FORM_INSTRILB,
	SYSZ_INSN_FORM_INSTRIC = SYSTEMZ_INSN_FORM_INSTRIC,
	SYSZ_INSN_FORM_INSTRILC = SYSTEMZ_INSN_FORM_INSTRILC,
	SYSZ_INSN_FORM_INSTRSI = SYSTEMZ_INSN_FORM_INSTRSI,
	SYSZ_INSN_FORM_INSTRIEE = SYSTEMZ_INSN_FORM_INSTRIEE,
	SYSZ_INSN_FORM_INSTRSA = SYSTEMZ_INSN_FORM_INSTRSA,
	SYSZ_INSN_FORM_INSTRSYA = SYSTEMZ_INSN_FORM_INSTRSYA,
	SYSZ_INSN_FORM_INSTRRFE = SYSTEMZ_INSN_FORM_INSTRRFE,
	SYSZ_INSN_FORM_INSTRSLB = SYSTEMZ_INSN_FORM_INSTRSLB,
	SYSZ_INSN_FORM_INSTS = SYSTEMZ_INSN_FORM_INSTS,
	SYSZ_INSN_FORM_INSTSIL = SYSTEMZ_INSN_FORM_INSTSIL,
	SYSZ_INSN_FORM_INSTRIS = SYSTEMZ_INSN_FORM_INSTRIS,
	SYSZ_INSN_FORM_INSTRIEC = SYSTEMZ_INSN_FORM_INSTRIEC,
	SYSZ_INSN_FORM_INSTRIEA = SYSTEMZ_INSN_FORM_INSTRIEA,
	SYSZ_INSN_FORM_INSTRRS = SYSTEMZ_INSN_FORM_INSTRRS,
	SYSZ_INSN_FORM_INSTRIEB = SYSTEMZ_INSN_FORM_INSTRIEB,
	SYSZ_INSN_FORM_INSTRRFC = SYSTEMZ_INSN_FORM_INSTRRFC,
	SYSZ_INSN_FORM_INSTSSA = SYSTEMZ_INSN_FORM_INSTSSA,
	SYSZ_INSN_FORM_INSTRSYB = SYSTEMZ_INSN_FORM_INSTRSYB,
	SYSZ_INSN_FORM_INSTSI = SYSTEMZ_INSN_FORM_INSTSI,
	SYSZ_INSN_FORM_INSTRSB = SYSTEMZ_INSN_FORM_INSTRSB,
	SYSZ_INSN_FORM_INSTRRFB = SYSTEMZ_INSN_FORM_INSTRRFB,
	SYSZ_INSN_FORM_INSTRRFD = SYSTEMZ_INSN_FORM_INSTRRFD,
	SYSZ_INSN_FORM_INSTSSF = SYSTEMZ_INSN_FORM_INSTSSF,
	SYSZ_INSN_FORM_INSTSSE = SYSTEMZ_INSN_FORM_INSTSSE,
	SYSZ_INSN_FORM_INSTRIEG = SYSTEMZ_INSN_FORM_INSTRIEG,
	SYSZ_INSN_FORM_INSTRXF = SYSTEMZ_INSN_FORM_INSTRXF,
	SYSZ_INSN_FORM_INSTRRD = SYSTEMZ_INSN_FORM_INSTRRD,
	SYSZ_INSN_FORM_INSTSSD = SYSTEMZ_INSN_FORM_INSTSSD,
	SYSZ_INSN_FORM_INSTIE = SYSTEMZ_INSN_FORM_INSTIE,
	SYSZ_INSN_FORM_INSTE = SYSTEMZ_INSN_FORM_INSTE,
	SYSZ_INSN_FORM_INSTRIEF = SYSTEMZ_INSN_FORM_INSTRIEF,
	SYSZ_INSN_FORM_INSTSSC = SYSTEMZ_INSN_FORM_INSTSSC,
	SYSZ_INSN_FORM_INSTI = SYSTEMZ_INSN_FORM_INSTI,
	SYSZ_INSN_FORM_INSTRSLA = SYSTEMZ_INSN_FORM_INSTRSLA,
	SYSZ_INSN_FORM_INSTVRRC = SYSTEMZ_INSN_FORM_INSTVRRC,
	SYSZ_INSN_FORM_INSTVRRD = SYSTEMZ_INSN_FORM_INSTVRRD,
	SYSZ_INSN_FORM_INSTVRIF = SYSTEMZ_INSN_FORM_INSTVRIF,
	SYSZ_INSN_FORM_INSTVRRA = SYSTEMZ_INSN_FORM_INSTVRRA,
	SYSZ_INSN_FORM_INSTVRRB = SYSTEMZ_INSN_FORM_INSTVRRB,
	SYSZ_INSN_FORM_INSTVRRK = SYSTEMZ_INSN_FORM_INSTVRRK,
	SYSZ_INSN_FORM_INSTVRRH = SYSTEMZ_INSN_FORM_INSTVRRH,
	SYSZ_INSN_FORM_INSTVRRJ = SYSTEMZ_INSN_FORM_INSTVRRJ,
	SYSZ_INSN_FORM_INSTVRRI = SYSTEMZ_INSN_FORM_INSTVRRI,
	SYSZ_INSN_FORM_INSTVRII = SYSTEMZ_INSN_FORM_INSTVRII,
	SYSZ_INSN_FORM_INSTVRID = SYSTEMZ_INSN_FORM_INSTVRID,
	SYSZ_INSN_FORM_INSTVRSA = SYSTEMZ_INSN_FORM_INSTVRSA,
	SYSZ_INSN_FORM_INSTVRRE = SYSTEMZ_INSN_FORM_INSTVRRE,
	SYSZ_INSN_FORM_INSTVRIE = SYSTEMZ_INSN_FORM_INSTVRIE,
	SYSZ_INSN_FORM_INSTVRIA = SYSTEMZ_INSN_FORM_INSTVRIA,
	SYSZ_INSN_FORM_INSTVRV = SYSTEMZ_INSN_FORM_INSTVRV,
	SYSZ_INSN_FORM_INSTVRIB = SYSTEMZ_INSN_FORM_INSTVRIB,
	SYSZ_INSN_FORM_INSTVRX = SYSTEMZ_INSN_FORM_INSTVRX,
	SYSZ_INSN_FORM_INSTVRSC = SYSTEMZ_INSN_FORM_INSTVRSC,
	SYSZ_INSN_FORM_INSTVRIH = SYSTEMZ_INSN_FORM_INSTVRIH,
	SYSZ_INSN_FORM_INSTVRSB = SYSTEMZ_INSN_FORM_INSTVRSB,
	SYSZ_INSN_FORM_INSTVSI = SYSTEMZ_INSN_FORM_INSTVSI,
	SYSZ_INSN_FORM_INSTVRSD = SYSTEMZ_INSN_FORM_INSTVRSD,
	SYSZ_INSN_FORM_INSTVRRF = SYSTEMZ_INSN_FORM_INSTVRRF,
	SYSZ_INSN_FORM_INSTVRIG = SYSTEMZ_INSN_FORM_INSTVRIG,
	SYSZ_INSN_FORM_INSTVRIC = SYSTEMZ_INSN_FORM_INSTVRIC,
	SYSZ_INSN_FORM_INSTVRRG = SYSTEMZ_INSN_FORM_INSTVRRG,

} sysz_insn_form;

typedef enum {
	SYSZ_AM_INVALID = SYSTEMZ_AM_INVALID,
	SYSZ_AM_BD = SYSTEMZ_AM_BD,
	SYSZ_AM_BDX = SYSTEMZ_AM_BDX,
	SYSZ_AM_BDL = SYSTEMZ_AM_BDL,
	SYSZ_AM_BDR = SYSTEMZ_AM_BDR,
	SYSZ_AM_BDV = SYSTEMZ_AM_BDV,
} sysz_addr_mode;

typedef systemz_suppl_info sysz_suppl_info;

typedef systemz_op_mem sysz_op_mem;

typedef cs_systemz_op cs_sysz_op;

#define NUM_SYSZ_OPS 6

typedef cs_systemz cs_sysz;

typedef enum {

	SYSZ_INS_INVALID = SYSTEMZ_INS_INVALID,
	SYSZ_INS_A = SYSTEMZ_INS_A,
	SYSZ_INS_AD = SYSTEMZ_INS_AD,
	SYSZ_INS_ADB = SYSTEMZ_INS_ADB,
	SYSZ_INS_ADBR = SYSTEMZ_INS_ADBR,
	SYSZ_INS_ADR = SYSTEMZ_INS_ADR,
	SYSZ_INS_ADTR = SYSTEMZ_INS_ADTR,
	SYSZ_INS_ADTRA = SYSTEMZ_INS_ADTRA,
	SYSZ_INS_AE = SYSTEMZ_INS_AE,
	SYSZ_INS_AEB = SYSTEMZ_INS_AEB,
	SYSZ_INS_AEBR = SYSTEMZ_INS_AEBR,
	SYSZ_INS_AER = SYSTEMZ_INS_AER,
	SYSZ_INS_AFI = SYSTEMZ_INS_AFI,
	SYSZ_INS_AG = SYSTEMZ_INS_AG,
	SYSZ_INS_AGF = SYSTEMZ_INS_AGF,
	SYSZ_INS_AGFI = SYSTEMZ_INS_AGFI,
	SYSZ_INS_AGFR = SYSTEMZ_INS_AGFR,
	SYSZ_INS_AGH = SYSTEMZ_INS_AGH,
	SYSZ_INS_AGHI = SYSTEMZ_INS_AGHI,
	SYSZ_INS_AGHIK = SYSTEMZ_INS_AGHIK,
	SYSZ_INS_AGR = SYSTEMZ_INS_AGR,
	SYSZ_INS_AGRK = SYSTEMZ_INS_AGRK,
	SYSZ_INS_AGSI = SYSTEMZ_INS_AGSI,
	SYSZ_INS_AH = SYSTEMZ_INS_AH,
	SYSZ_INS_AHHHR = SYSTEMZ_INS_AHHHR,
	SYSZ_INS_AHHLR = SYSTEMZ_INS_AHHLR,
	SYSZ_INS_AHI = SYSTEMZ_INS_AHI,
	SYSZ_INS_AHIK = SYSTEMZ_INS_AHIK,
	SYSZ_INS_AHY = SYSTEMZ_INS_AHY,
	SYSZ_INS_AIH = SYSTEMZ_INS_AIH,
	SYSZ_INS_AL = SYSTEMZ_INS_AL,
	SYSZ_INS_ALC = SYSTEMZ_INS_ALC,
	SYSZ_INS_ALCG = SYSTEMZ_INS_ALCG,
	SYSZ_INS_ALCGR = SYSTEMZ_INS_ALCGR,
	SYSZ_INS_ALCR = SYSTEMZ_INS_ALCR,
	SYSZ_INS_ALFI = SYSTEMZ_INS_ALFI,
	SYSZ_INS_ALG = SYSTEMZ_INS_ALG,
	SYSZ_INS_ALGF = SYSTEMZ_INS_ALGF,
	SYSZ_INS_ALGFI = SYSTEMZ_INS_ALGFI,
	SYSZ_INS_ALGFR = SYSTEMZ_INS_ALGFR,
	SYSZ_INS_ALGHSIK = SYSTEMZ_INS_ALGHSIK,
	SYSZ_INS_ALGR = SYSTEMZ_INS_ALGR,
	SYSZ_INS_ALGRK = SYSTEMZ_INS_ALGRK,
	SYSZ_INS_ALGSI = SYSTEMZ_INS_ALGSI,
	SYSZ_INS_ALHHHR = SYSTEMZ_INS_ALHHHR,
	SYSZ_INS_ALHHLR = SYSTEMZ_INS_ALHHLR,
	SYSZ_INS_ALHSIK = SYSTEMZ_INS_ALHSIK,
	SYSZ_INS_ALR = SYSTEMZ_INS_ALR,
	SYSZ_INS_ALRK = SYSTEMZ_INS_ALRK,
	SYSZ_INS_ALSI = SYSTEMZ_INS_ALSI,
	SYSZ_INS_ALSIH = SYSTEMZ_INS_ALSIH,
	SYSZ_INS_ALSIHN = SYSTEMZ_INS_ALSIHN,
	SYSZ_INS_ALY = SYSTEMZ_INS_ALY,
	SYSZ_INS_AP = SYSTEMZ_INS_AP,
	SYSZ_INS_AR = SYSTEMZ_INS_AR,
	SYSZ_INS_ARK = SYSTEMZ_INS_ARK,
	SYSZ_INS_ASI = SYSTEMZ_INS_ASI,
	SYSZ_INS_AU = SYSTEMZ_INS_AU,
	SYSZ_INS_AUR = SYSTEMZ_INS_AUR,
	SYSZ_INS_AW = SYSTEMZ_INS_AW,
	SYSZ_INS_AWR = SYSTEMZ_INS_AWR,
	SYSZ_INS_AXBR = SYSTEMZ_INS_AXBR,
	SYSZ_INS_AXR = SYSTEMZ_INS_AXR,
	SYSZ_INS_AXTR = SYSTEMZ_INS_AXTR,
	SYSZ_INS_AXTRA = SYSTEMZ_INS_AXTRA,
	SYSZ_INS_AY = SYSTEMZ_INS_AY,
	SYSZ_INS_B = SYSTEMZ_INS_B,
	SYSZ_INS_BAKR = SYSTEMZ_INS_BAKR,
	SYSZ_INS_BAL = SYSTEMZ_INS_BAL,
	SYSZ_INS_BALR = SYSTEMZ_INS_BALR,
	SYSZ_INS_BAS = SYSTEMZ_INS_BAS,
	SYSZ_INS_BASR = SYSTEMZ_INS_BASR,
	SYSZ_INS_BASSM = SYSTEMZ_INS_BASSM,
	SYSZ_INS_BE = SYSTEMZ_INS_BE,
	SYSZ_INS_BH = SYSTEMZ_INS_BH,
	SYSZ_INS_BHE = SYSTEMZ_INS_BHE,
	SYSZ_INS_BL = SYSTEMZ_INS_BL,
	SYSZ_INS_BLE = SYSTEMZ_INS_BLE,
	SYSZ_INS_BLH = SYSTEMZ_INS_BLH,
	SYSZ_INS_BM = SYSTEMZ_INS_BM,
	SYSZ_INS_BNE = SYSTEMZ_INS_BNE,
	SYSZ_INS_BNH = SYSTEMZ_INS_BNH,
	SYSZ_INS_BNHE = SYSTEMZ_INS_BNHE,
	SYSZ_INS_BNL = SYSTEMZ_INS_BNL,
	SYSZ_INS_BNLE = SYSTEMZ_INS_BNLE,
	SYSZ_INS_BNLH = SYSTEMZ_INS_BNLH,
	SYSZ_INS_BNM = SYSTEMZ_INS_BNM,
	SYSZ_INS_BNO = SYSTEMZ_INS_BNO,
	SYSZ_INS_BNP = SYSTEMZ_INS_BNP,
	SYSZ_INS_BNZ = SYSTEMZ_INS_BNZ,
	SYSZ_INS_BO = SYSTEMZ_INS_BO,
	SYSZ_INS_BP = SYSTEMZ_INS_BP,
	SYSZ_INS_BZ = SYSTEMZ_INS_BZ,
	SYSZ_INS_BC = SYSTEMZ_INS_BC,
	SYSZ_INS_BCR = SYSTEMZ_INS_BCR,
	SYSZ_INS_BCT = SYSTEMZ_INS_BCT,
	SYSZ_INS_BCTG = SYSTEMZ_INS_BCTG,
	SYSZ_INS_BCTGR = SYSTEMZ_INS_BCTGR,
	SYSZ_INS_BCTR = SYSTEMZ_INS_BCTR,
	SYSZ_INS_BI = SYSTEMZ_INS_BI,
	SYSZ_INS_BIE = SYSTEMZ_INS_BIE,
	SYSZ_INS_BIH = SYSTEMZ_INS_BIH,
	SYSZ_INS_BIHE = SYSTEMZ_INS_BIHE,
	SYSZ_INS_BIL = SYSTEMZ_INS_BIL,
	SYSZ_INS_BILE = SYSTEMZ_INS_BILE,
	SYSZ_INS_BILH = SYSTEMZ_INS_BILH,
	SYSZ_INS_BIM = SYSTEMZ_INS_BIM,
	SYSZ_INS_BINE = SYSTEMZ_INS_BINE,
	SYSZ_INS_BINH = SYSTEMZ_INS_BINH,
	SYSZ_INS_BINHE = SYSTEMZ_INS_BINHE,
	SYSZ_INS_BINL = SYSTEMZ_INS_BINL,
	SYSZ_INS_BINLE = SYSTEMZ_INS_BINLE,
	SYSZ_INS_BINLH = SYSTEMZ_INS_BINLH,
	SYSZ_INS_BINM = SYSTEMZ_INS_BINM,
	SYSZ_INS_BINO = SYSTEMZ_INS_BINO,
	SYSZ_INS_BINP = SYSTEMZ_INS_BINP,
	SYSZ_INS_BINZ = SYSTEMZ_INS_BINZ,
	SYSZ_INS_BIO = SYSTEMZ_INS_BIO,
	SYSZ_INS_BIP = SYSTEMZ_INS_BIP,
	SYSZ_INS_BIZ = SYSTEMZ_INS_BIZ,
	SYSZ_INS_BIC = SYSTEMZ_INS_BIC,
	SYSZ_INS_BPP = SYSTEMZ_INS_BPP,
	SYSZ_INS_BPRP = SYSTEMZ_INS_BPRP,
	SYSZ_INS_BR = SYSTEMZ_INS_BR,
	SYSZ_INS_BRAS = SYSTEMZ_INS_BRAS,
	SYSZ_INS_BRASL = SYSTEMZ_INS_BRASL,
	SYSZ_INS_BER = SYSTEMZ_INS_BER,
	SYSZ_INS_BHR = SYSTEMZ_INS_BHR,
	SYSZ_INS_BHER = SYSTEMZ_INS_BHER,
	SYSZ_INS_BLR = SYSTEMZ_INS_BLR,
	SYSZ_INS_BLER = SYSTEMZ_INS_BLER,
	SYSZ_INS_BLHR = SYSTEMZ_INS_BLHR,
	SYSZ_INS_BMR = SYSTEMZ_INS_BMR,
	SYSZ_INS_BNER = SYSTEMZ_INS_BNER,
	SYSZ_INS_BNHR = SYSTEMZ_INS_BNHR,
	SYSZ_INS_BNHER = SYSTEMZ_INS_BNHER,
	SYSZ_INS_BNLR = SYSTEMZ_INS_BNLR,
	SYSZ_INS_BNLER = SYSTEMZ_INS_BNLER,
	SYSZ_INS_BNLHR = SYSTEMZ_INS_BNLHR,
	SYSZ_INS_BNMR = SYSTEMZ_INS_BNMR,
	SYSZ_INS_BNOR = SYSTEMZ_INS_BNOR,
	SYSZ_INS_BNPR = SYSTEMZ_INS_BNPR,
	SYSZ_INS_BNZR = SYSTEMZ_INS_BNZR,
	SYSZ_INS_BOR = SYSTEMZ_INS_BOR,
	SYSZ_INS_BPR = SYSTEMZ_INS_BPR,
	SYSZ_INS_BZR = SYSTEMZ_INS_BZR,
	SYSZ_INS_BRC = SYSTEMZ_INS_BRC,
	SYSZ_INS_BRCL = SYSTEMZ_INS_BRCL,
	SYSZ_INS_BRCT = SYSTEMZ_INS_BRCT,
	SYSZ_INS_BRCTG = SYSTEMZ_INS_BRCTG,
	SYSZ_INS_BRCTH = SYSTEMZ_INS_BRCTH,
	SYSZ_INS_BRXH = SYSTEMZ_INS_BRXH,
	SYSZ_INS_BRXHG = SYSTEMZ_INS_BRXHG,
	SYSZ_INS_BRXLE = SYSTEMZ_INS_BRXLE,
	SYSZ_INS_BRXLG = SYSTEMZ_INS_BRXLG,
	SYSZ_INS_BSA = SYSTEMZ_INS_BSA,
	SYSZ_INS_BSG = SYSTEMZ_INS_BSG,
	SYSZ_INS_BSM = SYSTEMZ_INS_BSM,
	SYSZ_INS_BXH = SYSTEMZ_INS_BXH,
	SYSZ_INS_BXHG = SYSTEMZ_INS_BXHG,
	SYSZ_INS_BXLE = SYSTEMZ_INS_BXLE,
	SYSZ_INS_BXLEG = SYSTEMZ_INS_BXLEG,
	SYSZ_INS_C = SYSTEMZ_INS_C,
	SYSZ_INS_CD = SYSTEMZ_INS_CD,
	SYSZ_INS_CDB = SYSTEMZ_INS_CDB,
	SYSZ_INS_CDBR = SYSTEMZ_INS_CDBR,
	SYSZ_INS_CDFBR = SYSTEMZ_INS_CDFBR,
	SYSZ_INS_CDFBRA = SYSTEMZ_INS_CDFBRA,
	SYSZ_INS_CDFR = SYSTEMZ_INS_CDFR,
	SYSZ_INS_CDFTR = SYSTEMZ_INS_CDFTR,
	SYSZ_INS_CDGBR = SYSTEMZ_INS_CDGBR,
	SYSZ_INS_CDGBRA = SYSTEMZ_INS_CDGBRA,
	SYSZ_INS_CDGR = SYSTEMZ_INS_CDGR,
	SYSZ_INS_CDGTR = SYSTEMZ_INS_CDGTR,
	SYSZ_INS_CDGTRA = SYSTEMZ_INS_CDGTRA,
	SYSZ_INS_CDLFBR = SYSTEMZ_INS_CDLFBR,
	SYSZ_INS_CDLFTR = SYSTEMZ_INS_CDLFTR,
	SYSZ_INS_CDLGBR = SYSTEMZ_INS_CDLGBR,
	SYSZ_INS_CDLGTR = SYSTEMZ_INS_CDLGTR,
	SYSZ_INS_CDPT = SYSTEMZ_INS_CDPT,
	SYSZ_INS_CDR = SYSTEMZ_INS_CDR,
	SYSZ_INS_CDS = SYSTEMZ_INS_CDS,
	SYSZ_INS_CDSG = SYSTEMZ_INS_CDSG,
	SYSZ_INS_CDSTR = SYSTEMZ_INS_CDSTR,
	SYSZ_INS_CDSY = SYSTEMZ_INS_CDSY,
	SYSZ_INS_CDTR = SYSTEMZ_INS_CDTR,
	SYSZ_INS_CDUTR = SYSTEMZ_INS_CDUTR,
	SYSZ_INS_CDZT = SYSTEMZ_INS_CDZT,
	SYSZ_INS_CE = SYSTEMZ_INS_CE,
	SYSZ_INS_CEB = SYSTEMZ_INS_CEB,
	SYSZ_INS_CEBR = SYSTEMZ_INS_CEBR,
	SYSZ_INS_CEDTR = SYSTEMZ_INS_CEDTR,
	SYSZ_INS_CEFBR = SYSTEMZ_INS_CEFBR,
	SYSZ_INS_CEFBRA = SYSTEMZ_INS_CEFBRA,
	SYSZ_INS_CEFR = SYSTEMZ_INS_CEFR,
	SYSZ_INS_CEGBR = SYSTEMZ_INS_CEGBR,
	SYSZ_INS_CEGBRA = SYSTEMZ_INS_CEGBRA,
	SYSZ_INS_CEGR = SYSTEMZ_INS_CEGR,
	SYSZ_INS_CELFBR = SYSTEMZ_INS_CELFBR,
	SYSZ_INS_CELGBR = SYSTEMZ_INS_CELGBR,
	SYSZ_INS_CER = SYSTEMZ_INS_CER,
	SYSZ_INS_CEXTR = SYSTEMZ_INS_CEXTR,
	SYSZ_INS_CFC = SYSTEMZ_INS_CFC,
	SYSZ_INS_CFDBR = SYSTEMZ_INS_CFDBR,
	SYSZ_INS_CFDBRA = SYSTEMZ_INS_CFDBRA,
	SYSZ_INS_CFDR = SYSTEMZ_INS_CFDR,
	SYSZ_INS_CFDTR = SYSTEMZ_INS_CFDTR,
	SYSZ_INS_CFEBR = SYSTEMZ_INS_CFEBR,
	SYSZ_INS_CFEBRA = SYSTEMZ_INS_CFEBRA,
	SYSZ_INS_CFER = SYSTEMZ_INS_CFER,
	SYSZ_INS_CFI = SYSTEMZ_INS_CFI,
	SYSZ_INS_CFXBR = SYSTEMZ_INS_CFXBR,
	SYSZ_INS_CFXBRA = SYSTEMZ_INS_CFXBRA,
	SYSZ_INS_CFXR = SYSTEMZ_INS_CFXR,
	SYSZ_INS_CFXTR = SYSTEMZ_INS_CFXTR,
	SYSZ_INS_CG = SYSTEMZ_INS_CG,
	SYSZ_INS_CGDBR = SYSTEMZ_INS_CGDBR,
	SYSZ_INS_CGDBRA = SYSTEMZ_INS_CGDBRA,
	SYSZ_INS_CGDR = SYSTEMZ_INS_CGDR,
	SYSZ_INS_CGDTR = SYSTEMZ_INS_CGDTR,
	SYSZ_INS_CGDTRA = SYSTEMZ_INS_CGDTRA,
	SYSZ_INS_CGEBR = SYSTEMZ_INS_CGEBR,
	SYSZ_INS_CGEBRA = SYSTEMZ_INS_CGEBRA,
	SYSZ_INS_CGER = SYSTEMZ_INS_CGER,
	SYSZ_INS_CGF = SYSTEMZ_INS_CGF,
	SYSZ_INS_CGFI = SYSTEMZ_INS_CGFI,
	SYSZ_INS_CGFR = SYSTEMZ_INS_CGFR,
	SYSZ_INS_CGFRL = SYSTEMZ_INS_CGFRL,
	SYSZ_INS_CGH = SYSTEMZ_INS_CGH,
	SYSZ_INS_CGHI = SYSTEMZ_INS_CGHI,
	SYSZ_INS_CGHRL = SYSTEMZ_INS_CGHRL,
	SYSZ_INS_CGHSI = SYSTEMZ_INS_CGHSI,
	SYSZ_INS_CGIB = SYSTEMZ_INS_CGIB,
	SYSZ_INS_CGIBE = SYSTEMZ_INS_CGIBE,
	SYSZ_INS_CGIBH = SYSTEMZ_INS_CGIBH,
	SYSZ_INS_CGIBHE = SYSTEMZ_INS_CGIBHE,
	SYSZ_INS_CGIBL = SYSTEMZ_INS_CGIBL,
	SYSZ_INS_CGIBLE = SYSTEMZ_INS_CGIBLE,
	SYSZ_INS_CGIBLH = SYSTEMZ_INS_CGIBLH,
	SYSZ_INS_CGIBNE = SYSTEMZ_INS_CGIBNE,
	SYSZ_INS_CGIBNH = SYSTEMZ_INS_CGIBNH,
	SYSZ_INS_CGIBNHE = SYSTEMZ_INS_CGIBNHE,
	SYSZ_INS_CGIBNL = SYSTEMZ_INS_CGIBNL,
	SYSZ_INS_CGIBNLE = SYSTEMZ_INS_CGIBNLE,
	SYSZ_INS_CGIBNLH = SYSTEMZ_INS_CGIBNLH,
	SYSZ_INS_CGIJ = SYSTEMZ_INS_CGIJ,
	SYSZ_INS_CGIJE = SYSTEMZ_INS_CGIJE,
	SYSZ_INS_CGIJH = SYSTEMZ_INS_CGIJH,
	SYSZ_INS_CGIJHE = SYSTEMZ_INS_CGIJHE,
	SYSZ_INS_CGIJL = SYSTEMZ_INS_CGIJL,
	SYSZ_INS_CGIJLE = SYSTEMZ_INS_CGIJLE,
	SYSZ_INS_CGIJLH = SYSTEMZ_INS_CGIJLH,
	SYSZ_INS_CGIJNE = SYSTEMZ_INS_CGIJNE,
	SYSZ_INS_CGIJNH = SYSTEMZ_INS_CGIJNH,
	SYSZ_INS_CGIJNHE = SYSTEMZ_INS_CGIJNHE,
	SYSZ_INS_CGIJNL = SYSTEMZ_INS_CGIJNL,
	SYSZ_INS_CGIJNLE = SYSTEMZ_INS_CGIJNLE,
	SYSZ_INS_CGIJNLH = SYSTEMZ_INS_CGIJNLH,
	SYSZ_INS_CGIT = SYSTEMZ_INS_CGIT,
	SYSZ_INS_CGITE = SYSTEMZ_INS_CGITE,
	SYSZ_INS_CGITH = SYSTEMZ_INS_CGITH,
	SYSZ_INS_CGITHE = SYSTEMZ_INS_CGITHE,
	SYSZ_INS_CGITL = SYSTEMZ_INS_CGITL,
	SYSZ_INS_CGITLE = SYSTEMZ_INS_CGITLE,
	SYSZ_INS_CGITLH = SYSTEMZ_INS_CGITLH,
	SYSZ_INS_CGITNE = SYSTEMZ_INS_CGITNE,
	SYSZ_INS_CGITNH = SYSTEMZ_INS_CGITNH,
	SYSZ_INS_CGITNHE = SYSTEMZ_INS_CGITNHE,
	SYSZ_INS_CGITNL = SYSTEMZ_INS_CGITNL,
	SYSZ_INS_CGITNLE = SYSTEMZ_INS_CGITNLE,
	SYSZ_INS_CGITNLH = SYSTEMZ_INS_CGITNLH,
	SYSZ_INS_CGR = SYSTEMZ_INS_CGR,
	SYSZ_INS_CGRB = SYSTEMZ_INS_CGRB,
	SYSZ_INS_CGRBE = SYSTEMZ_INS_CGRBE,
	SYSZ_INS_CGRBH = SYSTEMZ_INS_CGRBH,
	SYSZ_INS_CGRBHE = SYSTEMZ_INS_CGRBHE,
	SYSZ_INS_CGRBL = SYSTEMZ_INS_CGRBL,
	SYSZ_INS_CGRBLE = SYSTEMZ_INS_CGRBLE,
	SYSZ_INS_CGRBLH = SYSTEMZ_INS_CGRBLH,
	SYSZ_INS_CGRBNE = SYSTEMZ_INS_CGRBNE,
	SYSZ_INS_CGRBNH = SYSTEMZ_INS_CGRBNH,
	SYSZ_INS_CGRBNHE = SYSTEMZ_INS_CGRBNHE,
	SYSZ_INS_CGRBNL = SYSTEMZ_INS_CGRBNL,
	SYSZ_INS_CGRBNLE = SYSTEMZ_INS_CGRBNLE,
	SYSZ_INS_CGRBNLH = SYSTEMZ_INS_CGRBNLH,
	SYSZ_INS_CGRJ = SYSTEMZ_INS_CGRJ,
	SYSZ_INS_CGRJE = SYSTEMZ_INS_CGRJE,
	SYSZ_INS_CGRJH = SYSTEMZ_INS_CGRJH,
	SYSZ_INS_CGRJHE = SYSTEMZ_INS_CGRJHE,
	SYSZ_INS_CGRJL = SYSTEMZ_INS_CGRJL,
	SYSZ_INS_CGRJLE = SYSTEMZ_INS_CGRJLE,
	SYSZ_INS_CGRJLH = SYSTEMZ_INS_CGRJLH,
	SYSZ_INS_CGRJNE = SYSTEMZ_INS_CGRJNE,
	SYSZ_INS_CGRJNH = SYSTEMZ_INS_CGRJNH,
	SYSZ_INS_CGRJNHE = SYSTEMZ_INS_CGRJNHE,
	SYSZ_INS_CGRJNL = SYSTEMZ_INS_CGRJNL,
	SYSZ_INS_CGRJNLE = SYSTEMZ_INS_CGRJNLE,
	SYSZ_INS_CGRJNLH = SYSTEMZ_INS_CGRJNLH,
	SYSZ_INS_CGRL = SYSTEMZ_INS_CGRL,
	SYSZ_INS_CGRT = SYSTEMZ_INS_CGRT,
	SYSZ_INS_CGRTE = SYSTEMZ_INS_CGRTE,
	SYSZ_INS_CGRTH = SYSTEMZ_INS_CGRTH,
	SYSZ_INS_CGRTHE = SYSTEMZ_INS_CGRTHE,
	SYSZ_INS_CGRTL = SYSTEMZ_INS_CGRTL,
	SYSZ_INS_CGRTLE = SYSTEMZ_INS_CGRTLE,
	SYSZ_INS_CGRTLH = SYSTEMZ_INS_CGRTLH,
	SYSZ_INS_CGRTNE = SYSTEMZ_INS_CGRTNE,
	SYSZ_INS_CGRTNH = SYSTEMZ_INS_CGRTNH,
	SYSZ_INS_CGRTNHE = SYSTEMZ_INS_CGRTNHE,
	SYSZ_INS_CGRTNL = SYSTEMZ_INS_CGRTNL,
	SYSZ_INS_CGRTNLE = SYSTEMZ_INS_CGRTNLE,
	SYSZ_INS_CGRTNLH = SYSTEMZ_INS_CGRTNLH,
	SYSZ_INS_CGXBR = SYSTEMZ_INS_CGXBR,
	SYSZ_INS_CGXBRA = SYSTEMZ_INS_CGXBRA,
	SYSZ_INS_CGXR = SYSTEMZ_INS_CGXR,
	SYSZ_INS_CGXTR = SYSTEMZ_INS_CGXTR,
	SYSZ_INS_CGXTRA = SYSTEMZ_INS_CGXTRA,
	SYSZ_INS_CH = SYSTEMZ_INS_CH,
	SYSZ_INS_CHF = SYSTEMZ_INS_CHF,
	SYSZ_INS_CHHR = SYSTEMZ_INS_CHHR,
	SYSZ_INS_CHHSI = SYSTEMZ_INS_CHHSI,
	SYSZ_INS_CHI = SYSTEMZ_INS_CHI,
	SYSZ_INS_CHLR = SYSTEMZ_INS_CHLR,
	SYSZ_INS_CHRL = SYSTEMZ_INS_CHRL,
	SYSZ_INS_CHSI = SYSTEMZ_INS_CHSI,
	SYSZ_INS_CHY = SYSTEMZ_INS_CHY,
	SYSZ_INS_CIB = SYSTEMZ_INS_CIB,
	SYSZ_INS_CIBE = SYSTEMZ_INS_CIBE,
	SYSZ_INS_CIBH = SYSTEMZ_INS_CIBH,
	SYSZ_INS_CIBHE = SYSTEMZ_INS_CIBHE,
	SYSZ_INS_CIBL = SYSTEMZ_INS_CIBL,
	SYSZ_INS_CIBLE = SYSTEMZ_INS_CIBLE,
	SYSZ_INS_CIBLH = SYSTEMZ_INS_CIBLH,
	SYSZ_INS_CIBNE = SYSTEMZ_INS_CIBNE,
	SYSZ_INS_CIBNH = SYSTEMZ_INS_CIBNH,
	SYSZ_INS_CIBNHE = SYSTEMZ_INS_CIBNHE,
	SYSZ_INS_CIBNL = SYSTEMZ_INS_CIBNL,
	SYSZ_INS_CIBNLE = SYSTEMZ_INS_CIBNLE,
	SYSZ_INS_CIBNLH = SYSTEMZ_INS_CIBNLH,
	SYSZ_INS_CIH = SYSTEMZ_INS_CIH,
	SYSZ_INS_CIJ = SYSTEMZ_INS_CIJ,
	SYSZ_INS_CIJE = SYSTEMZ_INS_CIJE,
	SYSZ_INS_CIJH = SYSTEMZ_INS_CIJH,
	SYSZ_INS_CIJHE = SYSTEMZ_INS_CIJHE,
	SYSZ_INS_CIJL = SYSTEMZ_INS_CIJL,
	SYSZ_INS_CIJLE = SYSTEMZ_INS_CIJLE,
	SYSZ_INS_CIJLH = SYSTEMZ_INS_CIJLH,
	SYSZ_INS_CIJNE = SYSTEMZ_INS_CIJNE,
	SYSZ_INS_CIJNH = SYSTEMZ_INS_CIJNH,
	SYSZ_INS_CIJNHE = SYSTEMZ_INS_CIJNHE,
	SYSZ_INS_CIJNL = SYSTEMZ_INS_CIJNL,
	SYSZ_INS_CIJNLE = SYSTEMZ_INS_CIJNLE,
	SYSZ_INS_CIJNLH = SYSTEMZ_INS_CIJNLH,
	SYSZ_INS_CIT = SYSTEMZ_INS_CIT,
	SYSZ_INS_CITE = SYSTEMZ_INS_CITE,
	SYSZ_INS_CITH = SYSTEMZ_INS_CITH,
	SYSZ_INS_CITHE = SYSTEMZ_INS_CITHE,
	SYSZ_INS_CITL = SYSTEMZ_INS_CITL,
	SYSZ_INS_CITLE = SYSTEMZ_INS_CITLE,
	SYSZ_INS_CITLH = SYSTEMZ_INS_CITLH,
	SYSZ_INS_CITNE = SYSTEMZ_INS_CITNE,
	SYSZ_INS_CITNH = SYSTEMZ_INS_CITNH,
	SYSZ_INS_CITNHE = SYSTEMZ_INS_CITNHE,
	SYSZ_INS_CITNL = SYSTEMZ_INS_CITNL,
	SYSZ_INS_CITNLE = SYSTEMZ_INS_CITNLE,
	SYSZ_INS_CITNLH = SYSTEMZ_INS_CITNLH,
	SYSZ_INS_CKSM = SYSTEMZ_INS_CKSM,
	SYSZ_INS_CL = SYSTEMZ_INS_CL,
	SYSZ_INS_CLC = SYSTEMZ_INS_CLC,
	SYSZ_INS_CLCL = SYSTEMZ_INS_CLCL,
	SYSZ_INS_CLCLE = SYSTEMZ_INS_CLCLE,
	SYSZ_INS_CLCLU = SYSTEMZ_INS_CLCLU,
	SYSZ_INS_CLFDBR = SYSTEMZ_INS_CLFDBR,
	SYSZ_INS_CLFDTR = SYSTEMZ_INS_CLFDTR,
	SYSZ_INS_CLFEBR = SYSTEMZ_INS_CLFEBR,
	SYSZ_INS_CLFHSI = SYSTEMZ_INS_CLFHSI,
	SYSZ_INS_CLFI = SYSTEMZ_INS_CLFI,
	SYSZ_INS_CLFIT = SYSTEMZ_INS_CLFIT,
	SYSZ_INS_CLFITE = SYSTEMZ_INS_CLFITE,
	SYSZ_INS_CLFITH = SYSTEMZ_INS_CLFITH,
	SYSZ_INS_CLFITHE = SYSTEMZ_INS_CLFITHE,
	SYSZ_INS_CLFITL = SYSTEMZ_INS_CLFITL,
	SYSZ_INS_CLFITLE = SYSTEMZ_INS_CLFITLE,
	SYSZ_INS_CLFITLH = SYSTEMZ_INS_CLFITLH,
	SYSZ_INS_CLFITNE = SYSTEMZ_INS_CLFITNE,
	SYSZ_INS_CLFITNH = SYSTEMZ_INS_CLFITNH,
	SYSZ_INS_CLFITNHE = SYSTEMZ_INS_CLFITNHE,
	SYSZ_INS_CLFITNL = SYSTEMZ_INS_CLFITNL,
	SYSZ_INS_CLFITNLE = SYSTEMZ_INS_CLFITNLE,
	SYSZ_INS_CLFITNLH = SYSTEMZ_INS_CLFITNLH,
	SYSZ_INS_CLFXBR = SYSTEMZ_INS_CLFXBR,
	SYSZ_INS_CLFXTR = SYSTEMZ_INS_CLFXTR,
	SYSZ_INS_CLG = SYSTEMZ_INS_CLG,
	SYSZ_INS_CLGDBR = SYSTEMZ_INS_CLGDBR,
	SYSZ_INS_CLGDTR = SYSTEMZ_INS_CLGDTR,
	SYSZ_INS_CLGEBR = SYSTEMZ_INS_CLGEBR,
	SYSZ_INS_CLGF = SYSTEMZ_INS_CLGF,
	SYSZ_INS_CLGFI = SYSTEMZ_INS_CLGFI,
	SYSZ_INS_CLGFR = SYSTEMZ_INS_CLGFR,
	SYSZ_INS_CLGFRL = SYSTEMZ_INS_CLGFRL,
	SYSZ_INS_CLGHRL = SYSTEMZ_INS_CLGHRL,
	SYSZ_INS_CLGHSI = SYSTEMZ_INS_CLGHSI,
	SYSZ_INS_CLGIB = SYSTEMZ_INS_CLGIB,
	SYSZ_INS_CLGIBE = SYSTEMZ_INS_CLGIBE,
	SYSZ_INS_CLGIBH = SYSTEMZ_INS_CLGIBH,
	SYSZ_INS_CLGIBHE = SYSTEMZ_INS_CLGIBHE,
	SYSZ_INS_CLGIBL = SYSTEMZ_INS_CLGIBL,
	SYSZ_INS_CLGIBLE = SYSTEMZ_INS_CLGIBLE,
	SYSZ_INS_CLGIBLH = SYSTEMZ_INS_CLGIBLH,
	SYSZ_INS_CLGIBNE = SYSTEMZ_INS_CLGIBNE,
	SYSZ_INS_CLGIBNH = SYSTEMZ_INS_CLGIBNH,
	SYSZ_INS_CLGIBNHE = SYSTEMZ_INS_CLGIBNHE,
	SYSZ_INS_CLGIBNL = SYSTEMZ_INS_CLGIBNL,
	SYSZ_INS_CLGIBNLE = SYSTEMZ_INS_CLGIBNLE,
	SYSZ_INS_CLGIBNLH = SYSTEMZ_INS_CLGIBNLH,
	SYSZ_INS_CLGIJ = SYSTEMZ_INS_CLGIJ,
	SYSZ_INS_CLGIJE = SYSTEMZ_INS_CLGIJE,
	SYSZ_INS_CLGIJH = SYSTEMZ_INS_CLGIJH,
	SYSZ_INS_CLGIJHE = SYSTEMZ_INS_CLGIJHE,
	SYSZ_INS_CLGIJL = SYSTEMZ_INS_CLGIJL,
	SYSZ_INS_CLGIJLE = SYSTEMZ_INS_CLGIJLE,
	SYSZ_INS_CLGIJLH = SYSTEMZ_INS_CLGIJLH,
	SYSZ_INS_CLGIJNE = SYSTEMZ_INS_CLGIJNE,
	SYSZ_INS_CLGIJNH = SYSTEMZ_INS_CLGIJNH,
	SYSZ_INS_CLGIJNHE = SYSTEMZ_INS_CLGIJNHE,
	SYSZ_INS_CLGIJNL = SYSTEMZ_INS_CLGIJNL,
	SYSZ_INS_CLGIJNLE = SYSTEMZ_INS_CLGIJNLE,
	SYSZ_INS_CLGIJNLH = SYSTEMZ_INS_CLGIJNLH,
	SYSZ_INS_CLGIT = SYSTEMZ_INS_CLGIT,
	SYSZ_INS_CLGITE = SYSTEMZ_INS_CLGITE,
	SYSZ_INS_CLGITH = SYSTEMZ_INS_CLGITH,
	SYSZ_INS_CLGITHE = SYSTEMZ_INS_CLGITHE,
	SYSZ_INS_CLGITL = SYSTEMZ_INS_CLGITL,
	SYSZ_INS_CLGITLE = SYSTEMZ_INS_CLGITLE,
	SYSZ_INS_CLGITLH = SYSTEMZ_INS_CLGITLH,
	SYSZ_INS_CLGITNE = SYSTEMZ_INS_CLGITNE,
	SYSZ_INS_CLGITNH = SYSTEMZ_INS_CLGITNH,
	SYSZ_INS_CLGITNHE = SYSTEMZ_INS_CLGITNHE,
	SYSZ_INS_CLGITNL = SYSTEMZ_INS_CLGITNL,
	SYSZ_INS_CLGITNLE = SYSTEMZ_INS_CLGITNLE,
	SYSZ_INS_CLGITNLH = SYSTEMZ_INS_CLGITNLH,
	SYSZ_INS_CLGR = SYSTEMZ_INS_CLGR,
	SYSZ_INS_CLGRB = SYSTEMZ_INS_CLGRB,
	SYSZ_INS_CLGRBE = SYSTEMZ_INS_CLGRBE,
	SYSZ_INS_CLGRBH = SYSTEMZ_INS_CLGRBH,
	SYSZ_INS_CLGRBHE = SYSTEMZ_INS_CLGRBHE,
	SYSZ_INS_CLGRBL = SYSTEMZ_INS_CLGRBL,
	SYSZ_INS_CLGRBLE = SYSTEMZ_INS_CLGRBLE,
	SYSZ_INS_CLGRBLH = SYSTEMZ_INS_CLGRBLH,
	SYSZ_INS_CLGRBNE = SYSTEMZ_INS_CLGRBNE,
	SYSZ_INS_CLGRBNH = SYSTEMZ_INS_CLGRBNH,
	SYSZ_INS_CLGRBNHE = SYSTEMZ_INS_CLGRBNHE,
	SYSZ_INS_CLGRBNL = SYSTEMZ_INS_CLGRBNL,
	SYSZ_INS_CLGRBNLE = SYSTEMZ_INS_CLGRBNLE,
	SYSZ_INS_CLGRBNLH = SYSTEMZ_INS_CLGRBNLH,
	SYSZ_INS_CLGRJ = SYSTEMZ_INS_CLGRJ,
	SYSZ_INS_CLGRJE = SYSTEMZ_INS_CLGRJE,
	SYSZ_INS_CLGRJH = SYSTEMZ_INS_CLGRJH,
	SYSZ_INS_CLGRJHE = SYSTEMZ_INS_CLGRJHE,
	SYSZ_INS_CLGRJL = SYSTEMZ_INS_CLGRJL,
	SYSZ_INS_CLGRJLE = SYSTEMZ_INS_CLGRJLE,
	SYSZ_INS_CLGRJLH = SYSTEMZ_INS_CLGRJLH,
	SYSZ_INS_CLGRJNE = SYSTEMZ_INS_CLGRJNE,
	SYSZ_INS_CLGRJNH = SYSTEMZ_INS_CLGRJNH,
	SYSZ_INS_CLGRJNHE = SYSTEMZ_INS_CLGRJNHE,
	SYSZ_INS_CLGRJNL = SYSTEMZ_INS_CLGRJNL,
	SYSZ_INS_CLGRJNLE = SYSTEMZ_INS_CLGRJNLE,
	SYSZ_INS_CLGRJNLH = SYSTEMZ_INS_CLGRJNLH,
	SYSZ_INS_CLGRL = SYSTEMZ_INS_CLGRL,
	SYSZ_INS_CLGRT = SYSTEMZ_INS_CLGRT,
	SYSZ_INS_CLGRTE = SYSTEMZ_INS_CLGRTE,
	SYSZ_INS_CLGRTH = SYSTEMZ_INS_CLGRTH,
	SYSZ_INS_CLGRTHE = SYSTEMZ_INS_CLGRTHE,
	SYSZ_INS_CLGRTL = SYSTEMZ_INS_CLGRTL,
	SYSZ_INS_CLGRTLE = SYSTEMZ_INS_CLGRTLE,
	SYSZ_INS_CLGRTLH = SYSTEMZ_INS_CLGRTLH,
	SYSZ_INS_CLGRTNE = SYSTEMZ_INS_CLGRTNE,
	SYSZ_INS_CLGRTNH = SYSTEMZ_INS_CLGRTNH,
	SYSZ_INS_CLGRTNHE = SYSTEMZ_INS_CLGRTNHE,
	SYSZ_INS_CLGRTNL = SYSTEMZ_INS_CLGRTNL,
	SYSZ_INS_CLGRTNLE = SYSTEMZ_INS_CLGRTNLE,
	SYSZ_INS_CLGRTNLH = SYSTEMZ_INS_CLGRTNLH,
	SYSZ_INS_CLGT = SYSTEMZ_INS_CLGT,
	SYSZ_INS_CLGTE = SYSTEMZ_INS_CLGTE,
	SYSZ_INS_CLGTH = SYSTEMZ_INS_CLGTH,
	SYSZ_INS_CLGTHE = SYSTEMZ_INS_CLGTHE,
	SYSZ_INS_CLGTL = SYSTEMZ_INS_CLGTL,
	SYSZ_INS_CLGTLE = SYSTEMZ_INS_CLGTLE,
	SYSZ_INS_CLGTLH = SYSTEMZ_INS_CLGTLH,
	SYSZ_INS_CLGTNE = SYSTEMZ_INS_CLGTNE,
	SYSZ_INS_CLGTNH = SYSTEMZ_INS_CLGTNH,
	SYSZ_INS_CLGTNHE = SYSTEMZ_INS_CLGTNHE,
	SYSZ_INS_CLGTNL = SYSTEMZ_INS_CLGTNL,
	SYSZ_INS_CLGTNLE = SYSTEMZ_INS_CLGTNLE,
	SYSZ_INS_CLGTNLH = SYSTEMZ_INS_CLGTNLH,
	SYSZ_INS_CLGXBR = SYSTEMZ_INS_CLGXBR,
	SYSZ_INS_CLGXTR = SYSTEMZ_INS_CLGXTR,
	SYSZ_INS_CLHF = SYSTEMZ_INS_CLHF,
	SYSZ_INS_CLHHR = SYSTEMZ_INS_CLHHR,
	SYSZ_INS_CLHHSI = SYSTEMZ_INS_CLHHSI,
	SYSZ_INS_CLHLR = SYSTEMZ_INS_CLHLR,
	SYSZ_INS_CLHRL = SYSTEMZ_INS_CLHRL,
	SYSZ_INS_CLI = SYSTEMZ_INS_CLI,
	SYSZ_INS_CLIB = SYSTEMZ_INS_CLIB,
	SYSZ_INS_CLIBE = SYSTEMZ_INS_CLIBE,
	SYSZ_INS_CLIBH = SYSTEMZ_INS_CLIBH,
	SYSZ_INS_CLIBHE = SYSTEMZ_INS_CLIBHE,
	SYSZ_INS_CLIBL = SYSTEMZ_INS_CLIBL,
	SYSZ_INS_CLIBLE = SYSTEMZ_INS_CLIBLE,
	SYSZ_INS_CLIBLH = SYSTEMZ_INS_CLIBLH,
	SYSZ_INS_CLIBNE = SYSTEMZ_INS_CLIBNE,
	SYSZ_INS_CLIBNH = SYSTEMZ_INS_CLIBNH,
	SYSZ_INS_CLIBNHE = SYSTEMZ_INS_CLIBNHE,
	SYSZ_INS_CLIBNL = SYSTEMZ_INS_CLIBNL,
	SYSZ_INS_CLIBNLE = SYSTEMZ_INS_CLIBNLE,
	SYSZ_INS_CLIBNLH = SYSTEMZ_INS_CLIBNLH,
	SYSZ_INS_CLIH = SYSTEMZ_INS_CLIH,
	SYSZ_INS_CLIJ = SYSTEMZ_INS_CLIJ,
	SYSZ_INS_CLIJE = SYSTEMZ_INS_CLIJE,
	SYSZ_INS_CLIJH = SYSTEMZ_INS_CLIJH,
	SYSZ_INS_CLIJHE = SYSTEMZ_INS_CLIJHE,
	SYSZ_INS_CLIJL = SYSTEMZ_INS_CLIJL,
	SYSZ_INS_CLIJLE = SYSTEMZ_INS_CLIJLE,
	SYSZ_INS_CLIJLH = SYSTEMZ_INS_CLIJLH,
	SYSZ_INS_CLIJNE = SYSTEMZ_INS_CLIJNE,
	SYSZ_INS_CLIJNH = SYSTEMZ_INS_CLIJNH,
	SYSZ_INS_CLIJNHE = SYSTEMZ_INS_CLIJNHE,
	SYSZ_INS_CLIJNL = SYSTEMZ_INS_CLIJNL,
	SYSZ_INS_CLIJNLE = SYSTEMZ_INS_CLIJNLE,
	SYSZ_INS_CLIJNLH = SYSTEMZ_INS_CLIJNLH,
	SYSZ_INS_CLIY = SYSTEMZ_INS_CLIY,
	SYSZ_INS_CLM = SYSTEMZ_INS_CLM,
	SYSZ_INS_CLMH = SYSTEMZ_INS_CLMH,
	SYSZ_INS_CLMY = SYSTEMZ_INS_CLMY,
	SYSZ_INS_CLR = SYSTEMZ_INS_CLR,
	SYSZ_INS_CLRB = SYSTEMZ_INS_CLRB,
	SYSZ_INS_CLRBE = SYSTEMZ_INS_CLRBE,
	SYSZ_INS_CLRBH = SYSTEMZ_INS_CLRBH,
	SYSZ_INS_CLRBHE = SYSTEMZ_INS_CLRBHE,
	SYSZ_INS_CLRBL = SYSTEMZ_INS_CLRBL,
	SYSZ_INS_CLRBLE = SYSTEMZ_INS_CLRBLE,
	SYSZ_INS_CLRBLH = SYSTEMZ_INS_CLRBLH,
	SYSZ_INS_CLRBNE = SYSTEMZ_INS_CLRBNE,
	SYSZ_INS_CLRBNH = SYSTEMZ_INS_CLRBNH,
	SYSZ_INS_CLRBNHE = SYSTEMZ_INS_CLRBNHE,
	SYSZ_INS_CLRBNL = SYSTEMZ_INS_CLRBNL,
	SYSZ_INS_CLRBNLE = SYSTEMZ_INS_CLRBNLE,
	SYSZ_INS_CLRBNLH = SYSTEMZ_INS_CLRBNLH,
	SYSZ_INS_CLRJ = SYSTEMZ_INS_CLRJ,
	SYSZ_INS_CLRJE = SYSTEMZ_INS_CLRJE,
	SYSZ_INS_CLRJH = SYSTEMZ_INS_CLRJH,
	SYSZ_INS_CLRJHE = SYSTEMZ_INS_CLRJHE,
	SYSZ_INS_CLRJL = SYSTEMZ_INS_CLRJL,
	SYSZ_INS_CLRJLE = SYSTEMZ_INS_CLRJLE,
	SYSZ_INS_CLRJLH = SYSTEMZ_INS_CLRJLH,
	SYSZ_INS_CLRJNE = SYSTEMZ_INS_CLRJNE,
	SYSZ_INS_CLRJNH = SYSTEMZ_INS_CLRJNH,
	SYSZ_INS_CLRJNHE = SYSTEMZ_INS_CLRJNHE,
	SYSZ_INS_CLRJNL = SYSTEMZ_INS_CLRJNL,
	SYSZ_INS_CLRJNLE = SYSTEMZ_INS_CLRJNLE,
	SYSZ_INS_CLRJNLH = SYSTEMZ_INS_CLRJNLH,
	SYSZ_INS_CLRL = SYSTEMZ_INS_CLRL,
	SYSZ_INS_CLRT = SYSTEMZ_INS_CLRT,
	SYSZ_INS_CLRTE = SYSTEMZ_INS_CLRTE,
	SYSZ_INS_CLRTH = SYSTEMZ_INS_CLRTH,
	SYSZ_INS_CLRTHE = SYSTEMZ_INS_CLRTHE,
	SYSZ_INS_CLRTL = SYSTEMZ_INS_CLRTL,
	SYSZ_INS_CLRTLE = SYSTEMZ_INS_CLRTLE,
	SYSZ_INS_CLRTLH = SYSTEMZ_INS_CLRTLH,
	SYSZ_INS_CLRTNE = SYSTEMZ_INS_CLRTNE,
	SYSZ_INS_CLRTNH = SYSTEMZ_INS_CLRTNH,
	SYSZ_INS_CLRTNHE = SYSTEMZ_INS_CLRTNHE,
	SYSZ_INS_CLRTNL = SYSTEMZ_INS_CLRTNL,
	SYSZ_INS_CLRTNLE = SYSTEMZ_INS_CLRTNLE,
	SYSZ_INS_CLRTNLH = SYSTEMZ_INS_CLRTNLH,
	SYSZ_INS_CLST = SYSTEMZ_INS_CLST,
	SYSZ_INS_CLT = SYSTEMZ_INS_CLT,
	SYSZ_INS_CLTE = SYSTEMZ_INS_CLTE,
	SYSZ_INS_CLTH = SYSTEMZ_INS_CLTH,
	SYSZ_INS_CLTHE = SYSTEMZ_INS_CLTHE,
	SYSZ_INS_CLTL = SYSTEMZ_INS_CLTL,
	SYSZ_INS_CLTLE = SYSTEMZ_INS_CLTLE,
	SYSZ_INS_CLTLH = SYSTEMZ_INS_CLTLH,
	SYSZ_INS_CLTNE = SYSTEMZ_INS_CLTNE,
	SYSZ_INS_CLTNH = SYSTEMZ_INS_CLTNH,
	SYSZ_INS_CLTNHE = SYSTEMZ_INS_CLTNHE,
	SYSZ_INS_CLTNL = SYSTEMZ_INS_CLTNL,
	SYSZ_INS_CLTNLE = SYSTEMZ_INS_CLTNLE,
	SYSZ_INS_CLTNLH = SYSTEMZ_INS_CLTNLH,
	SYSZ_INS_CLY = SYSTEMZ_INS_CLY,
	SYSZ_INS_CMPSC = SYSTEMZ_INS_CMPSC,
	SYSZ_INS_CP = SYSTEMZ_INS_CP,
	SYSZ_INS_CPDT = SYSTEMZ_INS_CPDT,
	SYSZ_INS_CPSDR = SYSTEMZ_INS_CPSDR,
	SYSZ_INS_CPXT = SYSTEMZ_INS_CPXT,
	SYSZ_INS_CPYA = SYSTEMZ_INS_CPYA,
	SYSZ_INS_CR = SYSTEMZ_INS_CR,
	SYSZ_INS_CRB = SYSTEMZ_INS_CRB,
	SYSZ_INS_CRBE = SYSTEMZ_INS_CRBE,
	SYSZ_INS_CRBH = SYSTEMZ_INS_CRBH,
	SYSZ_INS_CRBHE = SYSTEMZ_INS_CRBHE,
	SYSZ_INS_CRBL = SYSTEMZ_INS_CRBL,
	SYSZ_INS_CRBLE = SYSTEMZ_INS_CRBLE,
	SYSZ_INS_CRBLH = SYSTEMZ_INS_CRBLH,
	SYSZ_INS_CRBNE = SYSTEMZ_INS_CRBNE,
	SYSZ_INS_CRBNH = SYSTEMZ_INS_CRBNH,
	SYSZ_INS_CRBNHE = SYSTEMZ_INS_CRBNHE,
	SYSZ_INS_CRBNL = SYSTEMZ_INS_CRBNL,
	SYSZ_INS_CRBNLE = SYSTEMZ_INS_CRBNLE,
	SYSZ_INS_CRBNLH = SYSTEMZ_INS_CRBNLH,
	SYSZ_INS_CRDTE = SYSTEMZ_INS_CRDTE,
	SYSZ_INS_CRJ = SYSTEMZ_INS_CRJ,
	SYSZ_INS_CRJE = SYSTEMZ_INS_CRJE,
	SYSZ_INS_CRJH = SYSTEMZ_INS_CRJH,
	SYSZ_INS_CRJHE = SYSTEMZ_INS_CRJHE,
	SYSZ_INS_CRJL = SYSTEMZ_INS_CRJL,
	SYSZ_INS_CRJLE = SYSTEMZ_INS_CRJLE,
	SYSZ_INS_CRJLH = SYSTEMZ_INS_CRJLH,
	SYSZ_INS_CRJNE = SYSTEMZ_INS_CRJNE,
	SYSZ_INS_CRJNH = SYSTEMZ_INS_CRJNH,
	SYSZ_INS_CRJNHE = SYSTEMZ_INS_CRJNHE,
	SYSZ_INS_CRJNL = SYSTEMZ_INS_CRJNL,
	SYSZ_INS_CRJNLE = SYSTEMZ_INS_CRJNLE,
	SYSZ_INS_CRJNLH = SYSTEMZ_INS_CRJNLH,
	SYSZ_INS_CRL = SYSTEMZ_INS_CRL,
	SYSZ_INS_CRT = SYSTEMZ_INS_CRT,
	SYSZ_INS_CRTE = SYSTEMZ_INS_CRTE,
	SYSZ_INS_CRTH = SYSTEMZ_INS_CRTH,
	SYSZ_INS_CRTHE = SYSTEMZ_INS_CRTHE,
	SYSZ_INS_CRTL = SYSTEMZ_INS_CRTL,
	SYSZ_INS_CRTLE = SYSTEMZ_INS_CRTLE,
	SYSZ_INS_CRTLH = SYSTEMZ_INS_CRTLH,
	SYSZ_INS_CRTNE = SYSTEMZ_INS_CRTNE,
	SYSZ_INS_CRTNH = SYSTEMZ_INS_CRTNH,
	SYSZ_INS_CRTNHE = SYSTEMZ_INS_CRTNHE,
	SYSZ_INS_CRTNL = SYSTEMZ_INS_CRTNL,
	SYSZ_INS_CRTNLE = SYSTEMZ_INS_CRTNLE,
	SYSZ_INS_CRTNLH = SYSTEMZ_INS_CRTNLH,
	SYSZ_INS_CS = SYSTEMZ_INS_CS,
	SYSZ_INS_CSCH = SYSTEMZ_INS_CSCH,
	SYSZ_INS_CSDTR = SYSTEMZ_INS_CSDTR,
	SYSZ_INS_CSG = SYSTEMZ_INS_CSG,
	SYSZ_INS_CSP = SYSTEMZ_INS_CSP,
	SYSZ_INS_CSPG = SYSTEMZ_INS_CSPG,
	SYSZ_INS_CSST = SYSTEMZ_INS_CSST,
	SYSZ_INS_CSXTR = SYSTEMZ_INS_CSXTR,
	SYSZ_INS_CSY = SYSTEMZ_INS_CSY,
	SYSZ_INS_CU12 = SYSTEMZ_INS_CU12,
	SYSZ_INS_CU14 = SYSTEMZ_INS_CU14,
	SYSZ_INS_CU21 = SYSTEMZ_INS_CU21,
	SYSZ_INS_CU24 = SYSTEMZ_INS_CU24,
	SYSZ_INS_CU41 = SYSTEMZ_INS_CU41,
	SYSZ_INS_CU42 = SYSTEMZ_INS_CU42,
	SYSZ_INS_CUDTR = SYSTEMZ_INS_CUDTR,
	SYSZ_INS_CUSE = SYSTEMZ_INS_CUSE,
	SYSZ_INS_CUTFU = SYSTEMZ_INS_CUTFU,
	SYSZ_INS_CUUTF = SYSTEMZ_INS_CUUTF,
	SYSZ_INS_CUXTR = SYSTEMZ_INS_CUXTR,
	SYSZ_INS_CVB = SYSTEMZ_INS_CVB,
	SYSZ_INS_CVBG = SYSTEMZ_INS_CVBG,
	SYSZ_INS_CVBY = SYSTEMZ_INS_CVBY,
	SYSZ_INS_CVD = SYSTEMZ_INS_CVD,
	SYSZ_INS_CVDG = SYSTEMZ_INS_CVDG,
	SYSZ_INS_CVDY = SYSTEMZ_INS_CVDY,
	SYSZ_INS_CXBR = SYSTEMZ_INS_CXBR,
	SYSZ_INS_CXFBR = SYSTEMZ_INS_CXFBR,
	SYSZ_INS_CXFBRA = SYSTEMZ_INS_CXFBRA,
	SYSZ_INS_CXFR = SYSTEMZ_INS_CXFR,
	SYSZ_INS_CXFTR = SYSTEMZ_INS_CXFTR,
	SYSZ_INS_CXGBR = SYSTEMZ_INS_CXGBR,
	SYSZ_INS_CXGBRA = SYSTEMZ_INS_CXGBRA,
	SYSZ_INS_CXGR = SYSTEMZ_INS_CXGR,
	SYSZ_INS_CXGTR = SYSTEMZ_INS_CXGTR,
	SYSZ_INS_CXGTRA = SYSTEMZ_INS_CXGTRA,
	SYSZ_INS_CXLFBR = SYSTEMZ_INS_CXLFBR,
	SYSZ_INS_CXLFTR = SYSTEMZ_INS_CXLFTR,
	SYSZ_INS_CXLGBR = SYSTEMZ_INS_CXLGBR,
	SYSZ_INS_CXLGTR = SYSTEMZ_INS_CXLGTR,
	SYSZ_INS_CXPT = SYSTEMZ_INS_CXPT,
	SYSZ_INS_CXR = SYSTEMZ_INS_CXR,
	SYSZ_INS_CXSTR = SYSTEMZ_INS_CXSTR,
	SYSZ_INS_CXTR = SYSTEMZ_INS_CXTR,
	SYSZ_INS_CXUTR = SYSTEMZ_INS_CXUTR,
	SYSZ_INS_CXZT = SYSTEMZ_INS_CXZT,
	SYSZ_INS_CY = SYSTEMZ_INS_CY,
	SYSZ_INS_CZDT = SYSTEMZ_INS_CZDT,
	SYSZ_INS_CZXT = SYSTEMZ_INS_CZXT,
	SYSZ_INS_D = SYSTEMZ_INS_D,
	SYSZ_INS_DD = SYSTEMZ_INS_DD,
	SYSZ_INS_DDB = SYSTEMZ_INS_DDB,
	SYSZ_INS_DDBR = SYSTEMZ_INS_DDBR,
	SYSZ_INS_DDR = SYSTEMZ_INS_DDR,
	SYSZ_INS_DDTR = SYSTEMZ_INS_DDTR,
	SYSZ_INS_DDTRA = SYSTEMZ_INS_DDTRA,
	SYSZ_INS_DE = SYSTEMZ_INS_DE,
	SYSZ_INS_DEB = SYSTEMZ_INS_DEB,
	SYSZ_INS_DEBR = SYSTEMZ_INS_DEBR,
	SYSZ_INS_DER = SYSTEMZ_INS_DER,
	SYSZ_INS_DFLTCC = SYSTEMZ_INS_DFLTCC,
	SYSZ_INS_DIAG = SYSTEMZ_INS_DIAG,
	SYSZ_INS_DIDBR = SYSTEMZ_INS_DIDBR,
	SYSZ_INS_DIEBR = SYSTEMZ_INS_DIEBR,
	SYSZ_INS_DL = SYSTEMZ_INS_DL,
	SYSZ_INS_DLG = SYSTEMZ_INS_DLG,
	SYSZ_INS_DLGR = SYSTEMZ_INS_DLGR,
	SYSZ_INS_DLR = SYSTEMZ_INS_DLR,
	SYSZ_INS_DP = SYSTEMZ_INS_DP,
	SYSZ_INS_DR = SYSTEMZ_INS_DR,
	SYSZ_INS_DSG = SYSTEMZ_INS_DSG,
	SYSZ_INS_DSGF = SYSTEMZ_INS_DSGF,
	SYSZ_INS_DSGFR = SYSTEMZ_INS_DSGFR,
	SYSZ_INS_DSGR = SYSTEMZ_INS_DSGR,
	SYSZ_INS_DXBR = SYSTEMZ_INS_DXBR,
	SYSZ_INS_DXR = SYSTEMZ_INS_DXR,
	SYSZ_INS_DXTR = SYSTEMZ_INS_DXTR,
	SYSZ_INS_DXTRA = SYSTEMZ_INS_DXTRA,
	SYSZ_INS_EAR = SYSTEMZ_INS_EAR,
	SYSZ_INS_ECAG = SYSTEMZ_INS_ECAG,
	SYSZ_INS_ECCTR = SYSTEMZ_INS_ECCTR,
	SYSZ_INS_ECPGA = SYSTEMZ_INS_ECPGA,
	SYSZ_INS_ECTG = SYSTEMZ_INS_ECTG,
	SYSZ_INS_ED = SYSTEMZ_INS_ED,
	SYSZ_INS_EDMK = SYSTEMZ_INS_EDMK,
	SYSZ_INS_EEDTR = SYSTEMZ_INS_EEDTR,
	SYSZ_INS_EEXTR = SYSTEMZ_INS_EEXTR,
	SYSZ_INS_EFPC = SYSTEMZ_INS_EFPC,
	SYSZ_INS_EPAIR = SYSTEMZ_INS_EPAIR,
	SYSZ_INS_EPAR = SYSTEMZ_INS_EPAR,
	SYSZ_INS_EPCTR = SYSTEMZ_INS_EPCTR,
	SYSZ_INS_EPSW = SYSTEMZ_INS_EPSW,
	SYSZ_INS_EREG = SYSTEMZ_INS_EREG,
	SYSZ_INS_EREGG = SYSTEMZ_INS_EREGG,
	SYSZ_INS_ESAIR = SYSTEMZ_INS_ESAIR,
	SYSZ_INS_ESAR = SYSTEMZ_INS_ESAR,
	SYSZ_INS_ESDTR = SYSTEMZ_INS_ESDTR,
	SYSZ_INS_ESEA = SYSTEMZ_INS_ESEA,
	SYSZ_INS_ESTA = SYSTEMZ_INS_ESTA,
	SYSZ_INS_ESXTR = SYSTEMZ_INS_ESXTR,
	SYSZ_INS_ETND = SYSTEMZ_INS_ETND,
	SYSZ_INS_EX = SYSTEMZ_INS_EX,
	SYSZ_INS_EXRL = SYSTEMZ_INS_EXRL,
	SYSZ_INS_FIDBR = SYSTEMZ_INS_FIDBR,
	SYSZ_INS_FIDBRA = SYSTEMZ_INS_FIDBRA,
	SYSZ_INS_FIDR = SYSTEMZ_INS_FIDR,
	SYSZ_INS_FIDTR = SYSTEMZ_INS_FIDTR,
	SYSZ_INS_FIEBR = SYSTEMZ_INS_FIEBR,
	SYSZ_INS_FIEBRA = SYSTEMZ_INS_FIEBRA,
	SYSZ_INS_FIER = SYSTEMZ_INS_FIER,
	SYSZ_INS_FIXBR = SYSTEMZ_INS_FIXBR,
	SYSZ_INS_FIXBRA = SYSTEMZ_INS_FIXBRA,
	SYSZ_INS_FIXR = SYSTEMZ_INS_FIXR,
	SYSZ_INS_FIXTR = SYSTEMZ_INS_FIXTR,
	SYSZ_INS_FLOGR = SYSTEMZ_INS_FLOGR,
	SYSZ_INS_HDR = SYSTEMZ_INS_HDR,
	SYSZ_INS_HER = SYSTEMZ_INS_HER,
	SYSZ_INS_HSCH = SYSTEMZ_INS_HSCH,
	SYSZ_INS_IAC = SYSTEMZ_INS_IAC,
	SYSZ_INS_IC = SYSTEMZ_INS_IC,
	SYSZ_INS_ICM = SYSTEMZ_INS_ICM,
	SYSZ_INS_ICMH = SYSTEMZ_INS_ICMH,
	SYSZ_INS_ICMY = SYSTEMZ_INS_ICMY,
	SYSZ_INS_ICY = SYSTEMZ_INS_ICY,
	SYSZ_INS_IDTE = SYSTEMZ_INS_IDTE,
	SYSZ_INS_IEDTR = SYSTEMZ_INS_IEDTR,
	SYSZ_INS_IEXTR = SYSTEMZ_INS_IEXTR,
	SYSZ_INS_IIHF = SYSTEMZ_INS_IIHF,
	SYSZ_INS_IIHH = SYSTEMZ_INS_IIHH,
	SYSZ_INS_IIHL = SYSTEMZ_INS_IIHL,
	SYSZ_INS_IILF = SYSTEMZ_INS_IILF,
	SYSZ_INS_IILH = SYSTEMZ_INS_IILH,
	SYSZ_INS_IILL = SYSTEMZ_INS_IILL,
	SYSZ_INS_IPK = SYSTEMZ_INS_IPK,
	SYSZ_INS_IPM = SYSTEMZ_INS_IPM,
	SYSZ_INS_IPTE = SYSTEMZ_INS_IPTE,
	SYSZ_INS_IRBM = SYSTEMZ_INS_IRBM,
	SYSZ_INS_ISKE = SYSTEMZ_INS_ISKE,
	SYSZ_INS_IVSK = SYSTEMZ_INS_IVSK,
	SYSZ_INS_J = SYSTEMZ_INS_J,
	SYSZ_INS_JE = SYSTEMZ_INS_JE,
	SYSZ_INS_JH = SYSTEMZ_INS_JH,
	SYSZ_INS_JHE = SYSTEMZ_INS_JHE,
	SYSZ_INS_JL = SYSTEMZ_INS_JL,
	SYSZ_INS_JLE = SYSTEMZ_INS_JLE,
	SYSZ_INS_JLH = SYSTEMZ_INS_JLH,
	SYSZ_INS_JM = SYSTEMZ_INS_JM,
	SYSZ_INS_JNE = SYSTEMZ_INS_JNE,
	SYSZ_INS_JNH = SYSTEMZ_INS_JNH,
	SYSZ_INS_JNHE = SYSTEMZ_INS_JNHE,
	SYSZ_INS_JNL = SYSTEMZ_INS_JNL,
	SYSZ_INS_JNLE = SYSTEMZ_INS_JNLE,
	SYSZ_INS_JNLH = SYSTEMZ_INS_JNLH,
	SYSZ_INS_JNM = SYSTEMZ_INS_JNM,
	SYSZ_INS_JNO = SYSTEMZ_INS_JNO,
	SYSZ_INS_JNP = SYSTEMZ_INS_JNP,
	SYSZ_INS_JNZ = SYSTEMZ_INS_JNZ,
	SYSZ_INS_JO = SYSTEMZ_INS_JO,
	SYSZ_INS_JP = SYSTEMZ_INS_JP,
	SYSZ_INS_JZ = SYSTEMZ_INS_JZ,
	SYSZ_INS_J_G_LU_ = SYSTEMZ_INS_J_G_LU_,
	SYSZ_INS_J_G_L_E = SYSTEMZ_INS_J_G_L_E,
	SYSZ_INS_J_G_L_H = SYSTEMZ_INS_J_G_L_H,
	SYSZ_INS_J_G_L_HE = SYSTEMZ_INS_J_G_L_HE,
	SYSZ_INS_J_G_L_L = SYSTEMZ_INS_J_G_L_L,
	SYSZ_INS_J_G_L_LE = SYSTEMZ_INS_J_G_L_LE,
	SYSZ_INS_J_G_L_LH = SYSTEMZ_INS_J_G_L_LH,
	SYSZ_INS_J_G_L_M = SYSTEMZ_INS_J_G_L_M,
	SYSZ_INS_J_G_L_NE = SYSTEMZ_INS_J_G_L_NE,
	SYSZ_INS_J_G_L_NH = SYSTEMZ_INS_J_G_L_NH,
	SYSZ_INS_J_G_L_NHE = SYSTEMZ_INS_J_G_L_NHE,
	SYSZ_INS_J_G_L_NL = SYSTEMZ_INS_J_G_L_NL,
	SYSZ_INS_J_G_L_NLE = SYSTEMZ_INS_J_G_L_NLE,
	SYSZ_INS_J_G_L_NLH = SYSTEMZ_INS_J_G_L_NLH,
	SYSZ_INS_J_G_L_NM = SYSTEMZ_INS_J_G_L_NM,
	SYSZ_INS_J_G_L_NO = SYSTEMZ_INS_J_G_L_NO,
	SYSZ_INS_J_G_L_NP = SYSTEMZ_INS_J_G_L_NP,
	SYSZ_INS_J_G_L_NZ = SYSTEMZ_INS_J_G_L_NZ,
	SYSZ_INS_J_G_L_O = SYSTEMZ_INS_J_G_L_O,
	SYSZ_INS_J_G_L_P = SYSTEMZ_INS_J_G_L_P,
	SYSZ_INS_J_G_L_Z = SYSTEMZ_INS_J_G_L_Z,
	SYSZ_INS_KDB = SYSTEMZ_INS_KDB,
	SYSZ_INS_KDBR = SYSTEMZ_INS_KDBR,
	SYSZ_INS_KDSA = SYSTEMZ_INS_KDSA,
	SYSZ_INS_KDTR = SYSTEMZ_INS_KDTR,
	SYSZ_INS_KEB = SYSTEMZ_INS_KEB,
	SYSZ_INS_KEBR = SYSTEMZ_INS_KEBR,
	SYSZ_INS_KIMD = SYSTEMZ_INS_KIMD,
	SYSZ_INS_KLMD = SYSTEMZ_INS_KLMD,
	SYSZ_INS_KM = SYSTEMZ_INS_KM,
	SYSZ_INS_KMA = SYSTEMZ_INS_KMA,
	SYSZ_INS_KMAC = SYSTEMZ_INS_KMAC,
	SYSZ_INS_KMC = SYSTEMZ_INS_KMC,
	SYSZ_INS_KMCTR = SYSTEMZ_INS_KMCTR,
	SYSZ_INS_KMF = SYSTEMZ_INS_KMF,
	SYSZ_INS_KMO = SYSTEMZ_INS_KMO,
	SYSZ_INS_KXBR = SYSTEMZ_INS_KXBR,
	SYSZ_INS_KXTR = SYSTEMZ_INS_KXTR,
	SYSZ_INS_L = SYSTEMZ_INS_L,
	SYSZ_INS_LA = SYSTEMZ_INS_LA,
	SYSZ_INS_LAA = SYSTEMZ_INS_LAA,
	SYSZ_INS_LAAG = SYSTEMZ_INS_LAAG,
	SYSZ_INS_LAAL = SYSTEMZ_INS_LAAL,
	SYSZ_INS_LAALG = SYSTEMZ_INS_LAALG,
	SYSZ_INS_LAE = SYSTEMZ_INS_LAE,
	SYSZ_INS_LAEY = SYSTEMZ_INS_LAEY,
	SYSZ_INS_LAM = SYSTEMZ_INS_LAM,
	SYSZ_INS_LAMY = SYSTEMZ_INS_LAMY,
	SYSZ_INS_LAN = SYSTEMZ_INS_LAN,
	SYSZ_INS_LANG = SYSTEMZ_INS_LANG,
	SYSZ_INS_LAO = SYSTEMZ_INS_LAO,
	SYSZ_INS_LAOG = SYSTEMZ_INS_LAOG,
	SYSZ_INS_LARL = SYSTEMZ_INS_LARL,
	SYSZ_INS_LASP = SYSTEMZ_INS_LASP,
	SYSZ_INS_LAT = SYSTEMZ_INS_LAT,
	SYSZ_INS_LAX = SYSTEMZ_INS_LAX,
	SYSZ_INS_LAXG = SYSTEMZ_INS_LAXG,
	SYSZ_INS_LAY = SYSTEMZ_INS_LAY,
	SYSZ_INS_LB = SYSTEMZ_INS_LB,
	SYSZ_INS_LBEAR = SYSTEMZ_INS_LBEAR,
	SYSZ_INS_LBH = SYSTEMZ_INS_LBH,
	SYSZ_INS_LBR = SYSTEMZ_INS_LBR,
	SYSZ_INS_LCBB = SYSTEMZ_INS_LCBB,
	SYSZ_INS_LCCTL = SYSTEMZ_INS_LCCTL,
	SYSZ_INS_LCDBR = SYSTEMZ_INS_LCDBR,
	SYSZ_INS_LCDFR = SYSTEMZ_INS_LCDFR,
	SYSZ_INS_LCDR = SYSTEMZ_INS_LCDR,
	SYSZ_INS_LCEBR = SYSTEMZ_INS_LCEBR,
	SYSZ_INS_LCER = SYSTEMZ_INS_LCER,
	SYSZ_INS_LCGFR = SYSTEMZ_INS_LCGFR,
	SYSZ_INS_LCGR = SYSTEMZ_INS_LCGR,
	SYSZ_INS_LCR = SYSTEMZ_INS_LCR,
	SYSZ_INS_LCTL = SYSTEMZ_INS_LCTL,
	SYSZ_INS_LCTLG = SYSTEMZ_INS_LCTLG,
	SYSZ_INS_LCXBR = SYSTEMZ_INS_LCXBR,
	SYSZ_INS_LCXR = SYSTEMZ_INS_LCXR,
	SYSZ_INS_LD = SYSTEMZ_INS_LD,
	SYSZ_INS_LDE = SYSTEMZ_INS_LDE,
	SYSZ_INS_LDEB = SYSTEMZ_INS_LDEB,
	SYSZ_INS_LDEBR = SYSTEMZ_INS_LDEBR,
	SYSZ_INS_LDER = SYSTEMZ_INS_LDER,
	SYSZ_INS_LDETR = SYSTEMZ_INS_LDETR,
	SYSZ_INS_LDGR = SYSTEMZ_INS_LDGR,
	SYSZ_INS_LDR = SYSTEMZ_INS_LDR,
	SYSZ_INS_LDXBR = SYSTEMZ_INS_LDXBR,
	SYSZ_INS_LDXBRA = SYSTEMZ_INS_LDXBRA,
	SYSZ_INS_LDXR = SYSTEMZ_INS_LDXR,
	SYSZ_INS_LDXTR = SYSTEMZ_INS_LDXTR,
	SYSZ_INS_LDY = SYSTEMZ_INS_LDY,
	SYSZ_INS_LE = SYSTEMZ_INS_LE,
	SYSZ_INS_LEDBR = SYSTEMZ_INS_LEDBR,
	SYSZ_INS_LEDBRA = SYSTEMZ_INS_LEDBRA,
	SYSZ_INS_LEDR = SYSTEMZ_INS_LEDR,
	SYSZ_INS_LEDTR = SYSTEMZ_INS_LEDTR,
	SYSZ_INS_LER = SYSTEMZ_INS_LER,
	SYSZ_INS_LEXBR = SYSTEMZ_INS_LEXBR,
	SYSZ_INS_LEXBRA = SYSTEMZ_INS_LEXBRA,
	SYSZ_INS_LEXR = SYSTEMZ_INS_LEXR,
	SYSZ_INS_LEY = SYSTEMZ_INS_LEY,
	SYSZ_INS_LFAS = SYSTEMZ_INS_LFAS,
	SYSZ_INS_LFH = SYSTEMZ_INS_LFH,
	SYSZ_INS_LFHAT = SYSTEMZ_INS_LFHAT,
	SYSZ_INS_LFPC = SYSTEMZ_INS_LFPC,
	SYSZ_INS_LG = SYSTEMZ_INS_LG,
	SYSZ_INS_LGAT = SYSTEMZ_INS_LGAT,
	SYSZ_INS_LGB = SYSTEMZ_INS_LGB,
	SYSZ_INS_LGBR = SYSTEMZ_INS_LGBR,
	SYSZ_INS_LGDR = SYSTEMZ_INS_LGDR,
	SYSZ_INS_LGF = SYSTEMZ_INS_LGF,
	SYSZ_INS_LGFI = SYSTEMZ_INS_LGFI,
	SYSZ_INS_LGFR = SYSTEMZ_INS_LGFR,
	SYSZ_INS_LGFRL = SYSTEMZ_INS_LGFRL,
	SYSZ_INS_LGG = SYSTEMZ_INS_LGG,
	SYSZ_INS_LGH = SYSTEMZ_INS_LGH,
	SYSZ_INS_LGHI = SYSTEMZ_INS_LGHI,
	SYSZ_INS_LGHR = SYSTEMZ_INS_LGHR,
	SYSZ_INS_LGHRL = SYSTEMZ_INS_LGHRL,
	SYSZ_INS_LGR = SYSTEMZ_INS_LGR,
	SYSZ_INS_LGRL = SYSTEMZ_INS_LGRL,
	SYSZ_INS_LGSC = SYSTEMZ_INS_LGSC,
	SYSZ_INS_LH = SYSTEMZ_INS_LH,
	SYSZ_INS_LHH = SYSTEMZ_INS_LHH,
	SYSZ_INS_LHI = SYSTEMZ_INS_LHI,
	SYSZ_INS_LHR = SYSTEMZ_INS_LHR,
	SYSZ_INS_LHRL = SYSTEMZ_INS_LHRL,
	SYSZ_INS_LHY = SYSTEMZ_INS_LHY,
	SYSZ_INS_LLC = SYSTEMZ_INS_LLC,
	SYSZ_INS_LLCH = SYSTEMZ_INS_LLCH,
	SYSZ_INS_LLCR = SYSTEMZ_INS_LLCR,
	SYSZ_INS_LLGC = SYSTEMZ_INS_LLGC,
	SYSZ_INS_LLGCR = SYSTEMZ_INS_LLGCR,
	SYSZ_INS_LLGF = SYSTEMZ_INS_LLGF,
	SYSZ_INS_LLGFAT = SYSTEMZ_INS_LLGFAT,
	SYSZ_INS_LLGFR = SYSTEMZ_INS_LLGFR,
	SYSZ_INS_LLGFRL = SYSTEMZ_INS_LLGFRL,
	SYSZ_INS_LLGFSG = SYSTEMZ_INS_LLGFSG,
	SYSZ_INS_LLGH = SYSTEMZ_INS_LLGH,
	SYSZ_INS_LLGHR = SYSTEMZ_INS_LLGHR,
	SYSZ_INS_LLGHRL = SYSTEMZ_INS_LLGHRL,
	SYSZ_INS_LLGT = SYSTEMZ_INS_LLGT,
	SYSZ_INS_LLGTAT = SYSTEMZ_INS_LLGTAT,
	SYSZ_INS_LLGTR = SYSTEMZ_INS_LLGTR,
	SYSZ_INS_LLH = SYSTEMZ_INS_LLH,
	SYSZ_INS_LLHH = SYSTEMZ_INS_LLHH,
	SYSZ_INS_LLHR = SYSTEMZ_INS_LLHR,
	SYSZ_INS_LLHRL = SYSTEMZ_INS_LLHRL,
	SYSZ_INS_LLIHF = SYSTEMZ_INS_LLIHF,
	SYSZ_INS_LLIHH = SYSTEMZ_INS_LLIHH,
	SYSZ_INS_LLIHL = SYSTEMZ_INS_LLIHL,
	SYSZ_INS_LLILF = SYSTEMZ_INS_LLILF,
	SYSZ_INS_LLILH = SYSTEMZ_INS_LLILH,
	SYSZ_INS_LLILL = SYSTEMZ_INS_LLILL,
	SYSZ_INS_LLZRGF = SYSTEMZ_INS_LLZRGF,
	SYSZ_INS_LM = SYSTEMZ_INS_LM,
	SYSZ_INS_LMD = SYSTEMZ_INS_LMD,
	SYSZ_INS_LMG = SYSTEMZ_INS_LMG,
	SYSZ_INS_LMH = SYSTEMZ_INS_LMH,
	SYSZ_INS_LMY = SYSTEMZ_INS_LMY,
	SYSZ_INS_LNDBR = SYSTEMZ_INS_LNDBR,
	SYSZ_INS_LNDFR = SYSTEMZ_INS_LNDFR,
	SYSZ_INS_LNDR = SYSTEMZ_INS_LNDR,
	SYSZ_INS_LNEBR = SYSTEMZ_INS_LNEBR,
	SYSZ_INS_LNER = SYSTEMZ_INS_LNER,
	SYSZ_INS_LNGFR = SYSTEMZ_INS_LNGFR,
	SYSZ_INS_LNGR = SYSTEMZ_INS_LNGR,
	SYSZ_INS_LNR = SYSTEMZ_INS_LNR,
	SYSZ_INS_LNXBR = SYSTEMZ_INS_LNXBR,
	SYSZ_INS_LNXR = SYSTEMZ_INS_LNXR,
	SYSZ_INS_LOC = SYSTEMZ_INS_LOC,
	SYSZ_INS_LOCE = SYSTEMZ_INS_LOCE,
	SYSZ_INS_LOCH = SYSTEMZ_INS_LOCH,
	SYSZ_INS_LOCHE = SYSTEMZ_INS_LOCHE,
	SYSZ_INS_LOCL = SYSTEMZ_INS_LOCL,
	SYSZ_INS_LOCLE = SYSTEMZ_INS_LOCLE,
	SYSZ_INS_LOCLH = SYSTEMZ_INS_LOCLH,
	SYSZ_INS_LOCM = SYSTEMZ_INS_LOCM,
	SYSZ_INS_LOCNE = SYSTEMZ_INS_LOCNE,
	SYSZ_INS_LOCNH = SYSTEMZ_INS_LOCNH,
	SYSZ_INS_LOCNHE = SYSTEMZ_INS_LOCNHE,
	SYSZ_INS_LOCNL = SYSTEMZ_INS_LOCNL,
	SYSZ_INS_LOCNLE = SYSTEMZ_INS_LOCNLE,
	SYSZ_INS_LOCNLH = SYSTEMZ_INS_LOCNLH,
	SYSZ_INS_LOCNM = SYSTEMZ_INS_LOCNM,
	SYSZ_INS_LOCNO = SYSTEMZ_INS_LOCNO,
	SYSZ_INS_LOCNP = SYSTEMZ_INS_LOCNP,
	SYSZ_INS_LOCNZ = SYSTEMZ_INS_LOCNZ,
	SYSZ_INS_LOCO = SYSTEMZ_INS_LOCO,
	SYSZ_INS_LOCP = SYSTEMZ_INS_LOCP,
	SYSZ_INS_LOCZ = SYSTEMZ_INS_LOCZ,
	SYSZ_INS_LOCFH = SYSTEMZ_INS_LOCFH,
	SYSZ_INS_LOCFHE = SYSTEMZ_INS_LOCFHE,
	SYSZ_INS_LOCFHH = SYSTEMZ_INS_LOCFHH,
	SYSZ_INS_LOCFHHE = SYSTEMZ_INS_LOCFHHE,
	SYSZ_INS_LOCFHL = SYSTEMZ_INS_LOCFHL,
	SYSZ_INS_LOCFHLE = SYSTEMZ_INS_LOCFHLE,
	SYSZ_INS_LOCFHLH = SYSTEMZ_INS_LOCFHLH,
	SYSZ_INS_LOCFHM = SYSTEMZ_INS_LOCFHM,
	SYSZ_INS_LOCFHNE = SYSTEMZ_INS_LOCFHNE,
	SYSZ_INS_LOCFHNH = SYSTEMZ_INS_LOCFHNH,
	SYSZ_INS_LOCFHNHE = SYSTEMZ_INS_LOCFHNHE,
	SYSZ_INS_LOCFHNL = SYSTEMZ_INS_LOCFHNL,
	SYSZ_INS_LOCFHNLE = SYSTEMZ_INS_LOCFHNLE,
	SYSZ_INS_LOCFHNLH = SYSTEMZ_INS_LOCFHNLH,
	SYSZ_INS_LOCFHNM = SYSTEMZ_INS_LOCFHNM,
	SYSZ_INS_LOCFHNO = SYSTEMZ_INS_LOCFHNO,
	SYSZ_INS_LOCFHNP = SYSTEMZ_INS_LOCFHNP,
	SYSZ_INS_LOCFHNZ = SYSTEMZ_INS_LOCFHNZ,
	SYSZ_INS_LOCFHO = SYSTEMZ_INS_LOCFHO,
	SYSZ_INS_LOCFHP = SYSTEMZ_INS_LOCFHP,
	SYSZ_INS_LOCFHZ = SYSTEMZ_INS_LOCFHZ,
	SYSZ_INS_LOCFHR = SYSTEMZ_INS_LOCFHR,
	SYSZ_INS_LOCFHRE = SYSTEMZ_INS_LOCFHRE,
	SYSZ_INS_LOCFHRH = SYSTEMZ_INS_LOCFHRH,
	SYSZ_INS_LOCFHRHE = SYSTEMZ_INS_LOCFHRHE,
	SYSZ_INS_LOCFHRL = SYSTEMZ_INS_LOCFHRL,
	SYSZ_INS_LOCFHRLE = SYSTEMZ_INS_LOCFHRLE,
	SYSZ_INS_LOCFHRLH = SYSTEMZ_INS_LOCFHRLH,
	SYSZ_INS_LOCFHRM = SYSTEMZ_INS_LOCFHRM,
	SYSZ_INS_LOCFHRNE = SYSTEMZ_INS_LOCFHRNE,
	SYSZ_INS_LOCFHRNH = SYSTEMZ_INS_LOCFHRNH,
	SYSZ_INS_LOCFHRNHE = SYSTEMZ_INS_LOCFHRNHE,
	SYSZ_INS_LOCFHRNL = SYSTEMZ_INS_LOCFHRNL,
	SYSZ_INS_LOCFHRNLE = SYSTEMZ_INS_LOCFHRNLE,
	SYSZ_INS_LOCFHRNLH = SYSTEMZ_INS_LOCFHRNLH,
	SYSZ_INS_LOCFHRNM = SYSTEMZ_INS_LOCFHRNM,
	SYSZ_INS_LOCFHRNO = SYSTEMZ_INS_LOCFHRNO,
	SYSZ_INS_LOCFHRNP = SYSTEMZ_INS_LOCFHRNP,
	SYSZ_INS_LOCFHRNZ = SYSTEMZ_INS_LOCFHRNZ,
	SYSZ_INS_LOCFHRO = SYSTEMZ_INS_LOCFHRO,
	SYSZ_INS_LOCFHRP = SYSTEMZ_INS_LOCFHRP,
	SYSZ_INS_LOCFHRZ = SYSTEMZ_INS_LOCFHRZ,
	SYSZ_INS_LOCG = SYSTEMZ_INS_LOCG,
	SYSZ_INS_LOCGE = SYSTEMZ_INS_LOCGE,
	SYSZ_INS_LOCGH = SYSTEMZ_INS_LOCGH,
	SYSZ_INS_LOCGHE = SYSTEMZ_INS_LOCGHE,
	SYSZ_INS_LOCGL = SYSTEMZ_INS_LOCGL,
	SYSZ_INS_LOCGLE = SYSTEMZ_INS_LOCGLE,
	SYSZ_INS_LOCGLH = SYSTEMZ_INS_LOCGLH,
	SYSZ_INS_LOCGM = SYSTEMZ_INS_LOCGM,
	SYSZ_INS_LOCGNE = SYSTEMZ_INS_LOCGNE,
	SYSZ_INS_LOCGNH = SYSTEMZ_INS_LOCGNH,
	SYSZ_INS_LOCGNHE = SYSTEMZ_INS_LOCGNHE,
	SYSZ_INS_LOCGNL = SYSTEMZ_INS_LOCGNL,
	SYSZ_INS_LOCGNLE = SYSTEMZ_INS_LOCGNLE,
	SYSZ_INS_LOCGNLH = SYSTEMZ_INS_LOCGNLH,
	SYSZ_INS_LOCGNM = SYSTEMZ_INS_LOCGNM,
	SYSZ_INS_LOCGNO = SYSTEMZ_INS_LOCGNO,
	SYSZ_INS_LOCGNP = SYSTEMZ_INS_LOCGNP,
	SYSZ_INS_LOCGNZ = SYSTEMZ_INS_LOCGNZ,
	SYSZ_INS_LOCGO = SYSTEMZ_INS_LOCGO,
	SYSZ_INS_LOCGP = SYSTEMZ_INS_LOCGP,
	SYSZ_INS_LOCGZ = SYSTEMZ_INS_LOCGZ,
	SYSZ_INS_LOCGHI = SYSTEMZ_INS_LOCGHI,
	SYSZ_INS_LOCGHIE = SYSTEMZ_INS_LOCGHIE,
	SYSZ_INS_LOCGHIH = SYSTEMZ_INS_LOCGHIH,
	SYSZ_INS_LOCGHIHE = SYSTEMZ_INS_LOCGHIHE,
	SYSZ_INS_LOCGHIL = SYSTEMZ_INS_LOCGHIL,
	SYSZ_INS_LOCGHILE = SYSTEMZ_INS_LOCGHILE,
	SYSZ_INS_LOCGHILH = SYSTEMZ_INS_LOCGHILH,
	SYSZ_INS_LOCGHIM = SYSTEMZ_INS_LOCGHIM,
	SYSZ_INS_LOCGHINE = SYSTEMZ_INS_LOCGHINE,
	SYSZ_INS_LOCGHINH = SYSTEMZ_INS_LOCGHINH,
	SYSZ_INS_LOCGHINHE = SYSTEMZ_INS_LOCGHINHE,
	SYSZ_INS_LOCGHINL = SYSTEMZ_INS_LOCGHINL,
	SYSZ_INS_LOCGHINLE = SYSTEMZ_INS_LOCGHINLE,
	SYSZ_INS_LOCGHINLH = SYSTEMZ_INS_LOCGHINLH,
	SYSZ_INS_LOCGHINM = SYSTEMZ_INS_LOCGHINM,
	SYSZ_INS_LOCGHINO = SYSTEMZ_INS_LOCGHINO,
	SYSZ_INS_LOCGHINP = SYSTEMZ_INS_LOCGHINP,
	SYSZ_INS_LOCGHINZ = SYSTEMZ_INS_LOCGHINZ,
	SYSZ_INS_LOCGHIO = SYSTEMZ_INS_LOCGHIO,
	SYSZ_INS_LOCGHIP = SYSTEMZ_INS_LOCGHIP,
	SYSZ_INS_LOCGHIZ = SYSTEMZ_INS_LOCGHIZ,
	SYSZ_INS_LOCGR = SYSTEMZ_INS_LOCGR,
	SYSZ_INS_LOCGRE = SYSTEMZ_INS_LOCGRE,
	SYSZ_INS_LOCGRH = SYSTEMZ_INS_LOCGRH,
	SYSZ_INS_LOCGRHE = SYSTEMZ_INS_LOCGRHE,
	SYSZ_INS_LOCGRL = SYSTEMZ_INS_LOCGRL,
	SYSZ_INS_LOCGRLE = SYSTEMZ_INS_LOCGRLE,
	SYSZ_INS_LOCGRLH = SYSTEMZ_INS_LOCGRLH,
	SYSZ_INS_LOCGRM = SYSTEMZ_INS_LOCGRM,
	SYSZ_INS_LOCGRNE = SYSTEMZ_INS_LOCGRNE,
	SYSZ_INS_LOCGRNH = SYSTEMZ_INS_LOCGRNH,
	SYSZ_INS_LOCGRNHE = SYSTEMZ_INS_LOCGRNHE,
	SYSZ_INS_LOCGRNL = SYSTEMZ_INS_LOCGRNL,
	SYSZ_INS_LOCGRNLE = SYSTEMZ_INS_LOCGRNLE,
	SYSZ_INS_LOCGRNLH = SYSTEMZ_INS_LOCGRNLH,
	SYSZ_INS_LOCGRNM = SYSTEMZ_INS_LOCGRNM,
	SYSZ_INS_LOCGRNO = SYSTEMZ_INS_LOCGRNO,
	SYSZ_INS_LOCGRNP = SYSTEMZ_INS_LOCGRNP,
	SYSZ_INS_LOCGRNZ = SYSTEMZ_INS_LOCGRNZ,
	SYSZ_INS_LOCGRO = SYSTEMZ_INS_LOCGRO,
	SYSZ_INS_LOCGRP = SYSTEMZ_INS_LOCGRP,
	SYSZ_INS_LOCGRZ = SYSTEMZ_INS_LOCGRZ,
	SYSZ_INS_LOCHHI = SYSTEMZ_INS_LOCHHI,
	SYSZ_INS_LOCHHIE = SYSTEMZ_INS_LOCHHIE,
	SYSZ_INS_LOCHHIH = SYSTEMZ_INS_LOCHHIH,
	SYSZ_INS_LOCHHIHE = SYSTEMZ_INS_LOCHHIHE,
	SYSZ_INS_LOCHHIL = SYSTEMZ_INS_LOCHHIL,
	SYSZ_INS_LOCHHILE = SYSTEMZ_INS_LOCHHILE,
	SYSZ_INS_LOCHHILH = SYSTEMZ_INS_LOCHHILH,
	SYSZ_INS_LOCHHIM = SYSTEMZ_INS_LOCHHIM,
	SYSZ_INS_LOCHHINE = SYSTEMZ_INS_LOCHHINE,
	SYSZ_INS_LOCHHINH = SYSTEMZ_INS_LOCHHINH,
	SYSZ_INS_LOCHHINHE = SYSTEMZ_INS_LOCHHINHE,
	SYSZ_INS_LOCHHINL = SYSTEMZ_INS_LOCHHINL,
	SYSZ_INS_LOCHHINLE = SYSTEMZ_INS_LOCHHINLE,
	SYSZ_INS_LOCHHINLH = SYSTEMZ_INS_LOCHHINLH,
	SYSZ_INS_LOCHHINM = SYSTEMZ_INS_LOCHHINM,
	SYSZ_INS_LOCHHINO = SYSTEMZ_INS_LOCHHINO,
	SYSZ_INS_LOCHHINP = SYSTEMZ_INS_LOCHHINP,
	SYSZ_INS_LOCHHINZ = SYSTEMZ_INS_LOCHHINZ,
	SYSZ_INS_LOCHHIO = SYSTEMZ_INS_LOCHHIO,
	SYSZ_INS_LOCHHIP = SYSTEMZ_INS_LOCHHIP,
	SYSZ_INS_LOCHHIZ = SYSTEMZ_INS_LOCHHIZ,
	SYSZ_INS_LOCHI = SYSTEMZ_INS_LOCHI,
	SYSZ_INS_LOCHIE = SYSTEMZ_INS_LOCHIE,
	SYSZ_INS_LOCHIH = SYSTEMZ_INS_LOCHIH,
	SYSZ_INS_LOCHIHE = SYSTEMZ_INS_LOCHIHE,
	SYSZ_INS_LOCHIL = SYSTEMZ_INS_LOCHIL,
	SYSZ_INS_LOCHILE = SYSTEMZ_INS_LOCHILE,
	SYSZ_INS_LOCHILH = SYSTEMZ_INS_LOCHILH,
	SYSZ_INS_LOCHIM = SYSTEMZ_INS_LOCHIM,
	SYSZ_INS_LOCHINE = SYSTEMZ_INS_LOCHINE,
	SYSZ_INS_LOCHINH = SYSTEMZ_INS_LOCHINH,
	SYSZ_INS_LOCHINHE = SYSTEMZ_INS_LOCHINHE,
	SYSZ_INS_LOCHINL = SYSTEMZ_INS_LOCHINL,
	SYSZ_INS_LOCHINLE = SYSTEMZ_INS_LOCHINLE,
	SYSZ_INS_LOCHINLH = SYSTEMZ_INS_LOCHINLH,
	SYSZ_INS_LOCHINM = SYSTEMZ_INS_LOCHINM,
	SYSZ_INS_LOCHINO = SYSTEMZ_INS_LOCHINO,
	SYSZ_INS_LOCHINP = SYSTEMZ_INS_LOCHINP,
	SYSZ_INS_LOCHINZ = SYSTEMZ_INS_LOCHINZ,
	SYSZ_INS_LOCHIO = SYSTEMZ_INS_LOCHIO,
	SYSZ_INS_LOCHIP = SYSTEMZ_INS_LOCHIP,
	SYSZ_INS_LOCHIZ = SYSTEMZ_INS_LOCHIZ,
	SYSZ_INS_LOCR = SYSTEMZ_INS_LOCR,
	SYSZ_INS_LOCRE = SYSTEMZ_INS_LOCRE,
	SYSZ_INS_LOCRH = SYSTEMZ_INS_LOCRH,
	SYSZ_INS_LOCRHE = SYSTEMZ_INS_LOCRHE,
	SYSZ_INS_LOCRL = SYSTEMZ_INS_LOCRL,
	SYSZ_INS_LOCRLE = SYSTEMZ_INS_LOCRLE,
	SYSZ_INS_LOCRLH = SYSTEMZ_INS_LOCRLH,
	SYSZ_INS_LOCRM = SYSTEMZ_INS_LOCRM,
	SYSZ_INS_LOCRNE = SYSTEMZ_INS_LOCRNE,
	SYSZ_INS_LOCRNH = SYSTEMZ_INS_LOCRNH,
	SYSZ_INS_LOCRNHE = SYSTEMZ_INS_LOCRNHE,
	SYSZ_INS_LOCRNL = SYSTEMZ_INS_LOCRNL,
	SYSZ_INS_LOCRNLE = SYSTEMZ_INS_LOCRNLE,
	SYSZ_INS_LOCRNLH = SYSTEMZ_INS_LOCRNLH,
	SYSZ_INS_LOCRNM = SYSTEMZ_INS_LOCRNM,
	SYSZ_INS_LOCRNO = SYSTEMZ_INS_LOCRNO,
	SYSZ_INS_LOCRNP = SYSTEMZ_INS_LOCRNP,
	SYSZ_INS_LOCRNZ = SYSTEMZ_INS_LOCRNZ,
	SYSZ_INS_LOCRO = SYSTEMZ_INS_LOCRO,
	SYSZ_INS_LOCRP = SYSTEMZ_INS_LOCRP,
	SYSZ_INS_LOCRZ = SYSTEMZ_INS_LOCRZ,
	SYSZ_INS_LPCTL = SYSTEMZ_INS_LPCTL,
	SYSZ_INS_LPD = SYSTEMZ_INS_LPD,
	SYSZ_INS_LPDBR = SYSTEMZ_INS_LPDBR,
	SYSZ_INS_LPDFR = SYSTEMZ_INS_LPDFR,
	SYSZ_INS_LPDG = SYSTEMZ_INS_LPDG,
	SYSZ_INS_LPDR = SYSTEMZ_INS_LPDR,
	SYSZ_INS_LPEBR = SYSTEMZ_INS_LPEBR,
	SYSZ_INS_LPER = SYSTEMZ_INS_LPER,
	SYSZ_INS_LPGFR = SYSTEMZ_INS_LPGFR,
	SYSZ_INS_LPGR = SYSTEMZ_INS_LPGR,
	SYSZ_INS_LPP = SYSTEMZ_INS_LPP,
	SYSZ_INS_LPQ = SYSTEMZ_INS_LPQ,
	SYSZ_INS_LPR = SYSTEMZ_INS_LPR,
	SYSZ_INS_LPSW = SYSTEMZ_INS_LPSW,
	SYSZ_INS_LPSWE = SYSTEMZ_INS_LPSWE,
	SYSZ_INS_LPSWEY = SYSTEMZ_INS_LPSWEY,
	SYSZ_INS_LPTEA = SYSTEMZ_INS_LPTEA,
	SYSZ_INS_LPXBR = SYSTEMZ_INS_LPXBR,
	SYSZ_INS_LPXR = SYSTEMZ_INS_LPXR,
	SYSZ_INS_LR = SYSTEMZ_INS_LR,
	SYSZ_INS_LRA = SYSTEMZ_INS_LRA,
	SYSZ_INS_LRAG = SYSTEMZ_INS_LRAG,
	SYSZ_INS_LRAY = SYSTEMZ_INS_LRAY,
	SYSZ_INS_LRDR = SYSTEMZ_INS_LRDR,
	SYSZ_INS_LRER = SYSTEMZ_INS_LRER,
	SYSZ_INS_LRL = SYSTEMZ_INS_LRL,
	SYSZ_INS_LRV = SYSTEMZ_INS_LRV,
	SYSZ_INS_LRVG = SYSTEMZ_INS_LRVG,
	SYSZ_INS_LRVGR = SYSTEMZ_INS_LRVGR,
	SYSZ_INS_LRVH = SYSTEMZ_INS_LRVH,
	SYSZ_INS_LRVR = SYSTEMZ_INS_LRVR,
	SYSZ_INS_LSCTL = SYSTEMZ_INS_LSCTL,
	SYSZ_INS_LT = SYSTEMZ_INS_LT,
	SYSZ_INS_LTDBR = SYSTEMZ_INS_LTDBR,
	SYSZ_INS_LTDR = SYSTEMZ_INS_LTDR,
	SYSZ_INS_LTDTR = SYSTEMZ_INS_LTDTR,
	SYSZ_INS_LTEBR = SYSTEMZ_INS_LTEBR,
	SYSZ_INS_LTER = SYSTEMZ_INS_LTER,
	SYSZ_INS_LTG = SYSTEMZ_INS_LTG,
	SYSZ_INS_LTGF = SYSTEMZ_INS_LTGF,
	SYSZ_INS_LTGFR = SYSTEMZ_INS_LTGFR,
	SYSZ_INS_LTGR = SYSTEMZ_INS_LTGR,
	SYSZ_INS_LTR = SYSTEMZ_INS_LTR,
	SYSZ_INS_LTXBR = SYSTEMZ_INS_LTXBR,
	SYSZ_INS_LTXR = SYSTEMZ_INS_LTXR,
	SYSZ_INS_LTXTR = SYSTEMZ_INS_LTXTR,
	SYSZ_INS_LURA = SYSTEMZ_INS_LURA,
	SYSZ_INS_LURAG = SYSTEMZ_INS_LURAG,
	SYSZ_INS_LXD = SYSTEMZ_INS_LXD,
	SYSZ_INS_LXDB = SYSTEMZ_INS_LXDB,
	SYSZ_INS_LXDBR = SYSTEMZ_INS_LXDBR,
	SYSZ_INS_LXDR = SYSTEMZ_INS_LXDR,
	SYSZ_INS_LXDTR = SYSTEMZ_INS_LXDTR,
	SYSZ_INS_LXE = SYSTEMZ_INS_LXE,
	SYSZ_INS_LXEB = SYSTEMZ_INS_LXEB,
	SYSZ_INS_LXEBR = SYSTEMZ_INS_LXEBR,
	SYSZ_INS_LXER = SYSTEMZ_INS_LXER,
	SYSZ_INS_LXR = SYSTEMZ_INS_LXR,
	SYSZ_INS_LY = SYSTEMZ_INS_LY,
	SYSZ_INS_LZDR = SYSTEMZ_INS_LZDR,
	SYSZ_INS_LZER = SYSTEMZ_INS_LZER,
	SYSZ_INS_LZRF = SYSTEMZ_INS_LZRF,
	SYSZ_INS_LZRG = SYSTEMZ_INS_LZRG,
	SYSZ_INS_LZXR = SYSTEMZ_INS_LZXR,
	SYSZ_INS_M = SYSTEMZ_INS_M,
	SYSZ_INS_MAD = SYSTEMZ_INS_MAD,
	SYSZ_INS_MADB = SYSTEMZ_INS_MADB,
	SYSZ_INS_MADBR = SYSTEMZ_INS_MADBR,
	SYSZ_INS_MADR = SYSTEMZ_INS_MADR,
	SYSZ_INS_MAE = SYSTEMZ_INS_MAE,
	SYSZ_INS_MAEB = SYSTEMZ_INS_MAEB,
	SYSZ_INS_MAEBR = SYSTEMZ_INS_MAEBR,
	SYSZ_INS_MAER = SYSTEMZ_INS_MAER,
	SYSZ_INS_MAY = SYSTEMZ_INS_MAY,
	SYSZ_INS_MAYH = SYSTEMZ_INS_MAYH,
	SYSZ_INS_MAYHR = SYSTEMZ_INS_MAYHR,
	SYSZ_INS_MAYL = SYSTEMZ_INS_MAYL,
	SYSZ_INS_MAYLR = SYSTEMZ_INS_MAYLR,
	SYSZ_INS_MAYR = SYSTEMZ_INS_MAYR,
	SYSZ_INS_MC = SYSTEMZ_INS_MC,
	SYSZ_INS_MD = SYSTEMZ_INS_MD,
	SYSZ_INS_MDB = SYSTEMZ_INS_MDB,
	SYSZ_INS_MDBR = SYSTEMZ_INS_MDBR,
	SYSZ_INS_MDE = SYSTEMZ_INS_MDE,
	SYSZ_INS_MDEB = SYSTEMZ_INS_MDEB,
	SYSZ_INS_MDEBR = SYSTEMZ_INS_MDEBR,
	SYSZ_INS_MDER = SYSTEMZ_INS_MDER,
	SYSZ_INS_MDR = SYSTEMZ_INS_MDR,
	SYSZ_INS_MDTR = SYSTEMZ_INS_MDTR,
	SYSZ_INS_MDTRA = SYSTEMZ_INS_MDTRA,
	SYSZ_INS_ME = SYSTEMZ_INS_ME,
	SYSZ_INS_MEE = SYSTEMZ_INS_MEE,
	SYSZ_INS_MEEB = SYSTEMZ_INS_MEEB,
	SYSZ_INS_MEEBR = SYSTEMZ_INS_MEEBR,
	SYSZ_INS_MEER = SYSTEMZ_INS_MEER,
	SYSZ_INS_MER = SYSTEMZ_INS_MER,
	SYSZ_INS_MFY = SYSTEMZ_INS_MFY,
	SYSZ_INS_MG = SYSTEMZ_INS_MG,
	SYSZ_INS_MGH = SYSTEMZ_INS_MGH,
	SYSZ_INS_MGHI = SYSTEMZ_INS_MGHI,
	SYSZ_INS_MGRK = SYSTEMZ_INS_MGRK,
	SYSZ_INS_MH = SYSTEMZ_INS_MH,
	SYSZ_INS_MHI = SYSTEMZ_INS_MHI,
	SYSZ_INS_MHY = SYSTEMZ_INS_MHY,
	SYSZ_INS_ML = SYSTEMZ_INS_ML,
	SYSZ_INS_MLG = SYSTEMZ_INS_MLG,
	SYSZ_INS_MLGR = SYSTEMZ_INS_MLGR,
	SYSZ_INS_MLR = SYSTEMZ_INS_MLR,
	SYSZ_INS_MP = SYSTEMZ_INS_MP,
	SYSZ_INS_MR = SYSTEMZ_INS_MR,
	SYSZ_INS_MS = SYSTEMZ_INS_MS,
	SYSZ_INS_MSC = SYSTEMZ_INS_MSC,
	SYSZ_INS_MSCH = SYSTEMZ_INS_MSCH,
	SYSZ_INS_MSD = SYSTEMZ_INS_MSD,
	SYSZ_INS_MSDB = SYSTEMZ_INS_MSDB,
	SYSZ_INS_MSDBR = SYSTEMZ_INS_MSDBR,
	SYSZ_INS_MSDR = SYSTEMZ_INS_MSDR,
	SYSZ_INS_MSE = SYSTEMZ_INS_MSE,
	SYSZ_INS_MSEB = SYSTEMZ_INS_MSEB,
	SYSZ_INS_MSEBR = SYSTEMZ_INS_MSEBR,
	SYSZ_INS_MSER = SYSTEMZ_INS_MSER,
	SYSZ_INS_MSFI = SYSTEMZ_INS_MSFI,
	SYSZ_INS_MSG = SYSTEMZ_INS_MSG,
	SYSZ_INS_MSGC = SYSTEMZ_INS_MSGC,
	SYSZ_INS_MSGF = SYSTEMZ_INS_MSGF,
	SYSZ_INS_MSGFI = SYSTEMZ_INS_MSGFI,
	SYSZ_INS_MSGFR = SYSTEMZ_INS_MSGFR,
	SYSZ_INS_MSGR = SYSTEMZ_INS_MSGR,
	SYSZ_INS_MSGRKC = SYSTEMZ_INS_MSGRKC,
	SYSZ_INS_MSR = SYSTEMZ_INS_MSR,
	SYSZ_INS_MSRKC = SYSTEMZ_INS_MSRKC,
	SYSZ_INS_MSTA = SYSTEMZ_INS_MSTA,
	SYSZ_INS_MSY = SYSTEMZ_INS_MSY,
	SYSZ_INS_MVC = SYSTEMZ_INS_MVC,
	SYSZ_INS_MVCDK = SYSTEMZ_INS_MVCDK,
	SYSZ_INS_MVCIN = SYSTEMZ_INS_MVCIN,
	SYSZ_INS_MVCK = SYSTEMZ_INS_MVCK,
	SYSZ_INS_MVCL = SYSTEMZ_INS_MVCL,
	SYSZ_INS_MVCLE = SYSTEMZ_INS_MVCLE,
	SYSZ_INS_MVCLU = SYSTEMZ_INS_MVCLU,
	SYSZ_INS_MVCOS = SYSTEMZ_INS_MVCOS,
	SYSZ_INS_MVCP = SYSTEMZ_INS_MVCP,
	SYSZ_INS_MVCRL = SYSTEMZ_INS_MVCRL,
	SYSZ_INS_MVCS = SYSTEMZ_INS_MVCS,
	SYSZ_INS_MVCSK = SYSTEMZ_INS_MVCSK,
	SYSZ_INS_MVGHI = SYSTEMZ_INS_MVGHI,
	SYSZ_INS_MVHHI = SYSTEMZ_INS_MVHHI,
	SYSZ_INS_MVHI = SYSTEMZ_INS_MVHI,
	SYSZ_INS_MVI = SYSTEMZ_INS_MVI,
	SYSZ_INS_MVIY = SYSTEMZ_INS_MVIY,
	SYSZ_INS_MVN = SYSTEMZ_INS_MVN,
	SYSZ_INS_MVO = SYSTEMZ_INS_MVO,
	SYSZ_INS_MVPG = SYSTEMZ_INS_MVPG,
	SYSZ_INS_MVST = SYSTEMZ_INS_MVST,
	SYSZ_INS_MVZ = SYSTEMZ_INS_MVZ,
	SYSZ_INS_MXBR = SYSTEMZ_INS_MXBR,
	SYSZ_INS_MXD = SYSTEMZ_INS_MXD,
	SYSZ_INS_MXDB = SYSTEMZ_INS_MXDB,
	SYSZ_INS_MXDBR = SYSTEMZ_INS_MXDBR,
	SYSZ_INS_MXDR = SYSTEMZ_INS_MXDR,
	SYSZ_INS_MXR = SYSTEMZ_INS_MXR,
	SYSZ_INS_MXTR = SYSTEMZ_INS_MXTR,
	SYSZ_INS_MXTRA = SYSTEMZ_INS_MXTRA,
	SYSZ_INS_MY = SYSTEMZ_INS_MY,
	SYSZ_INS_MYH = SYSTEMZ_INS_MYH,
	SYSZ_INS_MYHR = SYSTEMZ_INS_MYHR,
	SYSZ_INS_MYL = SYSTEMZ_INS_MYL,
	SYSZ_INS_MYLR = SYSTEMZ_INS_MYLR,
	SYSZ_INS_MYR = SYSTEMZ_INS_MYR,
	SYSZ_INS_N = SYSTEMZ_INS_N,
	SYSZ_INS_NC = SYSTEMZ_INS_NC,
	SYSZ_INS_NCGRK = SYSTEMZ_INS_NCGRK,
	SYSZ_INS_NCRK = SYSTEMZ_INS_NCRK,
	SYSZ_INS_NG = SYSTEMZ_INS_NG,
	SYSZ_INS_NGR = SYSTEMZ_INS_NGR,
	SYSZ_INS_NGRK = SYSTEMZ_INS_NGRK,
	SYSZ_INS_NI = SYSTEMZ_INS_NI,
	SYSZ_INS_NIAI = SYSTEMZ_INS_NIAI,
	SYSZ_INS_NIHF = SYSTEMZ_INS_NIHF,
	SYSZ_INS_NIHH = SYSTEMZ_INS_NIHH,
	SYSZ_INS_NIHL = SYSTEMZ_INS_NIHL,
	SYSZ_INS_NILF = SYSTEMZ_INS_NILF,
	SYSZ_INS_NILH = SYSTEMZ_INS_NILH,
	SYSZ_INS_NILL = SYSTEMZ_INS_NILL,
	SYSZ_INS_NIY = SYSTEMZ_INS_NIY,
	SYSZ_INS_NNGRK = SYSTEMZ_INS_NNGRK,
	SYSZ_INS_NNPA = SYSTEMZ_INS_NNPA,
	SYSZ_INS_NNRK = SYSTEMZ_INS_NNRK,
	SYSZ_INS_NOGRK = SYSTEMZ_INS_NOGRK,
	SYSZ_INS_NOP = SYSTEMZ_INS_NOP,
	SYSZ_INS_NORK = SYSTEMZ_INS_NORK,
	SYSZ_INS_NR = SYSTEMZ_INS_NR,
	SYSZ_INS_NRK = SYSTEMZ_INS_NRK,
	SYSZ_INS_NTSTG = SYSTEMZ_INS_NTSTG,
	SYSZ_INS_NXGRK = SYSTEMZ_INS_NXGRK,
	SYSZ_INS_NXRK = SYSTEMZ_INS_NXRK,
	SYSZ_INS_NY = SYSTEMZ_INS_NY,
	SYSZ_INS_O = SYSTEMZ_INS_O,
	SYSZ_INS_OC = SYSTEMZ_INS_OC,
	SYSZ_INS_OCGRK = SYSTEMZ_INS_OCGRK,
	SYSZ_INS_OCRK = SYSTEMZ_INS_OCRK,
	SYSZ_INS_OG = SYSTEMZ_INS_OG,
	SYSZ_INS_OGR = SYSTEMZ_INS_OGR,
	SYSZ_INS_OGRK = SYSTEMZ_INS_OGRK,
	SYSZ_INS_OI = SYSTEMZ_INS_OI,
	SYSZ_INS_OIHF = SYSTEMZ_INS_OIHF,
	SYSZ_INS_OIHH = SYSTEMZ_INS_OIHH,
	SYSZ_INS_OIHL = SYSTEMZ_INS_OIHL,
	SYSZ_INS_OILF = SYSTEMZ_INS_OILF,
	SYSZ_INS_OILH = SYSTEMZ_INS_OILH,
	SYSZ_INS_OILL = SYSTEMZ_INS_OILL,
	SYSZ_INS_OIY = SYSTEMZ_INS_OIY,
	SYSZ_INS_OR = SYSTEMZ_INS_OR,
	SYSZ_INS_ORK = SYSTEMZ_INS_ORK,
	SYSZ_INS_OY = SYSTEMZ_INS_OY,
	SYSZ_INS_PACK = SYSTEMZ_INS_PACK,
	SYSZ_INS_PALB = SYSTEMZ_INS_PALB,
	SYSZ_INS_PC = SYSTEMZ_INS_PC,
	SYSZ_INS_PCC = SYSTEMZ_INS_PCC,
	SYSZ_INS_PCKMO = SYSTEMZ_INS_PCKMO,
	SYSZ_INS_PFD = SYSTEMZ_INS_PFD,
	SYSZ_INS_PFDRL = SYSTEMZ_INS_PFDRL,
	SYSZ_INS_PFMF = SYSTEMZ_INS_PFMF,
	SYSZ_INS_PFPO = SYSTEMZ_INS_PFPO,
	SYSZ_INS_PGIN = SYSTEMZ_INS_PGIN,
	SYSZ_INS_PGOUT = SYSTEMZ_INS_PGOUT,
	SYSZ_INS_PKA = SYSTEMZ_INS_PKA,
	SYSZ_INS_PKU = SYSTEMZ_INS_PKU,
	SYSZ_INS_PLO = SYSTEMZ_INS_PLO,
	SYSZ_INS_POPCNT = SYSTEMZ_INS_POPCNT,
	SYSZ_INS_PPA = SYSTEMZ_INS_PPA,
	SYSZ_INS_PPNO = SYSTEMZ_INS_PPNO,
	SYSZ_INS_PR = SYSTEMZ_INS_PR,
	SYSZ_INS_PRNO = SYSTEMZ_INS_PRNO,
	SYSZ_INS_PT = SYSTEMZ_INS_PT,
	SYSZ_INS_PTF = SYSTEMZ_INS_PTF,
	SYSZ_INS_PTFF = SYSTEMZ_INS_PTFF,
	SYSZ_INS_PTI = SYSTEMZ_INS_PTI,
	SYSZ_INS_PTLB = SYSTEMZ_INS_PTLB,
	SYSZ_INS_QADTR = SYSTEMZ_INS_QADTR,
	SYSZ_INS_QAXTR = SYSTEMZ_INS_QAXTR,
	SYSZ_INS_QCTRI = SYSTEMZ_INS_QCTRI,
	SYSZ_INS_QPACI = SYSTEMZ_INS_QPACI,
	SYSZ_INS_QSI = SYSTEMZ_INS_QSI,
	SYSZ_INS_RCHP = SYSTEMZ_INS_RCHP,
	SYSZ_INS_RDP = SYSTEMZ_INS_RDP,
	SYSZ_INS_RISBG = SYSTEMZ_INS_RISBG,
	SYSZ_INS_RISBGN = SYSTEMZ_INS_RISBGN,
	SYSZ_INS_RISBHG = SYSTEMZ_INS_RISBHG,
	SYSZ_INS_RISBLG = SYSTEMZ_INS_RISBLG,
	SYSZ_INS_RLL = SYSTEMZ_INS_RLL,
	SYSZ_INS_RLLG = SYSTEMZ_INS_RLLG,
	SYSZ_INS_RNSBG = SYSTEMZ_INS_RNSBG,
	SYSZ_INS_ROSBG = SYSTEMZ_INS_ROSBG,
	SYSZ_INS_RP = SYSTEMZ_INS_RP,
	SYSZ_INS_RRBE = SYSTEMZ_INS_RRBE,
	SYSZ_INS_RRBM = SYSTEMZ_INS_RRBM,
	SYSZ_INS_RRDTR = SYSTEMZ_INS_RRDTR,
	SYSZ_INS_RRXTR = SYSTEMZ_INS_RRXTR,
	SYSZ_INS_RSCH = SYSTEMZ_INS_RSCH,
	SYSZ_INS_RXSBG = SYSTEMZ_INS_RXSBG,
	SYSZ_INS_S = SYSTEMZ_INS_S,
	SYSZ_INS_SAC = SYSTEMZ_INS_SAC,
	SYSZ_INS_SACF = SYSTEMZ_INS_SACF,
	SYSZ_INS_SAL = SYSTEMZ_INS_SAL,
	SYSZ_INS_SAM24 = SYSTEMZ_INS_SAM24,
	SYSZ_INS_SAM31 = SYSTEMZ_INS_SAM31,
	SYSZ_INS_SAM64 = SYSTEMZ_INS_SAM64,
	SYSZ_INS_SAR = SYSTEMZ_INS_SAR,
	SYSZ_INS_SCCTR = SYSTEMZ_INS_SCCTR,
	SYSZ_INS_SCHM = SYSTEMZ_INS_SCHM,
	SYSZ_INS_SCK = SYSTEMZ_INS_SCK,
	SYSZ_INS_SCKC = SYSTEMZ_INS_SCKC,
	SYSZ_INS_SCKPF = SYSTEMZ_INS_SCKPF,
	SYSZ_INS_SD = SYSTEMZ_INS_SD,
	SYSZ_INS_SDB = SYSTEMZ_INS_SDB,
	SYSZ_INS_SDBR = SYSTEMZ_INS_SDBR,
	SYSZ_INS_SDR = SYSTEMZ_INS_SDR,
	SYSZ_INS_SDTR = SYSTEMZ_INS_SDTR,
	SYSZ_INS_SDTRA = SYSTEMZ_INS_SDTRA,
	SYSZ_INS_SE = SYSTEMZ_INS_SE,
	SYSZ_INS_SEB = SYSTEMZ_INS_SEB,
	SYSZ_INS_SEBR = SYSTEMZ_INS_SEBR,
	SYSZ_INS_SELFHR = SYSTEMZ_INS_SELFHR,
	SYSZ_INS_SELFHRE = SYSTEMZ_INS_SELFHRE,
	SYSZ_INS_SELFHRH = SYSTEMZ_INS_SELFHRH,
	SYSZ_INS_SELFHRHE = SYSTEMZ_INS_SELFHRHE,
	SYSZ_INS_SELFHRL = SYSTEMZ_INS_SELFHRL,
	SYSZ_INS_SELFHRLE = SYSTEMZ_INS_SELFHRLE,
	SYSZ_INS_SELFHRLH = SYSTEMZ_INS_SELFHRLH,
	SYSZ_INS_SELFHRM = SYSTEMZ_INS_SELFHRM,
	SYSZ_INS_SELFHRNE = SYSTEMZ_INS_SELFHRNE,
	SYSZ_INS_SELFHRNH = SYSTEMZ_INS_SELFHRNH,
	SYSZ_INS_SELFHRNHE = SYSTEMZ_INS_SELFHRNHE,
	SYSZ_INS_SELFHRNL = SYSTEMZ_INS_SELFHRNL,
	SYSZ_INS_SELFHRNLE = SYSTEMZ_INS_SELFHRNLE,
	SYSZ_INS_SELFHRNLH = SYSTEMZ_INS_SELFHRNLH,
	SYSZ_INS_SELFHRNM = SYSTEMZ_INS_SELFHRNM,
	SYSZ_INS_SELFHRNO = SYSTEMZ_INS_SELFHRNO,
	SYSZ_INS_SELFHRNP = SYSTEMZ_INS_SELFHRNP,
	SYSZ_INS_SELFHRNZ = SYSTEMZ_INS_SELFHRNZ,
	SYSZ_INS_SELFHRO = SYSTEMZ_INS_SELFHRO,
	SYSZ_INS_SELFHRP = SYSTEMZ_INS_SELFHRP,
	SYSZ_INS_SELFHRZ = SYSTEMZ_INS_SELFHRZ,
	SYSZ_INS_SELGR = SYSTEMZ_INS_SELGR,
	SYSZ_INS_SELGRE = SYSTEMZ_INS_SELGRE,
	SYSZ_INS_SELGRH = SYSTEMZ_INS_SELGRH,
	SYSZ_INS_SELGRHE = SYSTEMZ_INS_SELGRHE,
	SYSZ_INS_SELGRL = SYSTEMZ_INS_SELGRL,
	SYSZ_INS_SELGRLE = SYSTEMZ_INS_SELGRLE,
	SYSZ_INS_SELGRLH = SYSTEMZ_INS_SELGRLH,
	SYSZ_INS_SELGRM = SYSTEMZ_INS_SELGRM,
	SYSZ_INS_SELGRNE = SYSTEMZ_INS_SELGRNE,
	SYSZ_INS_SELGRNH = SYSTEMZ_INS_SELGRNH,
	SYSZ_INS_SELGRNHE = SYSTEMZ_INS_SELGRNHE,
	SYSZ_INS_SELGRNL = SYSTEMZ_INS_SELGRNL,
	SYSZ_INS_SELGRNLE = SYSTEMZ_INS_SELGRNLE,
	SYSZ_INS_SELGRNLH = SYSTEMZ_INS_SELGRNLH,
	SYSZ_INS_SELGRNM = SYSTEMZ_INS_SELGRNM,
	SYSZ_INS_SELGRNO = SYSTEMZ_INS_SELGRNO,
	SYSZ_INS_SELGRNP = SYSTEMZ_INS_SELGRNP,
	SYSZ_INS_SELGRNZ = SYSTEMZ_INS_SELGRNZ,
	SYSZ_INS_SELGRO = SYSTEMZ_INS_SELGRO,
	SYSZ_INS_SELGRP = SYSTEMZ_INS_SELGRP,
	SYSZ_INS_SELGRZ = SYSTEMZ_INS_SELGRZ,
	SYSZ_INS_SELR = SYSTEMZ_INS_SELR,
	SYSZ_INS_SELRE = SYSTEMZ_INS_SELRE,
	SYSZ_INS_SELRH = SYSTEMZ_INS_SELRH,
	SYSZ_INS_SELRHE = SYSTEMZ_INS_SELRHE,
	SYSZ_INS_SELRL = SYSTEMZ_INS_SELRL,
	SYSZ_INS_SELRLE = SYSTEMZ_INS_SELRLE,
	SYSZ_INS_SELRLH = SYSTEMZ_INS_SELRLH,
	SYSZ_INS_SELRM = SYSTEMZ_INS_SELRM,
	SYSZ_INS_SELRNE = SYSTEMZ_INS_SELRNE,
	SYSZ_INS_SELRNH = SYSTEMZ_INS_SELRNH,
	SYSZ_INS_SELRNHE = SYSTEMZ_INS_SELRNHE,
	SYSZ_INS_SELRNL = SYSTEMZ_INS_SELRNL,
	SYSZ_INS_SELRNLE = SYSTEMZ_INS_SELRNLE,
	SYSZ_INS_SELRNLH = SYSTEMZ_INS_SELRNLH,
	SYSZ_INS_SELRNM = SYSTEMZ_INS_SELRNM,
	SYSZ_INS_SELRNO = SYSTEMZ_INS_SELRNO,
	SYSZ_INS_SELRNP = SYSTEMZ_INS_SELRNP,
	SYSZ_INS_SELRNZ = SYSTEMZ_INS_SELRNZ,
	SYSZ_INS_SELRO = SYSTEMZ_INS_SELRO,
	SYSZ_INS_SELRP = SYSTEMZ_INS_SELRP,
	SYSZ_INS_SELRZ = SYSTEMZ_INS_SELRZ,
	SYSZ_INS_SER = SYSTEMZ_INS_SER,
	SYSZ_INS_SFASR = SYSTEMZ_INS_SFASR,
	SYSZ_INS_SFPC = SYSTEMZ_INS_SFPC,
	SYSZ_INS_SG = SYSTEMZ_INS_SG,
	SYSZ_INS_SGF = SYSTEMZ_INS_SGF,
	SYSZ_INS_SGFR = SYSTEMZ_INS_SGFR,
	SYSZ_INS_SGH = SYSTEMZ_INS_SGH,
	SYSZ_INS_SGR = SYSTEMZ_INS_SGR,
	SYSZ_INS_SGRK = SYSTEMZ_INS_SGRK,
	SYSZ_INS_SH = SYSTEMZ_INS_SH,
	SYSZ_INS_SHHHR = SYSTEMZ_INS_SHHHR,
	SYSZ_INS_SHHLR = SYSTEMZ_INS_SHHLR,
	SYSZ_INS_SHY = SYSTEMZ_INS_SHY,
	SYSZ_INS_SIE = SYSTEMZ_INS_SIE,
	SYSZ_INS_SIGA = SYSTEMZ_INS_SIGA,
	SYSZ_INS_SIGP = SYSTEMZ_INS_SIGP,
	SYSZ_INS_SL = SYSTEMZ_INS_SL,
	SYSZ_INS_SLA = SYSTEMZ_INS_SLA,
	SYSZ_INS_SLAG = SYSTEMZ_INS_SLAG,
	SYSZ_INS_SLAK = SYSTEMZ_INS_SLAK,
	SYSZ_INS_SLB = SYSTEMZ_INS_SLB,
	SYSZ_INS_SLBG = SYSTEMZ_INS_SLBG,
	SYSZ_INS_SLBGR = SYSTEMZ_INS_SLBGR,
	SYSZ_INS_SLBR = SYSTEMZ_INS_SLBR,
	SYSZ_INS_SLDA = SYSTEMZ_INS_SLDA,
	SYSZ_INS_SLDL = SYSTEMZ_INS_SLDL,
	SYSZ_INS_SLDT = SYSTEMZ_INS_SLDT,
	SYSZ_INS_SLFI = SYSTEMZ_INS_SLFI,
	SYSZ_INS_SLG = SYSTEMZ_INS_SLG,
	SYSZ_INS_SLGF = SYSTEMZ_INS_SLGF,
	SYSZ_INS_SLGFI = SYSTEMZ_INS_SLGFI,
	SYSZ_INS_SLGFR = SYSTEMZ_INS_SLGFR,
	SYSZ_INS_SLGR = SYSTEMZ_INS_SLGR,
	SYSZ_INS_SLGRK = SYSTEMZ_INS_SLGRK,
	SYSZ_INS_SLHHHR = SYSTEMZ_INS_SLHHHR,
	SYSZ_INS_SLHHLR = SYSTEMZ_INS_SLHHLR,
	SYSZ_INS_SLL = SYSTEMZ_INS_SLL,
	SYSZ_INS_SLLG = SYSTEMZ_INS_SLLG,
	SYSZ_INS_SLLK = SYSTEMZ_INS_SLLK,
	SYSZ_INS_SLR = SYSTEMZ_INS_SLR,
	SYSZ_INS_SLRK = SYSTEMZ_INS_SLRK,
	SYSZ_INS_SLXT = SYSTEMZ_INS_SLXT,
	SYSZ_INS_SLY = SYSTEMZ_INS_SLY,
	SYSZ_INS_SORTL = SYSTEMZ_INS_SORTL,
	SYSZ_INS_SP = SYSTEMZ_INS_SP,
	SYSZ_INS_SPCTR = SYSTEMZ_INS_SPCTR,
	SYSZ_INS_SPKA = SYSTEMZ_INS_SPKA,
	SYSZ_INS_SPM = SYSTEMZ_INS_SPM,
	SYSZ_INS_SPT = SYSTEMZ_INS_SPT,
	SYSZ_INS_SPX = SYSTEMZ_INS_SPX,
	SYSZ_INS_SQD = SYSTEMZ_INS_SQD,
	SYSZ_INS_SQDB = SYSTEMZ_INS_SQDB,
	SYSZ_INS_SQDBR = SYSTEMZ_INS_SQDBR,
	SYSZ_INS_SQDR = SYSTEMZ_INS_SQDR,
	SYSZ_INS_SQE = SYSTEMZ_INS_SQE,
	SYSZ_INS_SQEB = SYSTEMZ_INS_SQEB,
	SYSZ_INS_SQEBR = SYSTEMZ_INS_SQEBR,
	SYSZ_INS_SQER = SYSTEMZ_INS_SQER,
	SYSZ_INS_SQXBR = SYSTEMZ_INS_SQXBR,
	SYSZ_INS_SQXR = SYSTEMZ_INS_SQXR,
	SYSZ_INS_SR = SYSTEMZ_INS_SR,
	SYSZ_INS_SRA = SYSTEMZ_INS_SRA,
	SYSZ_INS_SRAG = SYSTEMZ_INS_SRAG,
	SYSZ_INS_SRAK = SYSTEMZ_INS_SRAK,
	SYSZ_INS_SRDA = SYSTEMZ_INS_SRDA,
	SYSZ_INS_SRDL = SYSTEMZ_INS_SRDL,
	SYSZ_INS_SRDT = SYSTEMZ_INS_SRDT,
	SYSZ_INS_SRK = SYSTEMZ_INS_SRK,
	SYSZ_INS_SRL = SYSTEMZ_INS_SRL,
	SYSZ_INS_SRLG = SYSTEMZ_INS_SRLG,
	SYSZ_INS_SRLK = SYSTEMZ_INS_SRLK,
	SYSZ_INS_SRNM = SYSTEMZ_INS_SRNM,
	SYSZ_INS_SRNMB = SYSTEMZ_INS_SRNMB,
	SYSZ_INS_SRNMT = SYSTEMZ_INS_SRNMT,
	SYSZ_INS_SRP = SYSTEMZ_INS_SRP,
	SYSZ_INS_SRST = SYSTEMZ_INS_SRST,
	SYSZ_INS_SRSTU = SYSTEMZ_INS_SRSTU,
	SYSZ_INS_SRXT = SYSTEMZ_INS_SRXT,
	SYSZ_INS_SSAIR = SYSTEMZ_INS_SSAIR,
	SYSZ_INS_SSAR = SYSTEMZ_INS_SSAR,
	SYSZ_INS_SSCH = SYSTEMZ_INS_SSCH,
	SYSZ_INS_SSKE = SYSTEMZ_INS_SSKE,
	SYSZ_INS_SSM = SYSTEMZ_INS_SSM,
	SYSZ_INS_ST = SYSTEMZ_INS_ST,
	SYSZ_INS_STAM = SYSTEMZ_INS_STAM,
	SYSZ_INS_STAMY = SYSTEMZ_INS_STAMY,
	SYSZ_INS_STAP = SYSTEMZ_INS_STAP,
	SYSZ_INS_STBEAR = SYSTEMZ_INS_STBEAR,
	SYSZ_INS_STC = SYSTEMZ_INS_STC,
	SYSZ_INS_STCH = SYSTEMZ_INS_STCH,
	SYSZ_INS_STCK = SYSTEMZ_INS_STCK,
	SYSZ_INS_STCKC = SYSTEMZ_INS_STCKC,
	SYSZ_INS_STCKE = SYSTEMZ_INS_STCKE,
	SYSZ_INS_STCKF = SYSTEMZ_INS_STCKF,
	SYSZ_INS_STCM = SYSTEMZ_INS_STCM,
	SYSZ_INS_STCMH = SYSTEMZ_INS_STCMH,
	SYSZ_INS_STCMY = SYSTEMZ_INS_STCMY,
	SYSZ_INS_STCPS = SYSTEMZ_INS_STCPS,
	SYSZ_INS_STCRW = SYSTEMZ_INS_STCRW,
	SYSZ_INS_STCTG = SYSTEMZ_INS_STCTG,
	SYSZ_INS_STCTL = SYSTEMZ_INS_STCTL,
	SYSZ_INS_STCY = SYSTEMZ_INS_STCY,
	SYSZ_INS_STD = SYSTEMZ_INS_STD,
	SYSZ_INS_STDY = SYSTEMZ_INS_STDY,
	SYSZ_INS_STE = SYSTEMZ_INS_STE,
	SYSZ_INS_STEY = SYSTEMZ_INS_STEY,
	SYSZ_INS_STFH = SYSTEMZ_INS_STFH,
	SYSZ_INS_STFL = SYSTEMZ_INS_STFL,
	SYSZ_INS_STFLE = SYSTEMZ_INS_STFLE,
	SYSZ_INS_STFPC = SYSTEMZ_INS_STFPC,
	SYSZ_INS_STG = SYSTEMZ_INS_STG,
	SYSZ_INS_STGRL = SYSTEMZ_INS_STGRL,
	SYSZ_INS_STGSC = SYSTEMZ_INS_STGSC,
	SYSZ_INS_STH = SYSTEMZ_INS_STH,
	SYSZ_INS_STHH = SYSTEMZ_INS_STHH,
	SYSZ_INS_STHRL = SYSTEMZ_INS_STHRL,
	SYSZ_INS_STHY = SYSTEMZ_INS_STHY,
	SYSZ_INS_STIDP = SYSTEMZ_INS_STIDP,
	SYSZ_INS_STM = SYSTEMZ_INS_STM,
	SYSZ_INS_STMG = SYSTEMZ_INS_STMG,
	SYSZ_INS_STMH = SYSTEMZ_INS_STMH,
	SYSZ_INS_STMY = SYSTEMZ_INS_STMY,
	SYSZ_INS_STNSM = SYSTEMZ_INS_STNSM,
	SYSZ_INS_STOC = SYSTEMZ_INS_STOC,
	SYSZ_INS_STOCE = SYSTEMZ_INS_STOCE,
	SYSZ_INS_STOCH = SYSTEMZ_INS_STOCH,
	SYSZ_INS_STOCHE = SYSTEMZ_INS_STOCHE,
	SYSZ_INS_STOCL = SYSTEMZ_INS_STOCL,
	SYSZ_INS_STOCLE = SYSTEMZ_INS_STOCLE,
	SYSZ_INS_STOCLH = SYSTEMZ_INS_STOCLH,
	SYSZ_INS_STOCM = SYSTEMZ_INS_STOCM,
	SYSZ_INS_STOCNE = SYSTEMZ_INS_STOCNE,
	SYSZ_INS_STOCNH = SYSTEMZ_INS_STOCNH,
	SYSZ_INS_STOCNHE = SYSTEMZ_INS_STOCNHE,
	SYSZ_INS_STOCNL = SYSTEMZ_INS_STOCNL,
	SYSZ_INS_STOCNLE = SYSTEMZ_INS_STOCNLE,
	SYSZ_INS_STOCNLH = SYSTEMZ_INS_STOCNLH,
	SYSZ_INS_STOCNM = SYSTEMZ_INS_STOCNM,
	SYSZ_INS_STOCNO = SYSTEMZ_INS_STOCNO,
	SYSZ_INS_STOCNP = SYSTEMZ_INS_STOCNP,
	SYSZ_INS_STOCNZ = SYSTEMZ_INS_STOCNZ,
	SYSZ_INS_STOCO = SYSTEMZ_INS_STOCO,
	SYSZ_INS_STOCP = SYSTEMZ_INS_STOCP,
	SYSZ_INS_STOCZ = SYSTEMZ_INS_STOCZ,
	SYSZ_INS_STOCFH = SYSTEMZ_INS_STOCFH,
	SYSZ_INS_STOCFHE = SYSTEMZ_INS_STOCFHE,
	SYSZ_INS_STOCFHH = SYSTEMZ_INS_STOCFHH,
	SYSZ_INS_STOCFHHE = SYSTEMZ_INS_STOCFHHE,
	SYSZ_INS_STOCFHL = SYSTEMZ_INS_STOCFHL,
	SYSZ_INS_STOCFHLE = SYSTEMZ_INS_STOCFHLE,
	SYSZ_INS_STOCFHLH = SYSTEMZ_INS_STOCFHLH,
	SYSZ_INS_STOCFHM = SYSTEMZ_INS_STOCFHM,
	SYSZ_INS_STOCFHNE = SYSTEMZ_INS_STOCFHNE,
	SYSZ_INS_STOCFHNH = SYSTEMZ_INS_STOCFHNH,
	SYSZ_INS_STOCFHNHE = SYSTEMZ_INS_STOCFHNHE,
	SYSZ_INS_STOCFHNL = SYSTEMZ_INS_STOCFHNL,
	SYSZ_INS_STOCFHNLE = SYSTEMZ_INS_STOCFHNLE,
	SYSZ_INS_STOCFHNLH = SYSTEMZ_INS_STOCFHNLH,
	SYSZ_INS_STOCFHNM = SYSTEMZ_INS_STOCFHNM,
	SYSZ_INS_STOCFHNO = SYSTEMZ_INS_STOCFHNO,
	SYSZ_INS_STOCFHNP = SYSTEMZ_INS_STOCFHNP,
	SYSZ_INS_STOCFHNZ = SYSTEMZ_INS_STOCFHNZ,
	SYSZ_INS_STOCFHO = SYSTEMZ_INS_STOCFHO,
	SYSZ_INS_STOCFHP = SYSTEMZ_INS_STOCFHP,
	SYSZ_INS_STOCFHZ = SYSTEMZ_INS_STOCFHZ,
	SYSZ_INS_STOCG = SYSTEMZ_INS_STOCG,
	SYSZ_INS_STOCGE = SYSTEMZ_INS_STOCGE,
	SYSZ_INS_STOCGH = SYSTEMZ_INS_STOCGH,
	SYSZ_INS_STOCGHE = SYSTEMZ_INS_STOCGHE,
	SYSZ_INS_STOCGL = SYSTEMZ_INS_STOCGL,
	SYSZ_INS_STOCGLE = SYSTEMZ_INS_STOCGLE,
	SYSZ_INS_STOCGLH = SYSTEMZ_INS_STOCGLH,
	SYSZ_INS_STOCGM = SYSTEMZ_INS_STOCGM,
	SYSZ_INS_STOCGNE = SYSTEMZ_INS_STOCGNE,
	SYSZ_INS_STOCGNH = SYSTEMZ_INS_STOCGNH,
	SYSZ_INS_STOCGNHE = SYSTEMZ_INS_STOCGNHE,
	SYSZ_INS_STOCGNL = SYSTEMZ_INS_STOCGNL,
	SYSZ_INS_STOCGNLE = SYSTEMZ_INS_STOCGNLE,
	SYSZ_INS_STOCGNLH = SYSTEMZ_INS_STOCGNLH,
	SYSZ_INS_STOCGNM = SYSTEMZ_INS_STOCGNM,
	SYSZ_INS_STOCGNO = SYSTEMZ_INS_STOCGNO,
	SYSZ_INS_STOCGNP = SYSTEMZ_INS_STOCGNP,
	SYSZ_INS_STOCGNZ = SYSTEMZ_INS_STOCGNZ,
	SYSZ_INS_STOCGO = SYSTEMZ_INS_STOCGO,
	SYSZ_INS_STOCGP = SYSTEMZ_INS_STOCGP,
	SYSZ_INS_STOCGZ = SYSTEMZ_INS_STOCGZ,
	SYSZ_INS_STOSM = SYSTEMZ_INS_STOSM,
	SYSZ_INS_STPQ = SYSTEMZ_INS_STPQ,
	SYSZ_INS_STPT = SYSTEMZ_INS_STPT,
	SYSZ_INS_STPX = SYSTEMZ_INS_STPX,
	SYSZ_INS_STRAG = SYSTEMZ_INS_STRAG,
	SYSZ_INS_STRL = SYSTEMZ_INS_STRL,
	SYSZ_INS_STRV = SYSTEMZ_INS_STRV,
	SYSZ_INS_STRVG = SYSTEMZ_INS_STRVG,
	SYSZ_INS_STRVH = SYSTEMZ_INS_STRVH,
	SYSZ_INS_STSCH = SYSTEMZ_INS_STSCH,
	SYSZ_INS_STSI = SYSTEMZ_INS_STSI,
	SYSZ_INS_STURA = SYSTEMZ_INS_STURA,
	SYSZ_INS_STURG = SYSTEMZ_INS_STURG,
	SYSZ_INS_STY = SYSTEMZ_INS_STY,
	SYSZ_INS_SU = SYSTEMZ_INS_SU,
	SYSZ_INS_SUR = SYSTEMZ_INS_SUR,
	SYSZ_INS_SVC = SYSTEMZ_INS_SVC,
	SYSZ_INS_SW = SYSTEMZ_INS_SW,
	SYSZ_INS_SWR = SYSTEMZ_INS_SWR,
	SYSZ_INS_SXBR = SYSTEMZ_INS_SXBR,
	SYSZ_INS_SXR = SYSTEMZ_INS_SXR,
	SYSZ_INS_SXTR = SYSTEMZ_INS_SXTR,
	SYSZ_INS_SXTRA = SYSTEMZ_INS_SXTRA,
	SYSZ_INS_SY = SYSTEMZ_INS_SY,
	SYSZ_INS_TABORT = SYSTEMZ_INS_TABORT,
	SYSZ_INS_TAM = SYSTEMZ_INS_TAM,
	SYSZ_INS_TAR = SYSTEMZ_INS_TAR,
	SYSZ_INS_TB = SYSTEMZ_INS_TB,
	SYSZ_INS_TBDR = SYSTEMZ_INS_TBDR,
	SYSZ_INS_TBEDR = SYSTEMZ_INS_TBEDR,
	SYSZ_INS_TBEGIN = SYSTEMZ_INS_TBEGIN,
	SYSZ_INS_TBEGINC = SYSTEMZ_INS_TBEGINC,
	SYSZ_INS_TCDB = SYSTEMZ_INS_TCDB,
	SYSZ_INS_TCEB = SYSTEMZ_INS_TCEB,
	SYSZ_INS_TCXB = SYSTEMZ_INS_TCXB,
	SYSZ_INS_TDCDT = SYSTEMZ_INS_TDCDT,
	SYSZ_INS_TDCET = SYSTEMZ_INS_TDCET,
	SYSZ_INS_TDCXT = SYSTEMZ_INS_TDCXT,
	SYSZ_INS_TDGDT = SYSTEMZ_INS_TDGDT,
	SYSZ_INS_TDGET = SYSTEMZ_INS_TDGET,
	SYSZ_INS_TDGXT = SYSTEMZ_INS_TDGXT,
	SYSZ_INS_TEND = SYSTEMZ_INS_TEND,
	SYSZ_INS_THDER = SYSTEMZ_INS_THDER,
	SYSZ_INS_THDR = SYSTEMZ_INS_THDR,
	SYSZ_INS_TM = SYSTEMZ_INS_TM,
	SYSZ_INS_TMHH = SYSTEMZ_INS_TMHH,
	SYSZ_INS_TMHL = SYSTEMZ_INS_TMHL,
	SYSZ_INS_TMLH = SYSTEMZ_INS_TMLH,
	SYSZ_INS_TMLL = SYSTEMZ_INS_TMLL,
	SYSZ_INS_TMY = SYSTEMZ_INS_TMY,
	SYSZ_INS_TP = SYSTEMZ_INS_TP,
	SYSZ_INS_TPI = SYSTEMZ_INS_TPI,
	SYSZ_INS_TPROT = SYSTEMZ_INS_TPROT,
	SYSZ_INS_TR = SYSTEMZ_INS_TR,
	SYSZ_INS_TRACE = SYSTEMZ_INS_TRACE,
	SYSZ_INS_TRACG = SYSTEMZ_INS_TRACG,
	SYSZ_INS_TRAP2 = SYSTEMZ_INS_TRAP2,
	SYSZ_INS_TRAP4 = SYSTEMZ_INS_TRAP4,
	SYSZ_INS_TRE = SYSTEMZ_INS_TRE,
	SYSZ_INS_TROO = SYSTEMZ_INS_TROO,
	SYSZ_INS_TROT = SYSTEMZ_INS_TROT,
	SYSZ_INS_TRT = SYSTEMZ_INS_TRT,
	SYSZ_INS_TRTE = SYSTEMZ_INS_TRTE,
	SYSZ_INS_TRTO = SYSTEMZ_INS_TRTO,
	SYSZ_INS_TRTR = SYSTEMZ_INS_TRTR,
	SYSZ_INS_TRTRE = SYSTEMZ_INS_TRTRE,
	SYSZ_INS_TRTT = SYSTEMZ_INS_TRTT,
	SYSZ_INS_TS = SYSTEMZ_INS_TS,
	SYSZ_INS_TSCH = SYSTEMZ_INS_TSCH,
	SYSZ_INS_UNPK = SYSTEMZ_INS_UNPK,
	SYSZ_INS_UNPKA = SYSTEMZ_INS_UNPKA,
	SYSZ_INS_UNPKU = SYSTEMZ_INS_UNPKU,
	SYSZ_INS_UPT = SYSTEMZ_INS_UPT,
	SYSZ_INS_VA = SYSTEMZ_INS_VA,
	SYSZ_INS_VAB = SYSTEMZ_INS_VAB,
	SYSZ_INS_VAC = SYSTEMZ_INS_VAC,
	SYSZ_INS_VACC = SYSTEMZ_INS_VACC,
	SYSZ_INS_VACCB = SYSTEMZ_INS_VACCB,
	SYSZ_INS_VACCC = SYSTEMZ_INS_VACCC,
	SYSZ_INS_VACCCQ = SYSTEMZ_INS_VACCCQ,
	SYSZ_INS_VACCF = SYSTEMZ_INS_VACCF,
	SYSZ_INS_VACCG = SYSTEMZ_INS_VACCG,
	SYSZ_INS_VACCH = SYSTEMZ_INS_VACCH,
	SYSZ_INS_VACCQ = SYSTEMZ_INS_VACCQ,
	SYSZ_INS_VACQ = SYSTEMZ_INS_VACQ,
	SYSZ_INS_VAF = SYSTEMZ_INS_VAF,
	SYSZ_INS_VAG = SYSTEMZ_INS_VAG,
	SYSZ_INS_VAH = SYSTEMZ_INS_VAH,
	SYSZ_INS_VAP = SYSTEMZ_INS_VAP,
	SYSZ_INS_VAQ = SYSTEMZ_INS_VAQ,
	SYSZ_INS_VAVG = SYSTEMZ_INS_VAVG,
	SYSZ_INS_VAVGB = SYSTEMZ_INS_VAVGB,
	SYSZ_INS_VAVGF = SYSTEMZ_INS_VAVGF,
	SYSZ_INS_VAVGG = SYSTEMZ_INS_VAVGG,
	SYSZ_INS_VAVGH = SYSTEMZ_INS_VAVGH,
	SYSZ_INS_VAVGL = SYSTEMZ_INS_VAVGL,
	SYSZ_INS_VAVGLB = SYSTEMZ_INS_VAVGLB,
	SYSZ_INS_VAVGLF = SYSTEMZ_INS_VAVGLF,
	SYSZ_INS_VAVGLG = SYSTEMZ_INS_VAVGLG,
	SYSZ_INS_VAVGLH = SYSTEMZ_INS_VAVGLH,
	SYSZ_INS_VBPERM = SYSTEMZ_INS_VBPERM,
	SYSZ_INS_VCDG = SYSTEMZ_INS_VCDG,
	SYSZ_INS_VCDGB = SYSTEMZ_INS_VCDGB,
	SYSZ_INS_VCDLG = SYSTEMZ_INS_VCDLG,
	SYSZ_INS_VCDLGB = SYSTEMZ_INS_VCDLGB,
	SYSZ_INS_VCEFB = SYSTEMZ_INS_VCEFB,
	SYSZ_INS_VCELFB = SYSTEMZ_INS_VCELFB,
	SYSZ_INS_VCEQ = SYSTEMZ_INS_VCEQ,
	SYSZ_INS_VCEQB = SYSTEMZ_INS_VCEQB,
	SYSZ_INS_VCEQBS = SYSTEMZ_INS_VCEQBS,
	SYSZ_INS_VCEQF = SYSTEMZ_INS_VCEQF,
	SYSZ_INS_VCEQFS = SYSTEMZ_INS_VCEQFS,
	SYSZ_INS_VCEQG = SYSTEMZ_INS_VCEQG,
	SYSZ_INS_VCEQGS = SYSTEMZ_INS_VCEQGS,
	SYSZ_INS_VCEQH = SYSTEMZ_INS_VCEQH,
	SYSZ_INS_VCEQHS = SYSTEMZ_INS_VCEQHS,
	SYSZ_INS_VCFEB = SYSTEMZ_INS_VCFEB,
	SYSZ_INS_VCFN = SYSTEMZ_INS_VCFN,
	SYSZ_INS_VCFPL = SYSTEMZ_INS_VCFPL,
	SYSZ_INS_VCFPS = SYSTEMZ_INS_VCFPS,
	SYSZ_INS_VCGD = SYSTEMZ_INS_VCGD,
	SYSZ_INS_VCGDB = SYSTEMZ_INS_VCGDB,
	SYSZ_INS_VCH = SYSTEMZ_INS_VCH,
	SYSZ_INS_VCHB = SYSTEMZ_INS_VCHB,
	SYSZ_INS_VCHBS = SYSTEMZ_INS_VCHBS,
	SYSZ_INS_VCHF = SYSTEMZ_INS_VCHF,
	SYSZ_INS_VCHFS = SYSTEMZ_INS_VCHFS,
	SYSZ_INS_VCHG = SYSTEMZ_INS_VCHG,
	SYSZ_INS_VCHGS = SYSTEMZ_INS_VCHGS,
	SYSZ_INS_VCHH = SYSTEMZ_INS_VCHH,
	SYSZ_INS_VCHHS = SYSTEMZ_INS_VCHHS,
	SYSZ_INS_VCHL = SYSTEMZ_INS_VCHL,
	SYSZ_INS_VCHLB = SYSTEMZ_INS_VCHLB,
	SYSZ_INS_VCHLBS = SYSTEMZ_INS_VCHLBS,
	SYSZ_INS_VCHLF = SYSTEMZ_INS_VCHLF,
	SYSZ_INS_VCHLFS = SYSTEMZ_INS_VCHLFS,
	SYSZ_INS_VCHLG = SYSTEMZ_INS_VCHLG,
	SYSZ_INS_VCHLGS = SYSTEMZ_INS_VCHLGS,
	SYSZ_INS_VCHLH = SYSTEMZ_INS_VCHLH,
	SYSZ_INS_VCHLHS = SYSTEMZ_INS_VCHLHS,
	SYSZ_INS_VCKSM = SYSTEMZ_INS_VCKSM,
	SYSZ_INS_VCLFEB = SYSTEMZ_INS_VCLFEB,
	SYSZ_INS_VCLFNH = SYSTEMZ_INS_VCLFNH,
	SYSZ_INS_VCLFNL = SYSTEMZ_INS_VCLFNL,
	SYSZ_INS_VCLFP = SYSTEMZ_INS_VCLFP,
	SYSZ_INS_VCLGD = SYSTEMZ_INS_VCLGD,
	SYSZ_INS_VCLGDB = SYSTEMZ_INS_VCLGDB,
	SYSZ_INS_VCLZ = SYSTEMZ_INS_VCLZ,
	SYSZ_INS_VCLZB = SYSTEMZ_INS_VCLZB,
	SYSZ_INS_VCLZDP = SYSTEMZ_INS_VCLZDP,
	SYSZ_INS_VCLZF = SYSTEMZ_INS_VCLZF,
	SYSZ_INS_VCLZG = SYSTEMZ_INS_VCLZG,
	SYSZ_INS_VCLZH = SYSTEMZ_INS_VCLZH,
	SYSZ_INS_VCNF = SYSTEMZ_INS_VCNF,
	SYSZ_INS_VCP = SYSTEMZ_INS_VCP,
	SYSZ_INS_VCRNF = SYSTEMZ_INS_VCRNF,
	SYSZ_INS_VCSFP = SYSTEMZ_INS_VCSFP,
	SYSZ_INS_VCSPH = SYSTEMZ_INS_VCSPH,
	SYSZ_INS_VCTZ = SYSTEMZ_INS_VCTZ,
	SYSZ_INS_VCTZB = SYSTEMZ_INS_VCTZB,
	SYSZ_INS_VCTZF = SYSTEMZ_INS_VCTZF,
	SYSZ_INS_VCTZG = SYSTEMZ_INS_VCTZG,
	SYSZ_INS_VCTZH = SYSTEMZ_INS_VCTZH,
	SYSZ_INS_VCVB = SYSTEMZ_INS_VCVB,
	SYSZ_INS_VCVBG = SYSTEMZ_INS_VCVBG,
	SYSZ_INS_VCVD = SYSTEMZ_INS_VCVD,
	SYSZ_INS_VCVDG = SYSTEMZ_INS_VCVDG,
	SYSZ_INS_VDP = SYSTEMZ_INS_VDP,
	SYSZ_INS_VEC = SYSTEMZ_INS_VEC,
	SYSZ_INS_VECB = SYSTEMZ_INS_VECB,
	SYSZ_INS_VECF = SYSTEMZ_INS_VECF,
	SYSZ_INS_VECG = SYSTEMZ_INS_VECG,
	SYSZ_INS_VECH = SYSTEMZ_INS_VECH,
	SYSZ_INS_VECL = SYSTEMZ_INS_VECL,
	SYSZ_INS_VECLB = SYSTEMZ_INS_VECLB,
	SYSZ_INS_VECLF = SYSTEMZ_INS_VECLF,
	SYSZ_INS_VECLG = SYSTEMZ_INS_VECLG,
	SYSZ_INS_VECLH = SYSTEMZ_INS_VECLH,
	SYSZ_INS_VERIM = SYSTEMZ_INS_VERIM,
	SYSZ_INS_VERIMB = SYSTEMZ_INS_VERIMB,
	SYSZ_INS_VERIMF = SYSTEMZ_INS_VERIMF,
	SYSZ_INS_VERIMG = SYSTEMZ_INS_VERIMG,
	SYSZ_INS_VERIMH = SYSTEMZ_INS_VERIMH,
	SYSZ_INS_VERLL = SYSTEMZ_INS_VERLL,
	SYSZ_INS_VERLLB = SYSTEMZ_INS_VERLLB,
	SYSZ_INS_VERLLF = SYSTEMZ_INS_VERLLF,
	SYSZ_INS_VERLLG = SYSTEMZ_INS_VERLLG,
	SYSZ_INS_VERLLH = SYSTEMZ_INS_VERLLH,
	SYSZ_INS_VERLLV = SYSTEMZ_INS_VERLLV,
	SYSZ_INS_VERLLVB = SYSTEMZ_INS_VERLLVB,
	SYSZ_INS_VERLLVF = SYSTEMZ_INS_VERLLVF,
	SYSZ_INS_VERLLVG = SYSTEMZ_INS_VERLLVG,
	SYSZ_INS_VERLLVH = SYSTEMZ_INS_VERLLVH,
	SYSZ_INS_VESL = SYSTEMZ_INS_VESL,
	SYSZ_INS_VESLB = SYSTEMZ_INS_VESLB,
	SYSZ_INS_VESLF = SYSTEMZ_INS_VESLF,
	SYSZ_INS_VESLG = SYSTEMZ_INS_VESLG,
	SYSZ_INS_VESLH = SYSTEMZ_INS_VESLH,
	SYSZ_INS_VESLV = SYSTEMZ_INS_VESLV,
	SYSZ_INS_VESLVB = SYSTEMZ_INS_VESLVB,
	SYSZ_INS_VESLVF = SYSTEMZ_INS_VESLVF,
	SYSZ_INS_VESLVG = SYSTEMZ_INS_VESLVG,
	SYSZ_INS_VESLVH = SYSTEMZ_INS_VESLVH,
	SYSZ_INS_VESRA = SYSTEMZ_INS_VESRA,
	SYSZ_INS_VESRAB = SYSTEMZ_INS_VESRAB,
	SYSZ_INS_VESRAF = SYSTEMZ_INS_VESRAF,
	SYSZ_INS_VESRAG = SYSTEMZ_INS_VESRAG,
	SYSZ_INS_VESRAH = SYSTEMZ_INS_VESRAH,
	SYSZ_INS_VESRAV = SYSTEMZ_INS_VESRAV,
	SYSZ_INS_VESRAVB = SYSTEMZ_INS_VESRAVB,
	SYSZ_INS_VESRAVF = SYSTEMZ_INS_VESRAVF,
	SYSZ_INS_VESRAVG = SYSTEMZ_INS_VESRAVG,
	SYSZ_INS_VESRAVH = SYSTEMZ_INS_VESRAVH,
	SYSZ_INS_VESRL = SYSTEMZ_INS_VESRL,
	SYSZ_INS_VESRLB = SYSTEMZ_INS_VESRLB,
	SYSZ_INS_VESRLF = SYSTEMZ_INS_VESRLF,
	SYSZ_INS_VESRLG = SYSTEMZ_INS_VESRLG,
	SYSZ_INS_VESRLH = SYSTEMZ_INS_VESRLH,
	SYSZ_INS_VESRLV = SYSTEMZ_INS_VESRLV,
	SYSZ_INS_VESRLVB = SYSTEMZ_INS_VESRLVB,
	SYSZ_INS_VESRLVF = SYSTEMZ_INS_VESRLVF,
	SYSZ_INS_VESRLVG = SYSTEMZ_INS_VESRLVG,
	SYSZ_INS_VESRLVH = SYSTEMZ_INS_VESRLVH,
	SYSZ_INS_VFA = SYSTEMZ_INS_VFA,
	SYSZ_INS_VFADB = SYSTEMZ_INS_VFADB,
	SYSZ_INS_VFAE = SYSTEMZ_INS_VFAE,
	SYSZ_INS_VFAEB = SYSTEMZ_INS_VFAEB,
	SYSZ_INS_VFAEBS = SYSTEMZ_INS_VFAEBS,
	SYSZ_INS_VFAEF = SYSTEMZ_INS_VFAEF,
	SYSZ_INS_VFAEFS = SYSTEMZ_INS_VFAEFS,
	SYSZ_INS_VFAEH = SYSTEMZ_INS_VFAEH,
	SYSZ_INS_VFAEHS = SYSTEMZ_INS_VFAEHS,
	SYSZ_INS_VFAEZB = SYSTEMZ_INS_VFAEZB,
	SYSZ_INS_VFAEZBS = SYSTEMZ_INS_VFAEZBS,
	SYSZ_INS_VFAEZF = SYSTEMZ_INS_VFAEZF,
	SYSZ_INS_VFAEZFS = SYSTEMZ_INS_VFAEZFS,
	SYSZ_INS_VFAEZH = SYSTEMZ_INS_VFAEZH,
	SYSZ_INS_VFAEZHS = SYSTEMZ_INS_VFAEZHS,
	SYSZ_INS_VFASB = SYSTEMZ_INS_VFASB,
	SYSZ_INS_VFCE = SYSTEMZ_INS_VFCE,
	SYSZ_INS_VFCEDB = SYSTEMZ_INS_VFCEDB,
	SYSZ_INS_VFCEDBS = SYSTEMZ_INS_VFCEDBS,
	SYSZ_INS_VFCESB = SYSTEMZ_INS_VFCESB,
	SYSZ_INS_VFCESBS = SYSTEMZ_INS_VFCESBS,
	SYSZ_INS_VFCH = SYSTEMZ_INS_VFCH,
	SYSZ_INS_VFCHDB = SYSTEMZ_INS_VFCHDB,
	SYSZ_INS_VFCHDBS = SYSTEMZ_INS_VFCHDBS,
	SYSZ_INS_VFCHE = SYSTEMZ_INS_VFCHE,
	SYSZ_INS_VFCHEDB = SYSTEMZ_INS_VFCHEDB,
	SYSZ_INS_VFCHEDBS = SYSTEMZ_INS_VFCHEDBS,
	SYSZ_INS_VFCHESB = SYSTEMZ_INS_VFCHESB,
	SYSZ_INS_VFCHESBS = SYSTEMZ_INS_VFCHESBS,
	SYSZ_INS_VFCHSB = SYSTEMZ_INS_VFCHSB,
	SYSZ_INS_VFCHSBS = SYSTEMZ_INS_VFCHSBS,
	SYSZ_INS_VFD = SYSTEMZ_INS_VFD,
	SYSZ_INS_VFDDB = SYSTEMZ_INS_VFDDB,
	SYSZ_INS_VFDSB = SYSTEMZ_INS_VFDSB,
	SYSZ_INS_VFEE = SYSTEMZ_INS_VFEE,
	SYSZ_INS_VFEEB = SYSTEMZ_INS_VFEEB,
	SYSZ_INS_VFEEBS = SYSTEMZ_INS_VFEEBS,
	SYSZ_INS_VFEEF = SYSTEMZ_INS_VFEEF,
	SYSZ_INS_VFEEFS = SYSTEMZ_INS_VFEEFS,
	SYSZ_INS_VFEEH = SYSTEMZ_INS_VFEEH,
	SYSZ_INS_VFEEHS = SYSTEMZ_INS_VFEEHS,
	SYSZ_INS_VFEEZB = SYSTEMZ_INS_VFEEZB,
	SYSZ_INS_VFEEZBS = SYSTEMZ_INS_VFEEZBS,
	SYSZ_INS_VFEEZF = SYSTEMZ_INS_VFEEZF,
	SYSZ_INS_VFEEZFS = SYSTEMZ_INS_VFEEZFS,
	SYSZ_INS_VFEEZH = SYSTEMZ_INS_VFEEZH,
	SYSZ_INS_VFEEZHS = SYSTEMZ_INS_VFEEZHS,
	SYSZ_INS_VFENE = SYSTEMZ_INS_VFENE,
	SYSZ_INS_VFENEB = SYSTEMZ_INS_VFENEB,
	SYSZ_INS_VFENEBS = SYSTEMZ_INS_VFENEBS,
	SYSZ_INS_VFENEF = SYSTEMZ_INS_VFENEF,
	SYSZ_INS_VFENEFS = SYSTEMZ_INS_VFENEFS,
	SYSZ_INS_VFENEH = SYSTEMZ_INS_VFENEH,
	SYSZ_INS_VFENEHS = SYSTEMZ_INS_VFENEHS,
	SYSZ_INS_VFENEZB = SYSTEMZ_INS_VFENEZB,
	SYSZ_INS_VFENEZBS = SYSTEMZ_INS_VFENEZBS,
	SYSZ_INS_VFENEZF = SYSTEMZ_INS_VFENEZF,
	SYSZ_INS_VFENEZFS = SYSTEMZ_INS_VFENEZFS,
	SYSZ_INS_VFENEZH = SYSTEMZ_INS_VFENEZH,
	SYSZ_INS_VFENEZHS = SYSTEMZ_INS_VFENEZHS,
	SYSZ_INS_VFI = SYSTEMZ_INS_VFI,
	SYSZ_INS_VFIDB = SYSTEMZ_INS_VFIDB,
	SYSZ_INS_VFISB = SYSTEMZ_INS_VFISB,
	SYSZ_INS_VFKEDB = SYSTEMZ_INS_VFKEDB,
	SYSZ_INS_VFKEDBS = SYSTEMZ_INS_VFKEDBS,
	SYSZ_INS_VFKESB = SYSTEMZ_INS_VFKESB,
	SYSZ_INS_VFKESBS = SYSTEMZ_INS_VFKESBS,
	SYSZ_INS_VFKHDB = SYSTEMZ_INS_VFKHDB,
	SYSZ_INS_VFKHDBS = SYSTEMZ_INS_VFKHDBS,
	SYSZ_INS_VFKHEDB = SYSTEMZ_INS_VFKHEDB,
	SYSZ_INS_VFKHEDBS = SYSTEMZ_INS_VFKHEDBS,
	SYSZ_INS_VFKHESB = SYSTEMZ_INS_VFKHESB,
	SYSZ_INS_VFKHESBS = SYSTEMZ_INS_VFKHESBS,
	SYSZ_INS_VFKHSB = SYSTEMZ_INS_VFKHSB,
	SYSZ_INS_VFKHSBS = SYSTEMZ_INS_VFKHSBS,
	SYSZ_INS_VFLCDB = SYSTEMZ_INS_VFLCDB,
	SYSZ_INS_VFLCSB = SYSTEMZ_INS_VFLCSB,
	SYSZ_INS_VFLL = SYSTEMZ_INS_VFLL,
	SYSZ_INS_VFLLS = SYSTEMZ_INS_VFLLS,
	SYSZ_INS_VFLNDB = SYSTEMZ_INS_VFLNDB,
	SYSZ_INS_VFLNSB = SYSTEMZ_INS_VFLNSB,
	SYSZ_INS_VFLPDB = SYSTEMZ_INS_VFLPDB,
	SYSZ_INS_VFLPSB = SYSTEMZ_INS_VFLPSB,
	SYSZ_INS_VFLR = SYSTEMZ_INS_VFLR,
	SYSZ_INS_VFLRD = SYSTEMZ_INS_VFLRD,
	SYSZ_INS_VFM = SYSTEMZ_INS_VFM,
	SYSZ_INS_VFMA = SYSTEMZ_INS_VFMA,
	SYSZ_INS_VFMADB = SYSTEMZ_INS_VFMADB,
	SYSZ_INS_VFMASB = SYSTEMZ_INS_VFMASB,
	SYSZ_INS_VFMAX = SYSTEMZ_INS_VFMAX,
	SYSZ_INS_VFMAXDB = SYSTEMZ_INS_VFMAXDB,
	SYSZ_INS_VFMAXSB = SYSTEMZ_INS_VFMAXSB,
	SYSZ_INS_VFMDB = SYSTEMZ_INS_VFMDB,
	SYSZ_INS_VFMIN = SYSTEMZ_INS_VFMIN,
	SYSZ_INS_VFMINDB = SYSTEMZ_INS_VFMINDB,
	SYSZ_INS_VFMINSB = SYSTEMZ_INS_VFMINSB,
	SYSZ_INS_VFMS = SYSTEMZ_INS_VFMS,
	SYSZ_INS_VFMSB = SYSTEMZ_INS_VFMSB,
	SYSZ_INS_VFMSDB = SYSTEMZ_INS_VFMSDB,
	SYSZ_INS_VFMSSB = SYSTEMZ_INS_VFMSSB,
	SYSZ_INS_VFNMA = SYSTEMZ_INS_VFNMA,
	SYSZ_INS_VFNMADB = SYSTEMZ_INS_VFNMADB,
	SYSZ_INS_VFNMASB = SYSTEMZ_INS_VFNMASB,
	SYSZ_INS_VFNMS = SYSTEMZ_INS_VFNMS,
	SYSZ_INS_VFNMSDB = SYSTEMZ_INS_VFNMSDB,
	SYSZ_INS_VFNMSSB = SYSTEMZ_INS_VFNMSSB,
	SYSZ_INS_VFPSO = SYSTEMZ_INS_VFPSO,
	SYSZ_INS_VFPSODB = SYSTEMZ_INS_VFPSODB,
	SYSZ_INS_VFPSOSB = SYSTEMZ_INS_VFPSOSB,
	SYSZ_INS_VFS = SYSTEMZ_INS_VFS,
	SYSZ_INS_VFSDB = SYSTEMZ_INS_VFSDB,
	SYSZ_INS_VFSQ = SYSTEMZ_INS_VFSQ,
	SYSZ_INS_VFSQDB = SYSTEMZ_INS_VFSQDB,
	SYSZ_INS_VFSQSB = SYSTEMZ_INS_VFSQSB,
	SYSZ_INS_VFSSB = SYSTEMZ_INS_VFSSB,
	SYSZ_INS_VFTCI = SYSTEMZ_INS_VFTCI,
	SYSZ_INS_VFTCIDB = SYSTEMZ_INS_VFTCIDB,
	SYSZ_INS_VFTCISB = SYSTEMZ_INS_VFTCISB,
	SYSZ_INS_VGBM = SYSTEMZ_INS_VGBM,
	SYSZ_INS_VGEF = SYSTEMZ_INS_VGEF,
	SYSZ_INS_VGEG = SYSTEMZ_INS_VGEG,
	SYSZ_INS_VGFM = SYSTEMZ_INS_VGFM,
	SYSZ_INS_VGFMA = SYSTEMZ_INS_VGFMA,
	SYSZ_INS_VGFMAB = SYSTEMZ_INS_VGFMAB,
	SYSZ_INS_VGFMAF = SYSTEMZ_INS_VGFMAF,
	SYSZ_INS_VGFMAG = SYSTEMZ_INS_VGFMAG,
	SYSZ_INS_VGFMAH = SYSTEMZ_INS_VGFMAH,
	SYSZ_INS_VGFMB = SYSTEMZ_INS_VGFMB,
	SYSZ_INS_VGFMF = SYSTEMZ_INS_VGFMF,
	SYSZ_INS_VGFMG = SYSTEMZ_INS_VGFMG,
	SYSZ_INS_VGFMH = SYSTEMZ_INS_VGFMH,
	SYSZ_INS_VGM = SYSTEMZ_INS_VGM,
	SYSZ_INS_VGMB = SYSTEMZ_INS_VGMB,
	SYSZ_INS_VGMF = SYSTEMZ_INS_VGMF,
	SYSZ_INS_VGMG = SYSTEMZ_INS_VGMG,
	SYSZ_INS_VGMH = SYSTEMZ_INS_VGMH,
	SYSZ_INS_VISTR = SYSTEMZ_INS_VISTR,
	SYSZ_INS_VISTRB = SYSTEMZ_INS_VISTRB,
	SYSZ_INS_VISTRBS = SYSTEMZ_INS_VISTRBS,
	SYSZ_INS_VISTRF = SYSTEMZ_INS_VISTRF,
	SYSZ_INS_VISTRFS = SYSTEMZ_INS_VISTRFS,
	SYSZ_INS_VISTRH = SYSTEMZ_INS_VISTRH,
	SYSZ_INS_VISTRHS = SYSTEMZ_INS_VISTRHS,
	SYSZ_INS_VL = SYSTEMZ_INS_VL,
	SYSZ_INS_VLBB = SYSTEMZ_INS_VLBB,
	SYSZ_INS_VLBR = SYSTEMZ_INS_VLBR,
	SYSZ_INS_VLBRF = SYSTEMZ_INS_VLBRF,
	SYSZ_INS_VLBRG = SYSTEMZ_INS_VLBRG,
	SYSZ_INS_VLBRH = SYSTEMZ_INS_VLBRH,
	SYSZ_INS_VLBRQ = SYSTEMZ_INS_VLBRQ,
	SYSZ_INS_VLBRREP = SYSTEMZ_INS_VLBRREP,
	SYSZ_INS_VLBRREPF = SYSTEMZ_INS_VLBRREPF,
	SYSZ_INS_VLBRREPG = SYSTEMZ_INS_VLBRREPG,
	SYSZ_INS_VLBRREPH = SYSTEMZ_INS_VLBRREPH,
	SYSZ_INS_VLC = SYSTEMZ_INS_VLC,
	SYSZ_INS_VLCB = SYSTEMZ_INS_VLCB,
	SYSZ_INS_VLCF = SYSTEMZ_INS_VLCF,
	SYSZ_INS_VLCG = SYSTEMZ_INS_VLCG,
	SYSZ_INS_VLCH = SYSTEMZ_INS_VLCH,
	SYSZ_INS_VLDE = SYSTEMZ_INS_VLDE,
	SYSZ_INS_VLDEB = SYSTEMZ_INS_VLDEB,
	SYSZ_INS_VLEB = SYSTEMZ_INS_VLEB,
	SYSZ_INS_VLEBRF = SYSTEMZ_INS_VLEBRF,
	SYSZ_INS_VLEBRG = SYSTEMZ_INS_VLEBRG,
	SYSZ_INS_VLEBRH = SYSTEMZ_INS_VLEBRH,
	SYSZ_INS_VLED = SYSTEMZ_INS_VLED,
	SYSZ_INS_VLEDB = SYSTEMZ_INS_VLEDB,
	SYSZ_INS_VLEF = SYSTEMZ_INS_VLEF,
	SYSZ_INS_VLEG = SYSTEMZ_INS_VLEG,
	SYSZ_INS_VLEH = SYSTEMZ_INS_VLEH,
	SYSZ_INS_VLEIB = SYSTEMZ_INS_VLEIB,
	SYSZ_INS_VLEIF = SYSTEMZ_INS_VLEIF,
	SYSZ_INS_VLEIG = SYSTEMZ_INS_VLEIG,
	SYSZ_INS_VLEIH = SYSTEMZ_INS_VLEIH,
	SYSZ_INS_VLER = SYSTEMZ_INS_VLER,
	SYSZ_INS_VLERF = SYSTEMZ_INS_VLERF,
	SYSZ_INS_VLERG = SYSTEMZ_INS_VLERG,
	SYSZ_INS_VLERH = SYSTEMZ_INS_VLERH,
	SYSZ_INS_VLGV = SYSTEMZ_INS_VLGV,
	SYSZ_INS_VLGVB = SYSTEMZ_INS_VLGVB,
	SYSZ_INS_VLGVF = SYSTEMZ_INS_VLGVF,
	SYSZ_INS_VLGVG = SYSTEMZ_INS_VLGVG,
	SYSZ_INS_VLGVH = SYSTEMZ_INS_VLGVH,
	SYSZ_INS_VLIP = SYSTEMZ_INS_VLIP,
	SYSZ_INS_VLL = SYSTEMZ_INS_VLL,
	SYSZ_INS_VLLEBRZ = SYSTEMZ_INS_VLLEBRZ,
	SYSZ_INS_VLLEBRZE = SYSTEMZ_INS_VLLEBRZE,
	SYSZ_INS_VLLEBRZF = SYSTEMZ_INS_VLLEBRZF,
	SYSZ_INS_VLLEBRZG = SYSTEMZ_INS_VLLEBRZG,
	SYSZ_INS_VLLEBRZH = SYSTEMZ_INS_VLLEBRZH,
	SYSZ_INS_VLLEZ = SYSTEMZ_INS_VLLEZ,
	SYSZ_INS_VLLEZB = SYSTEMZ_INS_VLLEZB,
	SYSZ_INS_VLLEZF = SYSTEMZ_INS_VLLEZF,
	SYSZ_INS_VLLEZG = SYSTEMZ_INS_VLLEZG,
	SYSZ_INS_VLLEZH = SYSTEMZ_INS_VLLEZH,
	SYSZ_INS_VLLEZLF = SYSTEMZ_INS_VLLEZLF,
	SYSZ_INS_VLM = SYSTEMZ_INS_VLM,
	SYSZ_INS_VLP = SYSTEMZ_INS_VLP,
	SYSZ_INS_VLPB = SYSTEMZ_INS_VLPB,
	SYSZ_INS_VLPF = SYSTEMZ_INS_VLPF,
	SYSZ_INS_VLPG = SYSTEMZ_INS_VLPG,
	SYSZ_INS_VLPH = SYSTEMZ_INS_VLPH,
	SYSZ_INS_VLR = SYSTEMZ_INS_VLR,
	SYSZ_INS_VLREP = SYSTEMZ_INS_VLREP,
	SYSZ_INS_VLREPB = SYSTEMZ_INS_VLREPB,
	SYSZ_INS_VLREPF = SYSTEMZ_INS_VLREPF,
	SYSZ_INS_VLREPG = SYSTEMZ_INS_VLREPG,
	SYSZ_INS_VLREPH = SYSTEMZ_INS_VLREPH,
	SYSZ_INS_VLRL = SYSTEMZ_INS_VLRL,
	SYSZ_INS_VLRLR = SYSTEMZ_INS_VLRLR,
	SYSZ_INS_VLVG = SYSTEMZ_INS_VLVG,
	SYSZ_INS_VLVGB = SYSTEMZ_INS_VLVGB,
	SYSZ_INS_VLVGF = SYSTEMZ_INS_VLVGF,
	SYSZ_INS_VLVGG = SYSTEMZ_INS_VLVGG,
	SYSZ_INS_VLVGH = SYSTEMZ_INS_VLVGH,
	SYSZ_INS_VLVGP = SYSTEMZ_INS_VLVGP,
	SYSZ_INS_VMAE = SYSTEMZ_INS_VMAE,
	SYSZ_INS_VMAEB = SYSTEMZ_INS_VMAEB,
	SYSZ_INS_VMAEF = SYSTEMZ_INS_VMAEF,
	SYSZ_INS_VMAEH = SYSTEMZ_INS_VMAEH,
	SYSZ_INS_VMAH = SYSTEMZ_INS_VMAH,
	SYSZ_INS_VMAHB = SYSTEMZ_INS_VMAHB,
	SYSZ_INS_VMAHF = SYSTEMZ_INS_VMAHF,
	SYSZ_INS_VMAHH = SYSTEMZ_INS_VMAHH,
	SYSZ_INS_VMAL = SYSTEMZ_INS_VMAL,
	SYSZ_INS_VMALB = SYSTEMZ_INS_VMALB,
	SYSZ_INS_VMALE = SYSTEMZ_INS_VMALE,
	SYSZ_INS_VMALEB = SYSTEMZ_INS_VMALEB,
	SYSZ_INS_VMALEF = SYSTEMZ_INS_VMALEF,
	SYSZ_INS_VMALEH = SYSTEMZ_INS_VMALEH,
	SYSZ_INS_VMALF = SYSTEMZ_INS_VMALF,
	SYSZ_INS_VMALH = SYSTEMZ_INS_VMALH,
	SYSZ_INS_VMALHB = SYSTEMZ_INS_VMALHB,
	SYSZ_INS_VMALHF = SYSTEMZ_INS_VMALHF,
	SYSZ_INS_VMALHH = SYSTEMZ_INS_VMALHH,
	SYSZ_INS_VMALHW = SYSTEMZ_INS_VMALHW,
	SYSZ_INS_VMALO = SYSTEMZ_INS_VMALO,
	SYSZ_INS_VMALOB = SYSTEMZ_INS_VMALOB,
	SYSZ_INS_VMALOF = SYSTEMZ_INS_VMALOF,
	SYSZ_INS_VMALOH = SYSTEMZ_INS_VMALOH,
	SYSZ_INS_VMAO = SYSTEMZ_INS_VMAO,
	SYSZ_INS_VMAOB = SYSTEMZ_INS_VMAOB,
	SYSZ_INS_VMAOF = SYSTEMZ_INS_VMAOF,
	SYSZ_INS_VMAOH = SYSTEMZ_INS_VMAOH,
	SYSZ_INS_VME = SYSTEMZ_INS_VME,
	SYSZ_INS_VMEB = SYSTEMZ_INS_VMEB,
	SYSZ_INS_VMEF = SYSTEMZ_INS_VMEF,
	SYSZ_INS_VMEH = SYSTEMZ_INS_VMEH,
	SYSZ_INS_VMH = SYSTEMZ_INS_VMH,
	SYSZ_INS_VMHB = SYSTEMZ_INS_VMHB,
	SYSZ_INS_VMHF = SYSTEMZ_INS_VMHF,
	SYSZ_INS_VMHH = SYSTEMZ_INS_VMHH,
	SYSZ_INS_VML = SYSTEMZ_INS_VML,
	SYSZ_INS_VMLB = SYSTEMZ_INS_VMLB,
	SYSZ_INS_VMLE = SYSTEMZ_INS_VMLE,
	SYSZ_INS_VMLEB = SYSTEMZ_INS_VMLEB,
	SYSZ_INS_VMLEF = SYSTEMZ_INS_VMLEF,
	SYSZ_INS_VMLEH = SYSTEMZ_INS_VMLEH,
	SYSZ_INS_VMLF = SYSTEMZ_INS_VMLF,
	SYSZ_INS_VMLH = SYSTEMZ_INS_VMLH,
	SYSZ_INS_VMLHB = SYSTEMZ_INS_VMLHB,
	SYSZ_INS_VMLHF = SYSTEMZ_INS_VMLHF,
	SYSZ_INS_VMLHH = SYSTEMZ_INS_VMLHH,
	SYSZ_INS_VMLHW = SYSTEMZ_INS_VMLHW,
	SYSZ_INS_VMLO = SYSTEMZ_INS_VMLO,
	SYSZ_INS_VMLOB = SYSTEMZ_INS_VMLOB,
	SYSZ_INS_VMLOF = SYSTEMZ_INS_VMLOF,
	SYSZ_INS_VMLOH = SYSTEMZ_INS_VMLOH,
	SYSZ_INS_VMN = SYSTEMZ_INS_VMN,
	SYSZ_INS_VMNB = SYSTEMZ_INS_VMNB,
	SYSZ_INS_VMNF = SYSTEMZ_INS_VMNF,
	SYSZ_INS_VMNG = SYSTEMZ_INS_VMNG,
	SYSZ_INS_VMNH = SYSTEMZ_INS_VMNH,
	SYSZ_INS_VMNL = SYSTEMZ_INS_VMNL,
	SYSZ_INS_VMNLB = SYSTEMZ_INS_VMNLB,
	SYSZ_INS_VMNLF = SYSTEMZ_INS_VMNLF,
	SYSZ_INS_VMNLG = SYSTEMZ_INS_VMNLG,
	SYSZ_INS_VMNLH = SYSTEMZ_INS_VMNLH,
	SYSZ_INS_VMO = SYSTEMZ_INS_VMO,
	SYSZ_INS_VMOB = SYSTEMZ_INS_VMOB,
	SYSZ_INS_VMOF = SYSTEMZ_INS_VMOF,
	SYSZ_INS_VMOH = SYSTEMZ_INS_VMOH,
	SYSZ_INS_VMP = SYSTEMZ_INS_VMP,
	SYSZ_INS_VMRH = SYSTEMZ_INS_VMRH,
	SYSZ_INS_VMRHB = SYSTEMZ_INS_VMRHB,
	SYSZ_INS_VMRHF = SYSTEMZ_INS_VMRHF,
	SYSZ_INS_VMRHG = SYSTEMZ_INS_VMRHG,
	SYSZ_INS_VMRHH = SYSTEMZ_INS_VMRHH,
	SYSZ_INS_VMRL = SYSTEMZ_INS_VMRL,
	SYSZ_INS_VMRLB = SYSTEMZ_INS_VMRLB,
	SYSZ_INS_VMRLF = SYSTEMZ_INS_VMRLF,
	SYSZ_INS_VMRLG = SYSTEMZ_INS_VMRLG,
	SYSZ_INS_VMRLH = SYSTEMZ_INS_VMRLH,
	SYSZ_INS_VMSL = SYSTEMZ_INS_VMSL,
	SYSZ_INS_VMSLG = SYSTEMZ_INS_VMSLG,
	SYSZ_INS_VMSP = SYSTEMZ_INS_VMSP,
	SYSZ_INS_VMX = SYSTEMZ_INS_VMX,
	SYSZ_INS_VMXB = SYSTEMZ_INS_VMXB,
	SYSZ_INS_VMXF = SYSTEMZ_INS_VMXF,
	SYSZ_INS_VMXG = SYSTEMZ_INS_VMXG,
	SYSZ_INS_VMXH = SYSTEMZ_INS_VMXH,
	SYSZ_INS_VMXL = SYSTEMZ_INS_VMXL,
	SYSZ_INS_VMXLB = SYSTEMZ_INS_VMXLB,
	SYSZ_INS_VMXLF = SYSTEMZ_INS_VMXLF,
	SYSZ_INS_VMXLG = SYSTEMZ_INS_VMXLG,
	SYSZ_INS_VMXLH = SYSTEMZ_INS_VMXLH,
	SYSZ_INS_VN = SYSTEMZ_INS_VN,
	SYSZ_INS_VNC = SYSTEMZ_INS_VNC,
	SYSZ_INS_VNN = SYSTEMZ_INS_VNN,
	SYSZ_INS_VNO = SYSTEMZ_INS_VNO,
	SYSZ_INS_VNX = SYSTEMZ_INS_VNX,
	SYSZ_INS_VO = SYSTEMZ_INS_VO,
	SYSZ_INS_VOC = SYSTEMZ_INS_VOC,
	SYSZ_INS_VONE = SYSTEMZ_INS_VONE,
	SYSZ_INS_VPDI = SYSTEMZ_INS_VPDI,
	SYSZ_INS_VPERM = SYSTEMZ_INS_VPERM,
	SYSZ_INS_VPK = SYSTEMZ_INS_VPK,
	SYSZ_INS_VPKF = SYSTEMZ_INS_VPKF,
	SYSZ_INS_VPKG = SYSTEMZ_INS_VPKG,
	SYSZ_INS_VPKH = SYSTEMZ_INS_VPKH,
	SYSZ_INS_VPKLS = SYSTEMZ_INS_VPKLS,
	SYSZ_INS_VPKLSF = SYSTEMZ_INS_VPKLSF,
	SYSZ_INS_VPKLSFS = SYSTEMZ_INS_VPKLSFS,
	SYSZ_INS_VPKLSG = SYSTEMZ_INS_VPKLSG,
	SYSZ_INS_VPKLSGS = SYSTEMZ_INS_VPKLSGS,
	SYSZ_INS_VPKLSH = SYSTEMZ_INS_VPKLSH,
	SYSZ_INS_VPKLSHS = SYSTEMZ_INS_VPKLSHS,
	SYSZ_INS_VPKS = SYSTEMZ_INS_VPKS,
	SYSZ_INS_VPKSF = SYSTEMZ_INS_VPKSF,
	SYSZ_INS_VPKSFS = SYSTEMZ_INS_VPKSFS,
	SYSZ_INS_VPKSG = SYSTEMZ_INS_VPKSG,
	SYSZ_INS_VPKSGS = SYSTEMZ_INS_VPKSGS,
	SYSZ_INS_VPKSH = SYSTEMZ_INS_VPKSH,
	SYSZ_INS_VPKSHS = SYSTEMZ_INS_VPKSHS,
	SYSZ_INS_VPKZ = SYSTEMZ_INS_VPKZ,
	SYSZ_INS_VPKZR = SYSTEMZ_INS_VPKZR,
	SYSZ_INS_VPOPCT = SYSTEMZ_INS_VPOPCT,
	SYSZ_INS_VPOPCTB = SYSTEMZ_INS_VPOPCTB,
	SYSZ_INS_VPOPCTF = SYSTEMZ_INS_VPOPCTF,
	SYSZ_INS_VPOPCTG = SYSTEMZ_INS_VPOPCTG,
	SYSZ_INS_VPOPCTH = SYSTEMZ_INS_VPOPCTH,
	SYSZ_INS_VPSOP = SYSTEMZ_INS_VPSOP,
	SYSZ_INS_VREP = SYSTEMZ_INS_VREP,
	SYSZ_INS_VREPB = SYSTEMZ_INS_VREPB,
	SYSZ_INS_VREPF = SYSTEMZ_INS_VREPF,
	SYSZ_INS_VREPG = SYSTEMZ_INS_VREPG,
	SYSZ_INS_VREPH = SYSTEMZ_INS_VREPH,
	SYSZ_INS_VREPI = SYSTEMZ_INS_VREPI,
	SYSZ_INS_VREPIB = SYSTEMZ_INS_VREPIB,
	SYSZ_INS_VREPIF = SYSTEMZ_INS_VREPIF,
	SYSZ_INS_VREPIG = SYSTEMZ_INS_VREPIG,
	SYSZ_INS_VREPIH = SYSTEMZ_INS_VREPIH,
	SYSZ_INS_VRP = SYSTEMZ_INS_VRP,
	SYSZ_INS_VS = SYSTEMZ_INS_VS,
	SYSZ_INS_VSB = SYSTEMZ_INS_VSB,
	SYSZ_INS_VSBCBI = SYSTEMZ_INS_VSBCBI,
	SYSZ_INS_VSBCBIQ = SYSTEMZ_INS_VSBCBIQ,
	SYSZ_INS_VSBI = SYSTEMZ_INS_VSBI,
	SYSZ_INS_VSBIQ = SYSTEMZ_INS_VSBIQ,
	SYSZ_INS_VSCBI = SYSTEMZ_INS_VSCBI,
	SYSZ_INS_VSCBIB = SYSTEMZ_INS_VSCBIB,
	SYSZ_INS_VSCBIF = SYSTEMZ_INS_VSCBIF,
	SYSZ_INS_VSCBIG = SYSTEMZ_INS_VSCBIG,
	SYSZ_INS_VSCBIH = SYSTEMZ_INS_VSCBIH,
	SYSZ_INS_VSCBIQ = SYSTEMZ_INS_VSCBIQ,
	SYSZ_INS_VSCEF = SYSTEMZ_INS_VSCEF,
	SYSZ_INS_VSCEG = SYSTEMZ_INS_VSCEG,
	SYSZ_INS_VSCHDP = SYSTEMZ_INS_VSCHDP,
	SYSZ_INS_VSCHP = SYSTEMZ_INS_VSCHP,
	SYSZ_INS_VSCHSP = SYSTEMZ_INS_VSCHSP,
	SYSZ_INS_VSCHXP = SYSTEMZ_INS_VSCHXP,
	SYSZ_INS_VSCSHP = SYSTEMZ_INS_VSCSHP,
	SYSZ_INS_VSDP = SYSTEMZ_INS_VSDP,
	SYSZ_INS_VSEG = SYSTEMZ_INS_VSEG,
	SYSZ_INS_VSEGB = SYSTEMZ_INS_VSEGB,
	SYSZ_INS_VSEGF = SYSTEMZ_INS_VSEGF,
	SYSZ_INS_VSEGH = SYSTEMZ_INS_VSEGH,
	SYSZ_INS_VSEL = SYSTEMZ_INS_VSEL,
	SYSZ_INS_VSF = SYSTEMZ_INS_VSF,
	SYSZ_INS_VSG = SYSTEMZ_INS_VSG,
	SYSZ_INS_VSH = SYSTEMZ_INS_VSH,
	SYSZ_INS_VSL = SYSTEMZ_INS_VSL,
	SYSZ_INS_VSLB = SYSTEMZ_INS_VSLB,
	SYSZ_INS_VSLD = SYSTEMZ_INS_VSLD,
	SYSZ_INS_VSLDB = SYSTEMZ_INS_VSLDB,
	SYSZ_INS_VSP = SYSTEMZ_INS_VSP,
	SYSZ_INS_VSQ = SYSTEMZ_INS_VSQ,
	SYSZ_INS_VSRA = SYSTEMZ_INS_VSRA,
	SYSZ_INS_VSRAB = SYSTEMZ_INS_VSRAB,
	SYSZ_INS_VSRD = SYSTEMZ_INS_VSRD,
	SYSZ_INS_VSRL = SYSTEMZ_INS_VSRL,
	SYSZ_INS_VSRLB = SYSTEMZ_INS_VSRLB,
	SYSZ_INS_VSRP = SYSTEMZ_INS_VSRP,
	SYSZ_INS_VSRPR = SYSTEMZ_INS_VSRPR,
	SYSZ_INS_VST = SYSTEMZ_INS_VST,
	SYSZ_INS_VSTBR = SYSTEMZ_INS_VSTBR,
	SYSZ_INS_VSTBRF = SYSTEMZ_INS_VSTBRF,
	SYSZ_INS_VSTBRG = SYSTEMZ_INS_VSTBRG,
	SYSZ_INS_VSTBRH = SYSTEMZ_INS_VSTBRH,
	SYSZ_INS_VSTBRQ = SYSTEMZ_INS_VSTBRQ,
	SYSZ_INS_VSTEB = SYSTEMZ_INS_VSTEB,
	SYSZ_INS_VSTEBRF = SYSTEMZ_INS_VSTEBRF,
	SYSZ_INS_VSTEBRG = SYSTEMZ_INS_VSTEBRG,
	SYSZ_INS_VSTEBRH = SYSTEMZ_INS_VSTEBRH,
	SYSZ_INS_VSTEF = SYSTEMZ_INS_VSTEF,
	SYSZ_INS_VSTEG = SYSTEMZ_INS_VSTEG,
	SYSZ_INS_VSTEH = SYSTEMZ_INS_VSTEH,
	SYSZ_INS_VSTER = SYSTEMZ_INS_VSTER,
	SYSZ_INS_VSTERF = SYSTEMZ_INS_VSTERF,
	SYSZ_INS_VSTERG = SYSTEMZ_INS_VSTERG,
	SYSZ_INS_VSTERH = SYSTEMZ_INS_VSTERH,
	SYSZ_INS_VSTL = SYSTEMZ_INS_VSTL,
	SYSZ_INS_VSTM = SYSTEMZ_INS_VSTM,
	SYSZ_INS_VSTRC = SYSTEMZ_INS_VSTRC,
	SYSZ_INS_VSTRCB = SYSTEMZ_INS_VSTRCB,
	SYSZ_INS_VSTRCBS = SYSTEMZ_INS_VSTRCBS,
	SYSZ_INS_VSTRCF = SYSTEMZ_INS_VSTRCF,
	SYSZ_INS_VSTRCFS = SYSTEMZ_INS_VSTRCFS,
	SYSZ_INS_VSTRCH = SYSTEMZ_INS_VSTRCH,
	SYSZ_INS_VSTRCHS = SYSTEMZ_INS_VSTRCHS,
	SYSZ_INS_VSTRCZB = SYSTEMZ_INS_VSTRCZB,
	SYSZ_INS_VSTRCZBS = SYSTEMZ_INS_VSTRCZBS,
	SYSZ_INS_VSTRCZF = SYSTEMZ_INS_VSTRCZF,
	SYSZ_INS_VSTRCZFS = SYSTEMZ_INS_VSTRCZFS,
	SYSZ_INS_VSTRCZH = SYSTEMZ_INS_VSTRCZH,
	SYSZ_INS_VSTRCZHS = SYSTEMZ_INS_VSTRCZHS,
	SYSZ_INS_VSTRL = SYSTEMZ_INS_VSTRL,
	SYSZ_INS_VSTRLR = SYSTEMZ_INS_VSTRLR,
	SYSZ_INS_VSTRS = SYSTEMZ_INS_VSTRS,
	SYSZ_INS_VSTRSB = SYSTEMZ_INS_VSTRSB,
	SYSZ_INS_VSTRSF = SYSTEMZ_INS_VSTRSF,
	SYSZ_INS_VSTRSH = SYSTEMZ_INS_VSTRSH,
	SYSZ_INS_VSTRSZB = SYSTEMZ_INS_VSTRSZB,
	SYSZ_INS_VSTRSZF = SYSTEMZ_INS_VSTRSZF,
	SYSZ_INS_VSTRSZH = SYSTEMZ_INS_VSTRSZH,
	SYSZ_INS_VSUM = SYSTEMZ_INS_VSUM,
	SYSZ_INS_VSUMB = SYSTEMZ_INS_VSUMB,
	SYSZ_INS_VSUMG = SYSTEMZ_INS_VSUMG,
	SYSZ_INS_VSUMGF = SYSTEMZ_INS_VSUMGF,
	SYSZ_INS_VSUMGH = SYSTEMZ_INS_VSUMGH,
	SYSZ_INS_VSUMH = SYSTEMZ_INS_VSUMH,
	SYSZ_INS_VSUMQ = SYSTEMZ_INS_VSUMQ,
	SYSZ_INS_VSUMQF = SYSTEMZ_INS_VSUMQF,
	SYSZ_INS_VSUMQG = SYSTEMZ_INS_VSUMQG,
	SYSZ_INS_VTM = SYSTEMZ_INS_VTM,
	SYSZ_INS_VTP = SYSTEMZ_INS_VTP,
	SYSZ_INS_VUPH = SYSTEMZ_INS_VUPH,
	SYSZ_INS_VUPHB = SYSTEMZ_INS_VUPHB,
	SYSZ_INS_VUPHF = SYSTEMZ_INS_VUPHF,
	SYSZ_INS_VUPHH = SYSTEMZ_INS_VUPHH,
	SYSZ_INS_VUPKZ = SYSTEMZ_INS_VUPKZ,
	SYSZ_INS_VUPKZH = SYSTEMZ_INS_VUPKZH,
	SYSZ_INS_VUPKZL = SYSTEMZ_INS_VUPKZL,
	SYSZ_INS_VUPL = SYSTEMZ_INS_VUPL,
	SYSZ_INS_VUPLB = SYSTEMZ_INS_VUPLB,
	SYSZ_INS_VUPLF = SYSTEMZ_INS_VUPLF,
	SYSZ_INS_VUPLH = SYSTEMZ_INS_VUPLH,
	SYSZ_INS_VUPLHB = SYSTEMZ_INS_VUPLHB,
	SYSZ_INS_VUPLHF = SYSTEMZ_INS_VUPLHF,
	SYSZ_INS_VUPLHH = SYSTEMZ_INS_VUPLHH,
	SYSZ_INS_VUPLHW = SYSTEMZ_INS_VUPLHW,
	SYSZ_INS_VUPLL = SYSTEMZ_INS_VUPLL,
	SYSZ_INS_VUPLLB = SYSTEMZ_INS_VUPLLB,
	SYSZ_INS_VUPLLF = SYSTEMZ_INS_VUPLLF,
	SYSZ_INS_VUPLLH = SYSTEMZ_INS_VUPLLH,
	SYSZ_INS_VX = SYSTEMZ_INS_VX,
	SYSZ_INS_VZERO = SYSTEMZ_INS_VZERO,
	SYSZ_INS_WCDGB = SYSTEMZ_INS_WCDGB,
	SYSZ_INS_WCDLGB = SYSTEMZ_INS_WCDLGB,
	SYSZ_INS_WCEFB = SYSTEMZ_INS_WCEFB,
	SYSZ_INS_WCELFB = SYSTEMZ_INS_WCELFB,
	SYSZ_INS_WCFEB = SYSTEMZ_INS_WCFEB,
	SYSZ_INS_WCGDB = SYSTEMZ_INS_WCGDB,
	SYSZ_INS_WCLFEB = SYSTEMZ_INS_WCLFEB,
	SYSZ_INS_WCLGDB = SYSTEMZ_INS_WCLGDB,
	SYSZ_INS_WFADB = SYSTEMZ_INS_WFADB,
	SYSZ_INS_WFASB = SYSTEMZ_INS_WFASB,
	SYSZ_INS_WFAXB = SYSTEMZ_INS_WFAXB,
	SYSZ_INS_WFC = SYSTEMZ_INS_WFC,
	SYSZ_INS_WFCDB = SYSTEMZ_INS_WFCDB,
	SYSZ_INS_WFCEDB = SYSTEMZ_INS_WFCEDB,
	SYSZ_INS_WFCEDBS = SYSTEMZ_INS_WFCEDBS,
	SYSZ_INS_WFCESB = SYSTEMZ_INS_WFCESB,
	SYSZ_INS_WFCESBS = SYSTEMZ_INS_WFCESBS,
	SYSZ_INS_WFCEXB = SYSTEMZ_INS_WFCEXB,
	SYSZ_INS_WFCEXBS = SYSTEMZ_INS_WFCEXBS,
	SYSZ_INS_WFCHDB = SYSTEMZ_INS_WFCHDB,
	SYSZ_INS_WFCHDBS = SYSTEMZ_INS_WFCHDBS,
	SYSZ_INS_WFCHEDB = SYSTEMZ_INS_WFCHEDB,
	SYSZ_INS_WFCHEDBS = SYSTEMZ_INS_WFCHEDBS,
	SYSZ_INS_WFCHESB = SYSTEMZ_INS_WFCHESB,
	SYSZ_INS_WFCHESBS = SYSTEMZ_INS_WFCHESBS,
	SYSZ_INS_WFCHEXB = SYSTEMZ_INS_WFCHEXB,
	SYSZ_INS_WFCHEXBS = SYSTEMZ_INS_WFCHEXBS,
	SYSZ_INS_WFCHSB = SYSTEMZ_INS_WFCHSB,
	SYSZ_INS_WFCHSBS = SYSTEMZ_INS_WFCHSBS,
	SYSZ_INS_WFCHXB = SYSTEMZ_INS_WFCHXB,
	SYSZ_INS_WFCHXBS = SYSTEMZ_INS_WFCHXBS,
	SYSZ_INS_WFCSB = SYSTEMZ_INS_WFCSB,
	SYSZ_INS_WFCXB = SYSTEMZ_INS_WFCXB,
	SYSZ_INS_WFDDB = SYSTEMZ_INS_WFDDB,
	SYSZ_INS_WFDSB = SYSTEMZ_INS_WFDSB,
	SYSZ_INS_WFDXB = SYSTEMZ_INS_WFDXB,
	SYSZ_INS_WFIDB = SYSTEMZ_INS_WFIDB,
	SYSZ_INS_WFISB = SYSTEMZ_INS_WFISB,
	SYSZ_INS_WFIXB = SYSTEMZ_INS_WFIXB,
	SYSZ_INS_WFK = SYSTEMZ_INS_WFK,
	SYSZ_INS_WFKDB = SYSTEMZ_INS_WFKDB,
	SYSZ_INS_WFKEDB = SYSTEMZ_INS_WFKEDB,
	SYSZ_INS_WFKEDBS = SYSTEMZ_INS_WFKEDBS,
	SYSZ_INS_WFKESB = SYSTEMZ_INS_WFKESB,
	SYSZ_INS_WFKESBS = SYSTEMZ_INS_WFKESBS,
	SYSZ_INS_WFKEXB = SYSTEMZ_INS_WFKEXB,
	SYSZ_INS_WFKEXBS = SYSTEMZ_INS_WFKEXBS,
	SYSZ_INS_WFKHDB = SYSTEMZ_INS_WFKHDB,
	SYSZ_INS_WFKHDBS = SYSTEMZ_INS_WFKHDBS,
	SYSZ_INS_WFKHEDB = SYSTEMZ_INS_WFKHEDB,
	SYSZ_INS_WFKHEDBS = SYSTEMZ_INS_WFKHEDBS,
	SYSZ_INS_WFKHESB = SYSTEMZ_INS_WFKHESB,
	SYSZ_INS_WFKHESBS = SYSTEMZ_INS_WFKHESBS,
	SYSZ_INS_WFKHEXB = SYSTEMZ_INS_WFKHEXB,
	SYSZ_INS_WFKHEXBS = SYSTEMZ_INS_WFKHEXBS,
	SYSZ_INS_WFKHSB = SYSTEMZ_INS_WFKHSB,
	SYSZ_INS_WFKHSBS = SYSTEMZ_INS_WFKHSBS,
	SYSZ_INS_WFKHXB = SYSTEMZ_INS_WFKHXB,
	SYSZ_INS_WFKHXBS = SYSTEMZ_INS_WFKHXBS,
	SYSZ_INS_WFKSB = SYSTEMZ_INS_WFKSB,
	SYSZ_INS_WFKXB = SYSTEMZ_INS_WFKXB,
	SYSZ_INS_WFLCDB = SYSTEMZ_INS_WFLCDB,
	SYSZ_INS_WFLCSB = SYSTEMZ_INS_WFLCSB,
	SYSZ_INS_WFLCXB = SYSTEMZ_INS_WFLCXB,
	SYSZ_INS_WFLLD = SYSTEMZ_INS_WFLLD,
	SYSZ_INS_WFLLS = SYSTEMZ_INS_WFLLS,
	SYSZ_INS_WFLNDB = SYSTEMZ_INS_WFLNDB,
	SYSZ_INS_WFLNSB = SYSTEMZ_INS_WFLNSB,
	SYSZ_INS_WFLNXB = SYSTEMZ_INS_WFLNXB,
	SYSZ_INS_WFLPDB = SYSTEMZ_INS_WFLPDB,
	SYSZ_INS_WFLPSB = SYSTEMZ_INS_WFLPSB,
	SYSZ_INS_WFLPXB = SYSTEMZ_INS_WFLPXB,
	SYSZ_INS_WFLRD = SYSTEMZ_INS_WFLRD,
	SYSZ_INS_WFLRX = SYSTEMZ_INS_WFLRX,
	SYSZ_INS_WFMADB = SYSTEMZ_INS_WFMADB,
	SYSZ_INS_WFMASB = SYSTEMZ_INS_WFMASB,
	SYSZ_INS_WFMAXB = SYSTEMZ_INS_WFMAXB,
	SYSZ_INS_WFMAXDB = SYSTEMZ_INS_WFMAXDB,
	SYSZ_INS_WFMAXSB = SYSTEMZ_INS_WFMAXSB,
	SYSZ_INS_WFMAXXB = SYSTEMZ_INS_WFMAXXB,
	SYSZ_INS_WFMDB = SYSTEMZ_INS_WFMDB,
	SYSZ_INS_WFMINDB = SYSTEMZ_INS_WFMINDB,
	SYSZ_INS_WFMINSB = SYSTEMZ_INS_WFMINSB,
	SYSZ_INS_WFMINXB = SYSTEMZ_INS_WFMINXB,
	SYSZ_INS_WFMSB = SYSTEMZ_INS_WFMSB,
	SYSZ_INS_WFMSDB = SYSTEMZ_INS_WFMSDB,
	SYSZ_INS_WFMSSB = SYSTEMZ_INS_WFMSSB,
	SYSZ_INS_WFMSXB = SYSTEMZ_INS_WFMSXB,
	SYSZ_INS_WFMXB = SYSTEMZ_INS_WFMXB,
	SYSZ_INS_WFNMADB = SYSTEMZ_INS_WFNMADB,
	SYSZ_INS_WFNMASB = SYSTEMZ_INS_WFNMASB,
	SYSZ_INS_WFNMAXB = SYSTEMZ_INS_WFNMAXB,
	SYSZ_INS_WFNMSDB = SYSTEMZ_INS_WFNMSDB,
	SYSZ_INS_WFNMSSB = SYSTEMZ_INS_WFNMSSB,
	SYSZ_INS_WFNMSXB = SYSTEMZ_INS_WFNMSXB,
	SYSZ_INS_WFPSODB = SYSTEMZ_INS_WFPSODB,
	SYSZ_INS_WFPSOSB = SYSTEMZ_INS_WFPSOSB,
	SYSZ_INS_WFPSOXB = SYSTEMZ_INS_WFPSOXB,
	SYSZ_INS_WFSDB = SYSTEMZ_INS_WFSDB,
	SYSZ_INS_WFSQDB = SYSTEMZ_INS_WFSQDB,
	SYSZ_INS_WFSQSB = SYSTEMZ_INS_WFSQSB,
	SYSZ_INS_WFSQXB = SYSTEMZ_INS_WFSQXB,
	SYSZ_INS_WFSSB = SYSTEMZ_INS_WFSSB,
	SYSZ_INS_WFSXB = SYSTEMZ_INS_WFSXB,
	SYSZ_INS_WFTCIDB = SYSTEMZ_INS_WFTCIDB,
	SYSZ_INS_WFTCISB = SYSTEMZ_INS_WFTCISB,
	SYSZ_INS_WFTCIXB = SYSTEMZ_INS_WFTCIXB,
	SYSZ_INS_WLDEB = SYSTEMZ_INS_WLDEB,
	SYSZ_INS_WLEDB = SYSTEMZ_INS_WLEDB,
	SYSZ_INS_X = SYSTEMZ_INS_X,
	SYSZ_INS_XC = SYSTEMZ_INS_XC,
	SYSZ_INS_XG = SYSTEMZ_INS_XG,
	SYSZ_INS_XGR = SYSTEMZ_INS_XGR,
	SYSZ_INS_XGRK = SYSTEMZ_INS_XGRK,
	SYSZ_INS_XI = SYSTEMZ_INS_XI,
	SYSZ_INS_XIHF = SYSTEMZ_INS_XIHF,
	SYSZ_INS_XILF = SYSTEMZ_INS_XILF,
	SYSZ_INS_XIY = SYSTEMZ_INS_XIY,
	SYSZ_INS_XR = SYSTEMZ_INS_XR,
	SYSZ_INS_XRK = SYSTEMZ_INS_XRK,
	SYSZ_INS_XSCH = SYSTEMZ_INS_XSCH,
	SYSZ_INS_XY = SYSTEMZ_INS_XY,
	SYSZ_INS_ZAP = SYSTEMZ_INS_ZAP,

	SYSZ_INS_ENDING = SYSTEMZ_INS_ENDING,

	SYSZ_INS_ALIAS_BEGIN = SYSTEMZ_INS_ALIAS_BEGIN,

	SYSZ_INS_ALIAS_VISTRB = SYSTEMZ_INS_ALIAS_VISTRB,
	SYSZ_INS_ALIAS_VISTR = SYSTEMZ_INS_ALIAS_VISTR,
	SYSZ_INS_ALIAS_VFEEB = SYSTEMZ_INS_ALIAS_VFEEB,
	SYSZ_INS_ALIAS_VFEE = SYSTEMZ_INS_ALIAS_VFEE,
	SYSZ_INS_ALIAS_VFAEB = SYSTEMZ_INS_ALIAS_VFAEB,
	SYSZ_INS_ALIAS_VFAEBS = SYSTEMZ_INS_ALIAS_VFAEBS,
	SYSZ_INS_ALIAS_VFAE = SYSTEMZ_INS_ALIAS_VFAE,
	SYSZ_INS_ALIAS_VSTRSB = SYSTEMZ_INS_ALIAS_VSTRSB,
	SYSZ_INS_ALIAS_VSTRS = SYSTEMZ_INS_ALIAS_VSTRS,
	SYSZ_INS_ALIAS_VSTRCB = SYSTEMZ_INS_ALIAS_VSTRCB,
	SYSZ_INS_ALIAS_VSTRCBS = SYSTEMZ_INS_ALIAS_VSTRCBS,
	SYSZ_INS_ALIAS_VSTRC = SYSTEMZ_INS_ALIAS_VSTRC,
	SYSZ_INS_ALIAS_VFAEH = SYSTEMZ_INS_ALIAS_VFAEH,
	SYSZ_INS_ALIAS_VFAEHS = SYSTEMZ_INS_ALIAS_VFAEHS,
	SYSZ_INS_ALIAS_VFAEF = SYSTEMZ_INS_ALIAS_VFAEF,
	SYSZ_INS_ALIAS_VFAEFS = SYSTEMZ_INS_ALIAS_VFAEFS,
	SYSZ_INS_ALIAS_VFAEZB = SYSTEMZ_INS_ALIAS_VFAEZB,
	SYSZ_INS_ALIAS_VFAEZBS = SYSTEMZ_INS_ALIAS_VFAEZBS,
	SYSZ_INS_ALIAS_VFAEZH = SYSTEMZ_INS_ALIAS_VFAEZH,
	SYSZ_INS_ALIAS_VFAEZHS = SYSTEMZ_INS_ALIAS_VFAEZHS,
	SYSZ_INS_ALIAS_VFAEZF = SYSTEMZ_INS_ALIAS_VFAEZF,
	SYSZ_INS_ALIAS_VFAEZFS = SYSTEMZ_INS_ALIAS_VFAEZFS,
	SYSZ_INS_ALIAS_VFEEH = SYSTEMZ_INS_ALIAS_VFEEH,
	SYSZ_INS_ALIAS_VFEEF = SYSTEMZ_INS_ALIAS_VFEEF,
	SYSZ_INS_ALIAS_VFENE = SYSTEMZ_INS_ALIAS_VFENE,
	SYSZ_INS_ALIAS_VFENEB = SYSTEMZ_INS_ALIAS_VFENEB,
	SYSZ_INS_ALIAS_VFENEH = SYSTEMZ_INS_ALIAS_VFENEH,
	SYSZ_INS_ALIAS_VFENEF = SYSTEMZ_INS_ALIAS_VFENEF,
	SYSZ_INS_ALIAS_VISTRH = SYSTEMZ_INS_ALIAS_VISTRH,
	SYSZ_INS_ALIAS_VISTRF = SYSTEMZ_INS_ALIAS_VISTRF,
	SYSZ_INS_ALIAS_VSTRCH = SYSTEMZ_INS_ALIAS_VSTRCH,
	SYSZ_INS_ALIAS_VSTRCHS = SYSTEMZ_INS_ALIAS_VSTRCHS,
	SYSZ_INS_ALIAS_VSTRCF = SYSTEMZ_INS_ALIAS_VSTRCF,
	SYSZ_INS_ALIAS_VSTRCFS = SYSTEMZ_INS_ALIAS_VSTRCFS,
	SYSZ_INS_ALIAS_VSTRCZB = SYSTEMZ_INS_ALIAS_VSTRCZB,
	SYSZ_INS_ALIAS_VSTRCZBS = SYSTEMZ_INS_ALIAS_VSTRCZBS,
	SYSZ_INS_ALIAS_VSTRCZH = SYSTEMZ_INS_ALIAS_VSTRCZH,
	SYSZ_INS_ALIAS_VSTRCZHS = SYSTEMZ_INS_ALIAS_VSTRCZHS,
	SYSZ_INS_ALIAS_VSTRCZF = SYSTEMZ_INS_ALIAS_VSTRCZF,
	SYSZ_INS_ALIAS_VSTRCZFS = SYSTEMZ_INS_ALIAS_VSTRCZFS,
	SYSZ_INS_ALIAS_VSTRSH = SYSTEMZ_INS_ALIAS_VSTRSH,
	SYSZ_INS_ALIAS_VSTRSF = SYSTEMZ_INS_ALIAS_VSTRSF,

	SYSZ_INS_ALIAS_END = SYSTEMZ_INS_ALIAS_END,
} sysz_insn;

typedef enum {
	SYSZ_GRP_INVALID = SYSTEMZ_GRP_INVALID,

	SYSZ_GRP_JUMP = SYSTEMZ_GRP_JUMP,
	SYSZ_GRP_CALL = SYSTEMZ_GRP_CALL,
	SYSZ_GRP_RET = SYSTEMZ_GRP_RET,
	SYSZ_GRP_INT = SYSTEMZ_GRP_INT,
	SYSZ_GRP_IRET = SYSTEMZ_GRP_IRET,
	SYSZ_GRP_PRIVILEGE = SYSTEMZ_GRP_PRIVILEGE,
	SYSZ_GRP_BRANCH_RELATIVE = SYSTEMZ_GRP_BRANCH_RELATIVE,

	SYSZ_FEATURE_FEATURESOFTFLOAT = SYSTEMZ_FEATURE_FEATURESOFTFLOAT,
	SYSZ_FEATURE_FEATUREBACKCHAIN = SYSTEMZ_FEATURE_FEATUREBACKCHAIN,
	SYSZ_FEATURE_FEATUREDISTINCTOPS = SYSTEMZ_FEATURE_FEATUREDISTINCTOPS,
	SYSZ_FEATURE_FEATUREFASTSERIALIZATION =
		SYSTEMZ_FEATURE_FEATUREFASTSERIALIZATION,
	SYSZ_FEATURE_FEATUREFPEXTENSION = SYSTEMZ_FEATURE_FEATUREFPEXTENSION,
	SYSZ_FEATURE_FEATUREHIGHWORD = SYSTEMZ_FEATURE_FEATUREHIGHWORD,
	SYSZ_FEATURE_FEATUREINTERLOCKEDACCESS1 =
		SYSTEMZ_FEATURE_FEATUREINTERLOCKEDACCESS1,
	SYSZ_FEATURE_FEATURELOADSTOREONCOND =
		SYSTEMZ_FEATURE_FEATURELOADSTOREONCOND,
	SYSZ_FEATURE_FEATUREPOPULATIONCOUNT =
		SYSTEMZ_FEATURE_FEATUREPOPULATIONCOUNT,
	SYSZ_FEATURE_FEATUREMESSAGESECURITYASSIST3 =
		SYSTEMZ_FEATURE_FEATUREMESSAGESECURITYASSIST3,
	SYSZ_FEATURE_FEATUREMESSAGESECURITYASSIST4 =
		SYSTEMZ_FEATURE_FEATUREMESSAGESECURITYASSIST4,
	SYSZ_FEATURE_FEATURERESETREFERENCEBITSMULTIPLE =
		SYSTEMZ_FEATURE_FEATURERESETREFERENCEBITSMULTIPLE,
	SYSZ_FEATURE_FEATUREEXECUTIONHINT =
		SYSTEMZ_FEATURE_FEATUREEXECUTIONHINT,
	SYSZ_FEATURE_FEATURELOADANDTRAP = SYSTEMZ_FEATURE_FEATURELOADANDTRAP,
	SYSZ_FEATURE_FEATUREMISCELLANEOUSEXTENSIONS =
		SYSTEMZ_FEATURE_FEATUREMISCELLANEOUSEXTENSIONS,
	SYSZ_FEATURE_FEATUREPROCESSORASSIST =
		SYSTEMZ_FEATURE_FEATUREPROCESSORASSIST,
	SYSZ_FEATURE_FEATURETRANSACTIONALEXECUTION =
		SYSTEMZ_FEATURE_FEATURETRANSACTIONALEXECUTION,
	SYSZ_FEATURE_FEATUREDFPZONEDCONVERSION =
		SYSTEMZ_FEATURE_FEATUREDFPZONEDCONVERSION,
	SYSZ_FEATURE_FEATUREENHANCEDDAT2 = SYSTEMZ_FEATURE_FEATUREENHANCEDDAT2,
	SYSZ_FEATURE_FEATURELOADANDZERORIGHTMOSTBYTE =
		SYSTEMZ_FEATURE_FEATURELOADANDZERORIGHTMOSTBYTE,
	SYSZ_FEATURE_FEATURELOADSTOREONCOND2 =
		SYSTEMZ_FEATURE_FEATURELOADSTOREONCOND2,
	SYSZ_FEATURE_FEATUREMESSAGESECURITYASSIST5 =
		SYSTEMZ_FEATURE_FEATUREMESSAGESECURITYASSIST5,
	SYSZ_FEATURE_FEATUREDFPPACKEDCONVERSION =
		SYSTEMZ_FEATURE_FEATUREDFPPACKEDCONVERSION,
	SYSZ_FEATURE_FEATUREVECTOR = SYSTEMZ_FEATURE_FEATUREVECTOR,
	SYSZ_FEATURE_FEATUREMISCELLANEOUSEXTENSIONS2 =
		SYSTEMZ_FEATURE_FEATUREMISCELLANEOUSEXTENSIONS2,
	SYSZ_FEATURE_FEATUREGUARDEDSTORAGE =
		SYSTEMZ_FEATURE_FEATUREGUARDEDSTORAGE,
	SYSZ_FEATURE_FEATUREMESSAGESECURITYASSIST7 =
		SYSTEMZ_FEATURE_FEATUREMESSAGESECURITYASSIST7,
	SYSZ_FEATURE_FEATUREMESSAGESECURITYASSIST8 =
		SYSTEMZ_FEATURE_FEATUREMESSAGESECURITYASSIST8,
	SYSZ_FEATURE_FEATUREVECTORENHANCEMENTS1 =
		SYSTEMZ_FEATURE_FEATUREVECTORENHANCEMENTS1,
	SYSZ_FEATURE_FEATUREVECTORPACKEDDECIMAL =
		SYSTEMZ_FEATURE_FEATUREVECTORPACKEDDECIMAL,
	SYSZ_FEATURE_FEATUREINSERTREFERENCEBITSMULTIPLE =
		SYSTEMZ_FEATURE_FEATUREINSERTREFERENCEBITSMULTIPLE,
	SYSZ_FEATURE_FEATUREMISCELLANEOUSEXTENSIONS3 =
		SYSTEMZ_FEATURE_FEATUREMISCELLANEOUSEXTENSIONS3,
	SYSZ_FEATURE_FEATUREMESSAGESECURITYASSIST9 =
		SYSTEMZ_FEATURE_FEATUREMESSAGESECURITYASSIST9,
	SYSZ_FEATURE_FEATUREVECTORENHANCEMENTS2 =
		SYSTEMZ_FEATURE_FEATUREVECTORENHANCEMENTS2,
	SYSZ_FEATURE_FEATUREVECTORPACKEDDECIMALENHANCEMENT =
		SYSTEMZ_FEATURE_FEATUREVECTORPACKEDDECIMALENHANCEMENT,
	SYSZ_FEATURE_FEATUREENHANCEDSORT = SYSTEMZ_FEATURE_FEATUREENHANCEDSORT,
	SYSZ_FEATURE_FEATUREDEFLATECONVERSION =
		SYSTEMZ_FEATURE_FEATUREDEFLATECONVERSION,
	SYSZ_FEATURE_FEATUREVECTORPACKEDDECIMALENHANCEMENT2 =
		SYSTEMZ_FEATURE_FEATUREVECTORPACKEDDECIMALENHANCEMENT2,
	SYSZ_FEATURE_FEATURENNPASSIST = SYSTEMZ_FEATURE_FEATURENNPASSIST,
	SYSZ_FEATURE_FEATUREBEARENHANCEMENT =
		SYSTEMZ_FEATURE_FEATUREBEARENHANCEMENT,
	SYSZ_FEATURE_FEATURERESETDATPROTECTION =
		SYSTEMZ_FEATURE_FEATURERESETDATPROTECTION,
	SYSZ_FEATURE_FEATUREPROCESSORACTIVITYINSTRUMENTATION =
		SYSTEMZ_FEATURE_FEATUREPROCESSORACTIVITYINSTRUMENTATION,

	SYSZ_GRP_ENDING = SYSTEMZ_GRP_ENDING,
} sysz_insn_group;

#ifdef __cplusplus
}
#endif

#endif
