/*-
 * Copyright (C) 2008 Erik Larsson
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.catacombae.hfsexplorer.types.hfs;

import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.types.finder.DInfo;
import org.catacombae.hfsexplorer.types.finder.DXInfo;
import java.io.PrintStream;
import org.catacombae.hfsexplorer.Util;

/** This class was generated by CStructToJavaClass. */
public class CdrDirRec extends CatDataRec {
    /*
     * struct CdrDirRec
     * size: 70 bytes
     * description:
     *
     * BP  Size  Type       Identifier   Description
     * ------------------------------------------------------------------------------
     * 0   1     SInt8      cdrType      record type (SignedByte)
     * 1   1     SInt8      cdrResrv2    reserved (SignedByte)
     * 2   2     SInt16     dirFlags     directory flags (Integer)
     * 4   2     SInt16     dirVal       directory valence (Integer)
     * 6   4     SInt32     dirDirID     directory ID (LongInt)
     * 10  4     SInt32     dirCrDat     date and time of creation (LongInt)
     * 14  4     SInt32     dirMdDat     date and time of last modification (LongInt)
     * 18  4     SInt32     dirBkDat     date and time of last backup (LongInt)
     * 22  16    DInfo      dirUsrInfo   Finder information (DInfo)
     * 38  16    DXInfo     dirFndrInfo  additional Finder information (DXInfo)
     * 54  4*4   SInt32[4]  dirResrv     reserved (ARRAY[1..4] OF LongInt)
     */
    
    public static final int STRUCTSIZE = 70;
    
    private final byte[] dirFlags = new byte[2];
    private final byte[] dirVal = new byte[2];
    private final byte[] dirDirID = new byte[4];
    private final byte[] dirCrDat = new byte[4];
    private final byte[] dirMdDat = new byte[4];
    private final byte[] dirBkDat = new byte[4];
    private final DInfo dirUsrInfo;
    private final DXInfo dirFndrInfo;
    private final byte[] dirResrv = new byte[4*4];
    
    public CdrDirRec(byte[] data, int offset) {
        super(data, offset);
        System.arraycopy(data, offset + 2, dirFlags, 0, 2);
        System.arraycopy(data, offset + 4, dirVal, 0, 2);
        System.arraycopy(data, offset + 6, dirDirID, 0, 4);
        System.arraycopy(data, offset + 10, dirCrDat, 0, 4);
        System.arraycopy(data, offset + 14, dirMdDat, 0, 4);
        System.arraycopy(data, offset + 18, dirBkDat, 0, 4);
        dirUsrInfo = new DInfo(data, offset + 22);
        dirFndrInfo = new DXInfo(data, offset + 38);
        System.arraycopy(data, offset + 54, dirResrv, 0, 4 * 4);
    }
    
    public static int length() { return STRUCTSIZE; }
    
    /** directory flags (Integer) */
    public short getDirFlags() { return Util.readShortBE(dirFlags); }
    /** directory valence (Integer) */
    public short getDirVal() { return Util.readShortBE(dirVal); }
    /** directory ID (LongInt) */
    public int getDirDirID() { return Util.readIntBE(dirDirID); }
    /** date and time of creation (LongInt) */
    public int getDirCrDat() { return Util.readIntBE(dirCrDat); }
    /** date and time of last modification (LongInt) */
    public int getDirMdDat() { return Util.readIntBE(dirMdDat); }
    /** date and time of last backup (LongInt) */
    public int getDirBkDat() { return Util.readIntBE(dirBkDat); }
    /** Finder information (DInfo) */
    public DInfo getDirUsrInfo() { return dirUsrInfo; }
    /** additional Finder information (DXInfo) */
    public DXInfo getDirFndrInfo() { return dirFndrInfo; }
    /** reserved (ARRAY[1..4] OF LongInt) */
    public int[] getDirResrv() { return Util.readIntArrayBE(dirResrv); }

    @Override
    public Dictionary getStructElements() {
        DictionaryBuilder db = new DictionaryBuilder(CdrDirRec.class.getSimpleName());
        
        super.addSuperStructElements(db);
        db.addUIntBE("dirFlags", dirFlags, "Directory flags", BINARY);
        db.addUIntBE("dirVal", dirVal, "Valence");
        db.addUIntBE("dirDirID", dirDirID, "Directory ID");
        db.add("dirCrDat", new HFSDateField(dirCrDat), "Creation date");
        db.add("dirMdDat", new HFSDateField(dirMdDat), "Modification date");
        db.add("dirBkDat", new HFSDateField(dirBkDat), "Backup date");
        db.add("dirUsrInfo", dirUsrInfo.getStructElements(), "Finder info");
        db.add("dirFndrInfo", dirFndrInfo.getStructElements(), "Extended Finder info");
        db.addIntArray("dirResrv", dirResrv, BITS_32, UNSIGNED, BIG_ENDIAN, "Reserved", HEXADECIMAL);
        
        return db.getResult();
    }

    @Override
    public void printFields(PrintStream ps, String prefix) {
        super.printFields(ps, prefix);
        ps.println(prefix + " cdrType: " + getCdrType());
        ps.println(prefix + " cdrResrv2: " + getCdrResrv2());
        ps.println(prefix + " dirFlags: " + getDirFlags());
        ps.println(prefix + " dirVal: " + getDirVal());
        ps.println(prefix + " dirDirID: " + getDirDirID());
        ps.println(prefix + " dirCrDat: " + getDirCrDat());
        ps.println(prefix + " dirMdDat: " + getDirMdDat());
        ps.println(prefix + " dirBkDat: " + getDirBkDat());
        ps.println(prefix + " dirUsrInfo: ");
        getDirUsrInfo().print(ps, prefix + "  ");
        ps.println(prefix + " dirFndrInfo: ");
        getDirFndrInfo().print(ps, prefix + "  ");
        ps.println(prefix + " dirResrv: " + getDirResrv());
    }
    
    @Override
    public void print(PrintStream ps, String prefix) {
	ps.println(prefix + "CdrDirRec:");
	printFields(ps, prefix);
    }
    
    @Override
    public byte[] getBytes() {
        byte[] result = new byte[size()];
        byte[] tempData;
        int offset = 0;

        byte[] superData = super.getBytes();
        System.arraycopy(superData, 0, result, offset, superData.length); offset += superData.length;
        System.arraycopy(dirFlags, 0, result, offset, dirFlags.length); offset += dirFlags.length;
        System.arraycopy(dirVal, 0, result, offset, dirVal.length); offset += dirVal.length;
        System.arraycopy(dirDirID, 0, result, offset, dirDirID.length); offset += dirDirID.length;
        System.arraycopy(dirCrDat, 0, result, offset, dirCrDat.length); offset += dirCrDat.length;
        System.arraycopy(dirMdDat, 0, result, offset, dirMdDat.length); offset += dirMdDat.length;
        System.arraycopy(dirBkDat, 0, result, offset, dirBkDat.length); offset += dirBkDat.length;
        tempData = dirUsrInfo.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length); offset += tempData.length;
        tempData = dirFndrInfo.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length); offset += tempData.length;
        System.arraycopy(dirResrv, 0, result, offset, dirResrv.length); offset += dirResrv.length;
        return result;
    }

    public int size() {
        return length();
    }
}
