#!/usr/bin/perl

use Archive::Zip qw(:CONSTANTS :ERROR_CODES);

use strict;

my $zip = Archive::Zip->new;
unless ( $zip->read( 'ecard.zip' ) == AZ_OK ) {
  die;
}

my $mem = $zip->memberNamed( 'ecard.exe' );
unless ($mem) {
  die;
}

my $meth = $mem->compressionMethod;
if ($meth == COMPRESSION_DEFLATED) {
  print "COMPRESSION_DEFLATED\n";
} elsif ($meth == COMPRESSION_STORED) {
  print "COMPRESSION_STORED\n";
}
# $mem->desiredCompressionMethod(COMPRESSION_STORED);
unless ($mem->rewindData == AZ_OK ) {
  die;
}
my $status = AZ_OK;
my $bufferRef;

local *F;
open(F, "> ecard.deflated") or die;

while ($status == AZ_OK) {
  print "reading chunk...\n";
  ($bufferRef, $status ) = $mem->readChunk();
  print F $$bufferRef;
  print "read ".length($$bufferRef)." bytes.\n";
}
unless ($status == AZ_STREAM_END) {
  die "status: $status";
}
close(F);
$mem->endRead();
