#include <iostream>
#include <fstream>
#include <string>
#include "strings.h"
#include "string.h"
#include <stdlib.h>

using namespace std;

long long findTag(char* filename) {
	FILE * pFile;
		
	pFile = fopen(filename, "r");
	
	if (pFile == 0) {
		return -2;
	}
	
	int bs = 1024;
	char block[bs];
	
	int ivlength = 8;
	
	int count = fread(block, ivlength, 1, pFile); // skip iv
	if (count != 1) {
		return -3;
	}
	
	long long blocknr = 0;
	
	char lastcipher[16];
	bzero(lastcipher, 16);
	
	long long result = -1;
	
	while( fread(block, bs, 1, pFile) == 1) {	
	
	  if (blocknr != 0 && memcmp(block, lastcipher, 16) == 0) {
			return blocknr;
		}
		
		memcpy(lastcipher, block, 16);
		blocknr++;		
	}
	
	return result;
}


int main(int argc, char *argv[]) {

  if (argc < 2) {
	  printf("file name is missing!\n");		
		exit(1);
	}
	
	
	for (int i=1; i<argc; ++i) {
	
		printf("%s: ", argv[i]);

		long long blocknr = findTag(argv[i]);	
		
		if (blocknr > 0)  {
		  printf("MARKED FILE! (Block number %lld)\n", blocknr);
		}
    if (blocknr == -1) {
		  printf("No mark found\n");
		}
		if (blocknr == -2) {
		  printf("I/O error\n");
		}
		if (blocknr == -3) {
		  printf("Not an encrypted file\n");
		}
		
	}

}
