// clang -o unarchiveDict unarchiveDict.m -framework Foundation

#include <Foundation/Foundation.h>
#include <Foundation/NSURL.h>
#include <WebKit/WebKit.h>
#include <Foundation/NSKeyedArchiver.h>

#include <dlfcn.h>

int main(int argc, const char * argv[]) {
    NSError* err = 0;

    if (argc < 2) {
        printf("Usage: %s path/to/plist\n", argv[0]);
        return 0;
    }

    dlopen("/System/Library/PrivateFrameworks/OfficeImport.framework/Versions/A/OfficeImport", RTLD_LAZY);

    NSString* path = [NSString stringWithUTF8String:argv[1]];
    NSData* data = [NSData dataWithContentsOfFile:path];

    NSSet* whitelist = [NSSet setWithArray: @[[NSDictionary class], [NSString class], [NSData class], [NSNumber class], [NSURL class], [NSUUID class], [NSValue class], [NSArray class]]];
    NSDictionary* o = [NSKeyedUnarchiver unarchivedObjectOfClasses:whitelist fromData:data error:&err];

    if (!o) {
        NSLog(@"Error: %@", err);
        return -1;
    }

    printf("Unarchived dictionary with %lu entries\n", [o count]);
    for (id key in [o allKeys]) {
        // Perform any action on the elements of the unarchived dictionary here
        [[o objectForKey:key] description];
    }

    return 0;
}
