// Compile with clang -o archiveDict archiveDict.m -framework Foundation

#include <Foundation/Foundation.h>
#include <Foundation/NSURL.h>
#include <WebKit/WebKit.h>
#include <Foundation/NSKeyedArchiver.h>

int main(int argc, const char * argv[]) {
    NSError* err = 0;

    NSDictionary* obj = @{@"a": @"b", @"arr":@[@1, @2, @3], @"dict":@{@"foo":@"bar"}};

    NSData* data = [NSKeyedArchiver archivedDataWithRootObject:obj requiringSecureCoding:true error:&err];
    if (!data) {
        NSLog(@"Error: %@", err);
        return -1;
    }
    printf("Encoded dictionary into %lu bytes\n", [data length]);

	[data writeToFile:@"./archive" atomically:YES];

    puts("Run `plutil -convert xml1 archive`, then replace NSDictionary with e.g. OITSUIntDictionary in the archive and unarchive it again using unarchiveDict");

    return 0;
}
