%define NOSTREAM    0xFFFFFFFF  ; Compound File Directory Entries Terminator
%define ENDOFCHAIN  0xFFFFFFFE  ; FAT Chain Terminator
%define FATSECT     0xFFFFFFFD  ; Sector reserved for FAT
%define FREESECT    0xFFFFFFFF  ; Unallocated/Free Sector

; [MS-CFB] 2.2
struc CompoundFileHeader
    .Signature              resq 1
    .Clsid                  resb 16
    .MinorVersion           resw 1
    .MajorVersion           resw 1
    .ByteOrder              resw 1
    .SectorShift            resw 1
    .MiniSectorShift        resw 1
    .Reserved               resb 6
    .NumberDirSect          resd 1
    .NumberFatSect          resd 1
    .DirectoryStart         resd 1
    .TransactionSignature   resd 1
    .MiniCutoffSize         resd 1
    .MiniFatStart           resd 1
    .NumMiniFatSect         resd 1
    .DifatStart             resd 1
    .NumDifatSect           resd 1
    .Difat                  resd 109
endstruc

; [MS-CFB] 2.6.1
struc DirectoryEntry
    .Name                   resb 64
    .NameLength             resw 1
    .ObjectType             resb 1
    .ColorFlag              resb 1
    .LeftSiblingID          resd 1
    .RightSiblingID         resd 1
    .ChildID                resd 1
    .CLSID                  resb 16
    .StateBits              resd 1
    .CreationTime           resq 1
    .ModifiedTime           resq 1
    .StartingSector         resd 1
    .StreamSize             resq 1
endstruc
