/*
    Copyright 2007,2008,2009 Luigi Auriemma

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <sys/stat.h>
#include <time.h>
#include "mydownlib.h"

typedef unsigned char   u8;



#define VER         "0.2a"
#define UPLOAD0     "Content-Type: multipart/form-data; boundary=---------------------------%u"
#define UPLOAD1     "-----------------------------%u\r\n" \
                    "Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"\r\n" \
                    "Content-Type: application/octet-stream\r\n" \
                    "\r\n"
#define UPLOADX     "-----------------------------%u\r\n" \
                    "Content-Disposition: form-data; name=\"%s\"\r\n" \
                    "\r\n" \
                    "%s\r\n"
#define UPLOAD2     "\r\n" \
                    "-----------------------------%u\r\n" \
                    "Content-Disposition: form-data; name=\"%s\"\r\n" \
                    "\r\n" \
                    "Upload\r\n" \
                    "-----------------------------%u--\r\n"



int spr(u8 **buff, int blen, u8 *fmt, ...);
void fgetz(char *data, int len);
void std_err(void);



int main(int argc, char *argv[]) {
    mydown_options  opt;
    struct stat xstat;
    FILE    *fd;
    int     i,
            len,
            seed,
            ret;
    u8      tmp[100]    = "",
            user[64]    = "",
            pass[64]    = "",
            *formname   = "",
            *btnname    = "Upload",
            *content    = NULL,
            *data,
            *host,
            *lfile,
            *dfile,
            *p;

    setbuf(stdout, NULL);

    fputs("\n"
        "Generic custom HTTP file uploader "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 6) {
        printf("\n"
            "Usage: %s <URL> <local_file> <dest_file> <form-name> <button-name> [form=data]\n"
            "\n"
            "Examples:\n"
            "  127.0.0.1 file.txt ../../../windows/win.ini \"\" upload\n"
            "  http://127.0.0.1:1234/upload malware.exe ../../dir/file.exe \"\" upload\n"
            "  http://127.0.0.1/upload.php file.exe file.exe myformname BtnUpload\n"
            "  localhost/upload myfile remotefile myformname BtnUpload TxtUser=user TxtPassword=pass\n"
            "\n", argv[0]);
        exit(1);
    }

    host     = argv[1];
    lfile    = argv[2];
    dfile    = argv[3];
    formname = argv[4];
    btnname  = argv[5];

    do {
        seed = (time(NULL) * 0x343FD) + 0x269EC3;
    } while(seed < 0xffff);         // in reality MIME uses a 64 bit value
    sprintf(tmp, UPLOAD0, seed);    // but this is enough

    printf(
        "- host:          %s\n"
        "- local file:    %s\n"
        "- remote file:   %s\n"
        "- form name:     %s\n"
        "- button name:   %s\n",
        host, lfile, dfile, formname, btnname);

    content = NULL;
    len = 0;

    for(i = 6; i < argc; i++) {
        printf("- add form/data: %s\n", argv[i]);
        p = strchr(argv[i], '=');
        if(p) {
            *p++ = 0;
        } else {
            p = argv[i] + strlen(argv[i]);
        }
        len += spr(&content, len, UPLOADX, seed, argv[i], p);
    }

    len += spr(&content, len, UPLOAD1, seed, formname, dfile);

    printf("- load %s\n", lfile);
    fd = fopen(lfile, "rb");
    if(!fd) std_err();
    fstat(fileno(fd), &xstat);
    content = realloc(content, len + 1 + xstat.st_size);    
    len += fread(content + len, 1, xstat.st_size, fd);
    fclose(fd);
    printf("- loaded %d bytes\n", (int)xstat.st_size);

    len += spr(&content, len, UPLOAD2, seed, btnname, seed);

    memset(&opt, 0, sizeof(opt));
    opt.verbose     = -1;
    opt.filedata    = (void *)&data;
    opt.ret_code    = &ret;
    opt.get         = "POST";
    opt.more_http   = tmp;
    opt.content     = content;
    opt.contentsize = len;

redo:
    data = NULL;
    printf("- start the upload of the file\n");
    len = mydown(host, NULL, &opt);
    if(data) {
        if(len != MYDOWN_ERROR) fwrite(data, 1, len, stdout);
        free(data);
    }

    if(ret == 401) {
        printf("- authorization required:\n");
        printf("  insert the username: ");
        fgetz(user, sizeof(user));
        printf("  insert the password: ");
        fgetz(pass, sizeof(pass));
        opt.user    = user;
        opt.pass    = pass;
        goto redo;
    }
    if((len == MYDOWN_ERROR) && (ret != 200)) {
        printf("\nError: something wrong (return code %d)\n", ret);
    } else {
        printf("- upload finished\n");
    }

    free(content);
    return(0);
}



int spr(u8 **buff, int blen, u8 *fmt, ...) {
    va_list ap;
    int     len,
            mlen;
    u8      *ret;

    mlen = strlen(fmt) + 128;

    va_start(ap, fmt);
    for(;;) {
        ret = malloc(mlen);
        if(!ret) return(0);     // return(-1);
        len = vsnprintf(ret, mlen, fmt, ap);
        if((len >= 0) && (len < mlen)) break;
        if(len < 0) {           // Windows style
            mlen += 128;
        } else {                // POSIX style
            mlen = len + 1;
        }
        free(ret);
    }
    va_end(ap);

    *buff = realloc(*buff, blen + len + 1);
    strcpy(*buff + blen, ret);
    return(len);
}



void fgetz(char *data, int len) {
    char    *p;

    fgets(data, len, stdin);
    for(p = data; *p && (*p != '\n') && (*p != '\r'); p++);
    *p = 0;
}



void std_err(void) {
    perror("\nError");
    exit(1);
}


