# CVE-2019-16294

Notepad++ (x64) before 7.7 allows remote code execution or denial of service via a crafted .ml file. 

### Description:
Memory corruption in notepad++ all x64 versions before 7.7 in Scintilla component (SciLexer.dll). Vulnerability triggering via special crafted .ml file. Vulnerability occurs during the processing of Unicode characters.

For example I used notepad++  v 7.6.6:. It is latest affected version before fixing version. [Download](https://notepad-plus-plus.org/download/v7.6.6.html)

![](https://github.com/bi7s/CVE/blob/master/CVE-2019-16294/img/version.png)

poc.ml - file for demonstrating triggering of vulnerability;

This file contain next bytes:
```
\xef\xbb\xbf\xf1\x94\xbe\xbe
```
Open this file in notepad++;

Result:

![](https://github.com/bi7s/CVE/blob/master/CVE-2019-16294/img/windbg_poc.png)

After analyze of this exception and poc.ml we can see, that we have control for part of the registers rbx, rcx. We can see, that rbx takes part in the formation of value of the pointer ```movzx   eax, word ptr[rax+rbx*2]```:

![](https://github.com/bi7s/CVE/blob/master/CVE-2019-16294/img/windbg_control_registers.png)

For demonstrate control of this values I modified current proof of concept and created new PoC (aaaaa.ml)

aaaaa.ml is file for triggering vulnerability, and overwriting parts values of the registers rbx, rcx to 0xaaaaa.

aaaaa.ml  contain next bytes:
```
\xe2\xbf\x88\xf2\xaa\xaa\xaa
``` 
After testing of this proof of concept we have result:

![](https://github.com/bi7s/CVE/blob/master/CVE-2019-16294/img/windbg_aaaa.png)

That`s means that we have control for part of values of the registers rbx, rcx and it can lead to remote code execution. 

This vulnerability was fixed in notepad++ 7.7






